/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.indentation;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.indentation.ExpressionHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentLevel;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentationCheck;

public class BlockParentHandler
extends ExpressionHandler {
    private static final int[] CHECKED_CHILDREN = new int[]{10, 28, 6, 86, 88, 90, 87};

    public BlockParentHandler(IndentationCheck indentCheck, String name, DetailAST ast, ExpressionHandler parent) {
        super(indentCheck, name, ast, parent);
    }

    protected int[] getCheckedChildren() {
        return (int[])CHECKED_CHILDREN.clone();
    }

    protected DetailAST getToplevelAST() {
        return this.getMainAst();
    }

    protected void checkToplevelToken() {
        DetailAST toplevel = this.getToplevelAST();
        if (toplevel == null || this.getLevel().accept(this.expandedTabsColumnNo(toplevel)) || this.hasLabelBefore()) {
            return;
        }
        if (!this.toplevelMustStartLine() && !this.startsLine(toplevel)) {
            return;
        }
        this.logError(toplevel, "", this.expandedTabsColumnNo(toplevel));
    }

    protected boolean hasLabelBefore() {
        DetailAST parent = this.getToplevelAST().getParent();
        return parent != null && parent.getType() == 22 && parent.getLineNo() == this.getToplevelAST().getLineNo();
    }

    protected boolean toplevelMustStartLine() {
        return true;
    }

    protected boolean hasCurlys() {
        return this.getLCurly() != null && this.getRCurly() != null;
    }

    protected DetailAST getLCurly() {
        return this.getMainAst().findFirstToken(7);
    }

    protected DetailAST getRCurly() {
        DetailAST slist = this.getMainAst().findFirstToken(7);
        if (slist == null) {
            return null;
        }
        return slist.findFirstToken(73);
    }

    protected void checkLCurly() {
        DetailAST lcurly = this.getLCurly();
        int lcurlyPos = this.expandedTabsColumnNo(lcurly);
        if (this.curlyLevel().accept(lcurlyPos) || !this.startsLine(lcurly)) {
            return;
        }
        this.logError(lcurly, "lcurly", lcurlyPos);
    }

    protected IndentLevel curlyLevel() {
        return new IndentLevel(this.getLevel(), this.getBraceAdjustment());
    }

    protected boolean rcurlyMustStart() {
        return true;
    }

    protected boolean childrenMayNest() {
        return false;
    }

    protected void checkRCurly() {
        DetailAST lcurly = this.getLCurly();
        DetailAST rcurly = this.getRCurly();
        int rcurlyPos = this.expandedTabsColumnNo(rcurly);
        if (this.curlyLevel().accept(rcurlyPos) || !this.rcurlyMustStart() && !this.startsLine(rcurly) || BlockParentHandler.areOnSameLine(rcurly, lcurly)) {
            return;
        }
        this.logError(rcurly, "rcurly", rcurlyPos, this.curlyLevel());
    }

    protected DetailAST getNonlistChild() {
        return this.getMainAst().findFirstToken(77).getNextSibling();
    }

    private void checkNonlistChild() {
        DetailAST nonlist = this.getNonlistChild();
        if (nonlist == null) {
            return;
        }
        IndentLevel expected = new IndentLevel(this.getLevel(), this.getBasicOffset());
        this.checkExpressionSubtree(nonlist, expected, false, false);
    }

    protected DetailAST getListChild() {
        return this.getMainAst().findFirstToken(7);
    }

    protected DetailAST getRParen() {
        return this.getMainAst().findFirstToken(77);
    }

    protected DetailAST getLParen() {
        return this.getMainAst().findFirstToken(76);
    }

    @Override
    public void checkIndentation() {
        DetailAST listChild;
        this.checkToplevelToken();
        this.checkLParen(this.getLParen());
        this.checkRParen(this.getLParen(), this.getRParen());
        if (this.hasCurlys()) {
            this.checkLCurly();
            this.checkRCurly();
        }
        if ((listChild = this.getListChild()) != null) {
            if (!this.hasCurlys() || !BlockParentHandler.areOnSameLine(this.getLCurly(), this.getRCurly())) {
                this.checkChildren(listChild, this.getCheckedChildren(), this.getChildrenExpectedLevel(), true, this.childrenMayNest());
            }
        } else {
            this.checkNonlistChild();
        }
    }

    protected IndentLevel getChildrenExpectedLevel() {
        if (this.getLevel().isMultiLevel() && this.hasCurlys() && !BlockParentHandler.areOnSameLine(this.getLCurly(), this.getRCurly())) {
            if (this.startsLine(this.getLCurly())) {
                return new IndentLevel(this.expandedTabsColumnNo(this.getLCurly()) + this.getBasicOffset());
            }
            if (this.startsLine(this.getRCurly())) {
                IndentLevel level = new IndentLevel(this.curlyLevel(), this.getBasicOffset());
                level.addAcceptedIndent(level.getFirstIndentLevel() + this.getLineWrappingIndent());
                return level;
            }
        }
        return new IndentLevel(this.getLevel(), this.getBasicOffset());
    }

    @Override
    public IndentLevel suggestedChildLevel(ExpressionHandler child) {
        return this.getChildrenExpectedLevel();
    }

    private int getLineWrappingIndent() {
        return this.getIndentCheck().getLineWrappingIndentation();
    }
}

