/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.annotation;

import com.puppycrawl.tools.checkstyle.AnnotationUtility;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.AbstractFormatCheck;
import java.util.regex.Matcher;

public class SuppressWarningsCheck
extends AbstractFormatCheck {
    public static final String MSG_KEY_SUPPRESSED_WARNING_NOT_ALLOWED = "suppressed.warning.not.allowed";
    private static final String SUPPRESS_WARNINGS = "SuppressWarnings";
    private static final String FQ_SUPPRESS_WARNINGS = "java.lang.SuppressWarnings";

    public SuppressWarningsCheck() {
        super("^$|^\\s+$");
    }

    @Override
    public final int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public final int[] getAcceptableTokens() {
        return new int[]{14, 15, 154, 157, 161, 155, 21, 10, 9, 8};
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST annotation = this.getSuppressWarnings(ast);
        if (annotation == null) {
            return;
        }
        DetailAST warningHolder = this.findWarningsHolder(annotation);
        DetailAST token = warningHolder.findFirstToken(160);
        DetailAST warning = token != null ? token.findFirstToken(28) : warningHolder.findFirstToken(28);
        if (warning == null) {
            this.logMatch(warningHolder.getLineNo(), warningHolder.getColumnNo(), "");
            return;
        }
        while (warning != null) {
            if (warning.getType() == 28) {
                DetailAST fChild = warning.getFirstChild();
                switch (fChild.getType()) {
                    case 139: {
                        String warningText = this.removeQuotes(warning.getFirstChild().getText());
                        this.logMatch(warning.getLineNo(), warning.getColumnNo(), warningText);
                        break;
                    }
                    case 109: {
                        this.walkConditional(fChild);
                        break;
                    }
                    case 58: 
                    case 59: {
                        break;
                    }
                }
            }
            warning = warning.getNextSibling();
        }
    }

    private DetailAST getSuppressWarnings(DetailAST ast) {
        DetailAST annotation = AnnotationUtility.getAnnotation(ast, SUPPRESS_WARNINGS);
        return annotation != null ? annotation : AnnotationUtility.getAnnotation(ast, FQ_SUPPRESS_WARNINGS);
    }

    private void logMatch(int lineNo, int colNum, String warningText) {
        Matcher matcher = this.getRegexp().matcher(warningText);
        if (matcher.matches()) {
            this.log(lineNo, colNum, MSG_KEY_SUPPRESSED_WARNING_NOT_ALLOWED, warningText);
        }
    }

    private DetailAST findWarningsHolder(DetailAST annotation) {
        DetailAST annValuePair = annotation.findFirstToken(160);
        DetailAST annArrayInit = annValuePair != null ? annValuePair.findFirstToken(162) : annotation.findFirstToken(162);
        if (annArrayInit != null) {
            return annArrayInit;
        }
        return annotation;
    }

    private String removeQuotes(String warning) {
        assert (warning != null) : "the warning was null";
        assert (warning.charAt(0) == '\"');
        assert (warning.charAt(warning.length() - 1) == '\"');
        return warning.substring(1, warning.length() - 1);
    }

    private void walkConditional(DetailAST cond) {
        if (cond.getType() != 109) {
            String warningText = this.removeQuotes(cond.getText());
            this.logMatch(cond.getLineNo(), cond.getColumnNo(), warningText);
            return;
        }
        this.walkConditional(this.getCondLeft(cond));
        this.walkConditional(this.getCondRight(cond));
    }

    private DetailAST getCondLeft(DetailAST cond) {
        DetailAST colon = cond.findFirstToken(82);
        return colon.getPreviousSibling();
    }

    private DetailAST getCondRight(DetailAST cond) {
        DetailAST colon = cond.findFirstToken(82);
        return colon.getNextSibling();
    }
}

