/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.indentation;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.indentation.AbstractExpressionHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.BlockParentHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentLevel;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentationCheck;

public class ArrayInitHandler
extends BlockParentHandler {
    public ArrayInitHandler(IndentationCheck indentCheck, DetailAST ast, AbstractExpressionHandler parent) {
        super(indentCheck, "array initialization", ast, parent);
    }

    @Override
    protected IndentLevel getLevelImpl() {
        DetailAST parentAST = this.getMainAst().getParent();
        int type = parentAST.getType();
        if (type == 136 || type == 80) {
            return new IndentLevel(this.getLineStart(parentAST));
        }
        if (this.getParent() instanceof ArrayInitHandler) {
            return ((ArrayInitHandler)this.getParent()).getChildrenExpectedLevel();
        }
        return this.getParent().getLevel();
    }

    @Override
    protected DetailAST getToplevelAST() {
        return null;
    }

    @Override
    protected DetailAST getLCurly() {
        return this.getMainAst();
    }

    @Override
    protected IndentLevel curlyLevel() {
        IndentLevel level = new IndentLevel(this.getLevel(), this.getBraceAdjustment());
        level.addAcceptedIndent(level.getLastIndentLevel() + this.getLineWrappingIndent());
        return level;
    }

    @Override
    protected DetailAST getRCurly() {
        return this.getMainAst().findFirstToken(73);
    }

    @Override
    protected boolean rcurlyMustStart() {
        return false;
    }

    @Override
    protected boolean childrenMayNest() {
        return true;
    }

    @Override
    protected DetailAST getListChild() {
        return this.getMainAst();
    }

    @Override
    protected IndentLevel getChildrenExpectedLevel() {
        int lcurlyPos;
        int firstChildPos;
        IndentLevel expectedIndent = new IndentLevel(this.getLevel(), this.getIndentCheck().getArrayInitIndent(), this.getIndentCheck().getLineWrappingIndentation());
        int firstLine = this.getFirstLine(Integer.MAX_VALUE, this.getListChild());
        if (this.hasCurlys() && firstLine == this.getLCurly().getLineNo() && (firstChildPos = this.getNextFirstNonblankOnLineAfter(firstLine, lcurlyPos = this.expandedTabsColumnNo(this.getLCurly()))) >= 0) {
            expectedIndent.addAcceptedIndent(firstChildPos);
            expectedIndent.addAcceptedIndent(lcurlyPos + this.getLineWrappingIndent());
        }
        return expectedIndent;
    }

    private int getNextFirstNonblankOnLineAfter(int lineNo, int columnNo) {
        int realColumnNo;
        String line = this.getIndentCheck().getLines()[lineNo - 1];
        int lineLength = line.length();
        for (realColumnNo = columnNo + 1; realColumnNo < lineLength && Character.isWhitespace(line.charAt(realColumnNo)); ++realColumnNo) {
        }
        return realColumnNo == lineLength ? -1 : realColumnNo;
    }

    private int getLineWrappingIndent() {
        return this.getIndentCheck().getLineWrappingIndentation();
    }
}

