/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.ScopeUtils;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.CheckUtils;

public class ExplicitInitializationCheck
extends Check {
    public static final String MSG_KEY = "explicit.init";

    @Override
    public final int[] getDefaultTokens() {
        return new int[]{10};
    }

    @Override
    public final int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    @Override
    public final int[] getAcceptableTokens() {
        return new int[]{10};
    }

    @Override
    public void visitToken(DetailAST ast) {
        int primitiveType;
        if (this.isSkipCase(ast)) {
            return;
        }
        DetailAST ident = ast.findFirstToken(58);
        DetailAST assign = ast.findFirstToken(80);
        DetailAST exprStart = assign.getFirstChild().getFirstChild();
        DetailAST type = ast.findFirstToken(13);
        if (this.isObjectType(type) && exprStart.getType() == 135) {
            this.log(ident, MSG_KEY, ident.getText(), "null");
        }
        if ((primitiveType = type.getFirstChild().getType()) == 50 && exprStart.getType() == 134) {
            this.log(ident, MSG_KEY, ident.getText(), "false");
        }
        if (this.isNumericType(primitiveType) && this.isZero(exprStart)) {
            this.log(ident, MSG_KEY, ident.getText(), "0");
        }
        if (primitiveType == 52 && this.isZeroChar(exprStart)) {
            this.log(ident, MSG_KEY, ident.getText(), "\\0");
        }
    }

    private boolean isZeroChar(DetailAST exprStart) {
        return this.isZero(exprStart) || exprStart.getType() == 138 && "'\\0'".equals(exprStart.getText());
    }

    private boolean isSkipCase(DetailAST ast) {
        if (ScopeUtils.isLocalVariableDef(ast) || ScopeUtils.inInterfaceOrAnnotationBlock(ast)) {
            return true;
        }
        DetailAST assign = ast.findFirstToken(80);
        if (assign == null) {
            return true;
        }
        DetailAST modifiers = ast.findFirstToken(5);
        return modifiers != null && modifiers.branchContains(39);
    }

    private boolean isObjectType(DetailAST type) {
        int objectType = type.getFirstChild().getType();
        return objectType == 58 || objectType == 59 || objectType == 17;
    }

    private boolean isNumericType(int type) {
        return type == 51 || type == 53 || type == 54 || type == 55 || type == 56 || type == 57;
    }

    private boolean isZero(DetailAST expr) {
        int type = expr.getType();
        switch (type) {
            case 137: 
            case 140: 
            case 141: 
            case 142: {
                String text = expr.getText();
                return 0.0 == CheckUtils.parseFloat(text, type);
            }
        }
        return false;
    }
}

