/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.google.common.collect.Lists;
import com.puppycrawl.tools.checkstyle.Checker;
import com.puppycrawl.tools.checkstyle.ConfigurationLoader;
import com.puppycrawl.tools.checkstyle.DefaultLogger;
import com.puppycrawl.tools.checkstyle.PropertiesExpander;
import com.puppycrawl.tools.checkstyle.XMLLogger;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.puppycrawl.tools.checkstyle.api.AutomaticBean;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public final class Main {
    private Main() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void main(String ... args) throws UnsupportedEncodingException, FileNotFoundException {
        int exitStatus;
        block12: {
            int errorCounter = 0;
            boolean cliViolations = false;
            int exitWithCliViolation = -1;
            int exitWithCheckstyleException = -2;
            exitStatus = 0;
            try {
                CommandLine commandLine = Main.parseCli(args);
                if (commandLine.hasOption("v")) {
                    System.out.println("Checkstyle version: " + Main.class.getPackage().getImplementationVersion());
                    exitStatus = 0;
                } else {
                    List<String> messages = Main.validateCli(commandLine);
                    boolean bl = cliViolations = !messages.isEmpty();
                    if (!cliViolations) {
                        CliOptions config = Main.convertCliToPojo(commandLine);
                        exitStatus = errorCounter = Main.runCheckstyle(config);
                    } else {
                        exitStatus = -1;
                        errorCounter = 1;
                        for (String message : messages) {
                            System.out.println(message);
                        }
                    }
                }
                if (errorCounter == 0 || cliViolations) break block12;
            }
            catch (ParseException pex) {
                block13: {
                    cliViolations = true;
                    exitStatus = -1;
                    errorCounter = 1;
                    System.out.println(pex.getMessage());
                    Main.printUsage();
                    if (errorCounter == 0 || cliViolations) break block13;
                    System.out.println(String.format("Checkstyle ends with %d errors.", errorCounter));
                }
                System.exit(exitStatus);
            }
            catch (CheckstyleException e) {
                block14: {
                    exitStatus = -2;
                    errorCounter = 1;
                    System.out.println(e.getMessage());
                    if (errorCounter == 0 || cliViolations) break block14;
                    {
                        catch (Throwable throwable) {
                            if (errorCounter != 0 && !cliViolations) {
                                System.out.println(String.format("Checkstyle ends with %d errors.", errorCounter));
                            }
                            System.exit(exitStatus);
                            throw throwable;
                        }
                    }
                    System.out.println(String.format("Checkstyle ends with %d errors.", errorCounter));
                }
                System.exit(exitStatus);
            }
            System.out.println(String.format("Checkstyle ends with %d errors.", errorCounter));
        }
        System.exit(exitStatus);
    }

    private static CommandLine parseCli(String ... args) throws ParseException {
        DefaultParser clp = new DefaultParser();
        return clp.parse(Main.buildOptions(), args);
    }

    private static List<String> validateCli(CommandLine cmdLine) {
        ArrayList<String> result = new ArrayList<String>();
        if (cmdLine.hasOption("c")) {
            List<File> files;
            String outputLocation;
            String propertiesLocation;
            File file;
            String format;
            String configLocation = cmdLine.getOptionValue("c");
            File configFile = new File(configLocation);
            if (!configFile.exists()) {
                result.add(String.format("unable to find '%s'.", configLocation));
            }
            if (cmdLine.hasOption("f") && !"plain".equals(format = cmdLine.getOptionValue("f")) && !"xml".equals(format)) {
                result.add(String.format("Invalid output format. Found '%s' but expected 'plain' or 'xml'.", format));
            }
            if (cmdLine.hasOption("p") && !(file = new File(propertiesLocation = cmdLine.getOptionValue("p"))).exists()) {
                result.add(String.format("Could not find file '%s'.", propertiesLocation));
            }
            if (cmdLine.hasOption("o") && (file = new File(outputLocation = cmdLine.getOptionValue("o"))).exists() && (!file.canRead() || !file.canWrite())) {
                result.add(String.format("Permission denied : '%s'.", outputLocation));
            }
            if ((files = Main.getFilesToProcess(cmdLine.getArgs())).isEmpty()) {
                result.add("Must specify files to process, found 0.");
            }
        } else {
            result.add("Must specify a config XML file.");
        }
        return result;
    }

    private static CliOptions convertCliToPojo(CommandLine cmdLine) {
        CliOptions conf = new CliOptions();
        conf.format = cmdLine.getOptionValue("f");
        if (conf.format == null) {
            conf.format = "plain";
        }
        conf.outputLocation = cmdLine.getOptionValue("o");
        conf.configLocation = cmdLine.getOptionValue("c");
        conf.propertiesLocation = cmdLine.getOptionValue("p");
        conf.files = Main.getFilesToProcess(cmdLine.getArgs());
        return conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int runCheckstyle(CliOptions cliOptions) throws CheckstyleException, UnsupportedEncodingException, FileNotFoundException {
        Properties props = cliOptions.propertiesLocation != null ? Main.loadProperties(new File(cliOptions.propertiesLocation)) : System.getProperties();
        Configuration config = ConfigurationLoader.loadConfiguration(cliOptions.configLocation, new PropertiesExpander(props));
        AuditListener listener = Main.createListener(cliOptions.format, cliOptions.outputLocation);
        int errorCounter = 0;
        Checker checker = new Checker();
        try {
            ClassLoader moduleClassLoader = Checker.class.getClassLoader();
            checker.setModuleClassLoader(moduleClassLoader);
            checker.configure(config);
            checker.addListener(listener);
            errorCounter = checker.process(cliOptions.files);
        }
        finally {
            checker.destroy();
        }
        return errorCounter;
    }

    private static Properties loadProperties(File file) throws CheckstyleException {
        Properties properties = new Properties();
        try (FileInputStream fis = new FileInputStream(file);){
            properties.load(fis);
        }
        catch (IOException e) {
            throw new CheckstyleException(String.format("Unable to load properties from file '%s'.", file.getAbsolutePath()), e);
        }
        return properties;
    }

    private static AuditListener createListener(String format, String outputLocation) throws UnsupportedEncodingException, FileNotFoundException {
        OutputStream out = null;
        boolean closeOut = false;
        if (outputLocation != null) {
            out = new FileOutputStream(outputLocation);
            closeOut = true;
        } else {
            out = System.out;
            closeOut = false;
        }
        AutomaticBean listener = null;
        switch (format) {
            case "xml": {
                listener = new XMLLogger(out, closeOut);
                break;
            }
            case "plain": {
                listener = new DefaultLogger(out, closeOut);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid output format. Found '" + format + "' but expected 'plain' or 'xml'.");
            }
        }
        return listener;
    }

    private static List<File> getFilesToProcess(String ... filesToProcess) {
        LinkedList files = Lists.newLinkedList();
        for (String element : filesToProcess) {
            files.addAll(Main.listFiles(new File(element)));
        }
        return files;
    }

    private static List<File> listFiles(File node) {
        LinkedList result = Lists.newLinkedList();
        if (node.canRead()) {
            if (node.isDirectory()) {
                File[] files = node.listFiles();
                if (files != null) {
                    for (File element : files) {
                        result.addAll(Main.listFiles(element));
                    }
                }
            } else if (node.isFile()) {
                result.add(node);
            }
        }
        return result;
    }

    private static void printUsage() {
        HelpFormatter hf = new HelpFormatter();
        hf.printHelp(String.format("java %s [options] -c <config.xml> file...", Main.class.getName()), Main.buildOptions());
    }

    private static Options buildOptions() {
        Options options = new Options();
        options.addOption("c", true, "Sets the check configuration file to use.");
        options.addOption("o", true, "Sets the output file. Defaults to stdout");
        options.addOption("p", true, "Loads the properties file");
        options.addOption("f", true, "Sets the output format. (plain|xml). Defaults to plain");
        options.addOption("v", false, "Print product version and exit");
        return options;
    }

    private static class CliOptions {
        private String propertiesLocation;
        private String configLocation;
        private String format;
        private String outputLocation;
        private List<File> files;

        private CliOptions() {
        }
    }
}

