/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.api;

import com.puppycrawl.tools.checkstyle.api.LocalizedMessage;
import com.puppycrawl.tools.checkstyle.api.SeverityLevel;
import java.util.EventObject;

public final class AuditEvent
extends EventObject {
    private static final long serialVersionUID = -3774725606973812736L;
    private final String fileName;
    private final LocalizedMessage message;

    public AuditEvent(Object source) {
        this(source, null);
    }

    public AuditEvent(Object src, String fileName) {
        this(src, fileName, null);
    }

    public AuditEvent(Object src, String fileName, LocalizedMessage message) {
        super(src);
        this.fileName = fileName;
        this.message = message;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLine() {
        return this.message.getLineNo();
    }

    public String getMessage() {
        return this.message.getMessage();
    }

    public int getColumn() {
        return this.message.getColumnNo();
    }

    public SeverityLevel getSeverityLevel() {
        return this.message == null ? SeverityLevel.INFO : this.message.getSeverityLevel();
    }

    public String getModuleId() {
        return this.message.getModuleId();
    }

    public String getSourceName() {
        return this.message.getSourceName();
    }

    public LocalizedMessage getLocalizedMessage() {
        return this.message;
    }
}

