/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.ScopeUtils;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public abstract class AbstractDeclarationCollector
extends Check {
    private Map<DetailAST, LexicalFrame> frames;
    private LexicalFrame current;

    @Override
    public void beginTree(DetailAST rootAST) {
        LinkedList frameStack = Lists.newLinkedList();
        frameStack.add(new GlobalFrame());
        this.frames = Maps.newHashMap();
        DetailAST curNode = rootAST;
        while (curNode != null) {
            this.collectDeclarations(frameStack, curNode);
            DetailAST toVisit = curNode.getFirstChild();
            while (curNode != null && toVisit == null) {
                this.endCollectingDeclarations(frameStack, curNode);
                toVisit = curNode.getNextSibling();
                if (toVisit != null) continue;
                curNode = curNode.getParent();
            }
            curNode = toVisit;
        }
    }

    @Override
    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 154: 
            case 157: {
                this.current = this.frames.get((Object)ast);
                break;
            }
        }
    }

    private void collectDeclarations(Deque<LexicalFrame> frameStack, DetailAST ast) {
        LexicalFrame frame = frameStack.peek();
        switch (ast.getType()) {
            case 10: {
                this.collectVariableDeclarations(ast, frame);
                break;
            }
            case 21: {
                DetailAST nameAST = ast.findFirstToken(58);
                frame.addName(nameAST.getText());
                break;
            }
            case 14: 
            case 15: 
            case 154: 
            case 157: {
                DetailAST nameAST = ast.findFirstToken(58);
                frame.addName(nameAST.getText());
                frameStack.addFirst(new ClassFrame(frame));
                break;
            }
            case 7: {
                frameStack.addFirst(new BlockFrame(frame));
                break;
            }
            case 9: {
                String name = ast.findFirstToken(58).getText();
                if (frame instanceof ClassFrame) {
                    DetailAST mods = ast.findFirstToken(5);
                    if (mods.branchContains(64)) {
                        ((ClassFrame)frame).addStaticMethod(name);
                    } else {
                        ((ClassFrame)frame).addInstanceMethod(name);
                    }
                }
                frameStack.addFirst(new MethodFrame(frame));
                break;
            }
            case 8: {
                frameStack.addFirst(new MethodFrame(frame));
                break;
            }
        }
    }

    private void collectVariableDeclarations(DetailAST ast, LexicalFrame frame) {
        String name = ast.findFirstToken(58).getText();
        if (frame instanceof ClassFrame) {
            DetailAST mods = ast.findFirstToken(5);
            if (ScopeUtils.inInterfaceBlock(ast) || mods.branchContains(64)) {
                ((ClassFrame)frame).addStaticMember(name);
            } else {
                ((ClassFrame)frame).addInstanceMember(name);
            }
        } else {
            frame.addName(name);
        }
    }

    private void endCollectingDeclarations(Queue<LexicalFrame> frameStack, DetailAST ast) {
        switch (ast.getType()) {
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 154: 
            case 157: {
                this.frames.put(ast, frameStack.poll());
                break;
            }
        }
    }

    protected final boolean isClassField(String name) {
        LexicalFrame frame = this.findFrame(name);
        return frame instanceof ClassFrame && ((ClassFrame)frame).hasInstanceMember(name);
    }

    protected final boolean isClassMethod(String name) {
        LexicalFrame frame = this.findFrame(name);
        return frame instanceof ClassFrame && ((ClassFrame)frame).hasInstanceMethod(name);
    }

    private LexicalFrame findFrame(String name) {
        if (this.current != null) {
            return this.current.getIfContains(name);
        }
        return null;
    }

    private static class BlockFrame
    extends LexicalFrame {
        protected BlockFrame(LexicalFrame parent) {
            super(parent);
        }
    }

    private static class ClassFrame
    extends LexicalFrame {
        private final Set<String> instanceMembers = Sets.newHashSet();
        private final Set<String> instanceMethods = Sets.newHashSet();
        private final Set<String> staticMembers = Sets.newHashSet();
        private final Set<String> staticMethods = Sets.newHashSet();

        public ClassFrame(LexicalFrame parent) {
            super(parent);
        }

        public void addStaticMember(String name) {
            this.staticMembers.add(name);
        }

        public void addStaticMethod(String name) {
            this.staticMethods.add(name);
        }

        public void addInstanceMember(String name) {
            this.instanceMembers.add(name);
        }

        public void addInstanceMethod(String name) {
            this.instanceMethods.add(name);
        }

        public boolean hasInstanceMember(String name) {
            return this.instanceMembers.contains(name);
        }

        public boolean hasInstanceMethod(String name) {
            return this.instanceMethods.contains(name);
        }

        @Override
        boolean contains(String nameToFind) {
            return super.contains(nameToFind) || this.instanceMembers.contains(nameToFind) || this.instanceMethods.contains(nameToFind) || this.staticMembers.contains(nameToFind) || this.staticMethods.contains(nameToFind);
        }
    }

    private static class MethodFrame
    extends LexicalFrame {
        protected MethodFrame(LexicalFrame parent) {
            super(parent);
        }
    }

    private static class GlobalFrame
    extends LexicalFrame {
        protected GlobalFrame() {
            super(null);
        }
    }

    private static class LexicalFrame {
        private final Set<String> varNames;
        private final LexicalFrame parent;

        protected LexicalFrame(LexicalFrame parent) {
            this.parent = parent;
            this.varNames = Sets.newHashSet();
        }

        void addName(String nameToAdd) {
            this.varNames.add(nameToAdd);
        }

        boolean contains(String nameToFind) {
            return this.varNames.contains(nameToFind);
        }

        LexicalFrame getIfContains(String nameToFind) {
            if (this.contains(nameToFind)) {
                return this;
            }
            if (this.parent != null) {
                return this.parent.getIfContains(nameToFind);
            }
            return null;
        }
    }
}

