/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.ScopeUtils;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class FinalLocalVariableCheck
extends Check {
    public static final String MSG_KEY = "final.variable";
    private final Deque<Map<String, DetailAST>> scopeStack = new ArrayDeque<Map<String, DetailAST>>();
    private boolean validateEnhancedForLoopVariable;

    public final void setValidateEnhancedForLoopVariable(boolean validateEnhancedForLoopVariable) {
        this.validateEnhancedForLoopVariable = validateEnhancedForLoopVariable;
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{58, 8, 9, 10, 11, 12, 91, 7, 6};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{58, 8, 9, 10, 11, 12, 91, 7, 6, 21};
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{58, 8, 9, 11, 12, 91, 7, 6};
    }

    @Override
    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 91: {
                this.scopeStack.push(new HashMap());
                break;
            }
            case 21: {
                if (ScopeUtils.inInterfaceBlock(ast) || FinalLocalVariableCheck.inAbstractOrNativeMethod(ast) || FinalLocalVariableCheck.inLambda(ast)) break;
            }
            case 10: {
                if (ast.getParent().getType() == 6 || !this.shouldCheckEnhancedForLoopVariable(ast) || !FinalLocalVariableCheck.isVariableInForInit(ast) || ast.branchContains(39)) break;
                this.insertVariable(ast);
                break;
            }
            case 58: {
                int parentType = ast.getParent().getType();
                if (!this.isAssignOperator(parentType) || ast.getParent().getFirstChild() != ast) break;
                this.removeVariable(ast);
                break;
            }
        }
    }

    private boolean isAssignOperator(int parentType) {
        return 26 == parentType || 130 == parentType || 25 == parentType || 129 == parentType || 80 == parentType || 98 == parentType || 99 == parentType || 101 == parentType || 100 == parentType || 102 == parentType || 103 == parentType || 104 == parentType || 105 == parentType || 107 == parentType || 108 == parentType || 106 == parentType;
    }

    private boolean shouldCheckEnhancedForLoopVariable(DetailAST ast) {
        return this.validateEnhancedForLoopVariable || ast.getParent().getType() != 156;
    }

    private static boolean isVariableInForInit(DetailAST variableDef) {
        return variableDef.getParent().getType() != 35;
    }

    private static boolean inAbstractOrNativeMethod(DetailAST ast) {
        for (DetailAST parent = ast.getParent(); parent != null; parent = parent.getParent()) {
            if (parent.getType() != 9) continue;
            DetailAST modifiers = parent.findFirstToken(5);
            return modifiers.branchContains(40) || modifiers.branchContains(66);
        }
        return false;
    }

    private static boolean inLambda(DetailAST paramDef) {
        return paramDef.getParent().getParent().getType() == 181;
    }

    private static DetailAST findClassOrConstructorOrMethodInWhichItIsDefined(DetailAST ast) {
        DetailAST astTraverse = ast;
        while (astTraverse.getType() != 9 && astTraverse.getType() != 14 && astTraverse.getType() != 8) {
            astTraverse = astTraverse.getParent();
        }
        return astTraverse;
    }

    private static boolean isSameVariables(DetailAST ast1, DetailAST ast2) {
        DetailAST classOrMethodOfAst1 = FinalLocalVariableCheck.findClassOrConstructorOrMethodInWhichItIsDefined(ast1);
        DetailAST classOrMethodOfAst2 = FinalLocalVariableCheck.findClassOrConstructorOrMethodInWhichItIsDefined(ast2);
        String identifierOfAst1 = classOrMethodOfAst1.findFirstToken(58).getText();
        String identifierOfAst2 = classOrMethodOfAst2.findFirstToken(58).getText();
        return identifierOfAst1.equals(identifierOfAst2);
    }

    private void insertVariable(DetailAST ast) {
        Map<String, DetailAST> state = this.scopeStack.peek();
        DetailAST astNode = ast.findFirstToken(58);
        state.put(astNode.getText(), astNode);
    }

    private void removeVariable(DetailAST ast) {
        Iterator<Map<String, DetailAST>> iterator = this.scopeStack.descendingIterator();
        while (iterator.hasNext()) {
            Map<String, DetailAST> state = iterator.next();
            DetailAST storedVariable = state.get(ast.getText());
            if (storedVariable == null || !FinalLocalVariableCheck.isSameVariables(storedVariable, ast)) continue;
            state.remove(ast.getText());
            break;
        }
    }

    @Override
    public void leaveToken(DetailAST ast) {
        super.leaveToken(ast);
        switch (ast.getType()) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 91: {
                Map<String, DetailAST> state = this.scopeStack.pop();
                for (DetailAST var : state.values()) {
                    this.log(var.getLineNo(), var.getColumnNo(), MSG_KEY, var.getText());
                }
                break;
            }
        }
    }
}

