/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.AnnotationUtility;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.checks.coding.AbstractIllegalCheck;
import java.util.Collections;
import java.util.Set;

public final class IllegalThrowsCheck
extends AbstractIllegalCheck {
    public static final String MSG_KEY = "illegal.throw";
    private static final String[] DEFAULT_IGNORED_METHOD_NAMES = new String[]{"finalize"};
    private boolean ignoreOverriddenMethods = true;
    private final Set<String> ignoredMethodNames = Sets.newHashSet();

    public IllegalThrowsCheck() {
        super("Error", "RuntimeException", "Throwable", "java.lang.Error", "java.lang.RuntimeException", "java.lang.Throwable");
        this.setIgnoredMethodNames(DEFAULT_IGNORED_METHOD_NAMES);
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{81};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{81};
    }

    @Override
    public void visitToken(DetailAST detailAST) {
        DetailAST methodDef = detailAST.getParent();
        if (!this.isIgnorableMethod(methodDef)) {
            for (DetailAST token = detailAST.getFirstChild(); token != null; token = token.getNextSibling()) {
                FullIdent ident;
                if (token.getType() == 74 || !this.isIllegalClassName((ident = FullIdent.createFullIdent(token)).getText())) continue;
                this.log(token, MSG_KEY, ident.getText());
            }
        }
    }

    private boolean isIgnorableMethod(DetailAST methodDef) {
        return this.shouldIgnoreMethod(methodDef.findFirstToken(58).getText()) || this.ignoreOverriddenMethods && (AnnotationUtility.containsAnnotation(methodDef, "Override") || AnnotationUtility.containsAnnotation(methodDef, "java.lang.Override"));
    }

    private boolean shouldIgnoreMethod(String name) {
        return this.ignoredMethodNames.contains(name);
    }

    public void setIgnoredMethodNames(String ... methodNames) {
        this.ignoredMethodNames.clear();
        Collections.addAll(this.ignoredMethodNames, methodNames);
    }

    public void setIgnoreOverriddenMethods(boolean ignoreOverriddenMethods) {
        this.ignoreOverriddenMethods = ignoreOverriddenMethods;
    }
}

