/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.whitespace;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class WhitespaceAfterCheck
extends Check {
    public static final String WS_NOT_FOLLOWED = "ws.notFollowed";
    public static final String WS_TYPECAST = "ws.typeCast";

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{74, 45, 23};
    }

    @Override
    public void visitToken(DetailAST ast) {
        String line = this.getLine(ast.getLineNo() - 1);
        if (ast.getType() == 23) {
            DetailAST targetAST = ast.findFirstToken(77);
            if (!WhitespaceAfterCheck.isFollowedByWhitespace(targetAST, line)) {
                this.log(targetAST.getLineNo(), targetAST.getColumnNo() + targetAST.getText().length(), WS_TYPECAST, new Object[0]);
            }
        } else if (!WhitespaceAfterCheck.isFollowedByWhitespace(ast, line)) {
            Object[] message = new Object[]{ast.getText()};
            this.log(ast.getLineNo(), ast.getColumnNo() + ast.getText().length(), WS_NOT_FOLLOWED, message);
        }
    }

    private static boolean isFollowedByWhitespace(DetailAST targetAST, String line) {
        int after = targetAST.getColumnNo() + targetAST.getText().length();
        boolean followedByWhitespace = true;
        if (after < line.length()) {
            char charAfter = line.charAt(after);
            if (targetAST.getType() == 45 && (charAfter == ';' || charAfter == ')')) {
                followedByWhitespace = true;
            } else if (!Character.isWhitespace(charAfter) && !WhitespaceAfterCheck.isEmptyForIterator(targetAST)) {
                followedByWhitespace = false;
            }
        }
        return followedByWhitespace;
    }

    private static boolean isEmptyForIterator(DetailAST targetAST) {
        DetailAST sibling;
        return targetAST.getType() == 45 && (sibling = targetAST.getNextSibling()) != null && sibling.getType() == 37 && sibling.getChildCount() == 0;
    }
}

