/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.api;

import com.google.common.collect.ImmutableMap;
import com.puppycrawl.tools.checkstyle.ScopeUtils;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.Scope;
import java.util.Arrays;
import java.util.Map;

public enum JavadocTagInfo {
    AUTHOR("@author", "author", Type.BLOCK){

        @Override
        public boolean isValidOn(DetailAST ast) {
            int type = ast.getType();
            return type == 16 || type == 14 || type == 15 || type == 154 || type == 157;
        }
    }
    ,
    CODE("{@code}", "code", Type.INLINE){

        @Override
        public boolean isValidOn(DetailAST ast) {
            int type = ast.getType();
            return Arrays.binarySearch(DEF_TOKEN_TYPES, type) >= 0 && !ScopeUtils.isLocalVariableDef(ast);
        }
    }
    ,
    DOC_ROOT("{@docRoot}", "docRoot", Type.INLINE){

        @Override
        public boolean isValidOn(DetailAST ast) {
            int type = ast.getType();
            return Arrays.binarySearch(DEF_TOKEN_TYPES, type) >= 0 && !ScopeUtils.isLocalVariableDef(ast);
        }
    }
    ,
    DEPRECATED("@deprecated", "deprecated", Type.BLOCK){

        @Override
        public boolean isValidOn(DetailAST ast) {
            int type = ast.getType();
            return Arrays.binarySearch(DEF_TOKEN_TYPES_DEPRECATED, type) >= 0 && !ScopeUtils.isLocalVariableDef(ast);
        }
    }
    ,
    EXCEPTION("@exception", "exception", Type.BLOCK){

        @Override
        public boolean isValidOn(DetailAST ast) {
            int type = ast.getType();
            return type == 9 || type == 8;
        }
    }
    ,
    INHERIT_DOC("{@inheritDoc}", "inheritDoc", Type.INLINE){

        @Override
        public boolean isValidOn(DetailAST ast) {
            int type = ast.getType();
            return type == 9 && !ast.branchContains(64) && ScopeUtils.getScopeFromMods(ast.findFirstToken(5)) != Scope.PRIVATE;
        }
    }
    ,
    LINK("{@link}", "link", Type.INLINE){

        @Override
        public boolean isValidOn(DetailAST ast) {
            int type = ast.getType();
            return Arrays.binarySearch(DEF_TOKEN_TYPES, type) >= 0 && !ScopeUtils.isLocalVariableDef(ast);
        }
    }
    ,
    LINKPLAIN("{@linkplain}", "linkplain", Type.INLINE){

        @Override
        public boolean isValidOn(DetailAST ast) {
            int type = ast.getType();
            return Arrays.binarySearch(DEF_TOKEN_TYPES, type) >= 0 && !ScopeUtils.isLocalVariableDef(ast);
        }
    }
    ,
    LITERAL("{@literal}", "literal", Type.INLINE){

        @Override
        public boolean isValidOn(DetailAST ast) {
            int type = ast.getType();
            return Arrays.binarySearch(DEF_TOKEN_TYPES, type) >= 0 && !ScopeUtils.isLocalVariableDef(ast);
        }
    }
    ,
    PARAM("@param", "param", Type.BLOCK){

        @Override
        public boolean isValidOn(DetailAST ast) {
            int type = ast.getType();
            return type == 14 || type == 15 || type == 9 || type == 8;
        }
    }
    ,
    RETURN("@return", "return", Type.BLOCK){

        @Override
        public boolean isValidOn(DetailAST ast) {
            int type = ast.getType();
            DetailAST returnType = ast.findFirstToken(13);
            return type == 9 && returnType.getFirstChild().getType() != 49;
        }
    }
    ,
    SEE("@see", "see", Type.BLOCK){

        @Override
        public boolean isValidOn(DetailAST ast) {
            int type = ast.getType();
            return Arrays.binarySearch(DEF_TOKEN_TYPES, type) >= 0 && !ScopeUtils.isLocalVariableDef(ast);
        }
    }
    ,
    SERIAL("@serial", "serial", Type.BLOCK){

        @Override
        public boolean isValidOn(DetailAST ast) {
            int type = ast.getType();
            return type == 10 && !ScopeUtils.isLocalVariableDef(ast);
        }
    }
    ,
    SERIAL_DATA("@serialData", "serialData", Type.BLOCK){

        @Override
        public boolean isValidOn(DetailAST ast) {
            int type = ast.getType();
            DetailAST methodNameAst = ast.findFirstToken(58);
            String methodName = methodNameAst.getText();
            return type == 9 && ("writeObject".equals(methodName) || "readObject".equals(methodName) || "writeExternal".equals(methodName) || "readExternal".equals(methodName) || "writeReplace".equals(methodName) || "readResolve".equals(methodName));
        }
    }
    ,
    SERIAL_FIELD("@serialField", "serialField", Type.BLOCK){

        @Override
        public boolean isValidOn(DetailAST ast) {
            int type = ast.getType();
            DetailAST varType = ast.findFirstToken(13);
            return type == 10 && varType.getFirstChild().getType() == 17 && "ObjectStreafield".equals(varType.getFirstChild().getText());
        }
    }
    ,
    SINCE("@since", "since", Type.BLOCK){

        @Override
        public boolean isValidOn(DetailAST ast) {
            int type = ast.getType();
            return Arrays.binarySearch(DEF_TOKEN_TYPES, type) >= 0 && !ScopeUtils.isLocalVariableDef(ast);
        }
    }
    ,
    THROWS("@throws", "throws", Type.BLOCK){

        @Override
        public boolean isValidOn(DetailAST ast) {
            int type = ast.getType();
            return type == 9 || type == 8;
        }
    }
    ,
    VALUE("{@value}", "value", Type.INLINE){

        @Override
        public boolean isValidOn(DetailAST ast) {
            int type = ast.getType();
            return Arrays.binarySearch(DEF_TOKEN_TYPES, type) >= 0 && !ScopeUtils.isLocalVariableDef(ast);
        }
    }
    ,
    VERSION("@version", "version", Type.BLOCK){

        @Override
        public boolean isValidOn(DetailAST ast) {
            int type = ast.getType();
            return type == 16 || type == 14 || type == 15 || type == 154 || type == 157;
        }
    };

    private static final int[] DEF_TOKEN_TYPES_DEPRECATED;
    private static final int[] DEF_TOKEN_TYPES;
    private static final Map<String, JavadocTagInfo> TEXT_TO_TAG;
    private static final Map<String, JavadocTagInfo> NAME_TO_TAG;
    private final String text;
    private final String name;
    private final Type type;

    private JavadocTagInfo(String text, String name, Type type) {
        this.text = text;
        this.name = name;
        this.type = type;
    }

    public abstract boolean isValidOn(DetailAST var1);

    public String getText() {
        return this.text;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public static JavadocTagInfo fromText(String text) {
        if (text == null) {
            throw new IllegalArgumentException("the text is null");
        }
        JavadocTagInfo tag = TEXT_TO_TAG.get(text);
        if (tag == null) {
            throw new IllegalArgumentException("the text [" + text + "] is not a valid Javadoc tag text");
        }
        return tag;
    }

    public static JavadocTagInfo fromName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("the name is null");
        }
        JavadocTagInfo tag = NAME_TO_TAG.get(name);
        if (tag == null) {
            throw new IllegalArgumentException("the name [" + name + "] is not a valid Javadoc tag name");
        }
        return tag;
    }

    public static boolean isValidName(String name) {
        return NAME_TO_TAG.containsKey(name);
    }

    public String toString() {
        return "text [" + this.text + "] name [" + this.name + "] type [" + (Object)((Object)this.type) + "]";
    }

    static {
        DEF_TOKEN_TYPES_DEPRECATED = new int[]{8, 9, 10, 14, 15, 154, 155, 157, 161};
        DEF_TOKEN_TYPES = new int[]{8, 9, 10, 14, 15, 16, 154, 157};
        ImmutableMap.Builder textToTagBuilder = new ImmutableMap.Builder();
        ImmutableMap.Builder nameToTagBuilder = new ImmutableMap.Builder();
        for (JavadocTagInfo tag : JavadocTagInfo.values()) {
            textToTagBuilder.put((Object)tag.getText(), (Object)tag);
            nameToTagBuilder.put((Object)tag.getName(), (Object)tag);
        }
        TEXT_TO_TAG = textToTagBuilder.build();
        NAME_TO_TAG = nameToTagBuilder.build();
        Arrays.sort(DEF_TOKEN_TYPES);
        Arrays.sort(DEF_TOKEN_TYPES_DEPRECATED);
    }

    public static enum Type {
        BLOCK,
        INLINE;

    }
}

