/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.api;

import com.puppycrawl.tools.checkstyle.api.SeverityLevel;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public final class LocalizedMessage
implements Comparable<LocalizedMessage>,
Serializable {
    private static final long serialVersionUID = 5675176836184862150L;
    private static Locale sLocale = Locale.getDefault();
    private static final Map<String, ResourceBundle> BUNDLE_CACHE = Collections.synchronizedMap(new HashMap());
    private static final SeverityLevel DEFAULT_SEVERITY = SeverityLevel.ERROR;
    private final int lineNo;
    private final int colNo;
    private final SeverityLevel severityLevel;
    private final String moduleId;
    private final String key;
    private final Object[] args;
    private final String bundle;
    private final Class<?> sourceClass;
    private final String customMessage;

    public LocalizedMessage(int lineNo, int colNo, String bundle, String key, Object[] args, SeverityLevel severityLevel, String moduleId, Class<?> sourceClass, String customMessage) {
        this.lineNo = lineNo;
        this.colNo = colNo;
        this.key = key;
        this.args = null == args ? null : (Object[])args.clone();
        this.bundle = bundle;
        this.severityLevel = severityLevel;
        this.moduleId = moduleId;
        this.sourceClass = sourceClass;
        this.customMessage = customMessage;
    }

    public LocalizedMessage(int lineNo, int colNo, String bundle, String key, Object[] args, String moduleId, Class<?> sourceClass, String customMessage) {
        this(lineNo, colNo, bundle, key, args, DEFAULT_SEVERITY, moduleId, sourceClass, customMessage);
    }

    public LocalizedMessage(int lineNo, String bundle, String key, Object[] args, SeverityLevel severityLevel, String moduleId, Class<?> sourceClass, String customMessage) {
        this(lineNo, 0, bundle, key, args, severityLevel, moduleId, sourceClass, customMessage);
    }

    public LocalizedMessage(int lineNo, String bundle, String key, Object[] args, String moduleId, Class<?> sourceClass, String customMessage) {
        this(lineNo, 0, bundle, key, args, DEFAULT_SEVERITY, moduleId, sourceClass, customMessage);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        LocalizedMessage that = (LocalizedMessage)object;
        return Objects.equals(this.lineNo, that.lineNo) && Objects.equals(this.colNo, that.colNo) && Objects.equals((Object)this.severityLevel, (Object)that.severityLevel) && Objects.equals(this.moduleId, that.moduleId) && Objects.equals(this.key, that.key) && Objects.equals(this.bundle, that.bundle) && Objects.equals(this.sourceClass, that.sourceClass) && Objects.equals(this.customMessage, that.customMessage) && Arrays.equals(this.args, that.args);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.lineNo, this.colNo, this.severityLevel, this.moduleId, this.key, this.bundle, this.sourceClass, this.customMessage, Arrays.hashCode(this.args)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() {
        Map<String, ResourceBundle> map = BUNDLE_CACHE;
        synchronized (map) {
            BUNDLE_CACHE.clear();
        }
    }

    public String getMessage() {
        String customMessage = this.getCustomMessage();
        if (customMessage != null) {
            return customMessage;
        }
        try {
            ResourceBundle bundle = this.getBundle(this.bundle);
            String pattern = bundle.getString(this.key);
            return MessageFormat.format(pattern, this.args);
        }
        catch (MissingResourceException ex) {
            return MessageFormat.format(this.key, this.args);
        }
    }

    private String getCustomMessage() {
        if (this.customMessage == null) {
            return null;
        }
        return MessageFormat.format(this.customMessage, this.args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceBundle getBundle(String bundleName) {
        Map<String, ResourceBundle> map = BUNDLE_CACHE;
        synchronized (map) {
            ResourceBundle bundle = BUNDLE_CACHE.get(bundleName);
            if (bundle == null) {
                bundle = ResourceBundle.getBundle(bundleName, sLocale, this.sourceClass.getClassLoader(), new UTF8Control());
                BUNDLE_CACHE.put(bundleName, bundle);
            }
            return bundle;
        }
    }

    public int getLineNo() {
        return this.lineNo;
    }

    public int getColumnNo() {
        return this.colNo;
    }

    public SeverityLevel getSeverityLevel() {
        return this.severityLevel;
    }

    public String getModuleId() {
        return this.moduleId;
    }

    public String getKey() {
        return this.key;
    }

    public String getSourceName() {
        return this.sourceClass.getName();
    }

    public static void setLocale(Locale locale) {
        sLocale = Locale.ENGLISH.getLanguage().equals(locale.getLanguage()) ? Locale.ROOT : locale;
    }

    @Override
    public int compareTo(LocalizedMessage other) {
        if (this.getLineNo() == other.getLineNo()) {
            if (this.getColumnNo() == other.getColumnNo()) {
                return this.getMessage().compareTo(other.getMessage());
            }
            return this.getColumnNo() < other.getColumnNo() ? -1 : 1;
        }
        return this.getLineNo() < other.getLineNo() ? -1 : 1;
    }

    protected static class UTF8Control
    extends ResourceBundle.Control {
        protected UTF8Control() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ResourceBundle newBundle(String aBaseName, Locale aLocale, String aFormat, ClassLoader aLoader, boolean aReload) throws IOException {
            String bundleName = this.toBundleName(aBaseName, aLocale);
            String resourceName = this.toResourceName(bundleName, "properties");
            InputStream stream = null;
            if (aReload) {
                URLConnection connection;
                URL url = aLoader.getResource(resourceName);
                if (url != null && (connection = url.openConnection()) != null) {
                    connection.setUseCaches(false);
                    stream = connection.getInputStream();
                }
            } else {
                stream = aLoader.getResourceAsStream(resourceName);
            }
            PropertyResourceBundle bundle = null;
            if (stream != null) {
                InputStreamReader streamReader = new InputStreamReader(stream, "UTF-8");
                try {
                    bundle = new PropertyResourceBundle(streamReader);
                }
                finally {
                    stream.close();
                }
            }
            return bundle;
        }
    }
}

