/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.beanutils.ConversionException;

public class SuppressWarningsHolder
extends Check {
    public static final String MSG_KEY = "suppress.warnings.invalid.target";
    public static final String CHECKSTYLE_PREFIX = "checkstyle:";
    private static final String JAVA_LANG_PREFIX = "java.lang.";
    private static final String CHECK_SUFFIX = "Check";
    private static final Map<String, String> CHECK_ALIAS_MAP = new HashMap<String, String>();
    private static final ThreadLocal<List<Entry>> ENTRIES = new ThreadLocal();

    public static String getDefaultAlias(String sourceName) {
        int startIndex = sourceName.lastIndexOf(46) + 1;
        int endIndex = sourceName.length();
        if (sourceName.endsWith(CHECK_SUFFIX)) {
            endIndex -= CHECK_SUFFIX.length();
        }
        return sourceName.substring(startIndex, endIndex).toLowerCase(Locale.ENGLISH);
    }

    public static String getAlias(String sourceName) {
        String checkAlias = CHECK_ALIAS_MAP.get(sourceName);
        if (checkAlias == null) {
            checkAlias = SuppressWarningsHolder.getDefaultAlias(sourceName);
        }
        return checkAlias;
    }

    public static void registerAlias(String sourceName, String checkAlias) {
        CHECK_ALIAS_MAP.put(sourceName, checkAlias);
    }

    public void setAliasList(String aliasList) {
        for (String sourceAlias : aliasList.split(",")) {
            int index = sourceAlias.indexOf(61);
            if (index > 0) {
                SuppressWarningsHolder.registerAlias(sourceAlias.substring(0, index), sourceAlias.substring(index + 1));
                continue;
            }
            if (sourceAlias.isEmpty()) continue;
            throw new ConversionException("'=' expected in alias list item: " + sourceAlias);
        }
    }

    public static boolean isSuppressed(String sourceName, int line, int column) {
        List<Entry> entries = ENTRIES.get();
        String checkAlias = SuppressWarningsHolder.getAlias(sourceName);
        for (Entry entry : entries) {
            boolean afterStart = entry.getFirstLine() < line || entry.getFirstLine() == line && entry.getFirstColumn() <= column;
            boolean beforeEnd = entry.getLastLine() > line || entry.getLastLine() == line && entry.getLastColumn() >= column;
            boolean nameMatches = entry.getCheckName().equals(checkAlias);
            if (!afterStart || !beforeEnd || !nameMatches) continue;
            return true;
        }
        return false;
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{159};
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        ENTRIES.set(new LinkedList());
    }

    @Override
    public void visitToken(DetailAST ast) {
        String identifier = SuppressWarningsHolder.getIdentifier(SuppressWarningsHolder.getNthChild(ast, 1));
        if (identifier.startsWith(JAVA_LANG_PREFIX)) {
            identifier = identifier.substring(JAVA_LANG_PREFIX.length());
        }
        if ("SuppressWarnings".equals(identifier)) {
            int lastColumn;
            int lastLine;
            List<String> values = SuppressWarningsHolder.getAllAnnotationValues(ast);
            if (SuppressWarningsHolder.isAnnotationEmpty(values)) {
                return;
            }
            DetailAST targetAST = SuppressWarningsHolder.getAnnotationTarget(ast);
            if (targetAST == null) {
                this.log(ast.getLineNo(), MSG_KEY, new Object[0]);
                return;
            }
            int firstLine = targetAST.getLineNo();
            int firstColumn = targetAST.getColumnNo();
            DetailAST nextAST = targetAST.getNextSibling();
            if (nextAST != null) {
                lastLine = nextAST.getLineNo();
                lastColumn = nextAST.getColumnNo() - 1;
            } else {
                lastLine = Integer.MAX_VALUE;
                lastColumn = Integer.MAX_VALUE;
            }
            List<Entry> entries = ENTRIES.get();
            if (entries != null) {
                for (String value : values) {
                    if (value.startsWith(CHECKSTYLE_PREFIX)) {
                        value = value.substring(CHECKSTYLE_PREFIX.length());
                    }
                    entries.add(new Entry(value, firstLine, firstColumn, lastLine, lastColumn));
                }
            }
        }
    }

    private static List<String> getAllAnnotationValues(DetailAST ast) {
        DetailAST nextAST;
        List<String> values = null;
        DetailAST lparenAST = ast.findFirstToken(76);
        if (lparenAST != null && (nextAST = lparenAST.getNextSibling()) != null) {
            int nextType = nextAST.getType();
            switch (nextType) {
                case 28: 
                case 162: {
                    values = SuppressWarningsHolder.getAnnotationValues(nextAST);
                    break;
                }
                case 160: {
                    values = SuppressWarningsHolder.getAnnotationValues(SuppressWarningsHolder.getNthChild(nextAST, 2));
                    break;
                }
                case 77: {
                    break;
                }
            }
        }
        return values;
    }

    private static boolean isAnnotationEmpty(List<String> values) {
        return values == null;
    }

    private static DetailAST getAnnotationTarget(DetailAST ast) {
        DetailAST targetAST = null;
        DetailAST parentAST = ast.getParent();
        if (parentAST != null) {
            block0 : switch (parentAST.getType()) {
                case 5: 
                case 158: {
                    parentAST = parentAST.getParent();
                    if (parentAST == null) break;
                    switch (parentAST.getType()) {
                        case 8: 
                        case 9: 
                        case 10: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 16: 
                        case 19: 
                        case 21: 
                        case 59: 
                        case 81: 
                        case 136: 
                        case 154: 
                        case 155: 
                        case 157: 
                        case 161: 
                        case 164: {
                            targetAST = parentAST;
                            break block0;
                        }
                    }
                    break;
                }
            }
        }
        return targetAST;
    }

    private static DetailAST getNthChild(DetailAST ast, int index) {
        DetailAST child = ast.getFirstChild();
        if (child != null) {
            for (int i = 0; i < index && child != null; child = child.getNextSibling(), ++i) {
            }
        }
        return child;
    }

    private static String getIdentifier(DetailAST ast) {
        if (ast != null) {
            if (ast.getType() == 58) {
                return ast.getText();
            }
            if (ast.getType() == 59) {
                return SuppressWarningsHolder.getIdentifier(ast.getFirstChild()) + "." + SuppressWarningsHolder.getIdentifier(ast.getLastChild());
            }
        }
        throw new IllegalArgumentException("Identifier AST expected: " + (Object)((Object)ast));
    }

    private static String getStringExpr(DetailAST ast) {
        if (ast != null && ast.getType() == 28) {
            DetailAST firstChild = ast.getFirstChild();
            switch (firstChild.getType()) {
                case 139: {
                    String quotedText = firstChild.getText();
                    return quotedText.substring(1, quotedText.length() - 1);
                }
                case 58: {
                    return firstChild.getText();
                }
                case 59: {
                    return firstChild.getLastChild().getText();
                }
            }
            return "";
        }
        throw new IllegalArgumentException("Expression AST expected: " + (Object)((Object)ast));
    }

    private static List<String> getAnnotationValues(DetailAST ast) {
        switch (ast.getType()) {
            case 28: {
                return ImmutableList.of((Object)SuppressWarningsHolder.getStringExpr(ast));
            }
            case 162: {
                LinkedList valueList = Lists.newLinkedList();
                for (DetailAST childAST = ast.getFirstChild(); childAST != null; childAST = childAST.getNextSibling()) {
                    if (childAST.getType() != 28) continue;
                    valueList.add(SuppressWarningsHolder.getStringExpr(childAST));
                }
                return valueList;
            }
        }
        throw new IllegalArgumentException("Expression or annotation array initializer AST expected: " + (Object)((Object)ast));
    }

    private static class Entry {
        private final String checkName;
        private final int firstLine;
        private final int firstColumn;
        private final int lastLine;
        private final int lastColumn;

        public Entry(String checkName, int firstLine, int firstColumn, int lastLine, int lastColumn) {
            this.checkName = checkName;
            this.firstLine = firstLine;
            this.firstColumn = firstColumn;
            this.lastLine = lastLine;
            this.lastColumn = lastColumn;
        }

        public String getCheckName() {
            return this.checkName;
        }

        public int getFirstLine() {
            return this.firstLine;
        }

        public int getFirstColumn() {
            return this.firstColumn;
        }

        public int getLastLine() {
            return this.lastLine;
        }

        public int getLastColumn() {
            return this.lastColumn;
        }
    }
}

