/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.blocks;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.AbstractOptionCheck;
import com.puppycrawl.tools.checkstyle.checks.blocks.BlockOption;
import org.apache.commons.lang3.StringUtils;

public class EmptyBlockCheck
extends AbstractOptionCheck<BlockOption> {
    public static final String MSG_KEY_BLOCK_NO_STMT = "block.noStmt";
    public static final String MSG_KEY_BLOCK_EMPTY = "block.empty";

    public EmptyBlockCheck() {
        super(BlockOption.STMT, BlockOption.class);
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{84, 95, 97, 85, 83, 92, 91, 11, 12, 89, 67};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{84, 95, 96, 97, 85, 83, 92, 91, 11, 12, 89, 67, 93, 94, 29};
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST leftCurly;
        DetailAST slistToken = ast.findFirstToken(7);
        DetailAST detailAST = leftCurly = slistToken != null ? slistToken : ast.findFirstToken(72);
        if (leftCurly != null) {
            if (this.getAbstractOption() == BlockOption.STMT) {
                boolean emptyBlock;
                if (leftCurly.getType() == 72) {
                    emptyBlock = leftCurly.getNextSibling().getType() != 33;
                } else {
                    boolean bl = emptyBlock = leftCurly.getChildCount() <= 1;
                }
                if (emptyBlock) {
                    this.log(leftCurly.getLineNo(), leftCurly.getColumnNo(), MSG_KEY_BLOCK_NO_STMT, ast.getText());
                }
            } else if (!this.hasText(leftCurly)) {
                this.log(leftCurly.getLineNo(), leftCurly.getColumnNo(), MSG_KEY_BLOCK_EMPTY, ast.getText());
            }
        }
    }

    protected boolean hasText(DetailAST slistAST) {
        boolean retVal;
        block4: {
            String[] lines;
            int rcurlyColNo;
            int rcurlyLineNo;
            int slistColNo;
            int slistLineNo;
            block3: {
                retVal = false;
                DetailAST rightCurly = slistAST.findFirstToken(73);
                DetailAST rcurlyAST = rightCurly != null ? rightCurly : slistAST.getParent().findFirstToken(73);
                slistLineNo = slistAST.getLineNo();
                slistColNo = slistAST.getColumnNo();
                rcurlyLineNo = rcurlyAST.getLineNo();
                rcurlyColNo = rcurlyAST.getColumnNo();
                lines = this.getLines();
                if (slistLineNo != rcurlyLineNo) break block3;
                String txt = lines[slistLineNo - 1].substring(slistColNo + 1, rcurlyColNo);
                if (!StringUtils.isNotBlank((CharSequence)txt)) break block4;
                retVal = true;
                break block4;
            }
            if (!lines[slistLineNo - 1].substring(slistColNo + 1).trim().isEmpty() || !lines[rcurlyLineNo - 1].substring(0, rcurlyColNo).trim().isEmpty()) {
                retVal = true;
            } else {
                for (int i = slistLineNo; i < rcurlyLineNo - 1; ++i) {
                    if (lines[i].trim().isEmpty()) continue;
                    retVal = true;
                    break;
                }
            }
        }
        return retVal;
    }
}

