/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FallThroughCheck
extends Check {
    public static final String MSG_FALL_THROUGH = "fall.through";
    public static final String MSG_FALL_THROUGH_LAST = "fall.through.last";
    private boolean checkLastGroup;
    private String reliefPattern = "fallthru|falls? ?through";
    private Pattern regExp;

    @Override
    public int[] getDefaultTokens() {
        return new int[]{33};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{33};
    }

    public void setReliefPattern(String pattern) {
        this.reliefPattern = pattern;
    }

    public void setCheckLastCaseGroup(boolean value) {
        this.checkLastGroup = value;
    }

    @Override
    public void init() {
        super.init();
        this.regExp = Pattern.compile(this.reliefPattern);
    }

    @Override
    public void visitToken(DetailAST ast) {
        boolean isLastGroup;
        DetailAST nextGroup = ast.getNextSibling();
        boolean bl = isLastGroup = nextGroup.getType() != 33;
        if (isLastGroup && !this.checkLastGroup) {
            return;
        }
        DetailAST slist = ast.findFirstToken(7);
        if (slist != null && !this.isTerminated(slist, true, true) && !this.hasFallTruComment(ast, nextGroup)) {
            if (!isLastGroup) {
                this.log(nextGroup, MSG_FALL_THROUGH, new Object[0]);
            } else {
                this.log(ast, MSG_FALL_THROUGH_LAST, new Object[0]);
            }
        }
    }

    private boolean isTerminated(DetailAST ast, boolean useBreak, boolean useContinue) {
        switch (ast.getType()) {
            case 88: 
            case 90: {
                return true;
            }
            case 86: {
                return useBreak;
            }
            case 87: {
                return useContinue;
            }
            case 7: {
                return this.checkSlist(ast, useBreak, useContinue);
            }
            case 83: {
                return this.checkIf(ast, useBreak, useContinue);
            }
            case 84: 
            case 85: 
            case 91: {
                return this.checkLoop(ast);
            }
            case 95: {
                return this.checkTry(ast, useBreak, useContinue);
            }
            case 89: {
                return this.checkSwitch(ast, useContinue);
            }
        }
        return false;
    }

    private boolean checkSlist(DetailAST slistAst, boolean useBreak, boolean useContinue) {
        DetailAST lastStmt = slistAst.getLastChild();
        if (lastStmt.getType() == 73) {
            lastStmt = lastStmt.getPreviousSibling();
        }
        return lastStmt != null && this.isTerminated(lastStmt, useBreak, useContinue);
    }

    private boolean checkIf(DetailAST ast, boolean useBreak, boolean useContinue) {
        DetailAST thenStmt = ast.findFirstToken(77).getNextSibling();
        DetailAST elseStmt = thenStmt.getNextSibling();
        boolean isTerminated = this.isTerminated(thenStmt, useBreak, useContinue);
        if (isTerminated && elseStmt != null) {
            isTerminated = this.isTerminated(elseStmt.getFirstChild(), useBreak, useContinue);
        } else if (elseStmt == null) {
            isTerminated = false;
        }
        return isTerminated;
    }

    private boolean checkLoop(DetailAST ast) {
        DetailAST loopBody = null;
        if (ast.getType() == 85) {
            DetailAST lparen = ast.findFirstToken(175);
            loopBody = lparen.getPreviousSibling();
        } else {
            DetailAST rparen = ast.findFirstToken(77);
            loopBody = rparen.getNextSibling();
        }
        return this.isTerminated(loopBody, false, false);
    }

    private boolean checkTry(DetailAST ast, boolean useBreak, boolean useContinue) {
        DetailAST catchBody;
        DetailAST finalStmt = ast.getLastChild();
        if (finalStmt.getType() == 97) {
            return this.isTerminated(finalStmt.findFirstToken(7), useBreak, useContinue);
        }
        boolean isTerminated = this.isTerminated(ast.getFirstChild(), useBreak, useContinue);
        for (DetailAST catchStmt = ast.findFirstToken(96); catchStmt != null && isTerminated; isTerminated &= this.isTerminated(catchBody, useBreak, useContinue), catchStmt = catchStmt.getNextSibling()) {
            catchBody = catchStmt.findFirstToken(7);
        }
        return isTerminated;
    }

    private boolean checkSwitch(DetailAST literalSwitchAst, boolean useContinue) {
        boolean isTerminated;
        DetailAST caseGroup = literalSwitchAst.findFirstToken(33);
        boolean bl = isTerminated = caseGroup != null;
        while (isTerminated && caseGroup.getType() != 73) {
            DetailAST caseBody = caseGroup.findFirstToken(7);
            isTerminated = caseBody != null && this.isTerminated(caseBody, false, useContinue);
            caseGroup = caseGroup.getNextSibling();
        }
        return isTerminated;
    }

    private boolean hasFallTruComment(DetailAST currentCase, DetailAST nextCase) {
        int endLineNo = nextCase.getLineNo();
        int endColNo = nextCase.getColumnNo();
        String[] lines = this.getLines();
        String linepart = lines[endLineNo - 1].substring(0, endColNo);
        if (this.commentMatch(this.regExp, linepart, endLineNo)) {
            return true;
        }
        int startLineNo = currentCase.getLineNo();
        for (int i = endLineNo - 2; i > startLineNo - 1; --i) {
            if (lines[i].trim().isEmpty()) continue;
            return this.commentMatch(this.regExp, lines[i], i + 1);
        }
        return false;
    }

    private boolean commentMatch(Pattern pattern, String line, int lineNo) {
        Matcher matcher = pattern.matcher(line);
        boolean hit = matcher.find();
        if (hit) {
            int startMatch = matcher.start();
            int endMatch = matcher.end() - 1;
            return this.getFileContents().hasIntersectionWithComment(lineNo, startMatch, lineNo, endMatch);
        }
        return false;
    }
}

