/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.puppycrawl.tools.checkstyle.Utils;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class MultipleStringLiteralsCheck
extends Check {
    public static final String MSG_KEY = "multiple.string.literal";
    private final Map<String, List<StringInfo>> stringMap = Maps.newHashMap();
    private final BitSet ignoreOccurrenceContext = new BitSet();
    private int allowedDuplicates = 1;
    private Pattern pattern;

    public MultipleStringLiteralsCheck() {
        this.setIgnoreStringsRegexp("^\"\"$");
        this.ignoreOccurrenceContext.set(159);
    }

    public void setAllowedDuplicates(int allowedDuplicates) {
        this.allowedDuplicates = allowedDuplicates;
    }

    public void setIgnoreStringsRegexp(String ignoreStringsRegexp) {
        this.pattern = ignoreStringsRegexp != null && !ignoreStringsRegexp.isEmpty() ? Utils.createPattern(ignoreStringsRegexp) : null;
    }

    public final void setIgnoreOccurrenceContext(String ... strRep) {
        this.ignoreOccurrenceContext.clear();
        for (String s : strRep) {
            int type = Utils.getTokenId(s);
            this.ignoreOccurrenceContext.set(type);
        }
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{139};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{139};
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (this.isInIgnoreOccurrenceContext(ast)) {
            return;
        }
        String currentString = ast.getText();
        if (this.pattern == null || !this.pattern.matcher(currentString).find()) {
            ArrayList hitList = this.stringMap.get(currentString);
            if (hitList == null) {
                hitList = Lists.newArrayList();
                this.stringMap.put(currentString, hitList);
            }
            int line = ast.getLineNo();
            int col = ast.getColumnNo();
            hitList.add(new StringInfo(line, col));
        }
    }

    private boolean isInIgnoreOccurrenceContext(DetailAST ast) {
        DetailAST token = ast;
        while (token.getParent() != null) {
            int type = token.getType();
            if (this.ignoreOccurrenceContext.get(type)) {
                return true;
            }
            token = token.getParent();
        }
        return false;
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        super.beginTree(rootAST);
        this.stringMap.clear();
    }

    @Override
    public void finishTree(DetailAST rootAST) {
        for (Map.Entry<String, List<StringInfo>> stringListEntry : this.stringMap.entrySet()) {
            List<StringInfo> hits = stringListEntry.getValue();
            if (hits.size() <= this.allowedDuplicates) continue;
            StringInfo firstFinding = hits.get(0);
            int line = firstFinding.getLine();
            int col = firstFinding.getCol();
            this.log(line, col, MSG_KEY, stringListEntry.getKey(), hits.size());
        }
    }

    private static final class StringInfo {
        private final int line;
        private final int col;

        public StringInfo(int line, int col) {
            this.line = line;
            this.col = col;
        }

        private int getLine() {
            return this.line;
        }

        private int getCol() {
            return this.col;
        }
    }
}

