/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.imports;

import com.puppycrawl.tools.checkstyle.Utils;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class CustomImportOrderCheck
extends Check {
    public static final String MSG_LINE_SEPARATOR = "custom.import.order.line.separator";
    public static final String MSG_LEX = "custom.import.order.lex";
    public static final String MSG_NONGROUP_IMPORT = "custom.import.order.nongroup.import";
    public static final String MSG_ORDER = "custom.import.order";
    private static final String STATIC_RULE_GROUP = "STATIC";
    private static final String SAME_PACKAGE_RULE_GROUP = "SAME_PACKAGE";
    private static final String THIRD_PARTY_PACKAGE_RULE_GROUP = "THIRD_PARTY_PACKAGE";
    private static final String STANDARD_JAVA_PACKAGE_RULE_GROUP = "STANDARD_JAVA_PACKAGE";
    private static final String SPECIAL_IMPORTS_RULE_GROUP = "SPECIAL_IMPORTS";
    private static final String NON_GROUP_RULE_GROUP = "NON_GROUP";
    private String samePackageDomainsRegExp = "";
    private Pattern standardPackageRegExp = Pattern.compile("^(java|javax)\\.");
    private Pattern thirdPartyPackageRegExp = Pattern.compile(".*");
    private Pattern specialImportsRegExp = Pattern.compile("^$");
    private boolean separateLineBetweenGroups = true;
    private boolean sortImportsInGroupAlphabetically;
    private final List<String> customImportOrderRules = new ArrayList<String>();
    private int samePackageMatchingDepth = 2;
    private final List<ImportDetails> importToGroupList = new ArrayList<ImportDetails>();

    public final void setStandardPackageRegExp(String regexp) {
        this.standardPackageRegExp = Utils.createPattern(regexp);
    }

    public final void setThirdPartyPackageRegExp(String regexp) {
        this.thirdPartyPackageRegExp = Utils.createPattern(regexp);
    }

    public final void setSpecialImportsRegExp(String regexp) {
        this.specialImportsRegExp = Utils.createPattern(regexp);
    }

    public final void setSeparateLineBetweenGroups(boolean value) {
        this.separateLineBetweenGroups = value;
    }

    public final void setSortImportsInGroupAlphabetically(boolean value) {
        this.sortImportsInGroupAlphabetically = value;
    }

    public final void setCustomImportOrderRules(String inputCustomImportOrder) {
        this.customImportOrderRules.clear();
        for (String currentState : inputCustomImportOrder.split("\\s*###\\s*")) {
            this.addRuleastoList(currentState);
        }
        this.customImportOrderRules.add(NON_GROUP_RULE_GROUP);
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{30, 152, 16};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{30, 152, 16};
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.importToGroupList.clear();
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (ast.getType() == 16) {
            if (this.customImportOrderRules.contains(SAME_PACKAGE_RULE_GROUP)) {
                this.samePackageDomainsRegExp = CustomImportOrderCheck.createSamePackageRegexp(this.samePackageMatchingDepth, ast);
            }
        } else {
            String importFullPath = CustomImportOrderCheck.getFullImportIdent(ast);
            int lineNo = ast.getLineNo();
            boolean isStatic = ast.getType() == 152;
            this.importToGroupList.add(new ImportDetails(importFullPath, lineNo, this.getImportGroup(isStatic, importFullPath), isStatic));
        }
    }

    @Override
    public void finishTree(DetailAST rootAST) {
        if (this.importToGroupList.isEmpty()) {
            return;
        }
        ImportDetails firstImport = this.importToGroupList.get(0);
        String currentGroup = this.getImportGroup(firstImport.isStaticImport(), firstImport.getImportFullPath());
        int groupNumber = this.customImportOrderRules.indexOf(currentGroup);
        String previousImport = null;
        for (ImportDetails importObject : this.importToGroupList) {
            String importGroup = importObject.getImportGroup();
            String fullImportIdent = importObject.importFullPath;
            if (!importGroup.equals(currentGroup)) {
                if (this.customImportOrderRules.size() > groupNumber + 1) {
                    String nextGroup = this.getNextImportGroup(groupNumber + 1);
                    if (importGroup.equals(nextGroup)) {
                        if (this.separateLineBetweenGroups && !this.hasEmptyLineBefore(importObject.getLineNumber())) {
                            this.log(importObject.getLineNumber(), MSG_LINE_SEPARATOR, fullImportIdent);
                        }
                        currentGroup = nextGroup;
                        groupNumber = this.customImportOrderRules.indexOf(nextGroup);
                    } else {
                        this.logWrongImportGroupOrder(importObject.getLineNumber(), importGroup);
                    }
                } else {
                    this.logWrongImportGroupOrder(importObject.getLineNumber(), importGroup);
                }
            } else if (this.sortImportsInGroupAlphabetically && previousImport != null && this.matchesImportGroup(importObject.isStaticImport(), fullImportIdent, currentGroup) && CustomImportOrderCheck.compareImports(fullImportIdent, previousImport) < 0) {
                this.log(importObject.getLineNumber(), MSG_LEX, fullImportIdent);
            }
            previousImport = fullImportIdent;
        }
    }

    private void logWrongImportGroupOrder(int currentImportLine, String importGroup) {
        if (NON_GROUP_RULE_GROUP.equals(importGroup)) {
            this.log(currentImportLine, MSG_NONGROUP_IMPORT, new Object[0]);
        } else {
            this.log(currentImportLine, MSG_ORDER, importGroup);
        }
    }

    private String getNextImportGroup(int currentGroupNumber) {
        int nextGroupNumber = currentGroupNumber;
        while (this.customImportOrderRules.size() > nextGroupNumber + 1 && !this.hasAnyImportInCurrentGroup(this.customImportOrderRules.get(nextGroupNumber))) {
            ++nextGroupNumber;
        }
        return this.customImportOrderRules.get(nextGroupNumber);
    }

    private boolean hasAnyImportInCurrentGroup(String currentGroup) {
        for (ImportDetails currentImport : this.importToGroupList) {
            if (!currentGroup.equals(currentImport.getImportGroup())) continue;
            return true;
        }
        return false;
    }

    private String getImportGroup(boolean isStatic, String importPath) {
        for (String group : this.customImportOrderRules) {
            if (!this.matchesImportGroup(isStatic, importPath, group)) continue;
            return group;
        }
        return NON_GROUP_RULE_GROUP;
    }

    private boolean matchesImportGroup(boolean isStatic, String importPath, String currentGroup) {
        return CustomImportOrderCheck.matchesStaticImportGroup(isStatic, currentGroup) || this.matchesSamePackageImportGroup(isStatic, importPath, currentGroup) || this.matchesSpecialImportsGroup(isStatic, importPath, currentGroup) || this.matchesStandartImportGroup(isStatic, importPath, currentGroup) || this.matchesThirdPartyImportGroup(isStatic, importPath, currentGroup);
    }

    private static boolean matchesStaticImportGroup(boolean isStatic, String currentGroup) {
        return isStatic && STATIC_RULE_GROUP.equals(currentGroup);
    }

    private boolean matchesSamePackageImportGroup(boolean isStatic, String importFullPath, String currentGroup) {
        String importPath = importFullPath.substring(0, importFullPath.lastIndexOf(46));
        return !isStatic && SAME_PACKAGE_RULE_GROUP.equals(currentGroup) && this.samePackageDomainsRegExp.contains(importPath);
    }

    private boolean matchesStandartImportGroup(boolean isStatic, String currentImport, String currentGroup) {
        return !isStatic && STANDARD_JAVA_PACKAGE_RULE_GROUP.equals(currentGroup) && this.standardPackageRegExp.matcher(currentImport).find();
    }

    private boolean matchesSpecialImportsGroup(boolean isStatic, String currentImport, String currentGroup) {
        return !isStatic && SPECIAL_IMPORTS_RULE_GROUP.equals(currentGroup) && this.specialImportsRegExp.matcher(currentImport).find();
    }

    private boolean matchesThirdPartyImportGroup(boolean isStatic, String currentImport, String currentGroup) {
        return !isStatic && THIRD_PARTY_PACKAGE_RULE_GROUP.equals(currentGroup) && this.thirdPartyPackageRegExp.matcher(currentImport).find() && !this.standardPackageRegExp.matcher(currentImport).find() && !this.specialImportsRegExp.matcher(currentImport).find();
    }

    private static int compareImports(String import1, String import2) {
        String import2Token;
        String import1Token;
        int result = 0;
        String[] import1Tokens = import1.split("\\.");
        String[] import2Tokens = import2.split("\\.");
        for (int i = 0; i < import1Tokens.length && i != import2Tokens.length && (result = (import1Token = import1Tokens[i]).compareTo(import2Token = import2Tokens[i])) == 0; ++i) {
        }
        return result;
    }

    private boolean hasEmptyLineBefore(int lineNo) {
        String lineBefore = this.getLine(lineNo - 2);
        return lineBefore.trim().isEmpty();
    }

    private static String getFullImportIdent(DetailAST token) {
        return token != null ? FullIdent.createFullIdent(token.findFirstToken(59)).getText() : "";
    }

    private void addRuleastoList(String ruleStr) {
        if (STATIC_RULE_GROUP.equals(ruleStr) || THIRD_PARTY_PACKAGE_RULE_GROUP.equals(ruleStr) || STANDARD_JAVA_PACKAGE_RULE_GROUP.equals(ruleStr) || SPECIAL_IMPORTS_RULE_GROUP.equals(ruleStr)) {
            this.customImportOrderRules.add(ruleStr);
        } else if (ruleStr.startsWith(SAME_PACKAGE_RULE_GROUP)) {
            String rule = ruleStr.substring(ruleStr.indexOf(40) + 1, ruleStr.indexOf(41));
            this.samePackageMatchingDepth = Integer.parseInt(rule);
            if (this.samePackageMatchingDepth <= 0) {
                throw new IllegalArgumentException("SAME_PACKAGE rule parameter should be positive integer: " + ruleStr);
            }
            this.customImportOrderRules.add(SAME_PACKAGE_RULE_GROUP);
        } else {
            throw new RuntimeException("Unexpected rule: " + ruleStr);
        }
    }

    private static String createSamePackageRegexp(int firstPackageDomainsCount, DetailAST packageNode) {
        StringBuilder builder = new StringBuilder();
        String packageFullPath = CustomImportOrderCheck.getFullImportIdent(packageNode);
        StringTokenizer tokens = new StringTokenizer(packageFullPath, ".");
        for (int count = firstPackageDomainsCount; tokens.hasMoreTokens() && count > 0; --count) {
            builder.append(tokens.nextToken()).append('.');
        }
        return builder.append("*").toString();
    }

    static class ImportDetails {
        private String importFullPath;
        private int lineNumber;
        private String importGroup;
        private boolean staticImport;

        public ImportDetails(String importFullPath, int lineNumber, String importGroup, boolean staticImport) {
            this.setImportFullPath(importFullPath);
            this.setLineNumber(lineNumber);
            this.setImportGroup(importGroup);
            this.setStaticImport(staticImport);
        }

        public String getImportFullPath() {
            return this.importFullPath;
        }

        public void setImportFullPath(String importFullPath) {
            this.importFullPath = importFullPath;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public void setLineNumber(int lineNumber) {
            this.lineNumber = lineNumber;
        }

        public String getImportGroup() {
            return this.importGroup;
        }

        public void setImportGroup(String importGroup) {
            this.importGroup = importGroup;
        }

        public boolean isStaticImport() {
            return this.staticImport;
        }

        public void setStaticImport(boolean isStatic) {
            this.staticImport = isStatic;
        }
    }
}

