/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.whitespace;

import com.puppycrawl.tools.checkstyle.Utils;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class GenericWhitespaceCheck
extends Check {
    public static final String WS_PRECEDED = "ws.preceded";
    public static final String WS_FOLLOWED = "ws.followed";
    public static final String WS_NOT_PRECEDED = "ws.notPreceded";
    public static final String WS_ILLEGAL_FOLLOW = "ws.illegalFollow";
    private int depth;

    @Override
    public int[] getDefaultTokens() {
        return new int[]{172, 173};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{172, 173};
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.depth = 0;
    }

    @Override
    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 172: {
                this.processStart(ast);
                ++this.depth;
                break;
            }
            case 173: {
                this.processEnd(ast);
                --this.depth;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type " + (Object)((Object)ast));
            }
        }
    }

    private void processEnd(DetailAST ast) {
        String line = this.getLine(ast.getLineNo() - 1);
        int before = ast.getColumnNo() - 1;
        int after = ast.getColumnNo() + 1;
        if (before >= 0 && Character.isWhitespace(line.charAt(before)) && !Utils.whitespaceBefore(before, line)) {
            this.log(ast.getLineNo(), before, WS_PRECEDED, ">");
        }
        if (after < line.length()) {
            if (1 == this.depth) {
                this.processSingleGeneric(ast, line, after);
            } else {
                this.processNestedGenerics(ast, line, after);
            }
        }
    }

    private void processNestedGenerics(DetailAST ast, String line, int after) {
        int indexOfAmp = line.indexOf(38, after);
        if (indexOfAmp >= 0 && GenericWhitespaceCheck.whitespaceBetween(after, indexOfAmp, line)) {
            if (indexOfAmp - after == 0) {
                this.log(ast.getLineNo(), after, WS_NOT_PRECEDED, "&");
            } else if (indexOfAmp - after != 1) {
                this.log(ast.getLineNo(), after, WS_FOLLOWED, ">");
            }
        } else if (line.charAt(after) == ' ') {
            this.log(ast.getLineNo(), after, WS_FOLLOWED, ">");
        }
    }

    private void processSingleGeneric(DetailAST ast, String line, int after) {
        char charAfter = line.charAt(after);
        if (GenericWhitespaceCheck.isGenericBeforeMethod(ast)) {
            if (Character.isWhitespace(charAfter)) {
                this.log(ast.getLineNo(), after, WS_FOLLOWED, ">");
            }
        } else if (!Character.isWhitespace(charAfter) && charAfter != '(' && charAfter != ')' && charAfter != ',' && charAfter != '[' && charAfter != '.' && charAfter != ':') {
            this.log(ast.getLineNo(), after, WS_ILLEGAL_FOLLOW, ">");
        }
    }

    private static boolean isGenericBeforeMethod(DetailAST ast) {
        return ast.getParent().getType() == 163 && ast.getParent().getParent().getType() == 59 && ast.getParent().getParent().getParent().getType() == 27 || GenericWhitespaceCheck.isAfterMethodReference(ast);
    }

    private static boolean isAfterMethodReference(DetailAST genericEnd) {
        return genericEnd.getParent().getParent().getType() == 180;
    }

    private void processStart(DetailAST ast) {
        String line = this.getLine(ast.getLineNo() - 1);
        int before = ast.getColumnNo() - 1;
        int after = ast.getColumnNo() + 1;
        if (before >= 0) {
            DetailAST parent = ast.getParent();
            DetailAST grandparent = parent.getParent();
            if (165 == parent.getType() && (8 == grandparent.getType() || 9 == grandparent.getType())) {
                if (!Character.isWhitespace(line.charAt(before))) {
                    this.log(ast.getLineNo(), before, WS_NOT_PRECEDED, "<");
                }
            } else if (Character.isWhitespace(line.charAt(before)) && !Utils.whitespaceBefore(before, line)) {
                this.log(ast.getLineNo(), before, WS_PRECEDED, "<");
            }
        }
        if (after < line.length() && Character.isWhitespace(line.charAt(after))) {
            this.log(ast.getLineNo(), after, WS_FOLLOWED, "<");
        }
    }

    private static boolean whitespaceBetween(int fromIndex, int toIndex, String line) {
        for (int i = fromIndex; i < toIndex; ++i) {
            if (Character.isWhitespace(line.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

