/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.filters;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.Lists;
import com.puppycrawl.tools.checkstyle.Utils;
import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.AutomaticBean;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.Filter;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.checks.FileContentsHolder;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.beanutils.ConversionException;

public class SuppressWithNearbyCommentFilter
extends AutomaticBean
implements Filter {
    private static final String DEFAULT_COMMENT_FORMAT = "SUPPRESS CHECKSTYLE (\\w+)";
    private static final String DEFAULT_CHECK_FORMAT = ".*";
    private static final String DEFAULT_INFLUENCE_FORMAT = "0";
    private boolean checkC = true;
    private boolean checkCPP = true;
    private Pattern commentRegexp;
    private String checkFormat;
    private String messageFormat;
    private String influenceFormat;
    private final List<Tag> tags = Lists.newArrayList();
    private WeakReference<FileContents> fileContentsReference = new WeakReference<Object>(null);

    public SuppressWithNearbyCommentFilter() {
        this.setCommentFormat(DEFAULT_COMMENT_FORMAT);
        this.setCheckFormat(DEFAULT_CHECK_FORMAT);
        this.setInfluenceFormat(DEFAULT_INFLUENCE_FORMAT);
    }

    public void setCommentFormat(String format) {
        this.commentRegexp = Utils.createPattern(format);
    }

    public FileContents getFileContents() {
        return (FileContents)this.fileContentsReference.get();
    }

    public void setFileContents(FileContents fileContents) {
        this.fileContentsReference = new WeakReference<FileContents>(fileContents);
    }

    public void setCheckFormat(String format) {
        this.checkFormat = format;
    }

    public void setMessageFormat(String format) {
        this.messageFormat = format;
    }

    public void setInfluenceFormat(String format) {
        this.influenceFormat = format;
    }

    public void setCheckCPP(boolean checkCPP) {
        this.checkCPP = checkCPP;
    }

    public void setCheckC(boolean checkC) {
        this.checkC = checkC;
    }

    @Override
    public boolean accept(AuditEvent event) {
        if (event.getLocalizedMessage() == null) {
            return true;
        }
        FileContents currentContents = FileContentsHolder.getContents();
        if (currentContents == null) {
            return true;
        }
        if (this.getFileContents() != currentContents) {
            this.setFileContents(currentContents);
            this.tagSuppressions();
        }
        for (Tag tag : this.tags) {
            if (!tag.isMatch(event)) continue;
            return false;
        }
        return true;
    }

    private void tagSuppressions() {
        this.tags.clear();
        FileContents contents = this.getFileContents();
        if (this.checkCPP) {
            this.tagSuppressions((Collection<TextBlock>)contents.getCppComments().values());
        }
        if (this.checkC) {
            ImmutableCollection cComments = contents.getCComments().values();
            for (List element : cComments) {
                this.tagSuppressions(element);
            }
        }
        Collections.sort(this.tags);
    }

    private void tagSuppressions(Collection<TextBlock> comments) {
        for (TextBlock comment : comments) {
            int startLineNo = comment.getStartLineNo();
            String[] text = comment.getText();
            this.tagCommentLine(text[0], startLineNo);
            for (int i = 1; i < text.length; ++i) {
                this.tagCommentLine(text[i], startLineNo + i);
            }
        }
    }

    private void tagCommentLine(String text, int line) {
        Matcher matcher = this.commentRegexp.matcher(text);
        if (matcher.find()) {
            this.addTag(matcher.group(0), line);
        }
    }

    private void addTag(String text, int line) {
        Tag tag = new Tag(text, line, this);
        this.tags.add(tag);
    }

    public static class Tag
    implements Comparable<Tag> {
        private final String text;
        private final int firstLine;
        private final int lastLine;
        private final Pattern tagCheckRegexp;
        private final Pattern tagMessageRegexp;

        public Tag(String text, int line, SuppressWithNearbyCommentFilter filter) {
            this.text = text;
            String format = "";
            try {
                format = Tag.expandFrocomment(text, filter.checkFormat, filter.commentRegexp);
                this.tagCheckRegexp = Pattern.compile(format);
                if (filter.messageFormat != null) {
                    format = Tag.expandFrocomment(text, filter.messageFormat, filter.commentRegexp);
                    this.tagMessageRegexp = Pattern.compile(format);
                } else {
                    this.tagMessageRegexp = null;
                }
                format = Tag.expandFrocomment(text, filter.influenceFormat, filter.commentRegexp);
                int influence = 0;
                try {
                    if (Utils.startsWithChar(format, '+')) {
                        format = format.substring(1);
                    }
                    influence = Integer.parseInt(format);
                }
                catch (NumberFormatException e) {
                    throw new ConversionException("unable to parse influence from '" + text + "' using " + filter.influenceFormat, (Throwable)e);
                }
                if (influence >= 0) {
                    this.firstLine = line;
                    this.lastLine = line + influence;
                } else {
                    this.firstLine = line + influence;
                    this.lastLine = line;
                }
            }
            catch (PatternSyntaxException e) {
                throw new ConversionException("unable to parse expanded comment " + format, (Throwable)e);
            }
        }

        public String getText() {
            return this.text;
        }

        public int getFirstLine() {
            return this.firstLine;
        }

        public int getLastLine() {
            return this.lastLine;
        }

        @Override
        public int compareTo(Tag other) {
            if (this.firstLine == other.firstLine) {
                return this.lastLine - other.lastLine;
            }
            return this.firstLine - other.firstLine;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Tag tag = (Tag)o;
            return Objects.equals(this.firstLine, tag.firstLine) && Objects.equals(this.lastLine, tag.lastLine) && Objects.equals(this.text, tag.text) && Objects.equals(this.tagCheckRegexp, tag.tagCheckRegexp) && Objects.equals(this.tagMessageRegexp, tag.tagMessageRegexp);
        }

        public int hashCode() {
            return Objects.hash(this.text, this.firstLine, this.lastLine, this.tagCheckRegexp, this.tagMessageRegexp);
        }

        public boolean isMatch(AuditEvent event) {
            int line = event.getLine();
            if (line < this.firstLine) {
                return false;
            }
            if (line > this.lastLine) {
                return false;
            }
            Matcher tagMatcher = this.tagCheckRegexp.matcher(event.getSourceName());
            if (tagMatcher.find()) {
                return true;
            }
            if (this.tagMessageRegexp != null) {
                Matcher messageMatcher = this.tagMessageRegexp.matcher(event.getMessage());
                return messageMatcher.find();
            }
            return false;
        }

        private static String expandFrocomment(String comment, String string, Pattern regexp) {
            Matcher matcher = regexp.matcher(comment);
            if (!matcher.find()) {
                return string;
            }
            String result = string;
            for (int i = 0; i <= matcher.groupCount(); ++i) {
                result = result.replaceAll("\\$" + i, matcher.group(i));
            }
            return result;
        }

        public final String toString() {
            return "Tag[lines=[" + this.getFirstLine() + " to " + this.getLastLine() + "]; text='" + this.getText() + "']";
        }
    }
}

