/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.imports;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.ExternalResourceHolder;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.checks.imports.AccessResult;
import com.puppycrawl.tools.checkstyle.checks.imports.ImportControlLoader;
import com.puppycrawl.tools.checkstyle.checks.imports.PkgControl;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.beanutils.ConversionException;

public class ImportControlCheck
extends AbstractCheck
implements ExternalResourceHolder {
    public static final String MSG_MISSING_FILE = "import.control.missing.file";
    public static final String MSG_UNKNOWN_PKG = "import.control.unknown.pkg";
    public static final String MSG_DISALLOWED = "import.control.disallowed";
    private static final String UNABLE_TO_LOAD = "Unable to load ";
    private String fileLocation;
    private PkgControl root;
    private String inPkg;
    private PkgControl currentLeaf;

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{16, 30, 152};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.currentLeaf = null;
    }

    @Override
    public void visitToken(DetailAST ast) {
        FullIdent imp;
        AccessResult access;
        if (ast.getType() == 16) {
            DetailAST nameAST = ast.getLastChild().getPreviousSibling();
            FullIdent full = FullIdent.createFullIdent(nameAST);
            if (this.root == null) {
                this.log(nameAST, MSG_MISSING_FILE, new Object[0]);
            } else {
                this.inPkg = full.getText();
                this.currentLeaf = this.root.locateFinest(this.inPkg);
                if (this.currentLeaf == null) {
                    this.log(nameAST, MSG_UNKNOWN_PKG, new Object[0]);
                }
            }
        } else if (this.currentLeaf != null && (access = this.currentLeaf.checkAccess((imp = ast.getType() == 30 ? FullIdent.createFullIdentBelow(ast) : FullIdent.createFullIdent(ast.getFirstChild().getNextSibling())).getText(), this.inPkg)) != AccessResult.ALLOWED) {
            this.log(ast, MSG_DISALLOWED, imp.getText());
        }
    }

    @Override
    public Set<String> getExternalResourceLocations() {
        return Collections.singleton(this.fileLocation);
    }

    public void setFile(String name) {
        if (!CommonUtils.isBlank(name)) {
            try {
                this.root = ImportControlLoader.load(new File(name).toURI());
                this.fileLocation = name;
            }
            catch (CheckstyleException ex) {
                throw new ConversionException(UNABLE_TO_LOAD + name, (Throwable)ex);
            }
        }
    }

    public void setUrl(String url) {
        if (!CommonUtils.isBlank(url)) {
            URI uri;
            try {
                uri = URI.create(url);
            }
            catch (IllegalArgumentException ex) {
                throw new ConversionException("Syntax error in url " + url, (Throwable)ex);
            }
            try {
                this.root = ImportControlLoader.load(uri);
                this.fileLocation = url;
            }
            catch (CheckstyleException ex) {
                throw new ConversionException(UNABLE_TO_LOAD + url, (Throwable)ex);
            }
        }
    }
}

