/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.filters;

import com.google.common.collect.ImmutableCollection;
import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.AutomaticBean;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.Filter;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.checks.FileContentsHolder;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.beanutils.ConversionException;

public class SuppressionCommentFilter
extends AutomaticBean
implements Filter {
    private static final String DEFAULT_OFF_FORMAT = "CHECKSTYLE:OFF";
    private static final String DEFAULT_ON_FORMAT = "CHECKSTYLE:ON";
    private static final String DEFAULT_CHECK_FORMAT = ".*";
    private final List<Tag> tags = new ArrayList<Tag>();
    private boolean checkC = true;
    private boolean checkCPP = true;
    private Pattern offCommentFormat = Pattern.compile("CHECKSTYLE:OFF");
    private Pattern onCommentFormat = Pattern.compile("CHECKSTYLE:ON");
    private String checkFormat = ".*";
    private String messageFormat;
    private WeakReference<FileContents> fileContentsReference = new WeakReference<Object>(null);

    public final void setOffCommentFormat(Pattern pattern) {
        this.offCommentFormat = pattern;
    }

    public final void setOnCommentFormat(Pattern pattern) {
        this.onCommentFormat = pattern;
    }

    public FileContents getFileContents() {
        return (FileContents)this.fileContentsReference.get();
    }

    public void setFileContents(FileContents fileContents) {
        this.fileContentsReference = new WeakReference<FileContents>(fileContents);
    }

    public final void setCheckFormat(String format) {
        this.checkFormat = format;
    }

    public void setMessageFormat(String format) {
        this.messageFormat = format;
    }

    public void setCheckCPP(boolean checkCpp) {
        this.checkCPP = checkCpp;
    }

    public void setCheckC(boolean checkC) {
        this.checkC = checkC;
    }

    @Override
    public boolean accept(AuditEvent event) {
        boolean accepted = true;
        if (event.getLocalizedMessage() != null) {
            Tag matchTag;
            FileContents currentContents = FileContentsHolder.getCurrentFileContents();
            if (this.getFileContents() != currentContents) {
                this.setFileContents(currentContents);
                this.tagSuppressions();
            }
            accepted = (matchTag = this.findNearestMatch(event)) == null || matchTag.isReportingOn();
        }
        return accepted;
    }

    private Tag findNearestMatch(AuditEvent event) {
        Tag result = null;
        for (Tag tag : this.tags) {
            if (tag.getLine() > event.getLine() || tag.getLine() == event.getLine() && tag.getColumn() > event.getColumn()) break;
            if (!tag.isMatch(event)) continue;
            result = tag;
        }
        return result;
    }

    private void tagSuppressions() {
        this.tags.clear();
        FileContents contents = this.getFileContents();
        if (this.checkCPP) {
            this.tagSuppressions((Collection<TextBlock>)contents.getCppComments().values());
        }
        if (this.checkC) {
            ImmutableCollection cComments = contents.getCComments().values();
            cComments.forEach(this::tagSuppressions);
        }
        Collections.sort(this.tags);
    }

    private void tagSuppressions(Collection<TextBlock> comments) {
        for (TextBlock comment : comments) {
            int startLineNo = comment.getStartLineNo();
            String[] text = comment.getText();
            this.tagCommentLine(text[0], startLineNo, comment.getStartColNo());
            for (int i = 1; i < text.length; ++i) {
                this.tagCommentLine(text[i], startLineNo + i, 0);
            }
        }
    }

    private void tagCommentLine(String text, int line, int column) {
        Matcher offMatcher = this.offCommentFormat.matcher(text);
        if (offMatcher.find()) {
            this.addTag(offMatcher.group(0), line, column, false);
        } else {
            Matcher onMatcher = this.onCommentFormat.matcher(text);
            if (onMatcher.find()) {
                this.addTag(onMatcher.group(0), line, column, true);
            }
        }
    }

    private void addTag(String text, int line, int column, boolean reportingOn) {
        Tag tag = new Tag(line, column, text, reportingOn, this);
        this.tags.add(tag);
    }

    public static class Tag
    implements Comparable<Tag> {
        private final String text;
        private final int line;
        private final int column;
        private final boolean reportingOn;
        private final Pattern tagCheckRegexp;
        private final Pattern tagMessageRegexp;

        public Tag(int line, int column, String text, boolean reportingOn, SuppressionCommentFilter filter) {
            this.line = line;
            this.column = column;
            this.text = text;
            this.reportingOn = reportingOn;
            String format = "";
            try {
                if (reportingOn) {
                    format = CommonUtils.fillTemplateWithStringsByRegexp(filter.checkFormat, text, filter.onCommentFormat);
                    this.tagCheckRegexp = Pattern.compile(format);
                    if (filter.messageFormat == null) {
                        this.tagMessageRegexp = null;
                    } else {
                        format = CommonUtils.fillTemplateWithStringsByRegexp(filter.messageFormat, text, filter.onCommentFormat);
                        this.tagMessageRegexp = Pattern.compile(format);
                    }
                } else {
                    format = CommonUtils.fillTemplateWithStringsByRegexp(filter.checkFormat, text, filter.offCommentFormat);
                    this.tagCheckRegexp = Pattern.compile(format);
                    if (filter.messageFormat == null) {
                        this.tagMessageRegexp = null;
                    } else {
                        format = CommonUtils.fillTemplateWithStringsByRegexp(filter.messageFormat, text, filter.offCommentFormat);
                        this.tagMessageRegexp = Pattern.compile(format);
                    }
                }
            }
            catch (PatternSyntaxException ex) {
                throw new ConversionException("unable to parse expanded comment " + format, (Throwable)ex);
            }
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }

        public boolean isReportingOn() {
            return this.reportingOn;
        }

        @Override
        public int compareTo(Tag object) {
            if (this.line == object.line) {
                return Integer.compare(this.column, object.column);
            }
            return Integer.compare(this.line, object.line);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Tag tag = (Tag)other;
            return Objects.equals(this.line, tag.line) && Objects.equals(this.column, tag.column) && Objects.equals(this.reportingOn, tag.reportingOn) && Objects.equals(this.text, tag.text) && Objects.equals(this.tagCheckRegexp, tag.tagCheckRegexp) && Objects.equals(this.tagMessageRegexp, tag.tagMessageRegexp);
        }

        public int hashCode() {
            return Objects.hash(this.text, this.line, this.column, this.reportingOn, this.tagCheckRegexp, this.tagMessageRegexp);
        }

        public boolean isMatch(AuditEvent event) {
            boolean match = false;
            Matcher tagMatcher = this.tagCheckRegexp.matcher(event.getSourceName());
            if (tagMatcher.find()) {
                if (this.tagMessageRegexp == null) {
                    match = true;
                } else {
                    Matcher messageMatcher = this.tagMessageRegexp.matcher(event.getMessage());
                    match = messageMatcher.find();
                }
            } else if (event.getModuleId() != null) {
                Matcher idMatcher = this.tagCheckRegexp.matcher(event.getModuleId());
                match = idMatcher.find();
            }
            return match;
        }

        public final String toString() {
            return "Tag[line=" + this.line + "; col=" + this.column + "; on=" + this.reportingOn + "; text='" + this.text + "']";
        }
    }
}

