/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.whitespace;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class NoWhitespaceAfterCheck
extends AbstractCheck {
    public static final String MSG_KEY = "ws.followed";
    private boolean allowLineBreaks = true;

    @Override
    public int[] getDefaultTokens() {
        return new int[]{29, 129, 130, 31, 32, 131, 132, 59, 17, 24};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{29, 129, 130, 31, 32, 131, 132, 59, 23, 17, 24, 67};
    }

    public void setAllowLineBreaks(boolean allowLineBreaks) {
        this.allowLineBreaks = allowLineBreaks;
    }

    @Override
    public void visitToken(DetailAST ast) {
        int whitespaceLineNo;
        DetailAST whitespaceFollowedAst = NoWhitespaceAfterCheck.getWhitespaceFollowedNode(ast);
        int whitespaceColumnNo = NoWhitespaceAfterCheck.getPositionAfter(whitespaceFollowedAst);
        if (this.hasTrailingWhitespace(ast, whitespaceColumnNo, whitespaceLineNo = whitespaceFollowedAst.getLineNo())) {
            this.log(whitespaceLineNo, whitespaceColumnNo, MSG_KEY, whitespaceFollowedAst.getText());
        }
    }

    private static DetailAST getWhitespaceFollowedNode(DetailAST ast) {
        DetailAST whitespaceFollowedAst;
        switch (ast.getType()) {
            case 23: {
                whitespaceFollowedAst = ast.findFirstToken(77);
                break;
            }
            case 17: {
                whitespaceFollowedAst = NoWhitespaceAfterCheck.getArrayDeclaratorPreviousElement(ast);
                break;
            }
            case 24: {
                whitespaceFollowedAst = NoWhitespaceAfterCheck.getIndexOpPreviousElement(ast);
                break;
            }
            default: {
                whitespaceFollowedAst = ast;
            }
        }
        return whitespaceFollowedAst;
    }

    private static int getPositionAfter(DetailAST ast) {
        int after;
        if (ast.getType() == 58 && ast.getNextSibling() != null && ast.getNextSibling().getType() == 76) {
            DetailAST methodDef = ast.getParent();
            DetailAST endOfParams = methodDef.findFirstToken(77);
            after = endOfParams.getColumnNo() + 1;
        } else {
            after = ast.getColumnNo() + ast.getText().length();
        }
        return after;
    }

    private boolean hasTrailingWhitespace(DetailAST ast, int whitespaceColumnNo, int whitespaceLineNo) {
        int astLineNo = ast.getLineNo();
        String line = this.getLine(astLineNo - 1);
        boolean result = astLineNo == whitespaceLineNo && whitespaceColumnNo < line.length() ? Character.isWhitespace(line.charAt(whitespaceColumnNo)) : !this.allowLineBreaks;
        return result;
    }

    private static DetailAST getArrayDeclaratorPreviousElement(DetailAST ast) {
        DetailAST previousElement;
        DetailAST firstChild = ast.getFirstChild();
        if (firstChild.getType() == 17) {
            previousElement = firstChild.findFirstToken(48);
        } else {
            DetailAST parent = NoWhitespaceAfterCheck.getFirstNonArrayDeclaratorParent(ast);
            switch (parent.getType()) {
                case 164: {
                    DetailAST wildcard = parent.findFirstToken(167);
                    if (wildcard == null) {
                        previousElement = NoWhitespaceAfterCheck.getTypeLastNode(ast);
                        break;
                    }
                    previousElement = NoWhitespaceAfterCheck.getTypeLastNode(ast.getFirstChild());
                    break;
                }
                case 136: {
                    previousElement = NoWhitespaceAfterCheck.getTypeLastNode(parent);
                    break;
                }
                case 13: {
                    previousElement = NoWhitespaceAfterCheck.getPreviousNodeWithParentOfTypeAst(ast, parent);
                    break;
                }
                case 59: {
                    previousElement = NoWhitespaceAfterCheck.getTypeLastNode(ast);
                    break;
                }
                case 180: {
                    DetailAST ident = NoWhitespaceAfterCheck.getIdentLastToken(ast);
                    if (ident == null) {
                        previousElement = ast.getFirstChild();
                        break;
                    }
                    previousElement = ident;
                    break;
                }
                default: {
                    throw new IllegalStateException("unexpected ast syntax" + (Object)((Object)parent));
                }
            }
        }
        return previousElement;
    }

    private static DetailAST getIndexOpPreviousElement(DetailAST ast) {
        DetailAST ident;
        DetailAST firstChild = ast.getFirstChild();
        DetailAST result = firstChild.getType() == 24 ? firstChild.findFirstToken(48) : ((ident = NoWhitespaceAfterCheck.getIdentLastToken(ast)) == null ? ast.findFirstToken(77) : ident);
        return result;
    }

    private static DetailAST getFirstNonArrayDeclaratorParent(DetailAST ast) {
        DetailAST parent = ast.getParent();
        while (parent.getType() == 17) {
            parent = parent.getParent();
        }
        return parent;
    }

    private static DetailAST getTypeLastNode(DetailAST ast) {
        DetailAST result = ast.findFirstToken(163);
        if (result == null) {
            result = NoWhitespaceAfterCheck.getIdentLastToken(ast);
            if (result == null) {
                result = ast.getFirstChild();
            }
        } else {
            result = result.findFirstToken(173);
        }
        return result;
    }

    private static DetailAST getPreviousNodeWithParentOfTypeAst(DetailAST ast, DetailAST parent) {
        DetailAST ident = NoWhitespaceAfterCheck.getIdentLastToken(parent.getParent());
        DetailAST lastTypeNode = NoWhitespaceAfterCheck.getTypeLastNode(ast);
        DetailAST previousElement = ident == null || ident.getLineNo() > ast.getLineNo() ? lastTypeNode : (ident.getLineNo() < ast.getLineNo() ? ident : (ident.getColumnNo() > ast.getColumnNo() || lastTypeNode.getColumnNo() > ident.getColumnNo() ? lastTypeNode : ident));
        return previousElement;
    }

    private static DetailAST getIdentLastToken(DetailAST ast) {
        DetailAST result = ast.findFirstToken(58);
        if (result == null) {
            DetailAST dot = ast.findFirstToken(59);
            if (dot == null) {
                DetailAST methodCall = ast.findFirstToken(27);
                if (methodCall != null) {
                    result = methodCall.findFirstToken(77);
                }
            } else {
                result = dot.findFirstToken(59) == null ? dot.getFirstChild().getNextSibling() : dot.findFirstToken(58);
            }
        }
        return result;
    }
}

