/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.puppycrawl.tools.checkstyle.AuditEventDefaultFormatter;
import com.puppycrawl.tools.checkstyle.AuditEventFormatter;
import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.puppycrawl.tools.checkstyle.api.AutomaticBean;
import com.puppycrawl.tools.checkstyle.api.LocalizedMessage;
import com.puppycrawl.tools.checkstyle.api.SeverityLevel;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;

public class DefaultLogger
extends AutomaticBean
implements AuditListener {
    public static final String ADD_EXCEPTION_MESSAGE = "DefaultLogger.addException";
    public static final String AUDIT_STARTED_MESSAGE = "DefaultLogger.auditStarted";
    public static final String AUDIT_FINISHED_MESSAGE = "DefaultLogger.auditFinished";
    private final PrintWriter infoWriter;
    private final boolean closeInfo;
    private final PrintWriter errorWriter;
    private final boolean closeError;
    private final AuditEventFormatter formatter;

    public DefaultLogger(OutputStream outputStream, boolean closeStreamsAfterUse) {
        this(outputStream, closeStreamsAfterUse, outputStream, false);
    }

    public DefaultLogger(OutputStream infoStream, boolean closeInfoAfterUse, OutputStream errorStream, boolean closeErrorAfterUse) {
        this(infoStream, closeInfoAfterUse, errorStream, closeErrorAfterUse, new AuditEventDefaultFormatter());
    }

    public DefaultLogger(OutputStream infoStream, boolean closeInfoAfterUse, OutputStream errorStream, boolean closeErrorAfterUse, AuditEventFormatter messageFormatter) {
        this.closeInfo = closeInfoAfterUse;
        this.closeError = closeErrorAfterUse;
        OutputStreamWriter infoStreamWriter = new OutputStreamWriter(infoStream, StandardCharsets.UTF_8);
        this.infoWriter = new PrintWriter(infoStreamWriter);
        if (infoStream == errorStream) {
            this.errorWriter = this.infoWriter;
        } else {
            OutputStreamWriter errorStreamWriter = new OutputStreamWriter(errorStream, StandardCharsets.UTF_8);
            this.errorWriter = new PrintWriter(errorStreamWriter);
        }
        this.formatter = messageFormatter;
    }

    @Override
    public void addError(AuditEvent event) {
        SeverityLevel severityLevel = event.getSeverityLevel();
        if (severityLevel != SeverityLevel.IGNORE) {
            String errorMessage = this.formatter.format(event);
            this.errorWriter.println(errorMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addException(AuditEvent event, Throwable throwable) {
        PrintWriter printWriter = this.errorWriter;
        synchronized (printWriter) {
            LocalizedMessage addExceptionMessage = new LocalizedMessage(0, "com.puppycrawl.tools.checkstyle.messages", ADD_EXCEPTION_MESSAGE, new String[]{event.getFileName()}, null, LocalizedMessage.class, null);
            this.errorWriter.println(addExceptionMessage.getMessage());
            throwable.printStackTrace(this.errorWriter);
        }
    }

    @Override
    public void auditStarted(AuditEvent event) {
        LocalizedMessage auditStartMessage = new LocalizedMessage(0, "com.puppycrawl.tools.checkstyle.messages", AUDIT_STARTED_MESSAGE, null, null, LocalizedMessage.class, null);
        this.infoWriter.println(auditStartMessage.getMessage());
        this.infoWriter.flush();
    }

    @Override
    public void auditFinished(AuditEvent event) {
        LocalizedMessage auditFinishMessage = new LocalizedMessage(0, "com.puppycrawl.tools.checkstyle.messages", AUDIT_FINISHED_MESSAGE, null, null, LocalizedMessage.class, null);
        this.infoWriter.println(auditFinishMessage.getMessage());
        this.closeStreams();
    }

    @Override
    public void fileStarted(AuditEvent event) {
    }

    @Override
    public void fileFinished(AuditEvent event) {
        this.infoWriter.flush();
    }

    private void closeStreams() {
        this.infoWriter.flush();
        if (this.closeInfo) {
            this.infoWriter.close();
        }
        this.errorWriter.flush();
        if (this.closeError) {
            this.errorWriter.close();
        }
    }
}

