/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.indentation;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentLevel;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentationCheck;
import com.puppycrawl.tools.checkstyle.checks.indentation.LineSet;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.util.Arrays;

public abstract class AbstractExpressionHandler {
    private final IndentationCheck indentCheck;
    private final DetailAST mainAst;
    private final String typeName;
    private final AbstractExpressionHandler parent;
    private IndentLevel indent;

    protected AbstractExpressionHandler(IndentationCheck indentCheck, String typeName, DetailAST expr, AbstractExpressionHandler parent) {
        this.indentCheck = indentCheck;
        this.typeName = typeName;
        this.mainAst = expr;
        this.parent = parent;
    }

    public abstract void checkIndentation();

    public final IndentLevel getIndent() {
        if (this.indent == null) {
            this.indent = this.getIndentImpl();
        }
        return this.indent;
    }

    protected IndentLevel getIndentImpl() {
        return this.parent.getSuggestedChildIndent(this);
    }

    public IndentLevel getSuggestedChildIndent(AbstractExpressionHandler child) {
        return new IndentLevel(this.getIndent(), this.getBasicOffset());
    }

    protected final void logError(DetailAST ast, String subtypeName, int actualIndent) {
        this.logError(ast, subtypeName, actualIndent, this.getIndent());
    }

    protected final void logError(DetailAST ast, String subtypeName, int actualIndent, IndentLevel expectedIndent) {
        String typeStr = subtypeName.isEmpty() ? "" : " " + subtypeName;
        String messageKey = "indentation.error";
        if (expectedIndent.isMultiLevel()) {
            messageKey = "indentation.error.multi";
        }
        this.indentCheck.indentationLog(ast.getLineNo(), messageKey, this.typeName + typeStr, actualIndent, expectedIndent);
    }

    private void logChildError(int line, int actualIndent, IndentLevel expectedIndent) {
        String messageKey = "indentation.child.error";
        if (expectedIndent.isMultiLevel()) {
            messageKey = "indentation.child.error.multi";
        }
        this.indentCheck.indentationLog(line, messageKey, this.typeName, actualIndent, expectedIndent);
    }

    protected final boolean isOnStartOfLine(DetailAST ast) {
        return this.getLineStart(ast) == this.expandedTabsColumnNo(ast);
    }

    public static boolean areOnSameLine(DetailAST ast1, DetailAST ast2) {
        return ast1.getLineNo() == ast2.getLineNo();
    }

    public static DetailAST getFirstToken(DetailAST ast) {
        DetailAST first = ast;
        for (DetailAST child = ast.getFirstChild(); child != null; child = child.getNextSibling()) {
            DetailAST toTest = AbstractExpressionHandler.getFirstToken(child);
            if (toTest.getColumnNo() >= first.getColumnNo()) continue;
            first = toTest;
        }
        return first;
    }

    protected final int getLineStart(DetailAST ast) {
        return this.getLineStart(ast.getLineNo());
    }

    protected final int getLineStart(int lineNo) {
        return this.getLineStart(this.indentCheck.getLine(lineNo - 1));
    }

    private int getLineStart(String line) {
        int index = 0;
        while (Character.isWhitespace(line.charAt(index))) {
            ++index;
        }
        return CommonUtils.lengthExpandedTabs(line, index, this.indentCheck.getIndentationTabWidth());
    }

    protected boolean shouldIncreaseIndent() {
        return true;
    }

    private void checkLinesIndent(LineSet lines, IndentLevel indentLevel, boolean firstLineMatches, int firstLine) {
        if (!lines.isEmpty()) {
            int startLine = lines.firstLine();
            int endLine = lines.lastLine();
            int startCol = lines.firstLineCol();
            int realStartCol = this.getLineStart(this.indentCheck.getLine(startLine - 1));
            if (realStartCol == startCol) {
                this.checkLineIndent(startLine, startCol, indentLevel, firstLineMatches);
            }
            IndentLevel theLevel = indentLevel;
            if (firstLineMatches || firstLine > this.mainAst.getLineNo() && this.shouldIncreaseIndent()) {
                theLevel = new IndentLevel(indentLevel, this.getBasicOffset());
            }
            for (int i = startLine + 1; i <= endLine; ++i) {
                Integer col = lines.getStartColumn(i);
                if (col == null) continue;
                this.checkLineIndent(i, col, theLevel, false);
            }
        }
    }

    private void checkLineIndent(int lineNum, int colNum, IndentLevel indentLevel, boolean mustMatch) {
        String line = this.indentCheck.getLine(lineNum - 1);
        int start = this.getLineStart(line);
        if (mustMatch && !indentLevel.isAcceptable(start) || !mustMatch && colNum == start && indentLevel.isGreaterThan(start)) {
            this.logChildError(lineNum, start, indentLevel);
        }
    }

    protected void checkWrappingIndentation(DetailAST firstNode, DetailAST lastNode) {
        this.indentCheck.getLineWrappingHandler().checkIndentation(firstNode, lastNode);
    }

    protected void checkWrappingIndentation(DetailAST firstNode, DetailAST lastNode, int wrappedIndentLevel, int startIndent, boolean ignoreFirstLine) {
        this.indentCheck.getLineWrappingHandler().checkIndentation(firstNode, lastNode, wrappedIndentLevel, startIndent, ignoreFirstLine);
    }

    protected final void checkChildren(DetailAST parentNode, int[] tokenTypes, IndentLevel startIndent, boolean firstLineMatches, boolean allowNesting) {
        Arrays.sort(tokenTypes);
        for (DetailAST child = parentNode.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (Arrays.binarySearch(tokenTypes, child.getType()) < 0) continue;
            this.checkExpressionSubtree(child, startIndent, firstLineMatches, allowNesting);
        }
    }

    protected final void checkExpressionSubtree(DetailAST tree, IndentLevel indentLevel, boolean firstLineMatches, boolean allowNesting) {
        LineSet subtreeLines = new LineSet();
        int firstLine = AbstractExpressionHandler.getFirstLine(Integer.MAX_VALUE, tree);
        if (firstLineMatches && !allowNesting) {
            subtreeLines.addLineAndCol(firstLine, this.getLineStart(this.indentCheck.getLine(firstLine - 1)));
        }
        this.findSubtreeLines(subtreeLines, tree, allowNesting);
        this.checkLinesIndent(subtreeLines, indentLevel, firstLineMatches, firstLine);
    }

    protected static int getFirstLine(int startLine, DetailAST tree) {
        int realStart = startLine;
        int currLine = tree.getLineNo();
        if (currLine < realStart) {
            realStart = currLine;
        }
        for (DetailAST node = tree.getFirstChild(); node != null; node = node.getNextSibling()) {
            realStart = AbstractExpressionHandler.getFirstLine(realStart, node);
        }
        return realStart;
    }

    protected final int expandedTabsColumnNo(DetailAST ast) {
        String line = this.indentCheck.getLine(ast.getLineNo() - 1);
        return CommonUtils.lengthExpandedTabs(line, ast.getColumnNo(), this.indentCheck.getIndentationTabWidth());
    }

    protected final void findSubtreeLines(LineSet lines, DetailAST tree, boolean allowNesting) {
        if (!this.indentCheck.getHandlerFactory().isHandledType(tree.getType())) {
            int lineNum = tree.getLineNo();
            Integer colNum = lines.getStartColumn(lineNum);
            int thisLineColumn = this.expandedTabsColumnNo(tree);
            if (colNum == null || thisLineColumn < colNum) {
                lines.addLineAndCol(lineNum, thisLineColumn);
            }
            for (DetailAST node = tree.getFirstChild(); node != null; node = node.getNextSibling()) {
                this.findSubtreeLines(lines, node, allowNesting);
            }
        }
    }

    protected void checkModifiers() {
        DetailAST modifiers = this.mainAst.findFirstToken(5);
        for (DetailAST modifier = modifiers.getFirstChild(); modifier != null; modifier = modifier.getNextSibling()) {
            if (!this.isOnStartOfLine(modifier) || this.getIndent().isAcceptable(this.expandedTabsColumnNo(modifier))) continue;
            this.logError(modifier, "modifier", this.expandedTabsColumnNo(modifier));
        }
    }

    protected final IndentationCheck getIndentCheck() {
        return this.indentCheck;
    }

    protected final DetailAST getMainAst() {
        return this.mainAst;
    }

    protected final AbstractExpressionHandler getParent() {
        return this.parent;
    }

    protected final int getBasicOffset() {
        return this.indentCheck.getBasicOffset();
    }

    protected final int getBraceAdjustment() {
        return this.indentCheck.getBraceAdjustment();
    }

    protected final void checkRightParen(DetailAST lparen, DetailAST rparen) {
        int lparenLevel;
        int rparenLevel;
        if (rparen != null && (rparenLevel = this.expandedTabsColumnNo(rparen)) != (lparenLevel = this.expandedTabsColumnNo(lparen)) + 1 && !this.getIndent().isAcceptable(rparenLevel) && this.isOnStartOfLine(rparen)) {
            this.logError(rparen, "rparen", rparenLevel);
        }
    }

    protected final void checkLeftParen(DetailAST lparen) {
        if (lparen != null && !this.getIndent().isAcceptable(this.expandedTabsColumnNo(lparen)) && this.isOnStartOfLine(lparen)) {
            this.logError(lparen, "lparen", this.expandedTabsColumnNo(lparen));
        }
    }
}

