/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.sizes;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtility;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;

public class ParameterNumberCheck
extends AbstractCheck {
    public static final String MSG_KEY = "maxParam";
    private static final String OVERRIDE = "Override";
    private static final String CANONICAL_OVERRIDE = "java.lang.Override";
    private static final int DEFAULT_MAX_PARAMETERS = 7;
    private int max = 7;
    private boolean ignoreOverriddenMethods;

    public void setMax(int max) {
        this.max = max;
    }

    public void setIgnoreOverriddenMethods(boolean ignoreOverriddenMethods) {
        this.ignoreOverriddenMethods = ignoreOverriddenMethods;
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{9, 8};
    }

    @Override
    public int[] getRequiredTokens() {
        return CommonUtils.EMPTY_INT_ARRAY;
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST params = ast.findFirstToken(20);
        int count = params.getChildCount(21);
        if (count > this.max && !this.shouldIgnoreNumberOfParameters(ast)) {
            DetailAST name = ast.findFirstToken(58);
            this.log(name.getLineNo(), name.getColumnNo(), MSG_KEY, this.max, count);
        }
    }

    private boolean shouldIgnoreNumberOfParameters(DetailAST ast) {
        return this.ignoreOverriddenMethods && (AnnotationUtility.containsAnnotation(ast, OVERRIDE) || AnnotationUtility.containsAnnotation(ast, CANONICAL_OVERRIDE));
    }
}

