/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.gui;

import antlr.ANTLRException;
import com.google.common.collect.ImmutableList;
import com.puppycrawl.tools.checkstyle.TreeWalker;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FileText;
import com.puppycrawl.tools.checkstyle.gui.ParseTreeTableModel;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;

public class MainFrameModel {
    private final ParseTreeTableModel parseTreeTableModel;
    private ImmutableList<Integer> linesToPosition = ImmutableList.of();
    private ParseMode parseMode = ParseMode.PLAIN_JAVA;
    private File currentFile;
    private String text;
    private String title = "Checkstyle GUI";
    private boolean reloadActionEnabled;

    public MainFrameModel() {
        this.parseTreeTableModel = new ParseTreeTableModel(null);
    }

    public void setParseMode(ParseMode mode) {
        this.parseMode = mode;
    }

    public ParseTreeTableModel getParseTreeTableModel() {
        return this.parseTreeTableModel;
    }

    public String getText() {
        return this.text;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isReloadActionEnabled() {
        return this.reloadActionEnabled;
    }

    public static boolean shouldAcceptFile(File file) {
        return file.isDirectory() || file.getName().endsWith(".java");
    }

    public File getLastDirectory() {
        File lastDirectory = null;
        if (this.currentFile != null) {
            lastDirectory = new File(this.currentFile.getParent());
        }
        return lastDirectory;
    }

    public File getCurrentFile() {
        return this.currentFile;
    }

    public ImmutableList<Integer> getLinesToPosition() {
        return this.linesToPosition;
    }

    public void openFile(File file) throws CheckstyleException {
        if (file != null) {
            try {
                DetailAST parseTree;
                this.currentFile = file;
                this.title = "Checkstyle GUI : " + file.getName();
                this.reloadActionEnabled = true;
                switch (this.parseMode) {
                    case PLAIN_JAVA: {
                        parseTree = this.parseFile(file);
                        break;
                    }
                    case JAVA_WITH_COMMENTS: 
                    case JAVA_WITH_JAVADOC_AND_COMMENTS: {
                        parseTree = this.parseFileWithComments(file);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown mode: " + (Object)((Object)this.parseMode));
                    }
                }
                this.parseTreeTableModel.setParseTree(parseTree);
                this.parseTreeTableModel.setParseMode(this.parseMode);
                String[] sourceLines = this.getFileText(file).toLinesArray();
                ArrayList<Integer> linesToPositionTemp = new ArrayList<Integer>();
                linesToPositionTemp.add(0);
                StringBuilder sb = new StringBuilder();
                for (String element : sourceLines) {
                    linesToPositionTemp.add(sb.length());
                    sb.append(element).append(System.lineSeparator());
                }
                this.linesToPosition = ImmutableList.copyOf(linesToPositionTemp);
                this.text = sb.toString();
            }
            catch (ANTLRException | IOException ex) {
                String exceptionMsg = String.format(Locale.ROOT, "%s occurred while opening file %s.", ex.getClass().getSimpleName(), file.getPath());
                throw new CheckstyleException(exceptionMsg, ex);
            }
        }
    }

    public DetailAST parseFile(File file) throws IOException, ANTLRException {
        FileText fileText = this.getFileText(file);
        FileContents contents = new FileContents(fileText);
        return TreeWalker.parse(contents);
    }

    public DetailAST parseFileWithComments(File file) throws IOException, ANTLRException {
        FileText fileText = this.getFileText(file);
        FileContents contents = new FileContents(fileText);
        return TreeWalker.parseWithComments(contents);
    }

    public FileText getFileText(File file) throws IOException {
        return new FileText(file.getAbsoluteFile(), System.getProperty("file.encoding", "UTF-8"));
    }

    public static enum ParseMode {
        PLAIN_JAVA("Plain Java"),
        JAVA_WITH_COMMENTS("Java with comments"),
        JAVA_WITH_JAVADOC_AND_COMMENTS("Java with comments and Javadocs");

        private final String description;

        private ParseMode(String descr) {
            this.description = descr;
        }

        public String toString() {
            return this.description;
        }
    }
}

