/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.metrics;

import com.puppycrawl.tools.checkstyle.FileStatefulCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CheckUtil;
import java.util.ArrayDeque;
import java.util.Deque;

@FileStatefulCheck
public final class BooleanExpressionComplexityCheck
extends AbstractCheck {
    public static final String MSG_KEY = "booleanExpressionComplexity";
    private static final int DEFAULT_MAX = 3;
    private final Deque<Context> contextStack = new ArrayDeque<Context>();
    private int max = 3;
    private Context context = new Context(false);

    @Override
    public int[] getDefaultTokens() {
        return new int[]{8, 9, 28, 111, 114, 110, 112, 113};
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{8, 9, 28};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{8, 9, 28, 111, 114, 110, 112, 113};
    }

    public void setMax(int max) {
        this.max = max;
    }

    @Override
    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 8: 
            case 9: {
                this.visitMethodDef(ast);
                break;
            }
            case 28: {
                this.visitExpr();
                break;
            }
            case 112: {
                if (BooleanExpressionComplexityCheck.isPipeOperator(ast) || BooleanExpressionComplexityCheck.isPassedInParameter(ast)) break;
                this.context.visitBooleanOperator();
                break;
            }
            case 113: 
            case 114: {
                if (BooleanExpressionComplexityCheck.isPassedInParameter(ast)) break;
                this.context.visitBooleanOperator();
                break;
            }
            case 110: 
            case 111: {
                this.context.visitBooleanOperator();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type: " + (Object)((Object)ast));
            }
        }
    }

    private static boolean isPassedInParameter(DetailAST logicalOperator) {
        return logicalOperator.getParent().getParent().getType() == 34;
    }

    private static boolean isPipeOperator(DetailAST binaryOr) {
        return binaryOr.getParent().getType() == 13;
    }

    @Override
    public void leaveToken(DetailAST ast) {
        switch (ast.getType()) {
            case 8: 
            case 9: {
                this.leaveMethodDef();
                break;
            }
            case 28: {
                this.leaveExpr(ast);
                break;
            }
        }
    }

    private void visitMethodDef(DetailAST ast) {
        this.contextStack.push(this.context);
        boolean check = !CheckUtil.isEqualsMethod(ast);
        this.context = new Context(check);
    }

    private void leaveMethodDef() {
        this.context = this.contextStack.pop();
    }

    private void visitExpr() {
        this.contextStack.push(this.context);
        this.context = new Context(this.context.isChecking());
    }

    private void leaveExpr(DetailAST ast) {
        this.context.checkCount(ast);
        this.context = this.contextStack.pop();
    }

    private class Context {
        private final boolean checking;
        private int count;

        Context(boolean checking) {
            this.checking = checking;
            this.count = 0;
        }

        public boolean isChecking() {
            return this.checking;
        }

        public void visitBooleanOperator() {
            ++this.count;
        }

        public void checkCount(DetailAST ast) {
            if (this.checking && this.count > BooleanExpressionComplexityCheck.this.max) {
                DetailAST parentAST = ast.getParent();
                BooleanExpressionComplexityCheck.this.log(parentAST, BooleanExpressionComplexityCheck.MSG_KEY, this.count, BooleanExpressionComplexityCheck.this.max);
            }
        }
    }
}

