/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.puppycrawl.tools.checkstyle.api.AutomaticBean;
import com.puppycrawl.tools.checkstyle.api.SeverityLevel;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;

public class XMLLogger
extends AutomaticBean
implements AuditListener {
    private static final int BASE_10 = 10;
    private static final int BASE_16 = 16;
    private static final String[] ENTITIES = new String[]{"gt", "amp", "lt", "apos", "quot"};
    private final boolean closeStream;
    private final Object writerLock = new Object();
    private final Map<String, FileMessages> fileMessages = new ConcurrentHashMap<String, FileMessages>();
    private final PrintWriter writer;

    @Deprecated
    public XMLLogger(OutputStream outputStream, boolean closeStream) {
        this.writer = new PrintWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));
        this.closeStream = closeStream;
    }

    public XMLLogger(OutputStream outputStream, AutomaticBean.OutputStreamOptions outputStreamOptions) {
        this.writer = new PrintWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));
        this.closeStream = outputStreamOptions == AutomaticBean.OutputStreamOptions.CLOSE;
    }

    @Override
    public void auditStarted(AuditEvent event) {
        this.writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        ResourceBundle compilationProperties = ResourceBundle.getBundle("checkstylecompilation", Locale.ROOT);
        String version = compilationProperties.getString("checkstyle.compile.version");
        this.writer.println("<checkstyle version=\"" + version + "\">");
    }

    @Override
    public void auditFinished(AuditEvent event) {
        this.fileMessages.forEach(this::writeFileMessages);
        this.writer.println("</checkstyle>");
        if (this.closeStream) {
            this.writer.close();
        } else {
            this.writer.flush();
        }
    }

    @Override
    public void fileStarted(AuditEvent event) {
        this.fileMessages.put(event.getFileName(), new FileMessages());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fileFinished(AuditEvent event) {
        String fileName = event.getFileName();
        FileMessages messages = this.fileMessages.get(fileName);
        Object object = this.writerLock;
        synchronized (object) {
            this.writeFileMessages(fileName, messages);
        }
        this.fileMessages.remove(fileName);
    }

    private void writeFileMessages(String fileName, FileMessages messages) {
        this.writeFileOpeningTag(fileName);
        if (messages != null) {
            for (AuditEvent errorEvent : messages.getErrors()) {
                this.writeFileError(errorEvent);
            }
            for (Throwable exception : messages.getExceptions()) {
                this.writeException(exception);
            }
        }
        this.writeFileClosingTag();
    }

    private void writeFileOpeningTag(String fileName) {
        this.writer.println("<file name=\"" + XMLLogger.encode(fileName) + "\">");
    }

    private void writeFileClosingTag() {
        this.writer.println("</file>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addError(AuditEvent event) {
        if (event.getSeverityLevel() != SeverityLevel.IGNORE) {
            String fileName = event.getFileName();
            if (fileName == null) {
                Object object = this.writerLock;
                synchronized (object) {
                    this.writeFileError(event);
                }
            } else {
                FileMessages messages = this.fileMessages.computeIfAbsent(fileName, name -> new FileMessages());
                messages.addError(event);
            }
        }
    }

    private void writeFileError(AuditEvent event) {
        this.writer.print("<error line=\"" + event.getLine() + "\"");
        if (event.getColumn() > 0) {
            this.writer.print(" column=\"" + event.getColumn() + "\"");
        }
        this.writer.print(" severity=\"" + event.getSeverityLevel().getName() + "\"");
        this.writer.print(" message=\"" + XMLLogger.encode(event.getMessage()) + "\"");
        this.writer.print(" source=\"");
        if (event.getModuleId() == null) {
            this.writer.print(XMLLogger.encode(event.getSourceName()));
        } else {
            this.writer.print(XMLLogger.encode(event.getModuleId()));
        }
        this.writer.println("\"/>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addException(AuditEvent event, Throwable throwable) {
        String fileName = event.getFileName();
        if (fileName == null) {
            Object object = this.writerLock;
            synchronized (object) {
                this.writeException(throwable);
            }
        } else {
            FileMessages messages = this.fileMessages.computeIfAbsent(fileName, name -> new FileMessages());
            messages.addException(throwable);
        }
    }

    private void writeException(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printer = new PrintWriter(stringWriter);
        printer.println("<exception>");
        printer.println("<![CDATA[");
        throwable.printStackTrace(printer);
        printer.println("]]>");
        printer.println("</exception>");
        this.writer.println(XMLLogger.encode(stringWriter.toString()));
    }

    public static String encode(String value) {
        StringBuilder sb = new StringBuilder(256);
        block9: for (int i = 0; i < value.length(); ++i) {
            char chr = value.charAt(i);
            switch (chr) {
                case '<': {
                    sb.append("&lt;");
                    continue block9;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block9;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block9;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block9;
                }
                case '&': {
                    sb.append(XMLLogger.encodeAmpersand(value, i));
                    continue block9;
                }
                case '\r': {
                    continue block9;
                }
                case '\n': {
                    sb.append("&#10;");
                    continue block9;
                }
                default: {
                    sb.append(chr);
                }
            }
        }
        return sb.toString();
    }

    public static boolean isReference(String ent) {
        boolean reference = false;
        if (ent.charAt(0) != '&' || !CommonUtils.endsWithChar(ent, ';')) {
            reference = false;
        } else if (ent.charAt(1) == '#') {
            int prefixLength = 2;
            int radix = 10;
            if (ent.charAt(2) == 'x') {
                ++prefixLength;
                radix = 16;
            }
            try {
                Integer.parseInt(ent.substring(prefixLength, ent.length() - 1), radix);
                reference = true;
            }
            catch (NumberFormatException ignored) {
                reference = false;
            }
        } else {
            String name = ent.substring(1, ent.length() - 1);
            for (String element : ENTITIES) {
                if (!name.equals(element)) continue;
                reference = true;
                break;
            }
        }
        return reference;
    }

    private static String encodeAmpersand(String value, int ampPosition) {
        int nextSemi = value.indexOf(59, ampPosition);
        String result = nextSemi == -1 || !XMLLogger.isReference(value.substring(ampPosition, nextSemi + 1)) ? "&amp;" : "&";
        return result;
    }

    private static class FileMessages {
        private final List<AuditEvent> errors = Collections.synchronizedList(new ArrayList());
        private final List<Throwable> exceptions = Collections.synchronizedList(new ArrayList());

        private FileMessages() {
        }

        public List<AuditEvent> getErrors() {
            return Collections.unmodifiableList(this.errors);
        }

        public void addError(AuditEvent event) {
            this.errors.add(event);
        }

        public List<Throwable> getExceptions() {
            return Collections.unmodifiableList(this.exceptions);
        }

        public void addException(Throwable throwable) {
            this.exceptions.add(throwable);
        }
    }
}

