/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import antlr.CommonASTWithHiddenTokens;
import antlr.CommonHiddenStreamToken;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.TokenStreamHiddenTokenFilter;
import antlr.collections.AST;
import com.puppycrawl.tools.checkstyle.DetailAstImpl;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FileText;
import com.puppycrawl.tools.checkstyle.grammar.GeneratedJavaLexer;
import com.puppycrawl.tools.checkstyle.grammar.GeneratedJavaRecognizer;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Locale;

public final class JavaParser {
    private JavaParser() {
    }

    public static DetailAST parse(FileContents contents) throws CheckstyleException {
        String fullText = contents.getText().getFullText().toString();
        StringReader reader = new StringReader(fullText);
        GeneratedJavaLexer lexer = new GeneratedJavaLexer(reader);
        lexer.setCommentListener(contents);
        lexer.setTokenObjectClass("antlr.CommonHiddenStreamToken");
        TokenStreamHiddenTokenFilter filter = new TokenStreamHiddenTokenFilter((TokenStream)lexer);
        filter.hide(144);
        filter.hide(145);
        GeneratedJavaRecognizer parser = new GeneratedJavaRecognizer((TokenStream)filter){

            public void reportError(RecognitionException ex) {
                throw new IllegalStateException((Throwable)ex);
            }
        };
        parser.setFilename(contents.getFileName());
        parser.setASTNodeClass(DetailAstImpl.class.getName());
        try {
            parser.compilationUnit();
        }
        catch (RecognitionException | TokenStreamException | IllegalStateException ex) {
            String exceptionMsg = String.format(Locale.ROOT, "%s occurred while parsing file %s.", ex.getClass().getSimpleName(), contents.getFileName());
            throw new CheckstyleException(exceptionMsg, ex);
        }
        return (DetailAST)parser.getAST();
    }

    public static DetailAST parseFileText(FileText text, Options options) throws CheckstyleException {
        FileContents contents = new FileContents(text);
        DetailAST ast = JavaParser.parse(contents);
        if (options == Options.WITH_COMMENTS) {
            ast = JavaParser.appendHiddenCommentNodes(ast);
        }
        return ast;
    }

    public static DetailAST parseFile(File file, Options options) throws IOException, CheckstyleException {
        FileText text = new FileText(file.getAbsoluteFile(), StandardCharsets.UTF_8.name());
        return JavaParser.parseFileText(text, options);
    }

    public static DetailAST appendHiddenCommentNodes(DetailAST root) {
        DetailAST newCommentNode;
        DetailAST currentSibling;
        DetailAST result = root;
        DetailAST curNode = root;
        DetailAST lastNode = root;
        while (curNode != null) {
            lastNode = curNode;
            currentSibling = curNode;
            for (CommonHiddenStreamToken tokenBefore = ((CommonASTWithHiddenTokens)curNode).getHiddenBefore(); tokenBefore != null; tokenBefore = tokenBefore.getHiddenBefore()) {
                newCommentNode = JavaParser.createCommentAstFromToken((Token)tokenBefore);
                ((DetailAstImpl)currentSibling).addPreviousSibling(newCommentNode);
                if (currentSibling == result) {
                    result = newCommentNode;
                }
                currentSibling = newCommentNode;
            }
            DetailAST toVisit = curNode.getFirstChild();
            while (curNode != null && toVisit == null) {
                toVisit = curNode.getNextSibling();
                curNode = curNode.getParent();
            }
            curNode = toVisit;
        }
        if (lastNode != null) {
            currentSibling = lastNode;
            for (CommonHiddenStreamToken tokenAfter = ((CommonASTWithHiddenTokens)lastNode).getHiddenAfter(); tokenAfter != null; tokenAfter = tokenAfter.getHiddenAfter()) {
                newCommentNode = JavaParser.createCommentAstFromToken((Token)tokenAfter);
                ((DetailAstImpl)currentSibling).addNextSibling(newCommentNode);
                currentSibling = newCommentNode;
            }
        }
        return result;
    }

    private static DetailAST createCommentAstFromToken(Token token) {
        DetailAST commentAst = token.getType() == 144 ? JavaParser.createSlCommentNode(token) : CommonUtil.createBlockCommentNode(token);
        return commentAst;
    }

    private static DetailAST createSlCommentNode(Token token) {
        DetailAstImpl slComment = new DetailAstImpl();
        slComment.setType(144);
        slComment.setText("//");
        slComment.setColumnNo(token.getColumn() - 1);
        slComment.setLineNo(token.getLine());
        DetailAstImpl slCommentContent = new DetailAstImpl();
        slCommentContent.setType(183);
        slCommentContent.setColumnNo(token.getColumn() - 1 + 2);
        slCommentContent.setLineNo(token.getLine());
        slCommentContent.setText(token.getText());
        slComment.addChild((AST)slCommentContent);
        return slComment;
    }

    public static enum Options {
        WITH_COMMENTS,
        WITHOUT_COMMENTS;

    }
}

