/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.xpath;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import com.puppycrawl.tools.checkstyle.utils.XpathUtil;
import com.puppycrawl.tools.checkstyle.xpath.AbstractNode;
import com.puppycrawl.tools.checkstyle.xpath.AttributeNode;
import java.util.List;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tree.iter.ArrayIterator;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.SingleNodeIterator;
import net.sf.saxon.tree.util.Navigator;

public class ElementNode
extends AbstractNode {
    private static final String TEXT_ATTRIBUTE_NAME = "text";
    private static final AbstractNode[] EMPTY_ABSTRACT_NODE_ARRAY = new AbstractNode[0];
    private final AbstractNode root;
    private final AbstractNode parent;
    private final DetailAST detailAst;
    private final String text;
    private final int indexAmongSiblings;
    private AttributeNode attributeNode;

    public ElementNode(AbstractNode root, AbstractNode parent, DetailAST detailAst) {
        super(root.getTreeInfo());
        this.parent = parent;
        this.root = root;
        this.detailAst = detailAst;
        this.text = TokenUtil.getTokenName(detailAst.getType());
        this.indexAmongSiblings = parent.getChildren().size();
        this.setDepth(parent.getDepth() + 1);
        this.createTextAttribute();
        this.createChildren();
    }

    public int compareOrder(NodeInfo other) {
        int result = 0;
        if (other instanceof AbstractNode && (result = this.getDepth() - ((AbstractNode)other).getDepth()) == 0) {
            ElementNode[] children = this.getCommonAncestorChildren(other);
            result = children[0].indexAmongSiblings - children[1].indexAmongSiblings;
        }
        return result;
    }

    private ElementNode[] getCommonAncestorChildren(NodeInfo other) {
        ElementNode child1 = this;
        NodeInfo child2 = other;
        while (!child1.getParent().equals((Object)child2.getParent())) {
            child1 = child1.getParent();
            child2 = child2.getParent();
        }
        return new ElementNode[]{child1, (ElementNode)child2};
    }

    private void createChildren() {
        for (DetailAST currentChild = this.detailAst.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
            ElementNode child = new ElementNode(this.root, this, currentChild);
            this.addChild(child);
        }
    }

    public String getAttributeValue(String namespace, String localPart) {
        String result = TEXT_ATTRIBUTE_NAME.equals(localPart) ? (this.attributeNode == null ? null : this.attributeNode.getStringValue()) : null;
        return result;
    }

    public String getLocalPart() {
        return this.text;
    }

    public int getNodeKind() {
        return 1;
    }

    public NodeInfo getParent() {
        return this.parent;
    }

    public NodeInfo getRoot() {
        return this.root;
    }

    /*
     * Unable to fully structure code
     */
    public AxisIterator iterateAxis(byte axisNumber) {
        switch (axisNumber) {
            case 0: {
                iterator = new Navigator.AncestorEnumeration((NodeInfo)this, false);
                var4_12 = null;
                result = iterator;
                if (iterator == null) break;
                if (var4_12 == null) ** GOTO lbl15
                try {
                    iterator.close();
                }
                catch (Throwable var5_23) {
                    var4_12.addSuppressed(var5_23);
                }
                break;
lbl15:
                // 1 sources

                iterator.close();
                break;
                catch (Throwable var5_24) {
                    try {
                        var4_12 = var5_24;
                        throw var5_24;
                    }
                    catch (Throwable var6_43) {
                        if (iterator != null) {
                            if (var4_12 != null) {
                                try {
                                    iterator.close();
                                }
                                catch (Throwable var7_44) {
                                    var4_12.addSuppressed(var7_44);
                                }
                            } else {
                                iterator.close();
                            }
                        }
                        throw var6_43;
                    }
                }
            }
            case 1: {
                iterator = new Navigator.AncestorEnumeration((NodeInfo)this, true);
                var4_13 = null;
                result = iterator;
                if (iterator == null) break;
                if (var4_13 == null) ** GOTO lbl45
                try {
                    iterator.close();
                }
                catch (Throwable var5_25) {
                    var4_13.addSuppressed(var5_25);
                }
                break;
lbl45:
                // 1 sources

                iterator.close();
                break;
                catch (Throwable var5_26) {
                    try {
                        var4_13 = var5_26;
                        throw var5_26;
                    }
                    catch (Throwable var8_45) {
                        if (iterator != null) {
                            if (var4_13 != null) {
                                try {
                                    iterator.close();
                                }
                                catch (Throwable var9_46) {
                                    var4_13.addSuppressed(var9_46);
                                }
                            } else {
                                iterator.close();
                            }
                        }
                        throw var8_45;
                    }
                }
            }
            case 2: {
                iterator = SingleNodeIterator.makeIterator((NodeInfo)this.attributeNode);
                var4_14 = null;
                result = iterator;
                if (iterator == null) break;
                if (var4_14 == null) ** GOTO lbl75
                try {
                    iterator.close();
                }
                catch (Throwable var5_27) {
                    var4_14.addSuppressed(var5_27);
                }
                break;
lbl75:
                // 1 sources

                iterator.close();
                break;
                catch (Throwable var5_28) {
                    try {
                        var4_14 = var5_28;
                        throw var5_28;
                    }
                    catch (Throwable var10_47) {
                        if (iterator != null) {
                            if (var4_14 != null) {
                                try {
                                    iterator.close();
                                }
                                catch (Throwable var11_48) {
                                    var4_14.addSuppressed(var11_48);
                                }
                            } else {
                                iterator.close();
                            }
                        }
                        throw var10_47;
                    }
                }
            }
            case 3: {
                if (!this.hasChildNodes()) ** GOTO lbl123
                iterator = new ArrayIterator.OfNodes((NodeInfo[])this.getChildren().toArray(ElementNode.EMPTY_ABSTRACT_NODE_ARRAY));
                var4_15 = null;
                result = iterator;
                if (iterator == null) break;
                if (var4_15 == null) ** GOTO lbl106
                try {
                    iterator.close();
                }
                catch (Throwable var5_29) {
                    var4_15.addSuppressed(var5_29);
                }
                break;
lbl106:
                // 1 sources

                iterator.close();
                break;
                catch (Throwable var5_30) {
                    try {
                        var4_15 = var5_30;
                        throw var5_30;
                    }
                    catch (Throwable var12_49) {
                        if (iterator != null) {
                            if (var4_15 != null) {
                                try {
                                    iterator.close();
                                }
                                catch (Throwable var13_50) {
                                    var4_15.addSuppressed(var13_50);
                                }
                            } else {
                                iterator.close();
                            }
                        }
                        throw var12_49;
                    }
                }
lbl123:
                // 1 sources

                result = EmptyIterator.OfNodes.THE_INSTANCE;
                break;
            }
            case 4: {
                if (!this.hasChildNodes()) ** GOTO lbl156
                iterator = new Navigator.DescendantEnumeration((NodeInfo)this, false, true);
                var4_16 = null;
                result = iterator;
                if (iterator == null) break;
                if (var4_16 == null) ** GOTO lbl139
                try {
                    iterator.close();
                }
                catch (Throwable var5_31) {
                    var4_16.addSuppressed(var5_31);
                }
                break;
lbl139:
                // 1 sources

                iterator.close();
                break;
                catch (Throwable var5_32) {
                    try {
                        var4_16 = var5_32;
                        throw var5_32;
                    }
                    catch (Throwable var14_51) {
                        if (iterator != null) {
                            if (var4_16 != null) {
                                try {
                                    iterator.close();
                                }
                                catch (Throwable var15_52) {
                                    var4_16.addSuppressed(var15_52);
                                }
                            } else {
                                iterator.close();
                            }
                        }
                        throw var14_51;
                    }
                }
lbl156:
                // 1 sources

                result = EmptyIterator.OfNodes.THE_INSTANCE;
                break;
            }
            case 5: {
                iterator = new Navigator.DescendantEnumeration((NodeInfo)this, true, true);
                var4_17 = null;
                result = iterator;
                if (iterator == null) break;
                if (var4_17 == null) ** GOTO lbl171
                try {
                    iterator.close();
                }
                catch (Throwable var5_33) {
                    var4_17.addSuppressed(var5_33);
                }
                break;
lbl171:
                // 1 sources

                iterator.close();
                break;
                catch (Throwable var5_34) {
                    try {
                        var4_17 = var5_34;
                        throw var5_34;
                    }
                    catch (Throwable var16_53) {
                        if (iterator != null) {
                            if (var4_17 != null) {
                                try {
                                    iterator.close();
                                }
                                catch (Throwable var17_54) {
                                    var4_17.addSuppressed(var17_54);
                                }
                            } else {
                                iterator.close();
                            }
                        }
                        throw var16_53;
                    }
                }
            }
            case 9: {
                iterator = SingleNodeIterator.makeIterator((NodeInfo)this.parent);
                var4_18 = null;
                result = iterator;
                if (iterator == null) break;
                if (var4_18 == null) ** GOTO lbl201
                try {
                    iterator.close();
                }
                catch (Throwable var5_35) {
                    var4_18.addSuppressed(var5_35);
                }
                break;
lbl201:
                // 1 sources

                iterator.close();
                break;
                catch (Throwable var5_36) {
                    try {
                        var4_18 = var5_36;
                        throw var5_36;
                    }
                    catch (Throwable var18_55) {
                        if (iterator != null) {
                            if (var4_18 != null) {
                                try {
                                    iterator.close();
                                }
                                catch (Throwable var19_56) {
                                    var4_18.addSuppressed(var19_56);
                                }
                            } else {
                                iterator.close();
                            }
                        }
                        throw var18_55;
                    }
                }
            }
            case 12: {
                iterator = SingleNodeIterator.makeIterator((NodeInfo)this);
                var4_19 = null;
                result = iterator;
                if (iterator == null) break;
                if (var4_19 == null) ** GOTO lbl231
                try {
                    iterator.close();
                }
                catch (Throwable var5_37) {
                    var4_19.addSuppressed(var5_37);
                }
                break;
lbl231:
                // 1 sources

                iterator.close();
                break;
                catch (Throwable var5_38) {
                    try {
                        var4_19 = var5_38;
                        throw var5_38;
                    }
                    catch (Throwable var20_57) {
                        if (iterator != null) {
                            if (var4_19 != null) {
                                try {
                                    iterator.close();
                                }
                                catch (Throwable var21_58) {
                                    var4_19.addSuppressed(var21_58);
                                }
                            } else {
                                iterator.close();
                            }
                        }
                        throw var20_57;
                    }
                }
            }
            case 7: {
                result = this.getFollowingSiblingsIterator();
                break;
            }
            case 11: {
                result = this.getPrecedingSiblingsIterator();
                break;
            }
            case 6: {
                iterator = new FollowingEnumeration(this);
                var4_20 = null;
                result = iterator;
                if (iterator == null) break;
                if (var4_20 == null) ** GOTO lbl267
                try {
                    iterator.close();
                }
                catch (Throwable var5_39) {
                    var4_20.addSuppressed(var5_39);
                }
                break;
lbl267:
                // 1 sources

                iterator.close();
                break;
                catch (Throwable var5_40) {
                    try {
                        var4_20 = var5_40;
                        throw var5_40;
                    }
                    catch (Throwable var22_59) {
                        if (iterator != null) {
                            if (var4_20 != null) {
                                try {
                                    iterator.close();
                                }
                                catch (Throwable var23_60) {
                                    var4_20.addSuppressed(var23_60);
                                }
                            } else {
                                iterator.close();
                            }
                        }
                        throw var22_59;
                    }
                }
            }
            case 10: {
                iterator = new Navigator.PrecedingEnumeration((NodeInfo)this, true);
                var4_21 = null;
                result = iterator;
                if (iterator == null) break;
                if (var4_21 == null) ** GOTO lbl297
                try {
                    iterator.close();
                }
                catch (Throwable var5_41) {
                    var4_21.addSuppressed(var5_41);
                }
                break;
lbl297:
                // 1 sources

                iterator.close();
                break;
                catch (Throwable var5_42) {
                    try {
                        var4_21 = var5_42;
                        throw var5_42;
                    }
                    catch (Throwable var24_61) {
                        if (iterator != null) {
                            if (var4_21 != null) {
                                try {
                                    iterator.close();
                                }
                                catch (Throwable var25_62) {
                                    var4_21.addSuppressed(var25_62);
                                }
                            } else {
                                iterator.close();
                            }
                        }
                        throw var24_61;
                    }
                }
            }
            default: {
                throw ElementNode.throwUnsupportedOperationException();
            }
        }
        return result;
    }

    public int getLineNumber() {
        return this.detailAst.getLineNo();
    }

    public int getColumnNumber() {
        return this.detailAst.getColumnNo();
    }

    @Override
    public int getTokenType() {
        return this.detailAst.getType();
    }

    @Override
    public DetailAST getUnderlyingNode() {
        return this.detailAst;
    }

    private AxisIterator getPrecedingSiblingsIterator() {
        EmptyIterator.OfNodes result;
        if (this.indexAmongSiblings == 0) {
            result = EmptyIterator.OfNodes.THE_INSTANCE;
        } else {
            try (ArrayIterator.OfNodes iterator = new ArrayIterator.OfNodes((NodeInfo[])this.getPrecedingSiblings().toArray(EMPTY_ABSTRACT_NODE_ARRAY));){
                result = iterator;
            }
        }
        return result;
    }

    private AxisIterator getFollowingSiblingsIterator() {
        EmptyIterator.OfNodes result;
        if (this.indexAmongSiblings == this.parent.getChildren().size() - 1) {
            result = EmptyIterator.OfNodes.THE_INSTANCE;
        } else {
            try (ArrayIterator.OfNodes iterator = new ArrayIterator.OfNodes((NodeInfo[])this.getFollowingSiblings().toArray(EMPTY_ABSTRACT_NODE_ARRAY));){
                result = iterator;
            }
        }
        return result;
    }

    private List<AbstractNode> getFollowingSiblings() {
        List<AbstractNode> siblings = this.parent.getChildren();
        return siblings.subList(this.indexAmongSiblings + 1, siblings.size());
    }

    private List<AbstractNode> getPrecedingSiblings() {
        List<AbstractNode> siblings = this.parent.getChildren();
        return siblings.subList(0, this.indexAmongSiblings);
    }

    private void createTextAttribute() {
        AttributeNode attribute = null;
        if (XpathUtil.supportsTextAttribute(this.detailAst)) {
            attribute = new AttributeNode(TEXT_ATTRIBUTE_NAME, XpathUtil.getTextAttributeValue(this.detailAst));
        }
        this.attributeNode = attribute;
    }

    private static UnsupportedOperationException throwUnsupportedOperationException() {
        return new UnsupportedOperationException("Operation is not supported");
    }

    private static final class FollowingEnumeration
    implements AxisIterator {
        private AxisIterator siblingEnum;
        private AxisIterator descendEnum;

        FollowingEnumeration(NodeInfo start) {
            this.siblingEnum = start.iterateAxis((byte)7);
        }

        public NodeInfo next() {
            NodeInfo result = null;
            if (this.descendEnum != null) {
                result = this.descendEnum.next();
            }
            if (result == null) {
                this.descendEnum = null;
                result = this.siblingEnum.next();
                if (result == null) {
                    this.siblingEnum = null;
                } else {
                    this.descendEnum = new Navigator.DescendantEnumeration(result, true, false);
                    result = this.next();
                }
            }
            return result;
        }
    }
}

