/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.sizes;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;

@StatelessCheck
public class MethodLengthCheck
extends AbstractCheck {
    public static final String MSG_KEY = "maxLen.method";
    private static final int DEFAULT_MAX_LINES = 150;
    private boolean countEmpty = true;
    private int max = 150;

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{9, 8, 203};
    }

    @Override
    public int[] getRequiredTokens() {
        return CommonUtil.EMPTY_INT_ARRAY;
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST closingBrace;
        int length;
        DetailAST openingBrace = ast.findFirstToken(7);
        if (openingBrace != null && (length = this.getLengthOfBlock(openingBrace, closingBrace = openingBrace.findFirstToken(73))) > this.max) {
            this.log(ast, MSG_KEY, length, this.max);
        }
    }

    private int getLengthOfBlock(DetailAST openingBrace, DetailAST closingBrace) {
        int length = closingBrace.getLineNo() - openingBrace.getLineNo() + 1;
        if (!this.countEmpty) {
            FileContents contents = this.getFileContents();
            int lastLine = closingBrace.getLineNo();
            for (int i = openingBrace.getLineNo() - 1; i <= lastLine - 2; ++i) {
                if (!contents.lineIsBlank(i) && !contents.lineIsComment(i)) continue;
                --length;
            }
        }
        return length;
    }

    public void setMax(int length) {
        this.max = length;
    }

    public void setCountEmpty(boolean countEmpty) {
        this.countEmpty = countEmpty;
    }
}

