/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.indentation;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.indentation.AbstractExpressionHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.BlockParentHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentLevel;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentationCheck;

public class AnnotationArrayInitHandler
extends BlockParentHandler {
    private static final int NOT_EXIST = -1;

    public AnnotationArrayInitHandler(IndentationCheck indentCheck, DetailAST ast, AbstractExpressionHandler parent) {
        super(indentCheck, "annotation array initialization", ast, parent);
    }

    @Override
    protected IndentLevel getIndentImpl() {
        DetailAST parentAST = this.getMainAst().getParent();
        return new IndentLevel(this.getLineStart(parentAST));
    }

    @Override
    protected DetailAST getTopLevelAst() {
        return null;
    }

    @Override
    protected DetailAST getLeftCurly() {
        return this.getMainAst();
    }

    @Override
    protected IndentLevel curlyIndent() {
        int offset = 0;
        DetailAST lcurly = this.getLeftCurly();
        if (this.isOnStartOfLine(lcurly)) {
            offset = this.getBraceAdjustment();
        }
        IndentLevel level = new IndentLevel(this.getIndent(), offset);
        return IndentLevel.addAcceptable(level, level.getLastIndentLevel() + this.getLineWrappingIndentation());
    }

    @Override
    protected DetailAST getRightCurly() {
        return this.getMainAst().findFirstToken(73);
    }

    @Override
    protected boolean canChildrenBeNested() {
        return true;
    }

    @Override
    protected DetailAST getListChild() {
        return this.getMainAst();
    }

    @Override
    protected IndentLevel getChildrenExpectedIndent() {
        int offset = Math.min(this.getArrayInitIndentation(), this.getLineWrappingIndentation());
        IndentLevel expectedIndent = new IndentLevel(this.getIndent(), offset);
        if (this.getIndentCheck().isForceStrictCondition()) {
            int lcurlyPos;
            expectedIndent = new IndentLevel(this.getIndent(), this.getArrayInitIndentation(), this.getLineWrappingIndentation());
            int firstLine = AnnotationArrayInitHandler.getFirstLine(this.getListChild());
            int firstChildPos = this.getNextFirstNonBlankOnLineAfter(firstLine, lcurlyPos = this.expandedTabsColumnNo(this.getLeftCurly()));
            if (firstChildPos != -1) {
                expectedIndent = IndentLevel.addAcceptable(expectedIndent, firstChildPos, lcurlyPos + this.getLineWrappingIndentation());
            }
        }
        return expectedIndent;
    }

    private int getNextFirstNonBlankOnLineAfter(int lineNo, int columnNo) {
        int realColumnNo;
        String line = this.getIndentCheck().getLines()[lineNo - 1];
        int lineLength = line.length();
        for (realColumnNo = columnNo + 1; realColumnNo < lineLength && Character.isWhitespace(line.charAt(realColumnNo)); ++realColumnNo) {
        }
        if (realColumnNo == lineLength) {
            realColumnNo = -1;
        }
        return realColumnNo;
    }

    private int getLineWrappingIndentation() {
        return this.getIndentCheck().getLineWrappingIndentation();
    }

    private int getArrayInitIndentation() {
        return this.getIndentCheck().getArrayInitIndent();
    }
}

