/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.FileStatefulCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CheckUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

@FileStatefulCheck
public class EqualsAvoidNullCheck
extends AbstractCheck {
    public static final String MSG_EQUALS_AVOID_NULL = "equals.avoid.null";
    public static final String MSG_EQUALS_IGNORE_CASE_AVOID_NULL = "equalsIgnoreCase.avoid.null";
    private static final String EQUALS = "equals";
    private static final String STRING = "String";
    private static final String LEFT_CURLY = "{";
    private boolean ignoreEqualsIgnoreCase;
    private FieldFrame currentFrame;

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{27, 14, 9, 91, 96, 95, 89, 10, 21, 8, 7, 6, 154, 155, 136, 181, 198, 199, 203, 202};
    }

    public void setIgnoreEqualsIgnoreCase(boolean newValue) {
        this.ignoreEqualsIgnoreCase = newValue;
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.currentFrame = new FieldFrame(null);
    }

    @Override
    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 10: 
            case 21: 
            case 198: 
            case 202: {
                this.currentFrame.addField(ast);
                break;
            }
            case 27: {
                this.processMethodCall(ast);
                break;
            }
            case 7: {
                this.processSlist(ast);
                break;
            }
            case 136: {
                this.processLiteralNew(ast);
                break;
            }
            case 6: {
                int parentType = ast.getParent().getType();
                if (EqualsAvoidNullCheck.astTypeIsClassOrEnumOrRecordDef(parentType)) break;
                this.processFrame(ast);
                break;
            }
            default: {
                this.processFrame(ast);
            }
        }
    }

    @Override
    public void leaveToken(DetailAST ast) {
        switch (ast.getType()) {
            case 7: {
                this.leaveSlist(ast);
                break;
            }
            case 136: {
                this.leaveLiteralNew(ast);
                break;
            }
            case 6: {
                int parentType = ast.getParent().getType();
                if (EqualsAvoidNullCheck.astTypeIsClassOrEnumOrRecordDef(parentType)) break;
                this.currentFrame = this.currentFrame.getParent();
                break;
            }
            case 10: 
            case 21: 
            case 27: 
            case 198: 
            case 202: {
                break;
            }
            default: {
                this.currentFrame = this.currentFrame.getParent();
            }
        }
    }

    @Override
    public void finishTree(DetailAST ast) {
        this.traverseFieldFrameTree(this.currentFrame);
    }

    private void processSlist(DetailAST ast) {
        if (LEFT_CURLY.equals(ast.getText())) {
            FieldFrame frame = new FieldFrame(this.currentFrame);
            this.currentFrame.addChild(frame);
            this.currentFrame = frame;
        }
    }

    private void leaveSlist(DetailAST ast) {
        if (LEFT_CURLY.equals(ast.getText())) {
            this.currentFrame = this.currentFrame.getParent();
        }
    }

    private void processFrame(DetailAST ast) {
        FieldFrame frame = new FieldFrame(this.currentFrame);
        int astType = ast.getType();
        if (EqualsAvoidNullCheck.astTypeIsClassOrEnumOrRecordDef(astType)) {
            frame.setClassOrEnumOrRecordDef(true);
            frame.setFrameName(ast.findFirstToken(58).getText());
        }
        this.currentFrame.addChild(frame);
        this.currentFrame = frame;
    }

    private void processMethodCall(DetailAST methodCall) {
        String methodName;
        DetailAST dot = methodCall.getFirstChild();
        if (dot.getType() == 59 && (EQUALS.equals(methodName = dot.getLastChild().getText()) || !this.ignoreEqualsIgnoreCase && "equalsIgnoreCase".equals(methodName))) {
            this.currentFrame.addMethodCall(methodCall);
        }
    }

    private void processLiteralNew(DetailAST ast) {
        if (ast.findFirstToken(6) != null) {
            FieldFrame frame = new FieldFrame(this.currentFrame);
            this.currentFrame.addChild(frame);
            this.currentFrame = frame;
        }
    }

    private void leaveLiteralNew(DetailAST ast) {
        if (ast.findFirstToken(6) != null) {
            this.currentFrame = this.currentFrame.getParent();
        }
    }

    private void traverseFieldFrameTree(FieldFrame frame) {
        for (FieldFrame child : frame.getChildren()) {
            this.traverseFieldFrameTree(child);
            this.currentFrame = child;
            child.getMethodCalls().forEach(this::checkMethodCall);
        }
    }

    private void checkMethodCall(DetailAST methodCall) {
        DetailAST objCalledOn = methodCall.getFirstChild().getFirstChild();
        if (objCalledOn.getType() == 59) {
            objCalledOn = objCalledOn.getLastChild();
        }
        DetailAST expr = methodCall.findFirstToken(34).getFirstChild();
        if (EqualsAvoidNullCheck.containsOneArgument(methodCall) && EqualsAvoidNullCheck.containsAllSafeTokens(expr) && this.isCalledOnStringFieldOrVariable(objCalledOn)) {
            String methodName = methodCall.getFirstChild().getLastChild().getText();
            if (EQUALS.equals(methodName)) {
                this.log(methodCall, MSG_EQUALS_AVOID_NULL, new Object[0]);
            } else {
                this.log(methodCall, MSG_EQUALS_IGNORE_CASE_AVOID_NULL, new Object[0]);
            }
        }
    }

    private static boolean containsOneArgument(DetailAST methodCall) {
        DetailAST elist = methodCall.findFirstToken(34);
        return elist.getChildCount() == 1;
    }

    private static boolean containsAllSafeTokens(DetailAST expr) {
        DetailAST arg = expr.getFirstChild();
        arg = EqualsAvoidNullCheck.skipVariableAssign(arg);
        boolean argIsNotNull = false;
        if (arg.getType() == 125) {
            for (DetailAST child = arg.getFirstChild(); child != null && !argIsNotNull; child = child.getNextSibling()) {
                argIsNotNull = child.getType() == 139 || child.getType() == 204 || child.getType() == 58;
            }
        } else {
            argIsNotNull = arg.getType() == 139 || arg.getType() == 204;
        }
        return argIsNotNull;
    }

    private static DetailAST skipVariableAssign(DetailAST currentAST) {
        DetailAST result = currentAST;
        while (result.getType() == 76) {
            result = result.getNextSibling();
        }
        if (result.getType() == 80) {
            result = result.getFirstChild().getNextSibling();
        }
        return result;
    }

    private boolean isCalledOnStringFieldOrVariable(DetailAST objCalledOn) {
        boolean result;
        DetailAST previousSiblingAst = objCalledOn.getPreviousSibling();
        if (previousSiblingAst == null) {
            result = this.isStringFieldOrVariable(objCalledOn);
        } else if (previousSiblingAst.getType() == 78) {
            result = this.isStringFieldOrVariableFromThisInstance(objCalledOn);
        } else {
            String className = previousSiblingAst.getText();
            result = this.isStringFieldOrVariableFromClass(objCalledOn, className);
        }
        return result;
    }

    private boolean isStringFieldOrVariable(DetailAST objCalledOn) {
        boolean result = false;
        String name = objCalledOn.getText();
        for (FieldFrame frame = this.currentFrame; frame != null; frame = frame.getParent()) {
            DetailAST field = frame.findField(name);
            if (field == null || !frame.isClassOrEnumOrRecordDef() && !EqualsAvoidNullCheck.checkLineNo(field, objCalledOn)) continue;
            result = STRING.equals(EqualsAvoidNullCheck.getFieldType(field));
            break;
        }
        return result;
    }

    private boolean isStringFieldOrVariableFromThisInstance(DetailAST objCalledOn) {
        String name = objCalledOn.getText();
        DetailAST field = EqualsAvoidNullCheck.getObjectFrame(this.currentFrame).findField(name);
        return STRING.equals(EqualsAvoidNullCheck.getFieldType(field));
    }

    private boolean isStringFieldOrVariableFromClass(DetailAST objCalledOn, String className) {
        boolean result = false;
        String name = objCalledOn.getText();
        FieldFrame frame = EqualsAvoidNullCheck.getObjectFrame(this.currentFrame);
        while (frame != null) {
            if (className.equals(frame.getFrameName())) {
                DetailAST field = frame.findField(name);
                result = STRING.equals(EqualsAvoidNullCheck.getFieldType(field));
                break;
            }
            frame = EqualsAvoidNullCheck.getObjectFrame(frame.getParent());
        }
        return result;
    }

    private static FieldFrame getObjectFrame(FieldFrame frame) {
        FieldFrame objectFrame;
        for (objectFrame = frame; objectFrame != null && !objectFrame.isClassOrEnumOrRecordDef(); objectFrame = objectFrame.getParent()) {
        }
        return objectFrame;
    }

    private static boolean checkLineNo(DetailAST field, DetailAST objCalledOn) {
        boolean result = false;
        if (CheckUtil.isBeforeInSource(field, objCalledOn)) {
            result = true;
        }
        return result;
    }

    private static String getFieldType(DetailAST field) {
        String fieldType = null;
        DetailAST identAst = field.findFirstToken(13).findFirstToken(58);
        if (identAst != null) {
            fieldType = identAst.getText();
        }
        return fieldType;
    }

    private static boolean astTypeIsClassOrEnumOrRecordDef(int tokenType) {
        return tokenType == 14 || tokenType == 199 || tokenType == 154;
    }

    private static class FieldFrame {
        private final FieldFrame parent;
        private final Set<FieldFrame> children = new HashSet<FieldFrame>();
        private final Set<DetailAST> fields = new HashSet<DetailAST>();
        private final Set<DetailAST> methodCalls = new HashSet<DetailAST>();
        private String frameName;
        private boolean classOrEnumOrRecordDef;

        FieldFrame(FieldFrame parent) {
            this.parent = parent;
        }

        public void setFrameName(String frameName) {
            this.frameName = frameName;
        }

        public String getFrameName() {
            return this.frameName;
        }

        public FieldFrame getParent() {
            return this.parent;
        }

        public Set<FieldFrame> getChildren() {
            return Collections.unmodifiableSet(this.children);
        }

        public void addChild(FieldFrame child) {
            this.children.add(child);
        }

        public void addField(DetailAST field) {
            if (field.findFirstToken(58) != null) {
                this.fields.add(field);
            }
        }

        public void setClassOrEnumOrRecordDef(boolean value) {
            this.classOrEnumOrRecordDef = value;
        }

        public boolean isClassOrEnumOrRecordDef() {
            return this.classOrEnumOrRecordDef;
        }

        public void addMethodCall(DetailAST methodCall) {
            this.methodCalls.add(methodCall);
        }

        public DetailAST findField(String name) {
            DetailAST resultField = null;
            for (DetailAST field : this.fields) {
                if (!FieldFrame.getFieldName(field).equals(name)) continue;
                resultField = field;
                break;
            }
            return resultField;
        }

        public Set<DetailAST> getMethodCalls() {
            return Collections.unmodifiableSet(this.methodCalls);
        }

        private static String getFieldName(DetailAST field) {
            return field.findFirstToken(58).getText();
        }
    }
}

