// $ANTLR 2.7.7 (20060906): "java.g" -> "GeneratedJavaRecognizer.java"$

package com.puppycrawl.tools.checkstyle.grammar;

import com.puppycrawl.tools.checkstyle.DetailAstImpl;
import java.text.MessageFormat;
import antlr.CommonHiddenStreamToken;
import antlr.TokenStreamSelector;

import antlr.TokenBuffer;
import antlr.TokenStreamException;
import antlr.TokenStreamIOException;
import antlr.ANTLRException;
import antlr.LLkParser;
import antlr.Token;
import antlr.TokenStream;
import antlr.RecognitionException;
import antlr.NoViableAltException;
import antlr.MismatchedTokenException;
import antlr.SemanticException;
import antlr.ParserSharedInputState;
import antlr.collections.impl.BitSet;
import antlr.collections.AST;
import java.util.Hashtable;
import antlr.ASTFactory;
import antlr.ASTPair;
import antlr.collections.impl.ASTArray;

/** Java 1.5 Recognizer
 *
 * This grammar is in the PUBLIC DOMAIN
 */
public class GeneratedJavaRecognizer extends antlr.LLkParser       implements GeneratedJavaTokenTypes
 {

    /**
     * Counts the number of LT seen in the typeArguments production.
     * It is used in semantic predicates to ensure we have seen
     * enough closing '>' characters; which actually may have been
     * either GT, SR or BSR tokens.
     */
    private int ltCounter = 0;

    /**
     * Counts the number of '>' characters that have been seen but
     * have not yet been associated with the end of a typeParameters or
     * typeArguments production. This is necessary because SR and BSR
     * tokens have significance (the extra '>' characters) not only for the production
     * that sees them but also productions higher in the stack (possibly right up to an outer-most
     * typeParameters production). As the stack of the typeArguments/typeParameters productions
     * unwind, any '>' characters seen prematurely through SRs or BSRs are reconciled.
     */
    private int gtToReconcile = 0;

    /**
     * The most recently seen gt sequence (GT, SR or BSR)
     * encountered in any type argument or type parameter production.
     * We retain this so we can keep manage the synthetic GT tokens/
     * AST nodes we emit to have '<' & '>' balanced trees when encountering
     * SR and BSR tokens.
     */
    private DetailAstImpl currentGtSequence = null;

    /**
     * Consume a sequence of '>' characters (GT, SR or BSR)
     * and match these against the '<' characters seen.
     */
    private void consumeCurrentGtSequence(DetailAstImpl gtSequence)
    {
        currentGtSequence = gtSequence;
        gtToReconcile += currentGtSequence.getText().length();
        ltCounter -= currentGtSequence.getText().length();
    }

    /**
     * Emits a single GT AST node with the line and column correctly
     * set to its position in the source file. This must only
     * ever be called when a typeParameters or typeArguments production
     * is ending and there is at least one GT character to be emitted.
     *
     * @see #areThereGtsToEmit
     */
    private DetailAstImpl emitSingleGt()
    {
        gtToReconcile -= 1;
        CommonHiddenStreamToken gtToken = new CommonHiddenStreamToken(GENERIC_END, ">");
        gtToken.setLine(currentGtSequence.getLineNo());
        gtToken.setColumn(currentGtSequence.getColumnNo()
                            + (currentGtSequence.getText().length() - gtToReconcile));
        return (DetailAstImpl)astFactory.create(gtToken);
    }

    /**
     * @return true if there is at least one '>' seen but
     * not reconciled with the end of a typeParameters or
     * typeArguments production; returns false otherwise
     */
    private boolean areThereGtsToEmit()
    {
        return (gtToReconcile > 0);
    }

    /**
     * @return true if there is exactly one '>' seen but
     * not reconciled with the end of a typeParameters
     * production; returns false otherwise
     */
    private boolean isThereASingleGtToEmit()
    {
        return (gtToReconcile == 1);
    }

    /**
     * @return true if the '<' and '>' are evenly matched
     * at the current typeParameters/typeArguments nested depth
     */
    private boolean areLtsAndGtsBalanced(int currentLtLevel)
    {
        return ((currentLtLevel != 0) || ltCounter == currentLtLevel);
    }

    /**
    * This int value tracks the depth of a switch expression. Along with the
    * IDENT to id rule at the end of the parser, this value helps us
    * to know if the "yield" we are parsing is an IDENT, method call, class,
    * field, etc. or if it is a java 13+ yield statement. Positive values
    * indicate that we are within a (possibly nested) switch expression.
    */
    private int switchBlockDepth = 0;

protected GeneratedJavaRecognizer(TokenBuffer tokenBuf, int k) {
  super(tokenBuf,k);
  tokenNames = _tokenNames;
  buildTokenTypeASTClassMap();
  astFactory = new ASTFactory(getTokenTypeToASTClassMap());
}

public GeneratedJavaRecognizer(TokenBuffer tokenBuf) {
  this(tokenBuf,2);
}

protected GeneratedJavaRecognizer(TokenStream lexer, int k) {
  super(lexer,k);
  tokenNames = _tokenNames;
  buildTokenTypeASTClassMap();
  astFactory = new ASTFactory(getTokenTypeToASTClassMap());
}

public GeneratedJavaRecognizer(TokenStream lexer) {
  this(lexer,2);
}

public GeneratedJavaRecognizer(ParserSharedInputState state) {
  super(state,2);
  tokenNames = _tokenNames;
  buildTokenTypeASTClassMap();
  astFactory = new ASTFactory(getTokenTypeToASTClassMap());
}

	public final void compilationUnit() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST compilationUnit_AST = null;
		
		{
		boolean synPredMatched4 = false;
		if (((LA(1)==LITERAL_package||LA(1)==AT) && (_tokenSet_0.member(LA(2))))) {
			int _m4 = mark();
			synPredMatched4 = true;
			inputState.guessing++;
			try {
				{
				annotations();
				match(LITERAL_package);
				}
			}
			catch (RecognitionException pe) {
				synPredMatched4 = false;
			}
			rewind(_m4);
inputState.guessing--;
		}
		if ( synPredMatched4 ) {
			packageDefinition();
			astFactory.addASTChild(currentAST, returnAST);
		}
		else if ((_tokenSet_1.member(LA(1))) && (_tokenSet_2.member(LA(2)))) {
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		{
		_loop6:
		do {
			if ((LA(1)==SEMI||LA(1)==LITERAL_import) && (_tokenSet_3.member(LA(2)))) {
				importDefinition();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else {
				break _loop6;
			}
			
		} while (true);
		}
		{
		_loop8:
		do {
			if ((_tokenSet_4.member(LA(1)))) {
				typeDefinition();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else {
				break _loop8;
			}
			
		} while (true);
		}
		match(Token.EOF_TYPE);
		compilationUnit_AST = (AST)currentAST.root;
		returnAST = compilationUnit_AST;
	}
	
	public final void annotations() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST annotations_AST = null;
		
		{
		_loop77:
		do {
			if ((LA(1)==AT) && (_tokenSet_0.member(LA(2)))) {
				annotation();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else {
				break _loop77;
			}
			
		} while (true);
		}
		if ( inputState.guessing==0 ) {
			annotations_AST = (AST)currentAST.root;
			annotations_AST = (AST)astFactory.make( (new ASTArray(2)).add(astFactory.create(ANNOTATIONS,"ANNOTATIONS")).add(annotations_AST));
			currentAST.root = annotations_AST;
			currentAST.child = annotations_AST!=null &&annotations_AST.getFirstChild()!=null ?
				annotations_AST.getFirstChild() : annotations_AST;
			currentAST.advanceChildToEnd();
		}
		annotations_AST = (AST)currentAST.root;
		returnAST = annotations_AST;
	}
	
	public final void packageDefinition() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST packageDefinition_AST = null;
		Token  p = null;
		AST p_AST = null;
		
		try {      // for error handling
			annotations();
			astFactory.addASTChild(currentAST, returnAST);
			p = LT(1);
			p_AST = astFactory.create(p);
			astFactory.makeASTRoot(currentAST, p_AST);
			match(LITERAL_package);
			if ( inputState.guessing==0 ) {
				p_AST.setType(PACKAGE_DEF);
			}
			identifier();
			astFactory.addASTChild(currentAST, returnAST);
			AST tmp2_AST = null;
			tmp2_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp2_AST);
			match(SEMI);
			packageDefinition_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_1);
			} else {
			  throw ex;
			}
		}
		returnAST = packageDefinition_AST;
	}
	
	public final void importDefinition() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST importDefinition_AST = null;
		Token  i = null;
		AST i_AST = null;
		
		try {      // for error handling
			switch ( LA(1)) {
			case LITERAL_import:
			{
				i = LT(1);
				i_AST = astFactory.create(i);
				astFactory.makeASTRoot(currentAST, i_AST);
				match(LITERAL_import);
				if ( inputState.guessing==0 ) {
					i_AST.setType(IMPORT);
				}
				{
				switch ( LA(1)) {
				case LITERAL_static:
				{
					AST tmp3_AST = null;
					tmp3_AST = astFactory.create(LT(1));
					astFactory.addASTChild(currentAST, tmp3_AST);
					match(LITERAL_static);
					if ( inputState.guessing==0 ) {
						i_AST.setType(STATIC_IMPORT);
					}
					break;
				}
				case IDENT:
				case LITERAL_record:
				case LITERAL_yield:
				case LITERAL_sealed:
				case LITERAL_permits:
				case LITERAL_non:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
				identifierStar();
				astFactory.addASTChild(currentAST, returnAST);
				AST tmp4_AST = null;
				tmp4_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp4_AST);
				match(SEMI);
				importDefinition_AST = (AST)currentAST.root;
				break;
			}
			case SEMI:
			{
				AST tmp5_AST = null;
				tmp5_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp5_AST);
				match(SEMI);
				importDefinition_AST = (AST)currentAST.root;
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_1);
			} else {
			  throw ex;
			}
		}
		returnAST = importDefinition_AST;
	}
	
	public final void typeDefinition() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST typeDefinition_AST = null;
		AST m_AST = null;
		
		try {      // for error handling
			switch ( LA(1)) {
			case FINAL:
			case ABSTRACT:
			case STRICTFP:
			case LITERAL_private:
			case LITERAL_public:
			case LITERAL_protected:
			case LITERAL_static:
			case LITERAL_transient:
			case LITERAL_native:
			case LITERAL_synchronized:
			case LITERAL_volatile:
			case LITERAL_class:
			case LITERAL_interface:
			case LITERAL_default:
			case ENUM:
			case AT:
			case LITERAL_record:
			case LITERAL_sealed:
			case LITERAL_non:
			{
				modifiers();
				m_AST = (AST)returnAST;
				typeDefinitionInternal(m_AST);
				astFactory.addASTChild(currentAST, returnAST);
				typeDefinition_AST = (AST)currentAST.root;
				break;
			}
			case SEMI:
			{
				AST tmp6_AST = null;
				tmp6_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp6_AST);
				match(SEMI);
				typeDefinition_AST = (AST)currentAST.root;
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_5);
			} else {
			  throw ex;
			}
		}
		returnAST = typeDefinition_AST;
	}
	
	public final void identifier() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST identifier_AST = null;
		
		id();
		astFactory.addASTChild(currentAST, returnAST);
		{
		_loop62:
		do {
			if ((LA(1)==DOT)) {
				AST tmp7_AST = null;
				tmp7_AST = astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp7_AST);
				match(DOT);
				id();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else {
				break _loop62;
			}
			
		} while (true);
		}
		identifier_AST = (AST)currentAST.root;
		returnAST = identifier_AST;
	}
	
	public final void identifierStar() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST identifierStar_AST = null;
		
		id();
		astFactory.addASTChild(currentAST, returnAST);
		{
		_loop65:
		do {
			if ((LA(1)==DOT) && (_tokenSet_0.member(LA(2)))) {
				AST tmp8_AST = null;
				tmp8_AST = astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp8_AST);
				match(DOT);
				id();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else {
				break _loop65;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case DOT:
		{
			AST tmp9_AST = null;
			tmp9_AST = astFactory.create(LT(1));
			astFactory.makeASTRoot(currentAST, tmp9_AST);
			match(DOT);
			AST tmp10_AST = null;
			tmp10_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp10_AST);
			match(STAR);
			break;
		}
		case SEMI:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		identifierStar_AST = (AST)currentAST.root;
		returnAST = identifierStar_AST;
	}
	
	public final void modifiers() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST modifiers_AST = null;
		
		{
		_loop69:
		do {
			if ((_tokenSet_6.member(LA(1))) && (_tokenSet_7.member(LA(2)))) {
				modifier();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else if (((LA(1)==AT) && (_tokenSet_0.member(LA(2))))&&(LA(1)==AT && !LT(2).getText().equals("interface"))) {
				annotation();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else {
				break _loop69;
			}
			
		} while (true);
		}
		if ( inputState.guessing==0 ) {
			modifiers_AST = (AST)currentAST.root;
			modifiers_AST = (AST)astFactory.make( (new ASTArray(2)).add(astFactory.create(MODIFIERS,"MODIFIERS")).add(modifiers_AST));
			currentAST.root = modifiers_AST;
			currentAST.child = modifiers_AST!=null &&modifiers_AST.getFirstChild()!=null ?
				modifiers_AST.getFirstChild() : modifiers_AST;
			currentAST.advanceChildToEnd();
		}
		modifiers_AST = (AST)currentAST.root;
		returnAST = modifiers_AST;
	}
	
	protected final void typeDefinitionInternal(
		AST modifiers
	) throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST typeDefinitionInternal_AST = null;
		
		switch ( LA(1)) {
		case LITERAL_class:
		{
			classDefinition(modifiers);
			astFactory.addASTChild(currentAST, returnAST);
			typeDefinitionInternal_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_interface:
		{
			interfaceDefinition(modifiers);
			astFactory.addASTChild(currentAST, returnAST);
			typeDefinitionInternal_AST = (AST)currentAST.root;
			break;
		}
		case ENUM:
		{
			enumDefinition(modifiers);
			astFactory.addASTChild(currentAST, returnAST);
			typeDefinitionInternal_AST = (AST)currentAST.root;
			break;
		}
		case AT:
		{
			annotationDefinition(modifiers);
			astFactory.addASTChild(currentAST, returnAST);
			typeDefinitionInternal_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_record:
		{
			recordDefinition(modifiers);
			astFactory.addASTChild(currentAST, returnAST);
			typeDefinitionInternal_AST = (AST)currentAST.root;
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		returnAST = typeDefinitionInternal_AST;
	}
	
	public final void classDefinition(
		AST modifiers
	) throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST classDefinition_AST = null;
		Token  c = null;
		AST c_AST = null;
		AST id_AST = null;
		AST tp_AST = null;
		AST sc_AST = null;
		AST ic_AST = null;
		AST ps_AST = null;
		AST cb_AST = null;
		
		c = LT(1);
		c_AST = astFactory.create(c);
		match(LITERAL_class);
		id();
		id_AST = (AST)returnAST;
		{
		switch ( LA(1)) {
		case LT:
		{
			typeParameters();
			tp_AST = (AST)returnAST;
			break;
		}
		case LITERAL_extends:
		case LCURLY:
		case LITERAL_implements:
		case LITERAL_permits:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		superClassClause();
		sc_AST = (AST)returnAST;
		implementsClause();
		ic_AST = (AST)returnAST;
		permittedSubclassesAndInterfaces();
		ps_AST = (AST)returnAST;
		classBlock();
		cb_AST = (AST)returnAST;
		if ( inputState.guessing==0 ) {
			classDefinition_AST = (AST)currentAST.root;
			classDefinition_AST = (AST)astFactory.make( (new ASTArray(9)).add(astFactory.create(CLASS_DEF,"CLASS_DEF")).add(modifiers).add(c_AST).add(id_AST).add(tp_AST).add(sc_AST).add(ic_AST).add(ps_AST).add(cb_AST));
			currentAST.root = classDefinition_AST;
			currentAST.child = classDefinition_AST!=null &&classDefinition_AST.getFirstChild()!=null ?
				classDefinition_AST.getFirstChild() : classDefinition_AST;
			currentAST.advanceChildToEnd();
		}
		returnAST = classDefinition_AST;
	}
	
	public final void interfaceDefinition(
		AST modifiers
	) throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST interfaceDefinition_AST = null;
		Token  i = null;
		AST i_AST = null;
		AST id_AST = null;
		AST tp_AST = null;
		AST ie_AST = null;
		AST ps_AST = null;
		AST cb_AST = null;
		
		i = LT(1);
		i_AST = astFactory.create(i);
		match(LITERAL_interface);
		id();
		id_AST = (AST)returnAST;
		{
		switch ( LA(1)) {
		case LT:
		{
			typeParameters();
			tp_AST = (AST)returnAST;
			break;
		}
		case LITERAL_extends:
		case LCURLY:
		case LITERAL_permits:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		interfaceExtends();
		ie_AST = (AST)returnAST;
		permittedSubclassesAndInterfaces();
		ps_AST = (AST)returnAST;
		classBlock();
		cb_AST = (AST)returnAST;
		if ( inputState.guessing==0 ) {
			interfaceDefinition_AST = (AST)currentAST.root;
			interfaceDefinition_AST = (AST)astFactory.make( (new ASTArray(8)).add(astFactory.create(INTERFACE_DEF,"INTERFACE_DEF")).add(modifiers).add(i_AST).add(id_AST).add(tp_AST).add(ie_AST).add(ps_AST).add(cb_AST));
			currentAST.root = interfaceDefinition_AST;
			currentAST.child = interfaceDefinition_AST!=null &&interfaceDefinition_AST.getFirstChild()!=null ?
				interfaceDefinition_AST.getFirstChild() : interfaceDefinition_AST;
			currentAST.advanceChildToEnd();
		}
		returnAST = interfaceDefinition_AST;
	}
	
	public final void enumDefinition(
		AST modifiers
	) throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST enumDefinition_AST = null;
		Token  e = null;
		AST e_AST = null;
		AST id_AST = null;
		AST ic_AST = null;
		AST eb_AST = null;
		
		e = LT(1);
		e_AST = astFactory.create(e);
		match(ENUM);
		id();
		id_AST = (AST)returnAST;
		implementsClause();
		ic_AST = (AST)returnAST;
		enumBlock();
		eb_AST = (AST)returnAST;
		if ( inputState.guessing==0 ) {
			enumDefinition_AST = (AST)currentAST.root;
			enumDefinition_AST = (AST)astFactory.make( (new ASTArray(6)).add(astFactory.create(ENUM_DEF,"ENUM_DEF")).add(modifiers).add(e_AST).add(id_AST).add(ic_AST).add(eb_AST));
			currentAST.root = enumDefinition_AST;
			currentAST.child = enumDefinition_AST!=null &&enumDefinition_AST.getFirstChild()!=null ?
				enumDefinition_AST.getFirstChild() : enumDefinition_AST;
			currentAST.advanceChildToEnd();
		}
		returnAST = enumDefinition_AST;
	}
	
	public final void annotationDefinition(
		AST modifiers
	) throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST annotationDefinition_AST = null;
		Token  a = null;
		AST a_AST = null;
		Token  i = null;
		AST i_AST = null;
		AST id_AST = null;
		AST ab_AST = null;
		
		a = LT(1);
		a_AST = astFactory.create(a);
		match(AT);
		i = LT(1);
		i_AST = astFactory.create(i);
		match(LITERAL_interface);
		id();
		id_AST = (AST)returnAST;
		annotationBlock();
		ab_AST = (AST)returnAST;
		if ( inputState.guessing==0 ) {
			annotationDefinition_AST = (AST)currentAST.root;
			annotationDefinition_AST = (AST)astFactory.make( (new ASTArray(6)).add(astFactory.create(ANNOTATION_DEF,"ANNOTATION_DEF")).add(modifiers).add(a_AST).add(i_AST).add(id_AST).add(ab_AST));
			currentAST.root = annotationDefinition_AST;
			currentAST.child = annotationDefinition_AST!=null &&annotationDefinition_AST.getFirstChild()!=null ?
				annotationDefinition_AST.getFirstChild() : annotationDefinition_AST;
			currentAST.advanceChildToEnd();
		}
		returnAST = annotationDefinition_AST;
	}
	
	public final void recordDefinition(
		AST modifiers
	) throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST recordDefinition_AST = null;
		Token  r = null;
		AST r_AST = null;
		AST id_AST = null;
		AST tp_AST = null;
		AST rc_AST = null;
		AST ic_AST = null;
		AST rb_AST = null;
		
		r = LT(1);
		r_AST = astFactory.create(r);
		match(LITERAL_record);
		id();
		id_AST = (AST)returnAST;
		{
		switch ( LA(1)) {
		case LT:
		{
			typeParameters();
			tp_AST = (AST)returnAST;
			break;
		}
		case LPAREN:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		recordComponentsList();
		rc_AST = (AST)returnAST;
		implementsClause();
		ic_AST = (AST)returnAST;
		recordBodyDeclaration();
		rb_AST = (AST)returnAST;
		if ( inputState.guessing==0 ) {
			recordDefinition_AST = (AST)currentAST.root;
			recordDefinition_AST = (AST)astFactory.make( (new ASTArray(8)).add(astFactory.create(RECORD_DEF,"RECORD_DEF")).add(modifiers).add(r_AST).add(id_AST).add(tp_AST).add(rc_AST).add(ic_AST).add(rb_AST));
			currentAST.root = recordDefinition_AST;
			currentAST.child = recordDefinition_AST!=null &&recordDefinition_AST.getFirstChild()!=null ?
				recordDefinition_AST.getFirstChild() : recordDefinition_AST;
			currentAST.advanceChildToEnd();
		}
		returnAST = recordDefinition_AST;
	}
	
	public final void typeSpec(
		boolean addImagNode
	) throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST typeSpec_AST = null;
		
		switch ( LA(1)) {
		case IDENT:
		case AT:
		case LITERAL_record:
		case LITERAL_yield:
		case LITERAL_sealed:
		case LITERAL_permits:
		case LITERAL_non:
		{
			classTypeSpec(addImagNode);
			astFactory.addASTChild(currentAST, returnAST);
			typeSpec_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_void:
		case LITERAL_boolean:
		case LITERAL_byte:
		case LITERAL_char:
		case LITERAL_short:
		case LITERAL_int:
		case LITERAL_float:
		case LITERAL_long:
		case LITERAL_double:
		{
			builtInTypeSpec(addImagNode);
			astFactory.addASTChild(currentAST, returnAST);
			typeSpec_AST = (AST)currentAST.root;
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		returnAST = typeSpec_AST;
	}
	
	public final void classTypeSpec(
		boolean addImagNode
	) throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST classTypeSpec_AST = null;
		Token  lb = null;
		AST lb_AST = null;
		
		classOrInterfaceType(addImagNode);
		astFactory.addASTChild(currentAST, returnAST);
		{
		_loop24:
		do {
			if ((LA(1)==LBRACK||LA(1)==AT) && (_tokenSet_8.member(LA(2)))) {
				{
				if (((LA(1)==LBRACK||LA(1)==AT) && (_tokenSet_8.member(LA(2))))&&(LA(1) == AT)) {
					annotations();
					astFactory.addASTChild(currentAST, returnAST);
				}
				else if ((LA(1)==LBRACK) && (LA(2)==RBRACK)) {
				}
				else {
					throw new NoViableAltException(LT(1), getFilename());
				}
				
				}
				lb = LT(1);
				lb_AST = astFactory.create(lb);
				astFactory.makeASTRoot(currentAST, lb_AST);
				match(LBRACK);
				if ( inputState.guessing==0 ) {
					lb_AST.setType(ARRAY_DECLARATOR);
				}
				AST tmp11_AST = null;
				tmp11_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp11_AST);
				match(RBRACK);
			}
			else {
				break _loop24;
			}
			
		} while (true);
		}
		if ( inputState.guessing==0 ) {
			classTypeSpec_AST = (AST)currentAST.root;
			
			if ( addImagNode ) {
			classTypeSpec_AST = (AST)astFactory.make( (new ASTArray(2)).add(astFactory.create(TYPE,"TYPE")).add(classTypeSpec_AST));
			}
			
			currentAST.root = classTypeSpec_AST;
			currentAST.child = classTypeSpec_AST!=null &&classTypeSpec_AST.getFirstChild()!=null ?
				classTypeSpec_AST.getFirstChild() : classTypeSpec_AST;
			currentAST.advanceChildToEnd();
		}
		classTypeSpec_AST = (AST)currentAST.root;
		returnAST = classTypeSpec_AST;
	}
	
	public final void builtInTypeSpec(
		boolean addImagNode
	) throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST builtInTypeSpec_AST = null;
		Token  lb = null;
		AST lb_AST = null;
		
		builtInType();
		astFactory.addASTChild(currentAST, returnAST);
		{
		_loop54:
		do {
			if ((LA(1)==LBRACK||LA(1)==AT) && (_tokenSet_8.member(LA(2)))) {
				{
				if (((LA(1)==LBRACK||LA(1)==AT) && (_tokenSet_8.member(LA(2))))&&(LA(1) == AT)) {
					annotations();
					astFactory.addASTChild(currentAST, returnAST);
				}
				else if ((LA(1)==LBRACK) && (LA(2)==RBRACK)) {
				}
				else {
					throw new NoViableAltException(LT(1), getFilename());
				}
				
				}
				lb = LT(1);
				lb_AST = astFactory.create(lb);
				astFactory.makeASTRoot(currentAST, lb_AST);
				match(LBRACK);
				if ( inputState.guessing==0 ) {
					lb_AST.setType(ARRAY_DECLARATOR);
				}
				AST tmp12_AST = null;
				tmp12_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp12_AST);
				match(RBRACK);
			}
			else {
				break _loop54;
			}
			
		} while (true);
		}
		if ( inputState.guessing==0 ) {
			builtInTypeSpec_AST = (AST)currentAST.root;
			
			if ( addImagNode ) {
			builtInTypeSpec_AST = (AST)astFactory.make( (new ASTArray(2)).add(astFactory.create(TYPE,"TYPE")).add(builtInTypeSpec_AST));
			}
			
			currentAST.root = builtInTypeSpec_AST;
			currentAST.child = builtInTypeSpec_AST!=null &&builtInTypeSpec_AST.getFirstChild()!=null ?
				builtInTypeSpec_AST.getFirstChild() : builtInTypeSpec_AST;
			currentAST.advanceChildToEnd();
		}
		builtInTypeSpec_AST = (AST)currentAST.root;
		returnAST = builtInTypeSpec_AST;
	}
	
	public final void variableLengthParameterTypeSpec() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST variableLengthParameterTypeSpec_AST = null;
		Token  lb = null;
		AST lb_AST = null;
		
		{
		switch ( LA(1)) {
		case IDENT:
		case AT:
		case LITERAL_record:
		case LITERAL_yield:
		case LITERAL_sealed:
		case LITERAL_permits:
		case LITERAL_non:
		{
			classOrInterfaceType(false);
			astFactory.addASTChild(currentAST, returnAST);
			break;
		}
		case LITERAL_void:
		case LITERAL_boolean:
		case LITERAL_byte:
		case LITERAL_char:
		case LITERAL_short:
		case LITERAL_int:
		case LITERAL_float:
		case LITERAL_long:
		case LITERAL_double:
		{
			builtInType();
			astFactory.addASTChild(currentAST, returnAST);
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		if (((_tokenSet_9.member(LA(1))) && (_tokenSet_8.member(LA(2))))&&(LA(1) == AT)) {
			annotations();
			astFactory.addASTChild(currentAST, returnAST);
		}
		else if ((LA(1)==LBRACK||LA(1)==ELLIPSIS) && (_tokenSet_8.member(LA(2)))) {
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		{
		_loop20:
		do {
			if ((LA(1)==LBRACK)) {
				lb = LT(1);
				lb_AST = astFactory.create(lb);
				astFactory.makeASTRoot(currentAST, lb_AST);
				match(LBRACK);
				if ( inputState.guessing==0 ) {
					lb_AST.setType(ARRAY_DECLARATOR);
				}
				AST tmp13_AST = null;
				tmp13_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp13_AST);
				match(RBRACK);
				{
				if (((_tokenSet_9.member(LA(1))) && (_tokenSet_8.member(LA(2))))&&(LA(1) == AT)) {
					annotations();
					astFactory.addASTChild(currentAST, returnAST);
				}
				else if ((LA(1)==LBRACK||LA(1)==ELLIPSIS) && (_tokenSet_8.member(LA(2)))) {
				}
				else {
					throw new NoViableAltException(LT(1), getFilename());
				}
				
				}
			}
			else {
				break _loop20;
			}
			
		} while (true);
		}
		variableLengthParameterTypeSpec_AST = (AST)currentAST.root;
		returnAST = variableLengthParameterTypeSpec_AST;
	}
	
	public final void classOrInterfaceType(
		boolean addImagNode
	) throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST classOrInterfaceType_AST = null;
		
		{
		if (((_tokenSet_10.member(LA(1))) && (_tokenSet_11.member(LA(2))))&&(LA(1) == AT)) {
			annotations();
			astFactory.addASTChild(currentAST, returnAST);
		}
		else if ((_tokenSet_0.member(LA(1))) && (_tokenSet_11.member(LA(2)))) {
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		id();
		astFactory.addASTChild(currentAST, returnAST);
		{
		if ((LA(1)==LT) && (_tokenSet_11.member(LA(2)))) {
			typeArguments(addImagNode);
			astFactory.addASTChild(currentAST, returnAST);
		}
		else if ((_tokenSet_11.member(LA(1))) && (_tokenSet_12.member(LA(2)))) {
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		{
		_loop31:
		do {
			if ((LA(1)==DOT) && (_tokenSet_10.member(LA(2)))) {
				AST tmp14_AST = null;
				tmp14_AST = astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp14_AST);
				match(DOT);
				{
				if (((_tokenSet_10.member(LA(1))) && (_tokenSet_11.member(LA(2))))&&(LA(1) == AT)) {
					annotations();
					astFactory.addASTChild(currentAST, returnAST);
				}
				else if ((_tokenSet_0.member(LA(1))) && (_tokenSet_11.member(LA(2)))) {
				}
				else {
					throw new NoViableAltException(LT(1), getFilename());
				}
				
				}
				id();
				astFactory.addASTChild(currentAST, returnAST);
				{
				if ((LA(1)==LT) && (_tokenSet_11.member(LA(2)))) {
					typeArguments(addImagNode);
					astFactory.addASTChild(currentAST, returnAST);
				}
				else if ((_tokenSet_11.member(LA(1))) && (_tokenSet_12.member(LA(2)))) {
				}
				else {
					throw new NoViableAltException(LT(1), getFilename());
				}
				
				}
			}
			else {
				break _loop31;
			}
			
		} while (true);
		}
		classOrInterfaceType_AST = (AST)currentAST.root;
		returnAST = classOrInterfaceType_AST;
	}
	
	public final void builtInType() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST builtInType_AST = null;
		
		switch ( LA(1)) {
		case LITERAL_void:
		{
			AST tmp15_AST = null;
			tmp15_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp15_AST);
			match(LITERAL_void);
			builtInType_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_boolean:
		{
			AST tmp16_AST = null;
			tmp16_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp16_AST);
			match(LITERAL_boolean);
			builtInType_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_byte:
		{
			AST tmp17_AST = null;
			tmp17_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp17_AST);
			match(LITERAL_byte);
			builtInType_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_char:
		{
			AST tmp18_AST = null;
			tmp18_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp18_AST);
			match(LITERAL_char);
			builtInType_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_short:
		{
			AST tmp19_AST = null;
			tmp19_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp19_AST);
			match(LITERAL_short);
			builtInType_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_int:
		{
			AST tmp20_AST = null;
			tmp20_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp20_AST);
			match(LITERAL_int);
			builtInType_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_float:
		{
			AST tmp21_AST = null;
			tmp21_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp21_AST);
			match(LITERAL_float);
			builtInType_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_long:
		{
			AST tmp22_AST = null;
			tmp22_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp22_AST);
			match(LITERAL_long);
			builtInType_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_double:
		{
			AST tmp23_AST = null;
			tmp23_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp23_AST);
			match(LITERAL_double);
			builtInType_AST = (AST)currentAST.root;
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		returnAST = builtInType_AST;
	}
	
	public final void id() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST id_AST = null;
		
		switch ( LA(1)) {
		case IDENT:
		{
			AST tmp24_AST = null;
			tmp24_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp24_AST);
			match(IDENT);
			id_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_record:
		{
			recordKey();
			astFactory.addASTChild(currentAST, returnAST);
			id_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_yield:
		{
			yieldKey();
			astFactory.addASTChild(currentAST, returnAST);
			id_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_non:
		{
			nonKey();
			astFactory.addASTChild(currentAST, returnAST);
			id_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_sealed:
		{
			sealedKey();
			astFactory.addASTChild(currentAST, returnAST);
			id_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_permits:
		{
			permitsKey();
			astFactory.addASTChild(currentAST, returnAST);
			id_AST = (AST)currentAST.root;
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		returnAST = id_AST;
	}
	
	public final void typeArguments(
		boolean addImagNode
	) throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST typeArguments_AST = null;
		Token  lt = null;
		AST lt_AST = null;
		int currentLtLevel = 0;
		
		if ( inputState.guessing==0 ) {
			currentLtLevel = ltCounter;
		}
		lt = LT(1);
		lt_AST = astFactory.create(lt);
		astFactory.addASTChild(currentAST, lt_AST);
		match(LT);
		if ( inputState.guessing==0 ) {
			lt_AST.setType(GENERIC_START); ;ltCounter++;
		}
		{
		if ((_tokenSet_13.member(LA(1))) && (_tokenSet_11.member(LA(2)))) {
			typeArgument(addImagNode);
			astFactory.addASTChild(currentAST, returnAST);
			{
			_loop43:
			do {
				if (((LA(1)==COMMA) && (_tokenSet_13.member(LA(2))))&&(gtToReconcile == 0)) {
					AST tmp25_AST = null;
					tmp25_AST = astFactory.create(LT(1));
					astFactory.addASTChild(currentAST, tmp25_AST);
					match(COMMA);
					typeArgument(addImagNode);
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					break _loop43;
				}
				
			} while (true);
			}
		}
		else if ((_tokenSet_11.member(LA(1))) && (_tokenSet_12.member(LA(2)))) {
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		{
		if ((_tokenSet_14.member(LA(1))) && (_tokenSet_11.member(LA(2)))) {
			typeArgumentsOrParametersEnd();
			astFactory.addASTChild(currentAST, returnAST);
		}
		else if ((_tokenSet_11.member(LA(1))) && (_tokenSet_12.member(LA(2)))) {
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		if ( inputState.guessing==0 ) {
			
			if (areThereGtsToEmit())
			{
			astFactory.addASTChild(currentAST, emitSingleGt());
			}
			
		}
		if (!(areLtsAndGtsBalanced(currentLtLevel)))
		  throw new SemanticException("areLtsAndGtsBalanced(currentLtLevel)");
		if ( inputState.guessing==0 ) {
			typeArguments_AST = (AST)currentAST.root;
			typeArguments_AST = (AST)astFactory.make( (new ASTArray(2)).add(astFactory.create(TYPE_ARGUMENTS,"TYPE_ARGUMENTS")).add(typeArguments_AST));
			currentAST.root = typeArguments_AST;
			currentAST.child = typeArguments_AST!=null &&typeArguments_AST.getFirstChild()!=null ?
				typeArguments_AST.getFirstChild() : typeArguments_AST;
			currentAST.advanceChildToEnd();
		}
		typeArguments_AST = (AST)currentAST.root;
		returnAST = typeArguments_AST;
	}
	
	public final void typeArgument(
		boolean addImagNode
	) throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST typeArgument_AST = null;
		
		{
		{
		if (((_tokenSet_13.member(LA(1))) && (_tokenSet_11.member(LA(2))))&&(LA(1) == AT)) {
			annotations();
			astFactory.addASTChild(currentAST, returnAST);
		}
		else if ((_tokenSet_13.member(LA(1))) && (_tokenSet_11.member(LA(2)))) {
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		{
		switch ( LA(1)) {
		case IDENT:
		case AT:
		case LITERAL_record:
		case LITERAL_yield:
		case LITERAL_sealed:
		case LITERAL_permits:
		case LITERAL_non:
		{
			classTypeSpec(addImagNode);
			astFactory.addASTChild(currentAST, returnAST);
			break;
		}
		case LITERAL_void:
		case LITERAL_boolean:
		case LITERAL_byte:
		case LITERAL_char:
		case LITERAL_short:
		case LITERAL_int:
		case LITERAL_float:
		case LITERAL_long:
		case LITERAL_double:
		{
			builtInTypeSpec(addImagNode);
			astFactory.addASTChild(currentAST, returnAST);
			break;
		}
		case QUESTION:
		{
			wildcardType(addImagNode);
			astFactory.addASTChild(currentAST, returnAST);
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		}
		if ( inputState.guessing==0 ) {
			typeArgument_AST = (AST)currentAST.root;
			typeArgument_AST = (AST)astFactory.make( (new ASTArray(2)).add(astFactory.create(TYPE_ARGUMENT,"TYPE_ARGUMENT")).add(typeArgument_AST));
			currentAST.root = typeArgument_AST;
			currentAST.child = typeArgument_AST!=null &&typeArgument_AST.getFirstChild()!=null ?
				typeArgument_AST.getFirstChild() : typeArgument_AST;
			currentAST.advanceChildToEnd();
		}
		typeArgument_AST = (AST)currentAST.root;
		returnAST = typeArgument_AST;
	}
	
	public final void wildcardType(
		boolean addImagNode
	) throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST wildcardType_AST = null;
		Token  q = null;
		AST q_AST = null;
		
		q = LT(1);
		q_AST = astFactory.create(q);
		astFactory.addASTChild(currentAST, q_AST);
		match(QUESTION);
		if ( inputState.guessing==0 ) {
			q_AST.setType(WILDCARD_TYPE);
		}
		{
		boolean synPredMatched39 = false;
		if (((LA(1)==LITERAL_extends||LA(1)==LITERAL_super) && (_tokenSet_15.member(LA(2))))) {
			int _m39 = mark();
			synPredMatched39 = true;
			inputState.guessing++;
			try {
				{
				switch ( LA(1)) {
				case LITERAL_extends:
				{
					match(LITERAL_extends);
					break;
				}
				case LITERAL_super:
				{
					match(LITERAL_super);
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
			}
			catch (RecognitionException pe) {
				synPredMatched39 = false;
			}
			rewind(_m39);
inputState.guessing--;
		}
		if ( synPredMatched39 ) {
			typeArgumentBounds(addImagNode);
			astFactory.addASTChild(currentAST, returnAST);
		}
		else if ((_tokenSet_11.member(LA(1))) && (_tokenSet_12.member(LA(2)))) {
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		wildcardType_AST = (AST)currentAST.root;
		returnAST = wildcardType_AST;
	}
	
	public final void typeArgumentBounds(
		boolean addImagNode
	) throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST typeArgumentBounds_AST = null;
		Token  e = null;
		AST e_AST = null;
		Token  s = null;
		AST s_AST = null;
		Token  lb = null;
		AST lb_AST = null;
		
		{
		switch ( LA(1)) {
		case LITERAL_extends:
		{
			e = LT(1);
			e_AST = astFactory.create(e);
			astFactory.makeASTRoot(currentAST, e_AST);
			match(LITERAL_extends);
			if ( inputState.guessing==0 ) {
				e_AST.setType(TYPE_UPPER_BOUNDS);
			}
			break;
		}
		case LITERAL_super:
		{
			s = LT(1);
			s_AST = astFactory.create(s);
			astFactory.makeASTRoot(currentAST, s_AST);
			match(LITERAL_super);
			if ( inputState.guessing==0 ) {
				s_AST.setType(TYPE_LOWER_BOUNDS);
			}
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		switch ( LA(1)) {
		case IDENT:
		case AT:
		case LITERAL_record:
		case LITERAL_yield:
		case LITERAL_sealed:
		case LITERAL_permits:
		case LITERAL_non:
		{
			classOrInterfaceType(addImagNode);
			astFactory.addASTChild(currentAST, returnAST);
			break;
		}
		case LITERAL_void:
		case LITERAL_boolean:
		case LITERAL_byte:
		case LITERAL_char:
		case LITERAL_short:
		case LITERAL_int:
		case LITERAL_float:
		case LITERAL_long:
		case LITERAL_double:
		{
			builtInType();
			astFactory.addASTChild(currentAST, returnAST);
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		_loop50:
		do {
			if ((LA(1)==LBRACK) && (LA(2)==RBRACK)) {
				lb = LT(1);
				lb_AST = astFactory.create(lb);
				astFactory.makeASTRoot(currentAST, lb_AST);
				match(LBRACK);
				if ( inputState.guessing==0 ) {
					lb_AST.setType(ARRAY_DECLARATOR);
				}
				AST tmp26_AST = null;
				tmp26_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp26_AST);
				match(RBRACK);
			}
			else {
				break _loop50;
			}
			
		} while (true);
		}
		typeArgumentBounds_AST = (AST)currentAST.root;
		returnAST = typeArgumentBounds_AST;
	}
	
	protected final void typeArgumentsOrParametersEnd() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST typeArgumentsOrParametersEnd_AST = null;
		Token  g = null;
		AST g_AST = null;
		Token  sr = null;
		AST sr_AST = null;
		Token  bsr = null;
		AST bsr_AST = null;
		
		switch ( LA(1)) {
		case GT:
		{
			g = LT(1);
			g_AST = astFactory.create(g);
			match(GT);
			if ( inputState.guessing==0 ) {
				consumeCurrentGtSequence((DetailAstImpl)g_AST);
			}
			break;
		}
		case SR:
		{
			sr = LT(1);
			sr_AST = astFactory.create(sr);
			match(SR);
			if ( inputState.guessing==0 ) {
				consumeCurrentGtSequence((DetailAstImpl)sr_AST);
			}
			break;
		}
		case BSR:
		{
			bsr = LT(1);
			bsr_AST = astFactory.create(bsr);
			match(BSR);
			if ( inputState.guessing==0 ) {
				consumeCurrentGtSequence((DetailAstImpl)bsr_AST);
			}
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		returnAST = typeArgumentsOrParametersEnd_AST;
	}
	
	public final void type() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST type_AST = null;
		
		{
		if (((_tokenSet_15.member(LA(1))) && (_tokenSet_16.member(LA(2))))&&(LA(1) == AT)) {
			annotations();
			astFactory.addASTChild(currentAST, returnAST);
		}
		else if ((_tokenSet_15.member(LA(1))) && (_tokenSet_16.member(LA(2)))) {
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		{
		switch ( LA(1)) {
		case IDENT:
		case AT:
		case LITERAL_record:
		case LITERAL_yield:
		case LITERAL_sealed:
		case LITERAL_permits:
		case LITERAL_non:
		{
			classOrInterfaceType(false);
			astFactory.addASTChild(currentAST, returnAST);
			break;
		}
		case LITERAL_void:
		case LITERAL_boolean:
		case LITERAL_byte:
		case LITERAL_char:
		case LITERAL_short:
		case LITERAL_int:
		case LITERAL_float:
		case LITERAL_long:
		case LITERAL_double:
		{
			builtInType();
			astFactory.addASTChild(currentAST, returnAST);
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		type_AST = (AST)currentAST.root;
		returnAST = type_AST;
	}
	
/** A declaration is the creation of a reference or primitive-type variable
 *  Create a separate Type/Var tree for each var in the var list.
    @throws RecognitionException if recognition problem occurs.
    @throws TokenStreamException if problem occurs while generating a stream of tokens.
 */
	public final void declaration() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST declaration_AST = null;
		AST m_AST = null;
		AST t_AST = null;
		AST v_AST = null;
		
		modifiers();
		m_AST = (AST)returnAST;
		typeSpec(false);
		t_AST = (AST)returnAST;
		variableDefinitions(m_AST,t_AST);
		v_AST = (AST)returnAST;
		if ( inputState.guessing==0 ) {
			declaration_AST = (AST)currentAST.root;
			declaration_AST = v_AST;
			currentAST.root = declaration_AST;
			currentAST.child = declaration_AST!=null &&declaration_AST.getFirstChild()!=null ?
				declaration_AST.getFirstChild() : declaration_AST;
			currentAST.advanceChildToEnd();
		}
		returnAST = declaration_AST;
	}
	
	public final void variableDefinitions(
		AST mods, AST t
	) throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST variableDefinitions_AST = null;
		
		variableDeclarator((AST) getASTFactory().dupTree(mods),
                           //dupList as this also copies siblings (like TYPE_ARGUMENTS)
                           (AST) getASTFactory().dupList(t));
		astFactory.addASTChild(currentAST, returnAST);
		{
		_loop194:
		do {
			if ((LA(1)==COMMA)) {
				AST tmp27_AST = null;
				tmp27_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp27_AST);
				match(COMMA);
				variableDeclarator((AST) getASTFactory().dupTree(mods),
                               //dupList as this also copies siblings (like TYPE_ARGUMENTS)
                               (AST) getASTFactory().dupList(t));
				astFactory.addASTChild(currentAST, returnAST);
			}
			else {
				break _loop194;
			}
			
		} while (true);
		}
		variableDefinitions_AST = (AST)currentAST.root;
		returnAST = variableDefinitions_AST;
	}
	
	public final void modifier() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST modifier_AST = null;
		
		switch ( LA(1)) {
		case LITERAL_private:
		{
			AST tmp28_AST = null;
			tmp28_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp28_AST);
			match(LITERAL_private);
			modifier_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_public:
		{
			AST tmp29_AST = null;
			tmp29_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp29_AST);
			match(LITERAL_public);
			modifier_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_protected:
		{
			AST tmp30_AST = null;
			tmp30_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp30_AST);
			match(LITERAL_protected);
			modifier_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_static:
		{
			AST tmp31_AST = null;
			tmp31_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp31_AST);
			match(LITERAL_static);
			modifier_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_transient:
		{
			AST tmp32_AST = null;
			tmp32_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp32_AST);
			match(LITERAL_transient);
			modifier_AST = (AST)currentAST.root;
			break;
		}
		case FINAL:
		{
			AST tmp33_AST = null;
			tmp33_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp33_AST);
			match(FINAL);
			modifier_AST = (AST)currentAST.root;
			break;
		}
		case ABSTRACT:
		{
			AST tmp34_AST = null;
			tmp34_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp34_AST);
			match(ABSTRACT);
			modifier_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_native:
		{
			AST tmp35_AST = null;
			tmp35_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp35_AST);
			match(LITERAL_native);
			modifier_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_synchronized:
		{
			AST tmp36_AST = null;
			tmp36_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp36_AST);
			match(LITERAL_synchronized);
			modifier_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_volatile:
		{
			AST tmp37_AST = null;
			tmp37_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp37_AST);
			match(LITERAL_volatile);
			modifier_AST = (AST)currentAST.root;
			break;
		}
		case STRICTFP:
		{
			AST tmp38_AST = null;
			tmp38_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp38_AST);
			match(STRICTFP);
			modifier_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_default:
		{
			AST tmp39_AST = null;
			tmp39_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp39_AST);
			match(LITERAL_default);
			modifier_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_non:
		{
			nonSealed();
			astFactory.addASTChild(currentAST, returnAST);
			modifier_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_sealed:
		{
			AST tmp40_AST = null;
			tmp40_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp40_AST);
			match(LITERAL_sealed);
			modifier_AST = (AST)currentAST.root;
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		returnAST = modifier_AST;
	}
	
	public final void annotation() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST annotation_AST = null;
		AST i_AST = null;
		Token  l = null;
		AST l_AST = null;
		AST args_AST = null;
		Token  r = null;
		AST r_AST = null;
		
		AST tmp41_AST = null;
		tmp41_AST = astFactory.create(LT(1));
		match(AT);
		identifier();
		i_AST = (AST)returnAST;
		{
		switch ( LA(1)) {
		case LPAREN:
		{
			l = LT(1);
			l_AST = astFactory.create(l);
			match(LPAREN);
			{
			switch ( LA(1)) {
			case LITERAL_void:
			case LITERAL_boolean:
			case LITERAL_byte:
			case LITERAL_char:
			case LITERAL_short:
			case LITERAL_int:
			case LITERAL_float:
			case LITERAL_long:
			case LITERAL_double:
			case IDENT:
			case LCURLY:
			case LPAREN:
			case LITERAL_this:
			case LITERAL_super:
			case LITERAL_switch:
			case PLUS:
			case MINUS:
			case INC:
			case DEC:
			case BNOT:
			case LNOT:
			case LITERAL_true:
			case LITERAL_false:
			case LITERAL_null:
			case LITERAL_new:
			case NUM_INT:
			case CHAR_LITERAL:
			case STRING_LITERAL:
			case NUM_FLOAT:
			case NUM_LONG:
			case NUM_DOUBLE:
			case AT:
			case LITERAL_record:
			case TEXT_BLOCK_CONTENT:
			case LITERAL_yield:
			case LITERAL_sealed:
			case LITERAL_permits:
			case LITERAL_non:
			{
				annotationArguments();
				args_AST = (AST)returnAST;
				break;
			}
			case RPAREN:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			r = LT(1);
			r_AST = astFactory.create(r);
			match(RPAREN);
			break;
		}
		case FINAL:
		case ABSTRACT:
		case STRICTFP:
		case LITERAL_package:
		case SEMI:
		case LBRACK:
		case LITERAL_void:
		case LITERAL_boolean:
		case LITERAL_byte:
		case LITERAL_char:
		case LITERAL_short:
		case LITERAL_int:
		case LITERAL_float:
		case LITERAL_long:
		case LITERAL_double:
		case IDENT:
		case LITERAL_private:
		case LITERAL_public:
		case LITERAL_protected:
		case LITERAL_static:
		case LITERAL_transient:
		case LITERAL_native:
		case LITERAL_synchronized:
		case LITERAL_volatile:
		case LITERAL_class:
		case LITERAL_interface:
		case RCURLY:
		case COMMA:
		case RPAREN:
		case LITERAL_this:
		case LITERAL_default:
		case QUESTION:
		case LT:
		case ENUM:
		case AT:
		case ELLIPSIS:
		case LITERAL_record:
		case LITERAL_yield:
		case LITERAL_sealed:
		case LITERAL_permits:
		case LITERAL_non:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		if ( inputState.guessing==0 ) {
			annotation_AST = (AST)currentAST.root;
			annotation_AST = (AST)astFactory.make( (new ASTArray(6)).add(astFactory.create(ANNOTATION,"ANNOTATION")).add(tmp41_AST).add(i_AST).add(l_AST).add(args_AST).add(r_AST));
			currentAST.root = annotation_AST;
			currentAST.child = annotation_AST!=null &&annotation_AST.getFirstChild()!=null ?
				annotation_AST.getFirstChild() : annotation_AST;
			currentAST.advanceChildToEnd();
		}
		returnAST = annotation_AST;
	}
	
	public final void nonSealed() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST nonSealed_AST = null;
		Token  ns = null;
		AST ns_AST = null;
		
		ns = LT(1);
		ns_AST = astFactory.create(ns);
		match(LITERAL_non);
		AST tmp42_AST = null;
		tmp42_AST = astFactory.create(LT(1));
		match(MINUS);
		match(LITERAL_sealed);
		if ( inputState.guessing==0 ) {
			ns_AST.setType(LITERAL_non_sealed);ns_AST.setText("non-sealed");
		}
		if ( inputState.guessing==0 ) {
			nonSealed_AST = (AST)currentAST.root;
			nonSealed_AST=(AST)astFactory.make( (new ASTArray(1)).add(ns_AST));
			currentAST.root = nonSealed_AST;
			currentAST.child = nonSealed_AST!=null &&nonSealed_AST.getFirstChild()!=null ?
				nonSealed_AST.getFirstChild() : nonSealed_AST;
			currentAST.advanceChildToEnd();
		}
		returnAST = nonSealed_AST;
	}
	
	public final void annotationArguments() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST annotationArguments_AST = null;
		
		if ((_tokenSet_17.member(LA(1))) && (_tokenSet_18.member(LA(2)))) {
			annotationMemberValueInitializer();
			astFactory.addASTChild(currentAST, returnAST);
			annotationArguments_AST = (AST)currentAST.root;
		}
		else if ((_tokenSet_0.member(LA(1))) && (LA(2)==ASSIGN)) {
			annotationMemberValuePairs();
			astFactory.addASTChild(currentAST, returnAST);
			annotationArguments_AST = (AST)currentAST.root;
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		returnAST = annotationArguments_AST;
	}
	
	public final void annotationMemberValueInitializer() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST annotationMemberValueInitializer_AST = null;
		
		boolean synPredMatched85 = false;
		if (((_tokenSet_19.member(LA(1))) && (_tokenSet_20.member(LA(2))))) {
			int _m85 = mark();
			synPredMatched85 = true;
			inputState.guessing++;
			try {
				{
				annotationExpression();
				}
			}
			catch (RecognitionException pe) {
				synPredMatched85 = false;
			}
			rewind(_m85);
inputState.guessing--;
		}
		if ( synPredMatched85 ) {
			annotationExpression();
			astFactory.addASTChild(currentAST, returnAST);
			annotationMemberValueInitializer_AST = (AST)currentAST.root;
		}
		else if ((LA(1)==AT) && (_tokenSet_0.member(LA(2)))) {
			annotation();
			astFactory.addASTChild(currentAST, returnAST);
			annotationMemberValueInitializer_AST = (AST)currentAST.root;
		}
		else if ((LA(1)==LCURLY)) {
			annotationMemberArrayInitializer();
			astFactory.addASTChild(currentAST, returnAST);
			annotationMemberValueInitializer_AST = (AST)currentAST.root;
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		returnAST = annotationMemberValueInitializer_AST;
	}
	
	public final void annotationMemberValuePairs() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST annotationMemberValuePairs_AST = null;
		
		annotationMemberValuePair();
		astFactory.addASTChild(currentAST, returnAST);
		{
		_loop81:
		do {
			if ((LA(1)==COMMA)) {
				AST tmp44_AST = null;
				tmp44_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp44_AST);
				match(COMMA);
				annotationMemberValuePair();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else {
				break _loop81;
			}
			
		} while (true);
		}
		annotationMemberValuePairs_AST = (AST)currentAST.root;
		returnAST = annotationMemberValuePairs_AST;
	}
	
	public final void annotationMemberValuePair() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST annotationMemberValuePair_AST = null;
		AST i_AST = null;
		Token  a = null;
		AST a_AST = null;
		AST v_AST = null;
		
		id();
		i_AST = (AST)returnAST;
		a = LT(1);
		a_AST = astFactory.create(a);
		match(ASSIGN);
		annotationMemberValueInitializer();
		v_AST = (AST)returnAST;
		if ( inputState.guessing==0 ) {
			annotationMemberValuePair_AST = (AST)currentAST.root;
			annotationMemberValuePair_AST =
			(AST)astFactory.make( (new ASTArray(4)).add(astFactory.create(ANNOTATION_MEMBER_VALUE_PAIR,"ANNOTATION_MEMBER_VALUE_PAIR")).add(i_AST).add(a_AST).add(v_AST));
			currentAST.root = annotationMemberValuePair_AST;
			currentAST.child = annotationMemberValuePair_AST!=null &&annotationMemberValuePair_AST.getFirstChild()!=null ?
				annotationMemberValuePair_AST.getFirstChild() : annotationMemberValuePair_AST;
			currentAST.advanceChildToEnd();
		}
		returnAST = annotationMemberValuePair_AST;
	}
	
	public final void annotationExpression() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST annotationExpression_AST = null;
		
		conditionalExpression();
		astFactory.addASTChild(currentAST, returnAST);
		if ( inputState.guessing==0 ) {
			annotationExpression_AST = (AST)currentAST.root;
			annotationExpression_AST = (AST)astFactory.make( (new ASTArray(2)).add(astFactory.create(EXPR,"EXPR")).add(annotationExpression_AST));
			currentAST.root = annotationExpression_AST;
			currentAST.child = annotationExpression_AST!=null &&annotationExpression_AST.getFirstChild()!=null ?
				annotationExpression_AST.getFirstChild() : annotationExpression_AST;
			currentAST.advanceChildToEnd();
		}
		annotationExpression_AST = (AST)currentAST.root;
		returnAST = annotationExpression_AST;
	}
	
	public final void annotationMemberArrayInitializer() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST annotationMemberArrayInitializer_AST = null;
		Token  lc = null;
		AST lc_AST = null;
		
		lc = LT(1);
		lc_AST = astFactory.create(lc);
		astFactory.makeASTRoot(currentAST, lc_AST);
		match(LCURLY);
		if ( inputState.guessing==0 ) {
			lc_AST.setType(ANNOTATION_ARRAY_INIT);
		}
		{
		switch ( LA(1)) {
		case LITERAL_void:
		case LITERAL_boolean:
		case LITERAL_byte:
		case LITERAL_char:
		case LITERAL_short:
		case LITERAL_int:
		case LITERAL_float:
		case LITERAL_long:
		case LITERAL_double:
		case IDENT:
		case LPAREN:
		case LITERAL_this:
		case LITERAL_super:
		case LITERAL_switch:
		case PLUS:
		case MINUS:
		case INC:
		case DEC:
		case BNOT:
		case LNOT:
		case LITERAL_true:
		case LITERAL_false:
		case LITERAL_null:
		case LITERAL_new:
		case NUM_INT:
		case CHAR_LITERAL:
		case STRING_LITERAL:
		case NUM_FLOAT:
		case NUM_LONG:
		case NUM_DOUBLE:
		case AT:
		case LITERAL_record:
		case TEXT_BLOCK_CONTENT:
		case LITERAL_yield:
		case LITERAL_sealed:
		case LITERAL_permits:
		case LITERAL_non:
		{
			annotationMemberArrayValueInitializer();
			astFactory.addASTChild(currentAST, returnAST);
			{
			_loop89:
			do {
				if ((LA(1)==COMMA) && (_tokenSet_19.member(LA(2)))) {
					AST tmp45_AST = null;
					tmp45_AST = astFactory.create(LT(1));
					astFactory.addASTChild(currentAST, tmp45_AST);
					match(COMMA);
					annotationMemberArrayValueInitializer();
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					break _loop89;
				}
				
			} while (true);
			}
			{
			switch ( LA(1)) {
			case COMMA:
			{
				AST tmp46_AST = null;
				tmp46_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp46_AST);
				match(COMMA);
				break;
			}
			case RCURLY:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			break;
		}
		case RCURLY:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		AST tmp47_AST = null;
		tmp47_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp47_AST);
		match(RCURLY);
		annotationMemberArrayInitializer_AST = (AST)currentAST.root;
		returnAST = annotationMemberArrayInitializer_AST;
	}
	
	public final void annotationMemberArrayValueInitializer() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST annotationMemberArrayValueInitializer_AST = null;
		
		boolean synPredMatched93 = false;
		if (((_tokenSet_19.member(LA(1))) && (_tokenSet_21.member(LA(2))))) {
			int _m93 = mark();
			synPredMatched93 = true;
			inputState.guessing++;
			try {
				{
				annotationExpression();
				}
			}
			catch (RecognitionException pe) {
				synPredMatched93 = false;
			}
			rewind(_m93);
inputState.guessing--;
		}
		if ( synPredMatched93 ) {
			annotationExpression();
			astFactory.addASTChild(currentAST, returnAST);
			annotationMemberArrayValueInitializer_AST = (AST)currentAST.root;
		}
		else if ((LA(1)==AT) && (_tokenSet_0.member(LA(2)))) {
			annotation();
			astFactory.addASTChild(currentAST, returnAST);
			annotationMemberArrayValueInitializer_AST = (AST)currentAST.root;
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		returnAST = annotationMemberArrayValueInitializer_AST;
	}
	
	public final void conditionalExpression() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST conditionalExpression_AST = null;
		
		logicalOrExpression();
		astFactory.addASTChild(currentAST, returnAST);
		{
		switch ( LA(1)) {
		case QUESTION:
		{
			AST tmp48_AST = null;
			tmp48_AST = astFactory.create(LT(1));
			astFactory.makeASTRoot(currentAST, tmp48_AST);
			match(QUESTION);
			{
			boolean synPredMatched353 = false;
			if (((_tokenSet_22.member(LA(1))) && (_tokenSet_23.member(LA(2))))) {
				int _m353 = mark();
				synPredMatched353 = true;
				inputState.guessing++;
				try {
					{
					lambdaExpression();
					}
				}
				catch (RecognitionException pe) {
					synPredMatched353 = false;
				}
				rewind(_m353);
inputState.guessing--;
			}
			if ( synPredMatched353 ) {
				lambdaExpression();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else if ((_tokenSet_19.member(LA(1))) && (_tokenSet_24.member(LA(2)))) {
				assignmentExpression();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else {
				throw new NoViableAltException(LT(1), getFilename());
			}
			
			}
			AST tmp49_AST = null;
			tmp49_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp49_AST);
			match(COLON);
			{
			boolean synPredMatched356 = false;
			if (((_tokenSet_22.member(LA(1))) && (_tokenSet_23.member(LA(2))))) {
				int _m356 = mark();
				synPredMatched356 = true;
				inputState.guessing++;
				try {
					{
					lambdaExpression();
					}
				}
				catch (RecognitionException pe) {
					synPredMatched356 = false;
				}
				rewind(_m356);
inputState.guessing--;
			}
			if ( synPredMatched356 ) {
				lambdaExpression();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else if ((_tokenSet_19.member(LA(1))) && (_tokenSet_25.member(LA(2)))) {
				conditionalExpression();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else {
				throw new NoViableAltException(LT(1), getFilename());
			}
			
			}
			break;
		}
		case FINAL:
		case ABSTRACT:
		case STRICTFP:
		case SEMI:
		case RBRACK:
		case LITERAL_void:
		case LITERAL_boolean:
		case LITERAL_byte:
		case LITERAL_char:
		case LITERAL_short:
		case LITERAL_int:
		case LITERAL_float:
		case LITERAL_long:
		case LITERAL_double:
		case IDENT:
		case STAR:
		case LITERAL_private:
		case LITERAL_public:
		case LITERAL_protected:
		case LITERAL_static:
		case LITERAL_transient:
		case LITERAL_native:
		case LITERAL_synchronized:
		case LITERAL_volatile:
		case LITERAL_class:
		case LITERAL_interface:
		case LCURLY:
		case RCURLY:
		case COMMA:
		case LPAREN:
		case RPAREN:
		case LITERAL_this:
		case LITERAL_super:
		case ASSIGN:
		case COLON:
		case LITERAL_if:
		case LITERAL_while:
		case LITERAL_do:
		case LITERAL_break:
		case LITERAL_continue:
		case LITERAL_return:
		case LITERAL_switch:
		case LITERAL_throw:
		case LITERAL_for:
		case LITERAL_else:
		case LITERAL_case:
		case LITERAL_default:
		case LITERAL_try:
		case PLUS_ASSIGN:
		case MINUS_ASSIGN:
		case STAR_ASSIGN:
		case DIV_ASSIGN:
		case MOD_ASSIGN:
		case SR_ASSIGN:
		case BSR_ASSIGN:
		case SL_ASSIGN:
		case BAND_ASSIGN:
		case BXOR_ASSIGN:
		case BOR_ASSIGN:
		case LT:
		case GT:
		case LE:
		case GE:
		case LITERAL_instanceof:
		case SL:
		case SR:
		case BSR:
		case PLUS:
		case MINUS:
		case DIV:
		case MOD:
		case INC:
		case DEC:
		case BNOT:
		case LNOT:
		case LITERAL_true:
		case LITERAL_false:
		case LITERAL_null:
		case LITERAL_new:
		case NUM_INT:
		case CHAR_LITERAL:
		case STRING_LITERAL:
		case NUM_FLOAT:
		case NUM_LONG:
		case NUM_DOUBLE:
		case ASSERT:
		case ENUM:
		case AT:
		case LAMBDA:
		case LITERAL_record:
		case TEXT_BLOCK_CONTENT:
		case LITERAL_yield:
		case LITERAL_sealed:
		case LITERAL_permits:
		case LITERAL_non:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		conditionalExpression_AST = (AST)currentAST.root;
		returnAST = conditionalExpression_AST;
	}
	
	public final void typeParameters() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST typeParameters_AST = null;
		Token  lt = null;
		AST lt_AST = null;
		int currentLtLevel = 0;
		
		if ( inputState.guessing==0 ) {
			currentLtLevel = ltCounter;
		}
		lt = LT(1);
		lt_AST = astFactory.create(lt);
		astFactory.addASTChild(currentAST, lt_AST);
		match(LT);
		if ( inputState.guessing==0 ) {
			lt_AST.setType(GENERIC_START); ltCounter++;
		}
		typeParameter();
		astFactory.addASTChild(currentAST, returnAST);
		{
		_loop125:
		do {
			if ((LA(1)==COMMA)) {
				AST tmp50_AST = null;
				tmp50_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp50_AST);
				match(COMMA);
				typeParameter();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else {
				break _loop125;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case GT:
		case SR:
		case BSR:
		{
			typeArgumentsOrParametersEnd();
			astFactory.addASTChild(currentAST, returnAST);
			break;
		}
		case LITERAL_void:
		case LITERAL_boolean:
		case LITERAL_byte:
		case LITERAL_char:
		case LITERAL_short:
		case LITERAL_int:
		case LITERAL_float:
		case LITERAL_long:
		case LITERAL_double:
		case IDENT:
		case LITERAL_extends:
		case LCURLY:
		case LITERAL_implements:
		case LPAREN:
		case AT:
		case LITERAL_record:
		case LITERAL_yield:
		case LITERAL_sealed:
		case LITERAL_permits:
		case LITERAL_non:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		if ( inputState.guessing==0 ) {
			
			if (isThereASingleGtToEmit()) {
			astFactory.addASTChild(currentAST, emitSingleGt());
			}
			
		}
		if (!(areLtsAndGtsBalanced(currentLtLevel)))
		  throw new SemanticException("areLtsAndGtsBalanced(currentLtLevel)");
		if ( inputState.guessing==0 ) {
			typeParameters_AST = (AST)currentAST.root;
			typeParameters_AST = (AST)astFactory.make( (new ASTArray(2)).add(astFactory.create(TYPE_PARAMETERS,"TYPE_PARAMETERS")).add(typeParameters_AST));
			currentAST.root = typeParameters_AST;
			currentAST.child = typeParameters_AST!=null &&typeParameters_AST.getFirstChild()!=null ?
				typeParameters_AST.getFirstChild() : typeParameters_AST;
			currentAST.advanceChildToEnd();
		}
		typeParameters_AST = (AST)currentAST.root;
		returnAST = typeParameters_AST;
	}
	
	public final void recordComponentsList() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST recordComponentsList_AST = null;
		
		AST tmp51_AST = null;
		tmp51_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp51_AST);
		match(LPAREN);
		recordComponents();
		astFactory.addASTChild(currentAST, returnAST);
		AST tmp52_AST = null;
		tmp52_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp52_AST);
		match(RPAREN);
		recordComponentsList_AST = (AST)currentAST.root;
		returnAST = recordComponentsList_AST;
	}
	
	public final void implementsClause() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST implementsClause_AST = null;
		Token  i = null;
		AST i_AST = null;
		
		{
		switch ( LA(1)) {
		case LITERAL_implements:
		{
			i = LT(1);
			i_AST = astFactory.create(i);
			astFactory.makeASTRoot(currentAST, i_AST);
			match(LITERAL_implements);
			if ( inputState.guessing==0 ) {
				i_AST.setType(IMPLEMENTS_CLAUSE);
			}
			classOrInterfaceType(false);
			astFactory.addASTChild(currentAST, returnAST);
			{
			_loop172:
			do {
				if ((LA(1)==COMMA)) {
					AST tmp53_AST = null;
					tmp53_AST = astFactory.create(LT(1));
					astFactory.addASTChild(currentAST, tmp53_AST);
					match(COMMA);
					classOrInterfaceType(false);
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					break _loop172;
				}
				
			} while (true);
			}
			break;
		}
		case LCURLY:
		case LITERAL_permits:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		implementsClause_AST = (AST)currentAST.root;
		returnAST = implementsClause_AST;
	}
	
	public final void recordBodyDeclaration() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST recordBodyDeclaration_AST = null;
		
		AST tmp54_AST = null;
		tmp54_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp54_AST);
		match(LCURLY);
		{
		_loop113:
		do {
			boolean synPredMatched112 = false;
			if (((_tokenSet_26.member(LA(1))) && (_tokenSet_27.member(LA(2))))) {
				int _m112 = mark();
				synPredMatched112 = true;
				inputState.guessing++;
				try {
					{
					compactConstructorDeclaration();
					}
				}
				catch (RecognitionException pe) {
					synPredMatched112 = false;
				}
				rewind(_m112);
inputState.guessing--;
			}
			if ( synPredMatched112 ) {
				compactConstructorDeclaration();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else if ((_tokenSet_28.member(LA(1))) && (_tokenSet_29.member(LA(2)))) {
				field();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else if ((LA(1)==SEMI)) {
				AST tmp55_AST = null;
				tmp55_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp55_AST);
				match(SEMI);
			}
			else {
				break _loop113;
			}
			
		} while (true);
		}
		AST tmp56_AST = null;
		tmp56_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp56_AST);
		match(RCURLY);
		if ( inputState.guessing==0 ) {
			recordBodyDeclaration_AST = (AST)currentAST.root;
			recordBodyDeclaration_AST = (AST)astFactory.make( (new ASTArray(2)).add(astFactory.create(OBJBLOCK,"OBJBLOCK")).add(recordBodyDeclaration_AST));
			currentAST.root = recordBodyDeclaration_AST;
			currentAST.child = recordBodyDeclaration_AST!=null &&recordBodyDeclaration_AST.getFirstChild()!=null ?
				recordBodyDeclaration_AST.getFirstChild() : recordBodyDeclaration_AST;
			currentAST.advanceChildToEnd();
		}
		recordBodyDeclaration_AST = (AST)currentAST.root;
		returnAST = recordBodyDeclaration_AST;
	}
	
	public final void recordComponents() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST recordComponents_AST = null;
		
		{
		boolean synPredMatched101 = false;
		if (((_tokenSet_15.member(LA(1))) && (_tokenSet_30.member(LA(2))))) {
			int _m101 = mark();
			synPredMatched101 = true;
			inputState.guessing++;
			try {
				{
				recordComponent();
				}
			}
			catch (RecognitionException pe) {
				synPredMatched101 = false;
			}
			rewind(_m101);
inputState.guessing--;
		}
		if ( synPredMatched101 ) {
			recordComponent();
			astFactory.addASTChild(currentAST, returnAST);
			{
			_loop105:
			do {
				boolean synPredMatched104 = false;
				if (((LA(1)==COMMA) && (_tokenSet_15.member(LA(2))))) {
					int _m104 = mark();
					synPredMatched104 = true;
					inputState.guessing++;
					try {
						{
						match(COMMA);
						recordComponent();
						}
					}
					catch (RecognitionException pe) {
						synPredMatched104 = false;
					}
					rewind(_m104);
inputState.guessing--;
				}
				if ( synPredMatched104 ) {
					AST tmp57_AST = null;
					tmp57_AST = astFactory.create(LT(1));
					astFactory.addASTChild(currentAST, tmp57_AST);
					match(COMMA);
					recordComponent();
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					break _loop105;
				}
				
			} while (true);
			}
			{
			switch ( LA(1)) {
			case COMMA:
			{
				AST tmp58_AST = null;
				tmp58_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp58_AST);
				match(COMMA);
				recordComponentVariableLength();
				astFactory.addASTChild(currentAST, returnAST);
				break;
			}
			case RPAREN:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
		}
		else if ((_tokenSet_15.member(LA(1))) && (_tokenSet_31.member(LA(2)))) {
			recordComponentVariableLength();
			astFactory.addASTChild(currentAST, returnAST);
		}
		else if ((LA(1)==RPAREN)) {
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		if ( inputState.guessing==0 ) {
			recordComponents_AST = (AST)currentAST.root;
			recordComponents_AST = (AST)astFactory.make( (new ASTArray(2)).add(astFactory.create(RECORD_COMPONENTS,"RECORD_COMPONENTS")).add(recordComponents_AST));
			currentAST.root = recordComponents_AST;
			currentAST.child = recordComponents_AST!=null &&recordComponents_AST.getFirstChild()!=null ?
				recordComponents_AST.getFirstChild() : recordComponents_AST;
			currentAST.advanceChildToEnd();
		}
		recordComponents_AST = (AST)currentAST.root;
		returnAST = recordComponents_AST;
	}
	
	public final void recordComponent() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST recordComponent_AST = null;
		AST a_AST = null;
		AST t_AST = null;
		AST i_AST = null;
		AST d_AST = null;
		
		annotations();
		a_AST = (AST)returnAST;
		typeSpec(false);
		t_AST = (AST)returnAST;
		id();
		i_AST = (AST)returnAST;
		declaratorBrackets(t_AST);
		d_AST = (AST)returnAST;
		if ( inputState.guessing==0 ) {
			recordComponent_AST = (AST)currentAST.root;
			recordComponent_AST = (AST)astFactory.make( (new ASTArray(4)).add(astFactory.create(RECORD_COMPONENT_DEF,"RECORD_COMPONENT_DEF")).add(a_AST).add((AST)astFactory.make( (new ASTArray(2)).add(astFactory.create(TYPE,"TYPE")).add(d_AST))).add(i_AST));
			currentAST.root = recordComponent_AST;
			currentAST.child = recordComponent_AST!=null &&recordComponent_AST.getFirstChild()!=null ?
				recordComponent_AST.getFirstChild() : recordComponent_AST;
			currentAST.advanceChildToEnd();
		}
		returnAST = recordComponent_AST;
	}
	
	public final void recordComponentVariableLength() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST recordComponentVariableLength_AST = null;
		AST a_AST = null;
		AST t_AST = null;
		Token  e = null;
		AST e_AST = null;
		AST i_AST = null;
		AST d_AST = null;
		
		annotations();
		a_AST = (AST)returnAST;
		variableLengthParameterTypeSpec();
		t_AST = (AST)returnAST;
		e = LT(1);
		e_AST = astFactory.create(e);
		match(ELLIPSIS);
		id();
		i_AST = (AST)returnAST;
		declaratorBrackets(t_AST);
		d_AST = (AST)returnAST;
		if ( inputState.guessing==0 ) {
			recordComponentVariableLength_AST = (AST)currentAST.root;
			recordComponentVariableLength_AST = (AST)astFactory.make( (new ASTArray(5)).add(astFactory.create(RECORD_COMPONENT_DEF,"RECORD_COMPONENT_DEF")).add(a_AST).add((AST)astFactory.make( (new ASTArray(2)).add(astFactory.create(TYPE,"TYPE")).add(d_AST))).add(e_AST).add(i_AST));
			currentAST.root = recordComponentVariableLength_AST;
			currentAST.child = recordComponentVariableLength_AST!=null &&recordComponentVariableLength_AST.getFirstChild()!=null ?
				recordComponentVariableLength_AST.getFirstChild() : recordComponentVariableLength_AST;
			currentAST.advanceChildToEnd();
		}
		returnAST = recordComponentVariableLength_AST;
	}
	
	public final void declaratorBrackets(
		AST typ
	) throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST declaratorBrackets_AST = null;
		AST an_AST = null;
		Token  lb = null;
		AST lb_AST = null;
		Token  rb = null;
		AST rb_AST = null;
		AST db_AST = null;
		
		if ((LA(1)==LBRACK||LA(1)==AT) && (_tokenSet_8.member(LA(2)))) {
			{
			if (((LA(1)==LBRACK||LA(1)==AT) && (_tokenSet_8.member(LA(2))))&&(LA(1) == AT)) {
				annotations();
				an_AST = (AST)returnAST;
			}
			else if ((LA(1)==LBRACK) && (LA(2)==RBRACK)) {
			}
			else {
				throw new NoViableAltException(LT(1), getFilename());
			}
			
			}
			lb = LT(1);
			lb_AST = astFactory.create(lb);
			match(LBRACK);
			if ( inputState.guessing==0 ) {
				lb_AST.setType(ARRAY_DECLARATOR);
			}
			rb = LT(1);
			rb_AST = astFactory.create(rb);
			match(RBRACK);
			declaratorBrackets((AST)astFactory.make( (new ASTArray(4)).add(lb_AST).add(typ).add(an_AST).add(rb_AST)));
			db_AST = (AST)returnAST;
			if ( inputState.guessing==0 ) {
				declaratorBrackets_AST = (AST)currentAST.root;
				declaratorBrackets_AST = db_AST;
				currentAST.root = declaratorBrackets_AST;
				currentAST.child = declaratorBrackets_AST!=null &&declaratorBrackets_AST.getFirstChild()!=null ?
					declaratorBrackets_AST.getFirstChild() : declaratorBrackets_AST;
				currentAST.advanceChildToEnd();
			}
		}
		else if ((_tokenSet_32.member(LA(1))) && (_tokenSet_33.member(LA(2)))) {
			if ( inputState.guessing==0 ) {
				declaratorBrackets_AST = (AST)currentAST.root;
				declaratorBrackets_AST = typ;
				currentAST.root = declaratorBrackets_AST;
				currentAST.child = declaratorBrackets_AST!=null &&declaratorBrackets_AST.getFirstChild()!=null ?
					declaratorBrackets_AST.getFirstChild() : declaratorBrackets_AST;
				currentAST.advanceChildToEnd();
			}
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		returnAST = declaratorBrackets_AST;
	}
	
	public final void compactConstructorDeclaration() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST compactConstructorDeclaration_AST = null;
		AST m_AST = null;
		AST i_AST = null;
		AST c_AST = null;
		
		modifiers();
		m_AST = (AST)returnAST;
		id();
		i_AST = (AST)returnAST;
		constructorBody();
		c_AST = (AST)returnAST;
		if ( inputState.guessing==0 ) {
			compactConstructorDeclaration_AST = (AST)currentAST.root;
			compactConstructorDeclaration_AST = (AST)astFactory.make( (new ASTArray(4)).add(astFactory.create(COMPACT_CTOR_DEF,"COMPACT_CTOR_DEF")).add(m_AST).add(i_AST).add(c_AST));
			currentAST.root = compactConstructorDeclaration_AST;
			currentAST.child = compactConstructorDeclaration_AST!=null &&compactConstructorDeclaration_AST.getFirstChild()!=null ?
				compactConstructorDeclaration_AST.getFirstChild() : compactConstructorDeclaration_AST;
			currentAST.advanceChildToEnd();
		}
		returnAST = compactConstructorDeclaration_AST;
	}
	
	public final void field() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST field_AST = null;
		AST mods_AST = null;
		AST td_AST = null;
		AST tp_AST = null;
		AST h_AST = null;
		AST s_AST = null;
		AST t_AST = null;
		AST id_AST = null;
		AST param_AST = null;
		AST rt_AST = null;
		AST tc_AST = null;
		AST s2_AST = null;
		Token  s5 = null;
		AST s5_AST = null;
		AST v_AST = null;
		Token  s6 = null;
		AST s6_AST = null;
		Token  si = null;
		AST si_AST = null;
		AST s3_AST = null;
		AST s4_AST = null;
		
		if ((_tokenSet_34.member(LA(1))) && (_tokenSet_35.member(LA(2)))) {
			modifiers();
			mods_AST = (AST)returnAST;
			{
			if ((_tokenSet_36.member(LA(1))) && (_tokenSet_37.member(LA(2)))) {
				typeDefinitionInternal(mods_AST);
				td_AST = (AST)returnAST;
				if ( inputState.guessing==0 ) {
					field_AST = (AST)currentAST.root;
					field_AST = td_AST;
					currentAST.root = field_AST;
					currentAST.child = field_AST!=null &&field_AST.getFirstChild()!=null ?
						field_AST.getFirstChild() : field_AST;
					currentAST.advanceChildToEnd();
				}
			}
			else if ((_tokenSet_38.member(LA(1))) && (_tokenSet_16.member(LA(2)))) {
				{
				switch ( LA(1)) {
				case LT:
				{
					typeParameters();
					tp_AST = (AST)returnAST;
					break;
				}
				case LITERAL_void:
				case LITERAL_boolean:
				case LITERAL_byte:
				case LITERAL_char:
				case LITERAL_short:
				case LITERAL_int:
				case LITERAL_float:
				case LITERAL_long:
				case LITERAL_double:
				case IDENT:
				case AT:
				case LITERAL_record:
				case LITERAL_yield:
				case LITERAL_sealed:
				case LITERAL_permits:
				case LITERAL_non:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
				{
				if ((_tokenSet_0.member(LA(1))) && (LA(2)==LPAREN)) {
					ctorHead();
					h_AST = (AST)returnAST;
					constructorBody();
					s_AST = (AST)returnAST;
					if ( inputState.guessing==0 ) {
						field_AST = (AST)currentAST.root;
						field_AST = (AST)astFactory.make( (new ASTArray(5)).add(astFactory.create(CTOR_DEF,"CTOR_DEF")).add(mods_AST).add(tp_AST).add(h_AST).add(s_AST));
						currentAST.root = field_AST;
						currentAST.child = field_AST!=null &&field_AST.getFirstChild()!=null ?
							field_AST.getFirstChild() : field_AST;
						currentAST.advanceChildToEnd();
					}
				}
				else if ((_tokenSet_15.member(LA(1))) && (_tokenSet_30.member(LA(2)))) {
					typeSpec(false);
					t_AST = (AST)returnAST;
					{
					if ((_tokenSet_0.member(LA(1))) && (LA(2)==LPAREN)) {
						id();
						id_AST = (AST)returnAST;
						AST tmp59_AST = null;
						tmp59_AST = astFactory.create(LT(1));
						match(LPAREN);
						parameterDeclarationList();
						param_AST = (AST)returnAST;
						AST tmp60_AST = null;
						tmp60_AST = astFactory.create(LT(1));
						match(RPAREN);
						declaratorBrackets(t_AST);
						rt_AST = (AST)returnAST;
						{
						switch ( LA(1)) {
						case LITERAL_throws:
						{
							throwsClause();
							tc_AST = (AST)returnAST;
							break;
						}
						case SEMI:
						case LCURLY:
						{
							break;
						}
						default:
						{
							throw new NoViableAltException(LT(1), getFilename());
						}
						}
						}
						{
						switch ( LA(1)) {
						case LCURLY:
						{
							compoundStatement();
							s2_AST = (AST)returnAST;
							break;
						}
						case SEMI:
						{
							s5 = LT(1);
							s5_AST = astFactory.create(s5);
							match(SEMI);
							break;
						}
						default:
						{
							throw new NoViableAltException(LT(1), getFilename());
						}
						}
						}
						if ( inputState.guessing==0 ) {
							field_AST = (AST)currentAST.root;
							field_AST = (AST)astFactory.make( (new ASTArray(11)).add(astFactory.create(METHOD_DEF,"METHOD_DEF")).add(mods_AST).add(tp_AST).add((AST)astFactory.make( (new ASTArray(2)).add(astFactory.create(TYPE,"TYPE")).add(rt_AST))).add(id_AST).add(tmp59_AST).add(param_AST).add(tmp60_AST).add(tc_AST).add(s2_AST).add(s5_AST));
							currentAST.root = field_AST;
							currentAST.child = field_AST!=null &&field_AST.getFirstChild()!=null ?
								field_AST.getFirstChild() : field_AST;
							currentAST.advanceChildToEnd();
						}
					}
					else if ((_tokenSet_0.member(LA(1))) && (_tokenSet_39.member(LA(2)))) {
						variableDefinitions(mods_AST,t_AST);
						v_AST = (AST)returnAST;
						{
						if ((LA(1)==SEMI) && (_tokenSet_40.member(LA(2)))) {
							s6 = LT(1);
							s6_AST = astFactory.create(s6);
							match(SEMI);
						}
						else if ((_tokenSet_40.member(LA(1))) && (_tokenSet_41.member(LA(2)))) {
						}
						else {
							throw new NoViableAltException(LT(1), getFilename());
						}
						
						}
						if ( inputState.guessing==0 ) {
							field_AST = (AST)currentAST.root;
							
							field_AST = v_AST;
							v_AST.addChild(s6_AST);
							
							currentAST.root = field_AST;
							currentAST.child = field_AST!=null &&field_AST.getFirstChild()!=null ?
								field_AST.getFirstChild() : field_AST;
							currentAST.advanceChildToEnd();
						}
					}
					else {
						throw new NoViableAltException(LT(1), getFilename());
					}
					
					}
				}
				else {
					throw new NoViableAltException(LT(1), getFilename());
				}
				
				}
			}
			else {
				throw new NoViableAltException(LT(1), getFilename());
			}
			
			}
		}
		else if ((LA(1)==LITERAL_static) && (LA(2)==LCURLY)) {
			si = LT(1);
			si_AST = astFactory.create(si);
			match(LITERAL_static);
			compoundStatement();
			s3_AST = (AST)returnAST;
			if ( inputState.guessing==0 ) {
				field_AST = (AST)currentAST.root;
				si_AST.setType(STATIC_INIT);
				si_AST.setText("STATIC_INIT");
				field_AST = (AST)astFactory.make( (new ASTArray(2)).add(si_AST).add(s3_AST));
				currentAST.root = field_AST;
				currentAST.child = field_AST!=null &&field_AST.getFirstChild()!=null ?
					field_AST.getFirstChild() : field_AST;
				currentAST.advanceChildToEnd();
			}
		}
		else if ((LA(1)==LCURLY)) {
			compoundStatement();
			s4_AST = (AST)returnAST;
			if ( inputState.guessing==0 ) {
				field_AST = (AST)currentAST.root;
				field_AST = (AST)astFactory.make( (new ASTArray(2)).add(astFactory.create(INSTANCE_INIT,"INSTANCE_INIT")).add(s4_AST));
				currentAST.root = field_AST;
				currentAST.child = field_AST!=null &&field_AST.getFirstChild()!=null ?
					field_AST.getFirstChild() : field_AST;
				currentAST.advanceChildToEnd();
			}
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		returnAST = field_AST;
	}
	
	public final void constructorBody() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST constructorBody_AST = null;
		Token  lc = null;
		AST lc_AST = null;
		
		lc = LT(1);
		lc_AST = astFactory.create(lc);
		astFactory.makeASTRoot(currentAST, lc_AST);
		match(LCURLY);
		if ( inputState.guessing==0 ) {
			lc_AST.setType(SLIST);
		}
		{
		boolean synPredMatched184 = false;
		if (((_tokenSet_42.member(LA(1))) && (_tokenSet_43.member(LA(2))))) {
			int _m184 = mark();
			synPredMatched184 = true;
			inputState.guessing++;
			try {
				{
				explicitConstructorInvocation();
				}
			}
			catch (RecognitionException pe) {
				synPredMatched184 = false;
			}
			rewind(_m184);
inputState.guessing--;
		}
		if ( synPredMatched184 ) {
			explicitConstructorInvocation();
			astFactory.addASTChild(currentAST, returnAST);
		}
		else if ((_tokenSet_44.member(LA(1))) && (_tokenSet_45.member(LA(2)))) {
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		{
		_loop186:
		do {
			if ((_tokenSet_46.member(LA(1)))) {
				statement();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else {
				break _loop186;
			}
			
		} while (true);
		}
		AST tmp61_AST = null;
		tmp61_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp61_AST);
		match(RCURLY);
		constructorBody_AST = (AST)currentAST.root;
		returnAST = constructorBody_AST;
	}
	
	public final void superClassClause() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST superClassClause_AST = null;
		Token  e = null;
		AST e_AST = null;
		AST c_AST = null;
		
		{
		switch ( LA(1)) {
		case LITERAL_extends:
		{
			e = LT(1);
			e_AST = astFactory.create(e);
			astFactory.makeASTRoot(currentAST, e_AST);
			match(LITERAL_extends);
			if ( inputState.guessing==0 ) {
				e_AST.setType(EXTENDS_CLAUSE);
			}
			classOrInterfaceType(false);
			c_AST = (AST)returnAST;
			astFactory.addASTChild(currentAST, returnAST);
			break;
		}
		case LCURLY:
		case LITERAL_implements:
		case LITERAL_permits:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		superClassClause_AST = (AST)currentAST.root;
		returnAST = superClassClause_AST;
	}
	
	public final void permittedSubclassesAndInterfaces() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST permittedSubclassesAndInterfaces_AST = null;
		Token  p = null;
		AST p_AST = null;
		
		{
		switch ( LA(1)) {
		case LITERAL_permits:
		{
			p = LT(1);
			p_AST = astFactory.create(p);
			astFactory.makeASTRoot(currentAST, p_AST);
			match(LITERAL_permits);
			if ( inputState.guessing==0 ) {
				p_AST.setType(PERMITS_CLAUSE);
			}
			classOrInterfaceType(false);
			astFactory.addASTChild(currentAST, returnAST);
			{
			_loop458:
			do {
				if ((LA(1)==COMMA)) {
					AST tmp62_AST = null;
					tmp62_AST = astFactory.create(LT(1));
					astFactory.addASTChild(currentAST, tmp62_AST);
					match(COMMA);
					classOrInterfaceType(false);
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					break _loop458;
				}
				
			} while (true);
			}
			break;
		}
		case LCURLY:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		permittedSubclassesAndInterfaces_AST = (AST)currentAST.root;
		returnAST = permittedSubclassesAndInterfaces_AST;
	}
	
	public final void classBlock() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST classBlock_AST = null;
		
		AST tmp63_AST = null;
		tmp63_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp63_AST);
		match(LCURLY);
		{
		_loop164:
		do {
			switch ( LA(1)) {
			case FINAL:
			case ABSTRACT:
			case STRICTFP:
			case LITERAL_void:
			case LITERAL_boolean:
			case LITERAL_byte:
			case LITERAL_char:
			case LITERAL_short:
			case LITERAL_int:
			case LITERAL_float:
			case LITERAL_long:
			case LITERAL_double:
			case IDENT:
			case LITERAL_private:
			case LITERAL_public:
			case LITERAL_protected:
			case LITERAL_static:
			case LITERAL_transient:
			case LITERAL_native:
			case LITERAL_synchronized:
			case LITERAL_volatile:
			case LITERAL_class:
			case LITERAL_interface:
			case LCURLY:
			case LITERAL_default:
			case LT:
			case ENUM:
			case AT:
			case LITERAL_record:
			case LITERAL_yield:
			case LITERAL_sealed:
			case LITERAL_permits:
			case LITERAL_non:
			{
				field();
				astFactory.addASTChild(currentAST, returnAST);
				break;
			}
			case SEMI:
			{
				AST tmp64_AST = null;
				tmp64_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp64_AST);
				match(SEMI);
				break;
			}
			default:
			{
				break _loop164;
			}
			}
		} while (true);
		}
		AST tmp65_AST = null;
		tmp65_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp65_AST);
		match(RCURLY);
		if ( inputState.guessing==0 ) {
			classBlock_AST = (AST)currentAST.root;
			classBlock_AST = (AST)astFactory.make( (new ASTArray(2)).add(astFactory.create(OBJBLOCK,"OBJBLOCK")).add(classBlock_AST));
			currentAST.root = classBlock_AST;
			currentAST.child = classBlock_AST!=null &&classBlock_AST.getFirstChild()!=null ?
				classBlock_AST.getFirstChild() : classBlock_AST;
			currentAST.advanceChildToEnd();
		}
		classBlock_AST = (AST)currentAST.root;
		returnAST = classBlock_AST;
	}
	
	public final void interfaceExtends() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST interfaceExtends_AST = null;
		Token  e = null;
		AST e_AST = null;
		
		{
		switch ( LA(1)) {
		case LITERAL_extends:
		{
			e = LT(1);
			e_AST = astFactory.create(e);
			astFactory.makeASTRoot(currentAST, e_AST);
			match(LITERAL_extends);
			if ( inputState.guessing==0 ) {
				e_AST.setType(EXTENDS_CLAUSE);
			}
			classOrInterfaceType(false);
			astFactory.addASTChild(currentAST, returnAST);
			{
			_loop168:
			do {
				if ((LA(1)==COMMA)) {
					AST tmp66_AST = null;
					tmp66_AST = astFactory.create(LT(1));
					astFactory.addASTChild(currentAST, tmp66_AST);
					match(COMMA);
					classOrInterfaceType(false);
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					break _loop168;
				}
				
			} while (true);
			}
			break;
		}
		case LCURLY:
		case LITERAL_permits:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		interfaceExtends_AST = (AST)currentAST.root;
		returnAST = interfaceExtends_AST;
	}
	
	public final void enumBlock() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST enumBlock_AST = null;
		
		AST tmp67_AST = null;
		tmp67_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp67_AST);
		match(LCURLY);
		{
		switch ( LA(1)) {
		case IDENT:
		case AT:
		case LITERAL_record:
		case LITERAL_yield:
		case LITERAL_sealed:
		case LITERAL_permits:
		case LITERAL_non:
		{
			enumConstant();
			astFactory.addASTChild(currentAST, returnAST);
			{
			_loop145:
			do {
				if ((LA(1)==COMMA) && (_tokenSet_10.member(LA(2)))) {
					AST tmp68_AST = null;
					tmp68_AST = astFactory.create(LT(1));
					astFactory.addASTChild(currentAST, tmp68_AST);
					match(COMMA);
					enumConstant();
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					break _loop145;
				}
				
			} while (true);
			}
			break;
		}
		case SEMI:
		case RCURLY:
		case COMMA:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		switch ( LA(1)) {
		case COMMA:
		{
			AST tmp69_AST = null;
			tmp69_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp69_AST);
			match(COMMA);
			break;
		}
		case SEMI:
		case RCURLY:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		switch ( LA(1)) {
		case SEMI:
		{
			AST tmp70_AST = null;
			tmp70_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp70_AST);
			match(SEMI);
			{
			_loop149:
			do {
				switch ( LA(1)) {
				case FINAL:
				case ABSTRACT:
				case STRICTFP:
				case LITERAL_void:
				case LITERAL_boolean:
				case LITERAL_byte:
				case LITERAL_char:
				case LITERAL_short:
				case LITERAL_int:
				case LITERAL_float:
				case LITERAL_long:
				case LITERAL_double:
				case IDENT:
				case LITERAL_private:
				case LITERAL_public:
				case LITERAL_protected:
				case LITERAL_static:
				case LITERAL_transient:
				case LITERAL_native:
				case LITERAL_synchronized:
				case LITERAL_volatile:
				case LITERAL_class:
				case LITERAL_interface:
				case LCURLY:
				case LITERAL_default:
				case LT:
				case ENUM:
				case AT:
				case LITERAL_record:
				case LITERAL_yield:
				case LITERAL_sealed:
				case LITERAL_permits:
				case LITERAL_non:
				{
					field();
					astFactory.addASTChild(currentAST, returnAST);
					break;
				}
				case SEMI:
				{
					AST tmp71_AST = null;
					tmp71_AST = astFactory.create(LT(1));
					astFactory.addASTChild(currentAST, tmp71_AST);
					match(SEMI);
					break;
				}
				default:
				{
					break _loop149;
				}
				}
			} while (true);
			}
			break;
		}
		case RCURLY:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		AST tmp72_AST = null;
		tmp72_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp72_AST);
		match(RCURLY);
		if ( inputState.guessing==0 ) {
			enumBlock_AST = (AST)currentAST.root;
			enumBlock_AST = (AST)astFactory.make( (new ASTArray(2)).add(astFactory.create(OBJBLOCK,"OBJBLOCK")).add(enumBlock_AST));
			currentAST.root = enumBlock_AST;
			currentAST.child = enumBlock_AST!=null &&enumBlock_AST.getFirstChild()!=null ?
				enumBlock_AST.getFirstChild() : enumBlock_AST;
			currentAST.advanceChildToEnd();
		}
		enumBlock_AST = (AST)currentAST.root;
		returnAST = enumBlock_AST;
	}
	
	public final void annotationBlock() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST annotationBlock_AST = null;
		
		AST tmp73_AST = null;
		tmp73_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp73_AST);
		match(LCURLY);
		{
		_loop136:
		do {
			switch ( LA(1)) {
			case FINAL:
			case ABSTRACT:
			case STRICTFP:
			case LITERAL_void:
			case LITERAL_boolean:
			case LITERAL_byte:
			case LITERAL_char:
			case LITERAL_short:
			case LITERAL_int:
			case LITERAL_float:
			case LITERAL_long:
			case LITERAL_double:
			case IDENT:
			case LITERAL_private:
			case LITERAL_public:
			case LITERAL_protected:
			case LITERAL_static:
			case LITERAL_transient:
			case LITERAL_native:
			case LITERAL_synchronized:
			case LITERAL_volatile:
			case LITERAL_class:
			case LITERAL_interface:
			case LITERAL_default:
			case ENUM:
			case AT:
			case LITERAL_record:
			case LITERAL_yield:
			case LITERAL_sealed:
			case LITERAL_permits:
			case LITERAL_non:
			{
				annotationField();
				astFactory.addASTChild(currentAST, returnAST);
				break;
			}
			case SEMI:
			{
				AST tmp74_AST = null;
				tmp74_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp74_AST);
				match(SEMI);
				break;
			}
			default:
			{
				break _loop136;
			}
			}
		} while (true);
		}
		AST tmp75_AST = null;
		tmp75_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp75_AST);
		match(RCURLY);
		if ( inputState.guessing==0 ) {
			annotationBlock_AST = (AST)currentAST.root;
			annotationBlock_AST = (AST)astFactory.make( (new ASTArray(2)).add(astFactory.create(OBJBLOCK,"OBJBLOCK")).add(annotationBlock_AST));
			currentAST.root = annotationBlock_AST;
			currentAST.child = annotationBlock_AST!=null &&annotationBlock_AST.getFirstChild()!=null ?
				annotationBlock_AST.getFirstChild() : annotationBlock_AST;
			currentAST.advanceChildToEnd();
		}
		annotationBlock_AST = (AST)currentAST.root;
		returnAST = annotationBlock_AST;
	}
	
	public final void typeParameter() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST typeParameter_AST = null;
		AST id_AST = null;
		
		{
		if (((_tokenSet_10.member(LA(1))) && (_tokenSet_47.member(LA(2))))&&(LA(1) == AT)) {
			annotations();
			astFactory.addASTChild(currentAST, returnAST);
		}
		else if ((_tokenSet_0.member(LA(1))) && (_tokenSet_47.member(LA(2)))) {
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		{
		id();
		id_AST = (AST)returnAST;
		astFactory.addASTChild(currentAST, returnAST);
		}
		{
		if ((LA(1)==LITERAL_extends) && (_tokenSet_10.member(LA(2)))) {
			typeParameterBounds();
			astFactory.addASTChild(currentAST, returnAST);
		}
		else if ((_tokenSet_47.member(LA(1))) && (_tokenSet_48.member(LA(2)))) {
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		if ( inputState.guessing==0 ) {
			typeParameter_AST = (AST)currentAST.root;
			typeParameter_AST = (AST)astFactory.make( (new ASTArray(2)).add(astFactory.create(TYPE_PARAMETER,"TYPE_PARAMETER")).add(typeParameter_AST));
			currentAST.root = typeParameter_AST;
			currentAST.child = typeParameter_AST!=null &&typeParameter_AST.getFirstChild()!=null ?
				typeParameter_AST.getFirstChild() : typeParameter_AST;
			currentAST.advanceChildToEnd();
		}
		typeParameter_AST = (AST)currentAST.root;
		returnAST = typeParameter_AST;
	}
	
	public final void typeParameterBounds() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST typeParameterBounds_AST = null;
		Token  e = null;
		AST e_AST = null;
		Token  b = null;
		AST b_AST = null;
		
		e = LT(1);
		e_AST = astFactory.create(e);
		astFactory.makeASTRoot(currentAST, e_AST);
		match(LITERAL_extends);
		classOrInterfaceType(true);
		astFactory.addASTChild(currentAST, returnAST);
		{
		_loop133:
		do {
			if ((LA(1)==BAND)) {
				b = LT(1);
				b_AST = astFactory.create(b);
				astFactory.addASTChild(currentAST, b_AST);
				match(BAND);
				if ( inputState.guessing==0 ) {
					b_AST.setType(TYPE_EXTENSION_AND);
				}
				classOrInterfaceType(true);
				astFactory.addASTChild(currentAST, returnAST);
			}
			else {
				break _loop133;
			}
			
		} while (true);
		}
		if ( inputState.guessing==0 ) {
			e_AST.setType(TYPE_UPPER_BOUNDS);
		}
		typeParameterBounds_AST = (AST)currentAST.root;
		returnAST = typeParameterBounds_AST;
	}
	
	public final void annotationField() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST annotationField_AST = null;
		AST mods_AST = null;
		AST td_AST = null;
		AST t_AST = null;
		AST i_AST = null;
		AST rt_AST = null;
		AST d_AST = null;
		Token  s = null;
		AST s_AST = null;
		AST v_AST = null;
		Token  s6 = null;
		AST s6_AST = null;
		
		modifiers();
		mods_AST = (AST)returnAST;
		{
		if ((_tokenSet_36.member(LA(1))) && (_tokenSet_37.member(LA(2)))) {
			typeDefinitionInternal(mods_AST);
			td_AST = (AST)returnAST;
			if ( inputState.guessing==0 ) {
				annotationField_AST = (AST)currentAST.root;
				annotationField_AST = td_AST;
				currentAST.root = annotationField_AST;
				currentAST.child = annotationField_AST!=null &&annotationField_AST.getFirstChild()!=null ?
					annotationField_AST.getFirstChild() : annotationField_AST;
				currentAST.advanceChildToEnd();
			}
		}
		else if ((_tokenSet_15.member(LA(1))) && (_tokenSet_30.member(LA(2)))) {
			typeSpec(false);
			t_AST = (AST)returnAST;
			{
			if ((_tokenSet_0.member(LA(1))) && (LA(2)==LPAREN)) {
				id();
				i_AST = (AST)returnAST;
				AST tmp76_AST = null;
				tmp76_AST = astFactory.create(LT(1));
				match(LPAREN);
				AST tmp77_AST = null;
				tmp77_AST = astFactory.create(LT(1));
				match(RPAREN);
				declaratorBrackets(t_AST);
				rt_AST = (AST)returnAST;
				{
				switch ( LA(1)) {
				case LITERAL_default:
				{
					annotationDefault();
					d_AST = (AST)returnAST;
					break;
				}
				case SEMI:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
				s = LT(1);
				s_AST = astFactory.create(s);
				match(SEMI);
				if ( inputState.guessing==0 ) {
					annotationField_AST = (AST)currentAST.root;
					annotationField_AST =
					(AST)astFactory.make( (new ASTArray(8)).add(astFactory.create(ANNOTATION_FIELD_DEF,"ANNOTATION_FIELD_DEF")).add(mods_AST).add((AST)astFactory.make( (new ASTArray(2)).add(astFactory.create(TYPE,"TYPE")).add(rt_AST))).add(i_AST).add(tmp76_AST).add(tmp77_AST).add(d_AST).add(s_AST));
					currentAST.root = annotationField_AST;
					currentAST.child = annotationField_AST!=null &&annotationField_AST.getFirstChild()!=null ?
						annotationField_AST.getFirstChild() : annotationField_AST;
					currentAST.advanceChildToEnd();
				}
			}
			else if ((_tokenSet_0.member(LA(1))) && (_tokenSet_49.member(LA(2)))) {
				variableDefinitions(mods_AST,t_AST);
				v_AST = (AST)returnAST;
				s6 = LT(1);
				s6_AST = astFactory.create(s6);
				match(SEMI);
				if ( inputState.guessing==0 ) {
					annotationField_AST = (AST)currentAST.root;
					
					annotationField_AST = v_AST;
					v_AST.addChild(s6_AST);
					
					currentAST.root = annotationField_AST;
					currentAST.child = annotationField_AST!=null &&annotationField_AST.getFirstChild()!=null ?
						annotationField_AST.getFirstChild() : annotationField_AST;
					currentAST.advanceChildToEnd();
				}
			}
			else {
				throw new NoViableAltException(LT(1), getFilename());
			}
			
			}
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		returnAST = annotationField_AST;
	}
	
	public final void annotationDefault() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST annotationDefault_AST = null;
		
		AST tmp78_AST = null;
		tmp78_AST = astFactory.create(LT(1));
		astFactory.makeASTRoot(currentAST, tmp78_AST);
		match(LITERAL_default);
		annotationMemberValueInitializer();
		astFactory.addASTChild(currentAST, returnAST);
		annotationDefault_AST = (AST)currentAST.root;
		returnAST = annotationDefault_AST;
	}
	
	public final void enumConstant() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST enumConstant_AST = null;
		AST an_AST = null;
		AST i_AST = null;
		Token  l = null;
		AST l_AST = null;
		AST args_AST = null;
		Token  r = null;
		AST r_AST = null;
		AST b_AST = null;
		
		annotations();
		an_AST = (AST)returnAST;
		id();
		i_AST = (AST)returnAST;
		{
		switch ( LA(1)) {
		case LPAREN:
		{
			l = LT(1);
			l_AST = astFactory.create(l);
			match(LPAREN);
			argList();
			args_AST = (AST)returnAST;
			r = LT(1);
			r_AST = astFactory.create(r);
			match(RPAREN);
			break;
		}
		case SEMI:
		case LCURLY:
		case RCURLY:
		case COMMA:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		switch ( LA(1)) {
		case LCURLY:
		{
			enumConstantBlock();
			b_AST = (AST)returnAST;
			break;
		}
		case SEMI:
		case RCURLY:
		case COMMA:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		if ( inputState.guessing==0 ) {
			enumConstant_AST = (AST)currentAST.root;
			enumConstant_AST = (AST)astFactory.make( (new ASTArray(7)).add(astFactory.create(ENUM_CONSTANT_DEF,"ENUM_CONSTANT_DEF")).add(an_AST).add(i_AST).add(l_AST).add(args_AST).add(r_AST).add(b_AST));
			currentAST.root = enumConstant_AST;
			currentAST.child = enumConstant_AST!=null &&enumConstant_AST.getFirstChild()!=null ?
				enumConstant_AST.getFirstChild() : enumConstant_AST;
			currentAST.advanceChildToEnd();
		}
		returnAST = enumConstant_AST;
	}
	
	public final void argList() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST argList_AST = null;
		
		{
		if (((_tokenSet_19.member(LA(1))))&&(LA(1)!=RPAREN)) {
			expressionList();
			astFactory.addASTChild(currentAST, returnAST);
		}
		else if ((LA(1)==RPAREN)) {
			if ( inputState.guessing==0 ) {
				argList_AST = (AST)currentAST.root;
				argList_AST = astFactory.create(ELIST,"ELIST");
				currentAST.root = argList_AST;
				currentAST.child = argList_AST!=null &&argList_AST.getFirstChild()!=null ?
					argList_AST.getFirstChild() : argList_AST;
				currentAST.advanceChildToEnd();
			}
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		argList_AST = (AST)currentAST.root;
		returnAST = argList_AST;
	}
	
	public final void enumConstantBlock() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST enumConstantBlock_AST = null;
		
		AST tmp79_AST = null;
		tmp79_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp79_AST);
		match(LCURLY);
		{
		_loop155:
		do {
			switch ( LA(1)) {
			case FINAL:
			case ABSTRACT:
			case STRICTFP:
			case LITERAL_void:
			case LITERAL_boolean:
			case LITERAL_byte:
			case LITERAL_char:
			case LITERAL_short:
			case LITERAL_int:
			case LITERAL_float:
			case LITERAL_long:
			case LITERAL_double:
			case IDENT:
			case LITERAL_private:
			case LITERAL_public:
			case LITERAL_protected:
			case LITERAL_static:
			case LITERAL_transient:
			case LITERAL_native:
			case LITERAL_synchronized:
			case LITERAL_volatile:
			case LITERAL_class:
			case LITERAL_interface:
			case LCURLY:
			case LITERAL_default:
			case LT:
			case ENUM:
			case AT:
			case LITERAL_record:
			case LITERAL_yield:
			case LITERAL_sealed:
			case LITERAL_permits:
			case LITERAL_non:
			{
				enumConstantField();
				astFactory.addASTChild(currentAST, returnAST);
				break;
			}
			case SEMI:
			{
				AST tmp80_AST = null;
				tmp80_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp80_AST);
				match(SEMI);
				break;
			}
			default:
			{
				break _loop155;
			}
			}
		} while (true);
		}
		AST tmp81_AST = null;
		tmp81_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp81_AST);
		match(RCURLY);
		if ( inputState.guessing==0 ) {
			enumConstantBlock_AST = (AST)currentAST.root;
			enumConstantBlock_AST = (AST)astFactory.make( (new ASTArray(2)).add(astFactory.create(OBJBLOCK,"OBJBLOCK")).add(enumConstantBlock_AST));
			currentAST.root = enumConstantBlock_AST;
			currentAST.child = enumConstantBlock_AST!=null &&enumConstantBlock_AST.getFirstChild()!=null ?
				enumConstantBlock_AST.getFirstChild() : enumConstantBlock_AST;
			currentAST.advanceChildToEnd();
		}
		enumConstantBlock_AST = (AST)currentAST.root;
		returnAST = enumConstantBlock_AST;
	}
	
	public final void enumConstantField() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST enumConstantField_AST = null;
		AST mods_AST = null;
		AST td_AST = null;
		AST tp_AST = null;
		AST t_AST = null;
		AST id_AST = null;
		AST param_AST = null;
		AST rt_AST = null;
		AST tc_AST = null;
		AST s2_AST = null;
		Token  s3 = null;
		AST s3_AST = null;
		AST v_AST = null;
		Token  s6 = null;
		AST s6_AST = null;
		AST s4_AST = null;
		
		switch ( LA(1)) {
		case FINAL:
		case ABSTRACT:
		case STRICTFP:
		case LITERAL_void:
		case LITERAL_boolean:
		case LITERAL_byte:
		case LITERAL_char:
		case LITERAL_short:
		case LITERAL_int:
		case LITERAL_float:
		case LITERAL_long:
		case LITERAL_double:
		case IDENT:
		case LITERAL_private:
		case LITERAL_public:
		case LITERAL_protected:
		case LITERAL_static:
		case LITERAL_transient:
		case LITERAL_native:
		case LITERAL_synchronized:
		case LITERAL_volatile:
		case LITERAL_class:
		case LITERAL_interface:
		case LITERAL_default:
		case LT:
		case ENUM:
		case AT:
		case LITERAL_record:
		case LITERAL_yield:
		case LITERAL_sealed:
		case LITERAL_permits:
		case LITERAL_non:
		{
			modifiers();
			mods_AST = (AST)returnAST;
			{
			if ((_tokenSet_36.member(LA(1))) && (_tokenSet_37.member(LA(2)))) {
				typeDefinitionInternal(mods_AST);
				td_AST = (AST)returnAST;
				if ( inputState.guessing==0 ) {
					enumConstantField_AST = (AST)currentAST.root;
					enumConstantField_AST = td_AST;
					currentAST.root = enumConstantField_AST;
					currentAST.child = enumConstantField_AST!=null &&enumConstantField_AST.getFirstChild()!=null ?
						enumConstantField_AST.getFirstChild() : enumConstantField_AST;
					currentAST.advanceChildToEnd();
				}
			}
			else if ((_tokenSet_38.member(LA(1))) && (_tokenSet_30.member(LA(2)))) {
				{
				switch ( LA(1)) {
				case LT:
				{
					typeParameters();
					tp_AST = (AST)returnAST;
					break;
				}
				case LITERAL_void:
				case LITERAL_boolean:
				case LITERAL_byte:
				case LITERAL_char:
				case LITERAL_short:
				case LITERAL_int:
				case LITERAL_float:
				case LITERAL_long:
				case LITERAL_double:
				case IDENT:
				case AT:
				case LITERAL_record:
				case LITERAL_yield:
				case LITERAL_sealed:
				case LITERAL_permits:
				case LITERAL_non:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
				typeSpec(false);
				t_AST = (AST)returnAST;
				{
				if ((_tokenSet_0.member(LA(1))) && (LA(2)==LPAREN)) {
					id();
					id_AST = (AST)returnAST;
					AST tmp82_AST = null;
					tmp82_AST = astFactory.create(LT(1));
					match(LPAREN);
					parameterDeclarationList();
					param_AST = (AST)returnAST;
					AST tmp83_AST = null;
					tmp83_AST = astFactory.create(LT(1));
					match(RPAREN);
					declaratorBrackets(t_AST);
					rt_AST = (AST)returnAST;
					{
					switch ( LA(1)) {
					case LITERAL_throws:
					{
						throwsClause();
						tc_AST = (AST)returnAST;
						break;
					}
					case SEMI:
					case LCURLY:
					{
						break;
					}
					default:
					{
						throw new NoViableAltException(LT(1), getFilename());
					}
					}
					}
					{
					switch ( LA(1)) {
					case LCURLY:
					{
						compoundStatement();
						s2_AST = (AST)returnAST;
						break;
					}
					case SEMI:
					{
						s3 = LT(1);
						s3_AST = astFactory.create(s3);
						match(SEMI);
						break;
					}
					default:
					{
						throw new NoViableAltException(LT(1), getFilename());
					}
					}
					}
					if ( inputState.guessing==0 ) {
						enumConstantField_AST = (AST)currentAST.root;
						enumConstantField_AST = (AST)astFactory.make( (new ASTArray(11)).add(astFactory.create(METHOD_DEF,"METHOD_DEF")).add(mods_AST).add(tp_AST).add((AST)astFactory.make( (new ASTArray(2)).add(astFactory.create(TYPE,"TYPE")).add(rt_AST))).add(id_AST).add(tmp82_AST).add(param_AST).add(tmp83_AST).add(tc_AST).add(s2_AST).add(s3_AST));
						currentAST.root = enumConstantField_AST;
						currentAST.child = enumConstantField_AST!=null &&enumConstantField_AST.getFirstChild()!=null ?
							enumConstantField_AST.getFirstChild() : enumConstantField_AST;
						currentAST.advanceChildToEnd();
					}
				}
				else if ((_tokenSet_0.member(LA(1))) && (_tokenSet_49.member(LA(2)))) {
					variableDefinitions(mods_AST,t_AST);
					v_AST = (AST)returnAST;
					s6 = LT(1);
					s6_AST = astFactory.create(s6);
					match(SEMI);
					if ( inputState.guessing==0 ) {
						enumConstantField_AST = (AST)currentAST.root;
						
						enumConstantField_AST = v_AST;
						v_AST.addChild(s6_AST);
						
						currentAST.root = enumConstantField_AST;
						currentAST.child = enumConstantField_AST!=null &&enumConstantField_AST.getFirstChild()!=null ?
							enumConstantField_AST.getFirstChild() : enumConstantField_AST;
						currentAST.advanceChildToEnd();
					}
				}
				else {
					throw new NoViableAltException(LT(1), getFilename());
				}
				
				}
			}
			else {
				throw new NoViableAltException(LT(1), getFilename());
			}
			
			}
			break;
		}
		case LCURLY:
		{
			compoundStatement();
			s4_AST = (AST)returnAST;
			if ( inputState.guessing==0 ) {
				enumConstantField_AST = (AST)currentAST.root;
				enumConstantField_AST = (AST)astFactory.make( (new ASTArray(2)).add(astFactory.create(INSTANCE_INIT,"INSTANCE_INIT")).add(s4_AST));
				currentAST.root = enumConstantField_AST;
				currentAST.child = enumConstantField_AST!=null &&enumConstantField_AST.getFirstChild()!=null ?
					enumConstantField_AST.getFirstChild() : enumConstantField_AST;
				currentAST.advanceChildToEnd();
			}
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		returnAST = enumConstantField_AST;
	}
	
	public final void parameterDeclarationList() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST parameterDeclarationList_AST = null;
		
		{
		boolean synPredMatched216 = false;
		if (((_tokenSet_50.member(LA(1))) && (_tokenSet_51.member(LA(2))))) {
			int _m216 = mark();
			synPredMatched216 = true;
			inputState.guessing++;
			try {
				{
				parameterDeclaration();
				}
			}
			catch (RecognitionException pe) {
				synPredMatched216 = false;
			}
			rewind(_m216);
inputState.guessing--;
		}
		if ( synPredMatched216 ) {
			parameterDeclaration();
			astFactory.addASTChild(currentAST, returnAST);
			{
			_loop220:
			do {
				boolean synPredMatched219 = false;
				if (((LA(1)==COMMA) && (_tokenSet_50.member(LA(2))))) {
					int _m219 = mark();
					synPredMatched219 = true;
					inputState.guessing++;
					try {
						{
						match(COMMA);
						parameterDeclaration();
						}
					}
					catch (RecognitionException pe) {
						synPredMatched219 = false;
					}
					rewind(_m219);
inputState.guessing--;
				}
				if ( synPredMatched219 ) {
					AST tmp84_AST = null;
					tmp84_AST = astFactory.create(LT(1));
					astFactory.addASTChild(currentAST, tmp84_AST);
					match(COMMA);
					parameterDeclaration();
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					break _loop220;
				}
				
			} while (true);
			}
			{
			switch ( LA(1)) {
			case COMMA:
			{
				AST tmp85_AST = null;
				tmp85_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp85_AST);
				match(COMMA);
				variableLengthParameterDeclaration();
				astFactory.addASTChild(currentAST, returnAST);
				break;
			}
			case RPAREN:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
		}
		else if ((_tokenSet_52.member(LA(1))) && (_tokenSet_53.member(LA(2)))) {
			variableLengthParameterDeclaration();
			astFactory.addASTChild(currentAST, returnAST);
		}
		else if ((LA(1)==RPAREN)) {
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		if ( inputState.guessing==0 ) {
			parameterDeclarationList_AST = (AST)currentAST.root;
			parameterDeclarationList_AST = (AST)astFactory.make( (new ASTArray(2)).add(astFactory.create(PARAMETERS,"PARAMETERS")).add(parameterDeclarationList_AST));
			currentAST.root = parameterDeclarationList_AST;
			currentAST.child = parameterDeclarationList_AST!=null &&parameterDeclarationList_AST.getFirstChild()!=null ?
				parameterDeclarationList_AST.getFirstChild() : parameterDeclarationList_AST;
			currentAST.advanceChildToEnd();
		}
		parameterDeclarationList_AST = (AST)currentAST.root;
		returnAST = parameterDeclarationList_AST;
	}
	
	public final void throwsClause() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST throwsClause_AST = null;
		
		AST tmp86_AST = null;
		tmp86_AST = astFactory.create(LT(1));
		astFactory.makeASTRoot(currentAST, tmp86_AST);
		match(LITERAL_throws);
		{
		if (((_tokenSet_10.member(LA(1))) && (_tokenSet_54.member(LA(2))))&&(LA(1) == AT)) {
			annotations();
			astFactory.addASTChild(currentAST, returnAST);
		}
		else if ((_tokenSet_0.member(LA(1))) && (_tokenSet_55.member(LA(2)))) {
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		identifier();
		astFactory.addASTChild(currentAST, returnAST);
		{
		_loop212:
		do {
			if ((LA(1)==COMMA)) {
				AST tmp87_AST = null;
				tmp87_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp87_AST);
				match(COMMA);
				{
				if (((_tokenSet_10.member(LA(1))) && (_tokenSet_54.member(LA(2))))&&(LA(1) == AT)) {
					annotations();
					astFactory.addASTChild(currentAST, returnAST);
				}
				else if ((_tokenSet_0.member(LA(1))) && (_tokenSet_55.member(LA(2)))) {
				}
				else {
					throw new NoViableAltException(LT(1), getFilename());
				}
				
				}
				identifier();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else {
				break _loop212;
			}
			
		} while (true);
		}
		throwsClause_AST = (AST)currentAST.root;
		returnAST = throwsClause_AST;
	}
	
	public final void compoundStatement() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST compoundStatement_AST = null;
		Token  lc = null;
		AST lc_AST = null;
		
		lc = LT(1);
		lc_AST = astFactory.create(lc);
		astFactory.makeASTRoot(currentAST, lc_AST);
		match(LCURLY);
		if ( inputState.guessing==0 ) {
			lc_AST.setType(SLIST);
		}
		{
		_loop240:
		do {
			if ((_tokenSet_46.member(LA(1)))) {
				statement();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else {
				break _loop240;
			}
			
		} while (true);
		}
		AST tmp88_AST = null;
		tmp88_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp88_AST);
		match(RCURLY);
		compoundStatement_AST = (AST)currentAST.root;
		returnAST = compoundStatement_AST;
	}
	
	public final void ctorHead() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST ctorHead_AST = null;
		
		id();
		astFactory.addASTChild(currentAST, returnAST);
		AST tmp89_AST = null;
		tmp89_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp89_AST);
		match(LPAREN);
		parameterDeclarationList();
		astFactory.addASTChild(currentAST, returnAST);
		AST tmp90_AST = null;
		tmp90_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp90_AST);
		match(RPAREN);
		{
		switch ( LA(1)) {
		case LITERAL_throws:
		{
			throwsClause();
			astFactory.addASTChild(currentAST, returnAST);
			break;
		}
		case LCURLY:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		ctorHead_AST = (AST)currentAST.root;
		returnAST = ctorHead_AST;
	}
	
	public final void explicitConstructorInvocation() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST explicitConstructorInvocation_AST = null;
		Token  t = null;
		AST t_AST = null;
		Token  s = null;
		AST s_AST = null;
		Token  s1 = null;
		AST s1_AST = null;
		
		{
		if ((_tokenSet_56.member(LA(1))) && (_tokenSet_57.member(LA(2)))) {
			{
			switch ( LA(1)) {
			case LT:
			{
				typeArguments(false);
				astFactory.addASTChild(currentAST, returnAST);
				break;
			}
			case LITERAL_this:
			case LITERAL_super:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			{
			switch ( LA(1)) {
			case LITERAL_this:
			{
				t = LT(1);
				t_AST = astFactory.create(t);
				astFactory.makeASTRoot(currentAST, t_AST);
				match(LITERAL_this);
				AST tmp91_AST = null;
				tmp91_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp91_AST);
				match(LPAREN);
				argList();
				astFactory.addASTChild(currentAST, returnAST);
				AST tmp92_AST = null;
				tmp92_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp92_AST);
				match(RPAREN);
				AST tmp93_AST = null;
				tmp93_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp93_AST);
				match(SEMI);
				if ( inputState.guessing==0 ) {
					t_AST.setType(CTOR_CALL);
				}
				break;
			}
			case LITERAL_super:
			{
				s = LT(1);
				s_AST = astFactory.create(s);
				astFactory.makeASTRoot(currentAST, s_AST);
				match(LITERAL_super);
				AST tmp94_AST = null;
				tmp94_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp94_AST);
				match(LPAREN);
				argList();
				astFactory.addASTChild(currentAST, returnAST);
				AST tmp95_AST = null;
				tmp95_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp95_AST);
				match(RPAREN);
				AST tmp96_AST = null;
				tmp96_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp96_AST);
				match(SEMI);
				if ( inputState.guessing==0 ) {
					s_AST.setType(SUPER_CTOR_CALL);
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
		}
		else if ((_tokenSet_58.member(LA(1))) && (_tokenSet_59.member(LA(2)))) {
			primaryExpression();
			astFactory.addASTChild(currentAST, returnAST);
			AST tmp97_AST = null;
			tmp97_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp97_AST);
			match(DOT);
			{
			switch ( LA(1)) {
			case LT:
			{
				typeArguments(false);
				astFactory.addASTChild(currentAST, returnAST);
				break;
			}
			case LITERAL_super:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			s1 = LT(1);
			s1_AST = astFactory.create(s1);
			astFactory.makeASTRoot(currentAST, s1_AST);
			match(LITERAL_super);
			AST tmp98_AST = null;
			tmp98_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp98_AST);
			match(LPAREN);
			argList();
			astFactory.addASTChild(currentAST, returnAST);
			AST tmp99_AST = null;
			tmp99_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp99_AST);
			match(RPAREN);
			AST tmp100_AST = null;
			tmp100_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp100_AST);
			match(SEMI);
			if ( inputState.guessing==0 ) {
				s1_AST.setType(SUPER_CTOR_CALL);
			}
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		explicitConstructorInvocation_AST = (AST)currentAST.root;
		returnAST = explicitConstructorInvocation_AST;
	}
	
	public final void statement() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST statement_AST = null;
		
		switch ( LA(1)) {
		case FINAL:
		case ABSTRACT:
		case STRICTFP:
		case SEMI:
		case LITERAL_void:
		case LITERAL_boolean:
		case LITERAL_byte:
		case LITERAL_char:
		case LITERAL_short:
		case LITERAL_int:
		case LITERAL_float:
		case LITERAL_long:
		case LITERAL_double:
		case IDENT:
		case LITERAL_private:
		case LITERAL_public:
		case LITERAL_protected:
		case LITERAL_static:
		case LITERAL_transient:
		case LITERAL_native:
		case LITERAL_synchronized:
		case LITERAL_volatile:
		case LITERAL_class:
		case LCURLY:
		case LPAREN:
		case LITERAL_this:
		case LITERAL_super:
		case LITERAL_if:
		case LITERAL_while:
		case LITERAL_do:
		case LITERAL_break:
		case LITERAL_continue:
		case LITERAL_return:
		case LITERAL_switch:
		case LITERAL_throw:
		case LITERAL_for:
		case LITERAL_default:
		case LITERAL_try:
		case PLUS:
		case MINUS:
		case INC:
		case DEC:
		case BNOT:
		case LNOT:
		case LITERAL_true:
		case LITERAL_false:
		case LITERAL_null:
		case LITERAL_new:
		case NUM_INT:
		case CHAR_LITERAL:
		case STRING_LITERAL:
		case NUM_FLOAT:
		case NUM_LONG:
		case NUM_DOUBLE:
		case AT:
		case LITERAL_record:
		case TEXT_BLOCK_CONTENT:
		case LITERAL_yield:
		case LITERAL_sealed:
		case LITERAL_permits:
		case LITERAL_non:
		{
			traditionalStatement();
			astFactory.addASTChild(currentAST, returnAST);
			statement_AST = (AST)currentAST.root;
			break;
		}
		case ASSERT:
		{
			assertStatement();
			astFactory.addASTChild(currentAST, returnAST);
			statement_AST = (AST)currentAST.root;
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		returnAST = statement_AST;
	}
	
	public final void primaryExpression() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST primaryExpression_AST = null;
		Token  lbt = null;
		AST lbt_AST = null;
		
		switch ( LA(1)) {
		case NUM_INT:
		case CHAR_LITERAL:
		case STRING_LITERAL:
		case NUM_FLOAT:
		case NUM_LONG:
		case NUM_DOUBLE:
		case TEXT_BLOCK_CONTENT:
		{
			constant();
			astFactory.addASTChild(currentAST, returnAST);
			primaryExpression_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_true:
		{
			AST tmp101_AST = null;
			tmp101_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp101_AST);
			match(LITERAL_true);
			primaryExpression_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_false:
		{
			AST tmp102_AST = null;
			tmp102_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp102_AST);
			match(LITERAL_false);
			primaryExpression_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_this:
		{
			AST tmp103_AST = null;
			tmp103_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp103_AST);
			match(LITERAL_this);
			primaryExpression_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_null:
		{
			AST tmp104_AST = null;
			tmp104_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp104_AST);
			match(LITERAL_null);
			primaryExpression_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_new:
		{
			newExpression();
			astFactory.addASTChild(currentAST, returnAST);
			primaryExpression_AST = (AST)currentAST.root;
			break;
		}
		case LPAREN:
		{
			AST tmp105_AST = null;
			tmp105_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp105_AST);
			match(LPAREN);
			{
			boolean synPredMatched432 = false;
			if (((_tokenSet_22.member(LA(1))) && (_tokenSet_23.member(LA(2))))) {
				int _m432 = mark();
				synPredMatched432 = true;
				inputState.guessing++;
				try {
					{
					lambdaExpression();
					}
				}
				catch (RecognitionException pe) {
					synPredMatched432 = false;
				}
				rewind(_m432);
inputState.guessing--;
			}
			if ( synPredMatched432 ) {
				lambdaExpression();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else if ((_tokenSet_19.member(LA(1))) && (_tokenSet_60.member(LA(2)))) {
				assignmentExpression();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else {
				throw new NoViableAltException(LT(1), getFilename());
			}
			
			}
			AST tmp106_AST = null;
			tmp106_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp106_AST);
			match(RPAREN);
			primaryExpression_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_super:
		{
			AST tmp107_AST = null;
			tmp107_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp107_AST);
			match(LITERAL_super);
			primaryExpression_AST = (AST)currentAST.root;
			break;
		}
		default:
			boolean synPredMatched429 = false;
			if (((_tokenSet_15.member(LA(1))) && (_tokenSet_61.member(LA(2))))) {
				int _m429 = mark();
				synPredMatched429 = true;
				inputState.guessing++;
				try {
					{
					typeSpec(false);
					match(DOUBLE_COLON);
					}
				}
				catch (RecognitionException pe) {
					synPredMatched429 = false;
				}
				rewind(_m429);
inputState.guessing--;
			}
			if ( synPredMatched429 ) {
				typeSpec(false);
				astFactory.addASTChild(currentAST, returnAST);
				primaryExpression_AST = (AST)currentAST.root;
			}
			else if ((_tokenSet_0.member(LA(1))) && (_tokenSet_61.member(LA(2)))) {
				id();
				astFactory.addASTChild(currentAST, returnAST);
				primaryExpression_AST = (AST)currentAST.root;
			}
			else if (((LA(1) >= LITERAL_void && LA(1) <= LITERAL_double)) && (_tokenSet_61.member(LA(2)))) {
				builtInType();
				astFactory.addASTChild(currentAST, returnAST);
				{
				_loop434:
				do {
					if ((LA(1)==LBRACK) && (LA(2)==RBRACK)) {
						lbt = LT(1);
						lbt_AST = astFactory.create(lbt);
						astFactory.makeASTRoot(currentAST, lbt_AST);
						match(LBRACK);
						if ( inputState.guessing==0 ) {
							lbt_AST.setType(ARRAY_DECLARATOR);
						}
						AST tmp108_AST = null;
						tmp108_AST = astFactory.create(LT(1));
						astFactory.addASTChild(currentAST, tmp108_AST);
						match(RBRACK);
					}
					else {
						break _loop434;
					}
					
				} while (true);
				}
				{
				if ((LA(1)==DOT) && (LA(2)==LITERAL_class)) {
					AST tmp109_AST = null;
					tmp109_AST = astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp109_AST);
					match(DOT);
					AST tmp110_AST = null;
					tmp110_AST = astFactory.create(LT(1));
					astFactory.addASTChild(currentAST, tmp110_AST);
					match(LITERAL_class);
				}
				else if ((_tokenSet_61.member(LA(1))) && (_tokenSet_62.member(LA(2)))) {
				}
				else {
					throw new NoViableAltException(LT(1), getFilename());
				}
				
				}
				primaryExpression_AST = (AST)currentAST.root;
			}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		returnAST = primaryExpression_AST;
	}
	
/** Declaration of a variable.  This can be a class/instance variable,
 *   or a local variable in a method.
    @param mods declaration mods.
    @param t variable declaration type.
    @throws RecognitionException if recognition problem occurs.
    @throws TokenStreamException if problem occurs while generating a stream of tokens.
 * It can also include possible initialization.
 */
	public final void variableDeclarator(
		AST mods, AST t
	) throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST variableDeclarator_AST = null;
		AST id_AST = null;
		AST d_AST = null;
		AST v_AST = null;
		
		id();
		id_AST = (AST)returnAST;
		declaratorBrackets(t);
		d_AST = (AST)returnAST;
		varInitializer();
		v_AST = (AST)returnAST;
		if ( inputState.guessing==0 ) {
			variableDeclarator_AST = (AST)currentAST.root;
			variableDeclarator_AST = (AST)astFactory.make( (new ASTArray(5)).add(astFactory.create(VARIABLE_DEF,"VARIABLE_DEF")).add(mods).add((AST)astFactory.make( (new ASTArray(2)).add(astFactory.create(TYPE,"TYPE")).add(d_AST))).add(id_AST).add(v_AST));
			currentAST.root = variableDeclarator_AST;
			currentAST.child = variableDeclarator_AST!=null &&variableDeclarator_AST.getFirstChild()!=null ?
				variableDeclarator_AST.getFirstChild() : variableDeclarator_AST;
			currentAST.advanceChildToEnd();
		}
		returnAST = variableDeclarator_AST;
	}
	
	public final void varInitializer() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST varInitializer_AST = null;
		
		{
		switch ( LA(1)) {
		case ASSIGN:
		{
			AST tmp111_AST = null;
			tmp111_AST = astFactory.create(LT(1));
			astFactory.makeASTRoot(currentAST, tmp111_AST);
			match(ASSIGN);
			initializer();
			astFactory.addASTChild(currentAST, returnAST);
			break;
		}
		case FINAL:
		case ABSTRACT:
		case STRICTFP:
		case SEMI:
		case LITERAL_void:
		case LITERAL_boolean:
		case LITERAL_byte:
		case LITERAL_char:
		case LITERAL_short:
		case LITERAL_int:
		case LITERAL_float:
		case LITERAL_long:
		case LITERAL_double:
		case IDENT:
		case LITERAL_private:
		case LITERAL_public:
		case LITERAL_protected:
		case LITERAL_static:
		case LITERAL_transient:
		case LITERAL_native:
		case LITERAL_synchronized:
		case LITERAL_volatile:
		case LITERAL_class:
		case LITERAL_interface:
		case LCURLY:
		case RCURLY:
		case COMMA:
		case RPAREN:
		case LITERAL_default:
		case LT:
		case ENUM:
		case AT:
		case LITERAL_record:
		case LITERAL_yield:
		case LITERAL_sealed:
		case LITERAL_permits:
		case LITERAL_non:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		varInitializer_AST = (AST)currentAST.root;
		returnAST = varInitializer_AST;
	}
	
	public final void initializer() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST initializer_AST = null;
		
		switch ( LA(1)) {
		case LITERAL_void:
		case LITERAL_boolean:
		case LITERAL_byte:
		case LITERAL_char:
		case LITERAL_short:
		case LITERAL_int:
		case LITERAL_float:
		case LITERAL_long:
		case LITERAL_double:
		case IDENT:
		case LPAREN:
		case LITERAL_this:
		case LITERAL_super:
		case LITERAL_switch:
		case PLUS:
		case MINUS:
		case INC:
		case DEC:
		case BNOT:
		case LNOT:
		case LITERAL_true:
		case LITERAL_false:
		case LITERAL_null:
		case LITERAL_new:
		case NUM_INT:
		case CHAR_LITERAL:
		case STRING_LITERAL:
		case NUM_FLOAT:
		case NUM_LONG:
		case NUM_DOUBLE:
		case AT:
		case LITERAL_record:
		case TEXT_BLOCK_CONTENT:
		case LITERAL_yield:
		case LITERAL_sealed:
		case LITERAL_permits:
		case LITERAL_non:
		{
			expression();
			astFactory.addASTChild(currentAST, returnAST);
			initializer_AST = (AST)currentAST.root;
			break;
		}
		case LCURLY:
		{
			arrayInitializer();
			astFactory.addASTChild(currentAST, returnAST);
			initializer_AST = (AST)currentAST.root;
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		returnAST = initializer_AST;
	}
	
	public final void arrayInitializer() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST arrayInitializer_AST = null;
		Token  lc = null;
		AST lc_AST = null;
		
		lc = LT(1);
		lc_AST = astFactory.create(lc);
		astFactory.makeASTRoot(currentAST, lc_AST);
		match(LCURLY);
		if ( inputState.guessing==0 ) {
			lc_AST.setType(ARRAY_INIT);
		}
		{
		switch ( LA(1)) {
		case LITERAL_void:
		case LITERAL_boolean:
		case LITERAL_byte:
		case LITERAL_char:
		case LITERAL_short:
		case LITERAL_int:
		case LITERAL_float:
		case LITERAL_long:
		case LITERAL_double:
		case IDENT:
		case LCURLY:
		case LPAREN:
		case LITERAL_this:
		case LITERAL_super:
		case LITERAL_switch:
		case PLUS:
		case MINUS:
		case INC:
		case DEC:
		case BNOT:
		case LNOT:
		case LITERAL_true:
		case LITERAL_false:
		case LITERAL_null:
		case LITERAL_new:
		case NUM_INT:
		case CHAR_LITERAL:
		case STRING_LITERAL:
		case NUM_FLOAT:
		case NUM_LONG:
		case NUM_DOUBLE:
		case AT:
		case LITERAL_record:
		case TEXT_BLOCK_CONTENT:
		case LITERAL_yield:
		case LITERAL_sealed:
		case LITERAL_permits:
		case LITERAL_non:
		{
			initializer();
			astFactory.addASTChild(currentAST, returnAST);
			{
			_loop203:
			do {
				if ((LA(1)==COMMA) && (_tokenSet_17.member(LA(2)))) {
					AST tmp112_AST = null;
					tmp112_AST = astFactory.create(LT(1));
					astFactory.addASTChild(currentAST, tmp112_AST);
					match(COMMA);
					initializer();
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					break _loop203;
				}
				
			} while (true);
			}
			break;
		}
		case RCURLY:
		case COMMA:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		switch ( LA(1)) {
		case COMMA:
		{
			AST tmp113_AST = null;
			tmp113_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp113_AST);
			match(COMMA);
			break;
		}
		case RCURLY:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		AST tmp114_AST = null;
		tmp114_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp114_AST);
		match(RCURLY);
		arrayInitializer_AST = (AST)currentAST.root;
		returnAST = arrayInitializer_AST;
	}
	
	public final void expression() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST expression_AST = null;
		
		boolean synPredMatched339 = false;
		if (((_tokenSet_22.member(LA(1))) && (_tokenSet_23.member(LA(2))))) {
			int _m339 = mark();
			synPredMatched339 = true;
			inputState.guessing++;
			try {
				{
				lambdaExpression();
				}
			}
			catch (RecognitionException pe) {
				synPredMatched339 = false;
			}
			rewind(_m339);
inputState.guessing--;
		}
		if ( synPredMatched339 ) {
			lambdaExpression();
			astFactory.addASTChild(currentAST, returnAST);
			expression_AST = (AST)currentAST.root;
		}
		else if (((_tokenSet_19.member(LA(1))) && (_tokenSet_63.member(LA(2))))&&(LA(1)!=RPAREN)) {
			assignmentExpression();
			astFactory.addASTChild(currentAST, returnAST);
			if ( inputState.guessing==0 ) {
				expression_AST = (AST)currentAST.root;
				expression_AST = (AST)astFactory.make( (new ASTArray(2)).add(astFactory.create(EXPR,"EXPR")).add(expression_AST));
				currentAST.root = expression_AST;
				currentAST.child = expression_AST!=null &&expression_AST.getFirstChild()!=null ?
					expression_AST.getFirstChild() : expression_AST;
				currentAST.advanceChildToEnd();
			}
			expression_AST = (AST)currentAST.root;
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		returnAST = expression_AST;
	}
	
	public final void parameterDeclaration() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST parameterDeclaration_AST = null;
		AST pm_AST = null;
		AST t_AST = null;
		AST id_AST = null;
		AST pd_AST = null;
		
		parameterModifier();
		pm_AST = (AST)returnAST;
		{
		if ((_tokenSet_15.member(LA(1))) && (_tokenSet_64.member(LA(2)))) {
			typeSpec(false);
			t_AST = (AST)returnAST;
		}
		else if ((_tokenSet_65.member(LA(1))) && (_tokenSet_66.member(LA(2)))) {
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		parameterIdent();
		id_AST = (AST)returnAST;
		declaratorBrackets(t_AST);
		pd_AST = (AST)returnAST;
		if ( inputState.guessing==0 ) {
			parameterDeclaration_AST = (AST)currentAST.root;
			parameterDeclaration_AST = (AST)astFactory.make( (new ASTArray(4)).add(astFactory.create(PARAMETER_DEF,"PARAMETER_DEF")).add(pm_AST).add((AST)astFactory.make( (new ASTArray(2)).add(astFactory.create(TYPE,"TYPE")).add(pd_AST))).add(id_AST));
			currentAST.root = parameterDeclaration_AST;
			currentAST.child = parameterDeclaration_AST!=null &&parameterDeclaration_AST.getFirstChild()!=null ?
				parameterDeclaration_AST.getFirstChild() : parameterDeclaration_AST;
			currentAST.advanceChildToEnd();
		}
		returnAST = parameterDeclaration_AST;
	}
	
	public final void variableLengthParameterDeclaration() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST variableLengthParameterDeclaration_AST = null;
		AST pm_AST = null;
		AST t_AST = null;
		Token  td = null;
		AST td_AST = null;
		AST id_AST = null;
		AST pd_AST = null;
		
		parameterModifier();
		pm_AST = (AST)returnAST;
		variableLengthParameterTypeSpec();
		t_AST = (AST)returnAST;
		td = LT(1);
		td_AST = astFactory.create(td);
		match(ELLIPSIS);
		id();
		id_AST = (AST)returnAST;
		declaratorBrackets(t_AST);
		pd_AST = (AST)returnAST;
		if ( inputState.guessing==0 ) {
			variableLengthParameterDeclaration_AST = (AST)currentAST.root;
			variableLengthParameterDeclaration_AST = (AST)astFactory.make( (new ASTArray(5)).add(astFactory.create(PARAMETER_DEF,"PARAMETER_DEF")).add(pm_AST).add((AST)astFactory.make( (new ASTArray(2)).add(astFactory.create(TYPE,"TYPE")).add(pd_AST))).add(td_AST).add(id_AST));
			currentAST.root = variableLengthParameterDeclaration_AST;
			currentAST.child = variableLengthParameterDeclaration_AST!=null &&variableLengthParameterDeclaration_AST.getFirstChild()!=null ?
				variableLengthParameterDeclaration_AST.getFirstChild() : variableLengthParameterDeclaration_AST;
			currentAST.advanceChildToEnd();
		}
		returnAST = variableLengthParameterDeclaration_AST;
	}
	
	public final void parameterModifier() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST parameterModifier_AST = null;
		Token  f = null;
		AST f_AST = null;
		
		{
		_loop225:
		do {
			if ((LA(1)==AT) && (_tokenSet_0.member(LA(2)))) {
				annotation();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else {
				break _loop225;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case FINAL:
		{
			f = LT(1);
			f_AST = astFactory.create(f);
			astFactory.addASTChild(currentAST, f_AST);
			match(FINAL);
			break;
		}
		case LITERAL_void:
		case LITERAL_boolean:
		case LITERAL_byte:
		case LITERAL_char:
		case LITERAL_short:
		case LITERAL_int:
		case LITERAL_float:
		case LITERAL_long:
		case LITERAL_double:
		case IDENT:
		case LITERAL_this:
		case AT:
		case LITERAL_record:
		case LITERAL_yield:
		case LITERAL_sealed:
		case LITERAL_permits:
		case LITERAL_non:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		_loop228:
		do {
			if ((LA(1)==AT) && (_tokenSet_0.member(LA(2)))) {
				annotation();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else {
				break _loop228;
			}
			
		} while (true);
		}
		if ( inputState.guessing==0 ) {
			parameterModifier_AST = (AST)currentAST.root;
			parameterModifier_AST = (AST)astFactory.make( (new ASTArray(2)).add(astFactory.create(MODIFIERS,"MODIFIERS")).add(parameterModifier_AST));
			currentAST.root = parameterModifier_AST;
			currentAST.child = parameterModifier_AST!=null &&parameterModifier_AST.getFirstChild()!=null ?
				parameterModifier_AST.getFirstChild() : parameterModifier_AST;
			currentAST.advanceChildToEnd();
		}
		parameterModifier_AST = (AST)currentAST.root;
		returnAST = parameterModifier_AST;
	}
	
	public final void parameterIdent() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST parameterIdent_AST = null;
		
		switch ( LA(1)) {
		case LITERAL_this:
		{
			AST tmp115_AST = null;
			tmp115_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp115_AST);
			match(LITERAL_this);
			parameterIdent_AST = (AST)currentAST.root;
			break;
		}
		case IDENT:
		case LITERAL_record:
		case LITERAL_yield:
		case LITERAL_sealed:
		case LITERAL_permits:
		case LITERAL_non:
		{
			{
			id();
			astFactory.addASTChild(currentAST, returnAST);
			{
			switch ( LA(1)) {
			case DOT:
			{
				AST tmp116_AST = null;
				tmp116_AST = astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp116_AST);
				match(DOT);
				AST tmp117_AST = null;
				tmp117_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp117_AST);
				match(LITERAL_this);
				break;
			}
			case LBRACK:
			case COMMA:
			case RPAREN:
			case AT:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			}
			parameterIdent_AST = (AST)currentAST.root;
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		returnAST = parameterIdent_AST;
	}
	
	public final void catchParameterDeclaration() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST catchParameterDeclaration_AST = null;
		AST pm_AST = null;
		AST mct_AST = null;
		AST id_AST = null;
		
		parameterModifier();
		pm_AST = (AST)returnAST;
		multiCatchTypes();
		mct_AST = (AST)returnAST;
		id();
		id_AST = (AST)returnAST;
		if ( inputState.guessing==0 ) {
			catchParameterDeclaration_AST = (AST)currentAST.root;
			catchParameterDeclaration_AST =
			(AST)astFactory.make( (new ASTArray(4)).add(astFactory.create(PARAMETER_DEF,"PARAMETER_DEF")).add(pm_AST).add((AST)astFactory.make( (new ASTArray(2)).add(astFactory.create(TYPE,"TYPE")).add(mct_AST))).add(id_AST));
			currentAST.root = catchParameterDeclaration_AST;
			currentAST.child = catchParameterDeclaration_AST!=null &&catchParameterDeclaration_AST.getFirstChild()!=null ?
				catchParameterDeclaration_AST.getFirstChild() : catchParameterDeclaration_AST;
			currentAST.advanceChildToEnd();
		}
		returnAST = catchParameterDeclaration_AST;
	}
	
	public final void multiCatchTypes() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST multiCatchTypes_AST = null;
		
		typeSpec(false);
		astFactory.addASTChild(currentAST, returnAST);
		{
		_loop237:
		do {
			if ((LA(1)==BOR)) {
				AST tmp118_AST = null;
				tmp118_AST = astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp118_AST);
				match(BOR);
				typeSpec(false);
				astFactory.addASTChild(currentAST, returnAST);
			}
			else {
				break _loop237;
			}
			
		} while (true);
		}
		multiCatchTypes_AST = (AST)currentAST.root;
		returnAST = multiCatchTypes_AST;
	}
	
	public final void traditionalStatement() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST traditionalStatement_AST = null;
		AST a_AST = null;
		AST m_AST = null;
		Token  c = null;
		AST c_AST = null;
		Token  w = null;
		AST w_AST = null;
		Token  s = null;
		AST s_AST = null;
		
		switch ( LA(1)) {
		case LCURLY:
		{
			compoundStatement();
			astFactory.addASTChild(currentAST, returnAST);
			traditionalStatement_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_if:
		{
			AST tmp119_AST = null;
			tmp119_AST = astFactory.create(LT(1));
			astFactory.makeASTRoot(currentAST, tmp119_AST);
			match(LITERAL_if);
			AST tmp120_AST = null;
			tmp120_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp120_AST);
			match(LPAREN);
			expression();
			astFactory.addASTChild(currentAST, returnAST);
			AST tmp121_AST = null;
			tmp121_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp121_AST);
			match(RPAREN);
			statement();
			astFactory.addASTChild(currentAST, returnAST);
			{
			if ((LA(1)==LITERAL_else) && (_tokenSet_46.member(LA(2)))) {
				elseStatement();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else if ((_tokenSet_67.member(LA(1))) && (_tokenSet_68.member(LA(2)))) {
			}
			else {
				throw new NoViableAltException(LT(1), getFilename());
			}
			
			}
			traditionalStatement_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_for:
		{
			forStatement();
			astFactory.addASTChild(currentAST, returnAST);
			traditionalStatement_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_while:
		{
			AST tmp122_AST = null;
			tmp122_AST = astFactory.create(LT(1));
			astFactory.makeASTRoot(currentAST, tmp122_AST);
			match(LITERAL_while);
			AST tmp123_AST = null;
			tmp123_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp123_AST);
			match(LPAREN);
			expression();
			astFactory.addASTChild(currentAST, returnAST);
			AST tmp124_AST = null;
			tmp124_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp124_AST);
			match(RPAREN);
			statement();
			astFactory.addASTChild(currentAST, returnAST);
			traditionalStatement_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_do:
		{
			AST tmp125_AST = null;
			tmp125_AST = astFactory.create(LT(1));
			astFactory.makeASTRoot(currentAST, tmp125_AST);
			match(LITERAL_do);
			statement();
			astFactory.addASTChild(currentAST, returnAST);
			w = LT(1);
			w_AST = astFactory.create(w);
			astFactory.addASTChild(currentAST, w_AST);
			match(LITERAL_while);
			if ( inputState.guessing==0 ) {
				w_AST.setType(DO_WHILE);
			}
			AST tmp126_AST = null;
			tmp126_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp126_AST);
			match(LPAREN);
			expression();
			astFactory.addASTChild(currentAST, returnAST);
			AST tmp127_AST = null;
			tmp127_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp127_AST);
			match(RPAREN);
			AST tmp128_AST = null;
			tmp128_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp128_AST);
			match(SEMI);
			traditionalStatement_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_break:
		{
			AST tmp129_AST = null;
			tmp129_AST = astFactory.create(LT(1));
			astFactory.makeASTRoot(currentAST, tmp129_AST);
			match(LITERAL_break);
			{
			switch ( LA(1)) {
			case IDENT:
			case LITERAL_record:
			case LITERAL_yield:
			case LITERAL_sealed:
			case LITERAL_permits:
			case LITERAL_non:
			{
				id();
				astFactory.addASTChild(currentAST, returnAST);
				break;
			}
			case SEMI:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			AST tmp130_AST = null;
			tmp130_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp130_AST);
			match(SEMI);
			traditionalStatement_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_continue:
		{
			AST tmp131_AST = null;
			tmp131_AST = astFactory.create(LT(1));
			astFactory.makeASTRoot(currentAST, tmp131_AST);
			match(LITERAL_continue);
			{
			switch ( LA(1)) {
			case IDENT:
			case LITERAL_record:
			case LITERAL_yield:
			case LITERAL_sealed:
			case LITERAL_permits:
			case LITERAL_non:
			{
				id();
				astFactory.addASTChild(currentAST, returnAST);
				break;
			}
			case SEMI:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			AST tmp132_AST = null;
			tmp132_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp132_AST);
			match(SEMI);
			traditionalStatement_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_return:
		{
			AST tmp133_AST = null;
			tmp133_AST = astFactory.create(LT(1));
			astFactory.makeASTRoot(currentAST, tmp133_AST);
			match(LITERAL_return);
			{
			switch ( LA(1)) {
			case LITERAL_void:
			case LITERAL_boolean:
			case LITERAL_byte:
			case LITERAL_char:
			case LITERAL_short:
			case LITERAL_int:
			case LITERAL_float:
			case LITERAL_long:
			case LITERAL_double:
			case IDENT:
			case LPAREN:
			case LITERAL_this:
			case LITERAL_super:
			case LITERAL_switch:
			case PLUS:
			case MINUS:
			case INC:
			case DEC:
			case BNOT:
			case LNOT:
			case LITERAL_true:
			case LITERAL_false:
			case LITERAL_null:
			case LITERAL_new:
			case NUM_INT:
			case CHAR_LITERAL:
			case STRING_LITERAL:
			case NUM_FLOAT:
			case NUM_LONG:
			case NUM_DOUBLE:
			case AT:
			case LITERAL_record:
			case TEXT_BLOCK_CONTENT:
			case LITERAL_yield:
			case LITERAL_sealed:
			case LITERAL_permits:
			case LITERAL_non:
			{
				expression();
				astFactory.addASTChild(currentAST, returnAST);
				break;
			}
			case SEMI:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			AST tmp134_AST = null;
			tmp134_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp134_AST);
			match(SEMI);
			traditionalStatement_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_try:
		{
			tryBlock();
			astFactory.addASTChild(currentAST, returnAST);
			traditionalStatement_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_throw:
		{
			throwStatement();
			astFactory.addASTChild(currentAST, returnAST);
			traditionalStatement_AST = (AST)currentAST.root;
			break;
		}
		case SEMI:
		{
			s = LT(1);
			s_AST = astFactory.create(s);
			astFactory.addASTChild(currentAST, s_AST);
			match(SEMI);
			if ( inputState.guessing==0 ) {
				s_AST.setType(EMPTY_STAT);
			}
			traditionalStatement_AST = (AST)currentAST.root;
			break;
		}
		default:
			if (((LA(1)==LITERAL_yield) && (_tokenSet_19.member(LA(2))))&&(this.switchBlockDepth>0)) {
				yieldStatement();
				astFactory.addASTChild(currentAST, returnAST);
				traditionalStatement_AST = (AST)currentAST.root;
			}
			else {
				boolean synPredMatched246 = false;
				if (((_tokenSet_69.member(LA(1))) && (_tokenSet_70.member(LA(2))))) {
					int _m246 = mark();
					synPredMatched246 = true;
					inputState.guessing++;
					try {
						{
						declaration();
						}
					}
					catch (RecognitionException pe) {
						synPredMatched246 = false;
					}
					rewind(_m246);
inputState.guessing--;
				}
				if ( synPredMatched246 ) {
					declaration();
					astFactory.addASTChild(currentAST, returnAST);
					AST tmp135_AST = null;
					tmp135_AST = astFactory.create(LT(1));
					astFactory.addASTChild(currentAST, tmp135_AST);
					match(SEMI);
					traditionalStatement_AST = (AST)currentAST.root;
				}
				else {
					boolean synPredMatched248 = false;
					if (((LA(1)==AT||LA(1)==LITERAL_record) && (_tokenSet_0.member(LA(2))))) {
						int _m248 = mark();
						synPredMatched248 = true;
						inputState.guessing++;
						try {
							{
							annotations();
							recordDefinition(null);
							}
						}
						catch (RecognitionException pe) {
							synPredMatched248 = false;
						}
						rewind(_m248);
inputState.guessing--;
					}
					if ( synPredMatched248 ) {
						{
						annotations();
						a_AST = (AST)returnAST;
						if ( inputState.guessing==0 ) {
							
							// We will change the annotations AST to be a modifier AST so that
							// if there are no annotations, we still have an empty modifier AST as we
							// do for classes without modifiers AND to reflect the structure of our
							// class def AST.
							a_AST.setType(MODIFIERS);
							a_AST.setText("MODIFIERS");
							
						}
						recordDefinition(a_AST);
						astFactory.addASTChild(currentAST, returnAST);
						}
						traditionalStatement_AST = (AST)currentAST.root;
					}
					else if ((LA(1)==LITERAL_switch) && (LA(2)==LPAREN)) {
						switchExpression();
						astFactory.addASTChild(currentAST, returnAST);
						traditionalStatement_AST = (AST)currentAST.root;
					}
					else {
						boolean synPredMatched252 = false;
						if ((((_tokenSet_19.member(LA(1))) && (_tokenSet_71.member(LA(2))))&&(LA(2) != COLON))) {
							int _m252 = mark();
							synPredMatched252 = true;
							inputState.guessing++;
							try {
								{
								if (!(LA(2) != COLON))
								  throw new SemanticException("LA(2) != COLON");
								expression();
								{
								if ((LA(1)==SEMI)) {
									match(SEMI);
								}
								else {
								}
								
								}
								}
							}
							catch (RecognitionException pe) {
								synPredMatched252 = false;
							}
							rewind(_m252);
inputState.guessing--;
						}
						if ( synPredMatched252 ) {
							expression();
							astFactory.addASTChild(currentAST, returnAST);
							{
							if ((LA(1)==SEMI) && (_tokenSet_67.member(LA(2)))) {
								AST tmp136_AST = null;
								tmp136_AST = astFactory.create(LT(1));
								astFactory.addASTChild(currentAST, tmp136_AST);
								match(SEMI);
							}
							else if ((_tokenSet_67.member(LA(1))) && (_tokenSet_68.member(LA(2)))) {
							}
							else {
								throw new NoViableAltException(LT(1), getFilename());
							}
							
							}
							traditionalStatement_AST = (AST)currentAST.root;
						}
						else if ((_tokenSet_72.member(LA(1))) && (_tokenSet_73.member(LA(2)))) {
							modifiers();
							m_AST = (AST)returnAST;
							classDefinition(m_AST);
							astFactory.addASTChild(currentAST, returnAST);
							traditionalStatement_AST = (AST)currentAST.root;
						}
						else if ((_tokenSet_0.member(LA(1))) && (LA(2)==COLON)) {
							id();
							astFactory.addASTChild(currentAST, returnAST);
							c = LT(1);
							c_AST = astFactory.create(c);
							astFactory.makeASTRoot(currentAST, c_AST);
							match(COLON);
							if ( inputState.guessing==0 ) {
								c_AST.setType(LABELED_STAT);
							}
							statement();
							astFactory.addASTChild(currentAST, returnAST);
							traditionalStatement_AST = (AST)currentAST.root;
						}
						else if ((LA(1)==LITERAL_synchronized) && (LA(2)==LPAREN)) {
							AST tmp137_AST = null;
							tmp137_AST = astFactory.create(LT(1));
							astFactory.makeASTRoot(currentAST, tmp137_AST);
							match(LITERAL_synchronized);
							AST tmp138_AST = null;
							tmp138_AST = astFactory.create(LT(1));
							astFactory.addASTChild(currentAST, tmp138_AST);
							match(LPAREN);
							expression();
							astFactory.addASTChild(currentAST, returnAST);
							AST tmp139_AST = null;
							tmp139_AST = astFactory.create(LT(1));
							astFactory.addASTChild(currentAST, tmp139_AST);
							match(RPAREN);
							compoundStatement();
							astFactory.addASTChild(currentAST, returnAST);
							traditionalStatement_AST = (AST)currentAST.root;
						}
					else {
						throw new NoViableAltException(LT(1), getFilename());
					}
					}}}}
					returnAST = traditionalStatement_AST;
				}
				
	public final void assertStatement() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST assertStatement_AST = null;
		
		AST tmp140_AST = null;
		tmp140_AST = astFactory.create(LT(1));
		astFactory.makeASTRoot(currentAST, tmp140_AST);
		match(ASSERT);
		expression();
		astFactory.addASTChild(currentAST, returnAST);
		{
		switch ( LA(1)) {
		case COLON:
		{
			AST tmp141_AST = null;
			tmp141_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp141_AST);
			match(COLON);
			expression();
			astFactory.addASTChild(currentAST, returnAST);
			break;
		}
		case SEMI:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		AST tmp142_AST = null;
		tmp142_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp142_AST);
		match(SEMI);
		assertStatement_AST = (AST)currentAST.root;
		returnAST = assertStatement_AST;
	}
	
	public final void yieldStatement() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST yieldStatement_AST = null;
		Token  l = null;
		AST l_AST = null;
		AST e_AST = null;
		Token  s = null;
		AST s_AST = null;
		
		l = LT(1);
		l_AST = astFactory.create(l);
		match(LITERAL_yield);
		expression();
		e_AST = (AST)returnAST;
		s = LT(1);
		s_AST = astFactory.create(s);
		match(SEMI);
		if ( inputState.guessing==0 ) {
			yieldStatement_AST = (AST)currentAST.root;
			yieldStatement_AST = (AST)astFactory.make( (new ASTArray(3)).add(l_AST).add(e_AST).add(s_AST));
			currentAST.root = yieldStatement_AST;
			currentAST.child = yieldStatement_AST!=null &&yieldStatement_AST.getFirstChild()!=null ?
				yieldStatement_AST.getFirstChild() : yieldStatement_AST;
			currentAST.advanceChildToEnd();
		}
		returnAST = yieldStatement_AST;
	}
	
	public final void switchExpression() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST switchExpression_AST = null;
		
		AST tmp143_AST = null;
		tmp143_AST = astFactory.create(LT(1));
		astFactory.makeASTRoot(currentAST, tmp143_AST);
		match(LITERAL_switch);
		AST tmp144_AST = null;
		tmp144_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp144_AST);
		match(LPAREN);
		expression();
		astFactory.addASTChild(currentAST, returnAST);
		AST tmp145_AST = null;
		tmp145_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp145_AST);
		match(RPAREN);
		switchBlock();
		astFactory.addASTChild(currentAST, returnAST);
		switchExpression_AST = (AST)currentAST.root;
		returnAST = switchExpression_AST;
	}
	
	public final void elseStatement() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST elseStatement_AST = null;
		
		AST tmp146_AST = null;
		tmp146_AST = astFactory.create(LT(1));
		astFactory.makeASTRoot(currentAST, tmp146_AST);
		match(LITERAL_else);
		statement();
		astFactory.addASTChild(currentAST, returnAST);
		elseStatement_AST = (AST)currentAST.root;
		returnAST = elseStatement_AST;
	}
	
	public final void forStatement() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST forStatement_AST = null;
		Token  f = null;
		AST f_AST = null;
		
		f = LT(1);
		f_AST = astFactory.create(f);
		astFactory.makeASTRoot(currentAST, f_AST);
		match(LITERAL_for);
		AST tmp147_AST = null;
		tmp147_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp147_AST);
		match(LPAREN);
		{
		boolean synPredMatched262 = false;
		if (((_tokenSet_74.member(LA(1))) && (_tokenSet_75.member(LA(2))))) {
			int _m262 = mark();
			synPredMatched262 = true;
			inputState.guessing++;
			try {
				{
				forInit();
				match(SEMI);
				}
			}
			catch (RecognitionException pe) {
				synPredMatched262 = false;
			}
			rewind(_m262);
inputState.guessing--;
		}
		if ( synPredMatched262 ) {
			traditionalForClause();
			astFactory.addASTChild(currentAST, returnAST);
		}
		else if ((_tokenSet_69.member(LA(1))) && (_tokenSet_70.member(LA(2)))) {
			forEachClause();
			astFactory.addASTChild(currentAST, returnAST);
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		AST tmp148_AST = null;
		tmp148_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp148_AST);
		match(RPAREN);
		statement();
		astFactory.addASTChild(currentAST, returnAST);
		forStatement_AST = (AST)currentAST.root;
		returnAST = forStatement_AST;
	}
	
	public final void tryBlock() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST tryBlock_AST = null;
		
		AST tmp149_AST = null;
		tmp149_AST = astFactory.create(LT(1));
		astFactory.makeASTRoot(currentAST, tmp149_AST);
		match(LITERAL_try);
		{
		switch ( LA(1)) {
		case LPAREN:
		{
			resourceSpecification();
			astFactory.addASTChild(currentAST, returnAST);
			break;
		}
		case LCURLY:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		compoundStatement();
		astFactory.addASTChild(currentAST, returnAST);
		{
		_loop320:
		do {
			if ((LA(1)==LITERAL_catch)) {
				handler();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else {
				break _loop320;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case LITERAL_finally:
		{
			finallyHandler();
			astFactory.addASTChild(currentAST, returnAST);
			break;
		}
		case FINAL:
		case ABSTRACT:
		case STRICTFP:
		case SEMI:
		case LITERAL_void:
		case LITERAL_boolean:
		case LITERAL_byte:
		case LITERAL_char:
		case LITERAL_short:
		case LITERAL_int:
		case LITERAL_float:
		case LITERAL_long:
		case LITERAL_double:
		case IDENT:
		case STAR:
		case LITERAL_private:
		case LITERAL_public:
		case LITERAL_protected:
		case LITERAL_static:
		case LITERAL_transient:
		case LITERAL_native:
		case LITERAL_synchronized:
		case LITERAL_volatile:
		case LITERAL_class:
		case LCURLY:
		case RCURLY:
		case LPAREN:
		case RPAREN:
		case LITERAL_this:
		case LITERAL_super:
		case COLON:
		case LITERAL_if:
		case LITERAL_while:
		case LITERAL_do:
		case LITERAL_break:
		case LITERAL_continue:
		case LITERAL_return:
		case LITERAL_switch:
		case LITERAL_throw:
		case LITERAL_for:
		case LITERAL_else:
		case LITERAL_case:
		case LITERAL_default:
		case LITERAL_try:
		case LT:
		case GT:
		case LE:
		case GE:
		case LITERAL_instanceof:
		case SL:
		case SR:
		case BSR:
		case PLUS:
		case MINUS:
		case DIV:
		case MOD:
		case INC:
		case DEC:
		case BNOT:
		case LNOT:
		case LITERAL_true:
		case LITERAL_false:
		case LITERAL_null:
		case LITERAL_new:
		case NUM_INT:
		case CHAR_LITERAL:
		case STRING_LITERAL:
		case NUM_FLOAT:
		case NUM_LONG:
		case NUM_DOUBLE:
		case ASSERT:
		case AT:
		case LITERAL_record:
		case TEXT_BLOCK_CONTENT:
		case LITERAL_yield:
		case LITERAL_sealed:
		case LITERAL_permits:
		case LITERAL_non:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		tryBlock_AST = (AST)currentAST.root;
		returnAST = tryBlock_AST;
	}
	
	public final void throwStatement() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST throwStatement_AST = null;
		
		AST tmp150_AST = null;
		tmp150_AST = astFactory.create(LT(1));
		astFactory.makeASTRoot(currentAST, tmp150_AST);
		match(LITERAL_throw);
		expression();
		astFactory.addASTChild(currentAST, returnAST);
		AST tmp151_AST = null;
		tmp151_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp151_AST);
		match(SEMI);
		throwStatement_AST = (AST)currentAST.root;
		returnAST = throwStatement_AST;
	}
	
	public final void forInit() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST forInit_AST = null;
		
		{
		boolean synPredMatched312 = false;
		if (((_tokenSet_69.member(LA(1))) && (_tokenSet_70.member(LA(2))))) {
			int _m312 = mark();
			synPredMatched312 = true;
			inputState.guessing++;
			try {
				{
				declaration();
				}
			}
			catch (RecognitionException pe) {
				synPredMatched312 = false;
			}
			rewind(_m312);
inputState.guessing--;
		}
		if ( synPredMatched312 ) {
			declaration();
			astFactory.addASTChild(currentAST, returnAST);
		}
		else if ((_tokenSet_19.member(LA(1))) && (_tokenSet_76.member(LA(2)))) {
			expressionList();
			astFactory.addASTChild(currentAST, returnAST);
		}
		else if ((LA(1)==SEMI)) {
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		if ( inputState.guessing==0 ) {
			forInit_AST = (AST)currentAST.root;
			forInit_AST = (AST)astFactory.make( (new ASTArray(2)).add(astFactory.create(FOR_INIT,"FOR_INIT")).add(forInit_AST));
			currentAST.root = forInit_AST;
			currentAST.child = forInit_AST!=null &&forInit_AST.getFirstChild()!=null ?
				forInit_AST.getFirstChild() : forInit_AST;
			currentAST.advanceChildToEnd();
		}
		forInit_AST = (AST)currentAST.root;
		returnAST = forInit_AST;
	}
	
	public final void traditionalForClause() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST traditionalForClause_AST = null;
		
		forInit();
		astFactory.addASTChild(currentAST, returnAST);
		AST tmp152_AST = null;
		tmp152_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp152_AST);
		match(SEMI);
		forCond();
		astFactory.addASTChild(currentAST, returnAST);
		AST tmp153_AST = null;
		tmp153_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp153_AST);
		match(SEMI);
		forIter();
		astFactory.addASTChild(currentAST, returnAST);
		traditionalForClause_AST = (AST)currentAST.root;
		returnAST = traditionalForClause_AST;
	}
	
	public final void forEachClause() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST forEachClause_AST = null;
		
		forEachDeclarator();
		astFactory.addASTChild(currentAST, returnAST);
		AST tmp154_AST = null;
		tmp154_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp154_AST);
		match(COLON);
		expression();
		astFactory.addASTChild(currentAST, returnAST);
		if ( inputState.guessing==0 ) {
			forEachClause_AST = (AST)currentAST.root;
			forEachClause_AST = (AST)astFactory.make( (new ASTArray(2)).add(astFactory.create(FOR_EACH_CLAUSE,"FOR_EACH_CLAUSE")).add(forEachClause_AST));
			currentAST.root = forEachClause_AST;
			currentAST.child = forEachClause_AST!=null &&forEachClause_AST.getFirstChild()!=null ?
				forEachClause_AST.getFirstChild() : forEachClause_AST;
			currentAST.advanceChildToEnd();
		}
		forEachClause_AST = (AST)currentAST.root;
		returnAST = forEachClause_AST;
	}
	
	public final void forCond() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST forCond_AST = null;
		
		{
		switch ( LA(1)) {
		case LITERAL_void:
		case LITERAL_boolean:
		case LITERAL_byte:
		case LITERAL_char:
		case LITERAL_short:
		case LITERAL_int:
		case LITERAL_float:
		case LITERAL_long:
		case LITERAL_double:
		case IDENT:
		case LPAREN:
		case LITERAL_this:
		case LITERAL_super:
		case LITERAL_switch:
		case PLUS:
		case MINUS:
		case INC:
		case DEC:
		case BNOT:
		case LNOT:
		case LITERAL_true:
		case LITERAL_false:
		case LITERAL_null:
		case LITERAL_new:
		case NUM_INT:
		case CHAR_LITERAL:
		case STRING_LITERAL:
		case NUM_FLOAT:
		case NUM_LONG:
		case NUM_DOUBLE:
		case AT:
		case LITERAL_record:
		case TEXT_BLOCK_CONTENT:
		case LITERAL_yield:
		case LITERAL_sealed:
		case LITERAL_permits:
		case LITERAL_non:
		{
			expression();
			astFactory.addASTChild(currentAST, returnAST);
			break;
		}
		case SEMI:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		if ( inputState.guessing==0 ) {
			forCond_AST = (AST)currentAST.root;
			forCond_AST = (AST)astFactory.make( (new ASTArray(2)).add(astFactory.create(FOR_CONDITION,"FOR_CONDITION")).add(forCond_AST));
			currentAST.root = forCond_AST;
			currentAST.child = forCond_AST!=null &&forCond_AST.getFirstChild()!=null ?
				forCond_AST.getFirstChild() : forCond_AST;
			currentAST.advanceChildToEnd();
		}
		forCond_AST = (AST)currentAST.root;
		returnAST = forCond_AST;
	}
	
	public final void forIter() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST forIter_AST = null;
		
		{
		switch ( LA(1)) {
		case LITERAL_void:
		case LITERAL_boolean:
		case LITERAL_byte:
		case LITERAL_char:
		case LITERAL_short:
		case LITERAL_int:
		case LITERAL_float:
		case LITERAL_long:
		case LITERAL_double:
		case IDENT:
		case LPAREN:
		case LITERAL_this:
		case LITERAL_super:
		case LITERAL_switch:
		case PLUS:
		case MINUS:
		case INC:
		case DEC:
		case BNOT:
		case LNOT:
		case LITERAL_true:
		case LITERAL_false:
		case LITERAL_null:
		case LITERAL_new:
		case NUM_INT:
		case CHAR_LITERAL:
		case STRING_LITERAL:
		case NUM_FLOAT:
		case NUM_LONG:
		case NUM_DOUBLE:
		case AT:
		case LITERAL_record:
		case TEXT_BLOCK_CONTENT:
		case LITERAL_yield:
		case LITERAL_sealed:
		case LITERAL_permits:
		case LITERAL_non:
		{
			expressionList();
			astFactory.addASTChild(currentAST, returnAST);
			break;
		}
		case RPAREN:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		if ( inputState.guessing==0 ) {
			forIter_AST = (AST)currentAST.root;
			forIter_AST = (AST)astFactory.make( (new ASTArray(2)).add(astFactory.create(FOR_ITERATOR,"FOR_ITERATOR")).add(forIter_AST));
			currentAST.root = forIter_AST;
			currentAST.child = forIter_AST!=null &&forIter_AST.getFirstChild()!=null ?
				forIter_AST.getFirstChild() : forIter_AST;
			currentAST.advanceChildToEnd();
		}
		forIter_AST = (AST)currentAST.root;
		returnAST = forIter_AST;
	}
	
	public final void forEachDeclarator() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST forEachDeclarator_AST = null;
		AST m_AST = null;
		AST t_AST = null;
		AST id_AST = null;
		AST d_AST = null;
		
		modifiers();
		m_AST = (AST)returnAST;
		typeSpec(false);
		t_AST = (AST)returnAST;
		id();
		id_AST = (AST)returnAST;
		declaratorBrackets(t_AST);
		d_AST = (AST)returnAST;
		if ( inputState.guessing==0 ) {
			forEachDeclarator_AST = (AST)currentAST.root;
			forEachDeclarator_AST = (AST)astFactory.make( (new ASTArray(4)).add(astFactory.create(VARIABLE_DEF,"VARIABLE_DEF")).add(m_AST).add((AST)astFactory.make( (new ASTArray(2)).add(astFactory.create(TYPE,"TYPE")).add(d_AST))).add(id_AST));
			currentAST.root = forEachDeclarator_AST;
			currentAST.child = forEachDeclarator_AST!=null &&forEachDeclarator_AST.getFirstChild()!=null ?
				forEachDeclarator_AST.getFirstChild() : forEachDeclarator_AST;
			currentAST.advanceChildToEnd();
		}
		returnAST = forEachDeclarator_AST;
	}
	
	public final void switchBlock() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST switchBlock_AST = null;
		
		{
		switchBlockDepth++;
		AST tmp155_AST = null;
		tmp155_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp155_AST);
		match(LCURLY);
		}
		{
		boolean synPredMatched273 = false;
		if (((LA(1)==LITERAL_case||LA(1)==LITERAL_default) && (_tokenSet_77.member(LA(2))))) {
			int _m273 = mark();
			synPredMatched273 = true;
			inputState.guessing++;
			try {
				{
				{
				int _cnt272=0;
				_loop272:
				do {
					if ((LA(1)==LITERAL_case||LA(1)==LITERAL_default)) {
						switchRule();
					}
					else {
						if ( _cnt272>=1 ) { break _loop272; } else {throw new NoViableAltException(LT(1), getFilename());}
					}
					
					_cnt272++;
				} while (true);
				}
				}
			}
			catch (RecognitionException pe) {
				synPredMatched273 = false;
			}
			rewind(_m273);
inputState.guessing--;
		}
		if ( synPredMatched273 ) {
			{
			{
			int _cnt276=0;
			_loop276:
			do {
				if ((LA(1)==LITERAL_case||LA(1)==LITERAL_default)) {
					switchRule();
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					if ( _cnt276>=1 ) { break _loop276; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				
				_cnt276++;
			} while (true);
			}
			}
		}
		else {
			boolean synPredMatched280 = false;
			if (((_tokenSet_78.member(LA(1))) && (_tokenSet_79.member(LA(2))))) {
				int _m280 = mark();
				synPredMatched280 = true;
				inputState.guessing++;
				try {
					{
					{
					_loop279:
					do {
						if ((LA(1)==LITERAL_case||LA(1)==LITERAL_default)) {
							casesGroup();
						}
						else {
							break _loop279;
						}
						
					} while (true);
					}
					}
				}
				catch (RecognitionException pe) {
					synPredMatched280 = false;
				}
				rewind(_m280);
inputState.guessing--;
			}
			if ( synPredMatched280 ) {
				{
				{
				_loop283:
				do {
					if ((LA(1)==LITERAL_case||LA(1)==LITERAL_default)) {
						casesGroup();
						astFactory.addASTChild(currentAST, returnAST);
					}
					else {
						break _loop283;
					}
					
				} while (true);
				}
				}
			}
			else {
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			{
			switchBlockDepth--;
			AST tmp156_AST = null;
			tmp156_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp156_AST);
			match(RCURLY);
			}
			switchBlock_AST = (AST)currentAST.root;
			returnAST = switchBlock_AST;
		}
		
	public final void switchRule() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST switchRule_AST = null;
		AST se_AST = null;
		AST sb_AST = null;
		AST st_AST = null;
		
		{
		boolean synPredMatched295 = false;
		if (((LA(1)==LITERAL_case||LA(1)==LITERAL_default) && (_tokenSet_77.member(LA(2))))) {
			int _m295 = mark();
			synPredMatched295 = true;
			inputState.guessing++;
			try {
				{
				switchLabeledExpression();
				}
			}
			catch (RecognitionException pe) {
				synPredMatched295 = false;
			}
			rewind(_m295);
inputState.guessing--;
		}
		if ( synPredMatched295 ) {
			switchLabeledExpression();
			se_AST = (AST)returnAST;
			astFactory.addASTChild(currentAST, returnAST);
		}
		else {
			boolean synPredMatched297 = false;
			if (((LA(1)==LITERAL_case||LA(1)==LITERAL_default) && (_tokenSet_77.member(LA(2))))) {
				int _m297 = mark();
				synPredMatched297 = true;
				inputState.guessing++;
				try {
					{
					switchLabeledBlock();
					}
				}
				catch (RecognitionException pe) {
					synPredMatched297 = false;
				}
				rewind(_m297);
inputState.guessing--;
			}
			if ( synPredMatched297 ) {
				switchLabeledBlock();
				sb_AST = (AST)returnAST;
				astFactory.addASTChild(currentAST, returnAST);
			}
			else {
				boolean synPredMatched299 = false;
				if (((LA(1)==LITERAL_case||LA(1)==LITERAL_default) && (_tokenSet_77.member(LA(2))))) {
					int _m299 = mark();
					synPredMatched299 = true;
					inputState.guessing++;
					try {
						{
						switchLabeledThrow();
						}
					}
					catch (RecognitionException pe) {
						synPredMatched299 = false;
					}
					rewind(_m299);
inputState.guessing--;
				}
				if ( synPredMatched299 ) {
					switchLabeledThrow();
					st_AST = (AST)returnAST;
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					throw new NoViableAltException(LT(1), getFilename());
				}
				}}
				}
				if ( inputState.guessing==0 ) {
					switchRule_AST = (AST)currentAST.root;
					switchRule_AST = (AST)astFactory.make( (new ASTArray(4)).add(astFactory.create(SWITCH_RULE,"SWITCH_RULE")).add(se_AST).add(sb_AST).add(st_AST));
					currentAST.root = switchRule_AST;
					currentAST.child = switchRule_AST!=null &&switchRule_AST.getFirstChild()!=null ?
						switchRule_AST.getFirstChild() : switchRule_AST;
					currentAST.advanceChildToEnd();
				}
				switchRule_AST = (AST)currentAST.root;
				returnAST = switchRule_AST;
			}
			
	public final void casesGroup() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST casesGroup_AST = null;
		
		{
		int _cnt287=0;
		_loop287:
		do {
			if ((LA(1)==LITERAL_case||LA(1)==LITERAL_default) && (_tokenSet_80.member(LA(2)))) {
				switchLabel();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else {
				if ( _cnt287>=1 ) { break _loop287; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt287++;
		} while (true);
		}
		{
		if ((_tokenSet_46.member(LA(1))) && (_tokenSet_81.member(LA(2)))) {
			caseSList();
			astFactory.addASTChild(currentAST, returnAST);
		}
		else if ((_tokenSet_78.member(LA(1))) && (_tokenSet_79.member(LA(2)))) {
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		if ( inputState.guessing==0 ) {
			casesGroup_AST = (AST)currentAST.root;
			casesGroup_AST = (AST)astFactory.make( (new ASTArray(2)).add(astFactory.create(CASE_GROUP,"CASE_GROUP")).add(casesGroup_AST));
			currentAST.root = casesGroup_AST;
			currentAST.child = casesGroup_AST!=null &&casesGroup_AST.getFirstChild()!=null ?
				casesGroup_AST.getFirstChild() : casesGroup_AST;
			currentAST.advanceChildToEnd();
		}
		casesGroup_AST = (AST)currentAST.root;
		returnAST = casesGroup_AST;
	}
	
	public final void switchLabel() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST switchLabel_AST = null;
		
		{
		switch ( LA(1)) {
		case LITERAL_case:
		{
			AST tmp157_AST = null;
			tmp157_AST = astFactory.create(LT(1));
			astFactory.makeASTRoot(currentAST, tmp157_AST);
			match(LITERAL_case);
			caseConstant();
			astFactory.addASTChild(currentAST, returnAST);
			{
			_loop306:
			do {
				if ((LA(1)==COMMA)) {
					AST tmp158_AST = null;
					tmp158_AST = astFactory.create(LT(1));
					astFactory.addASTChild(currentAST, tmp158_AST);
					match(COMMA);
					caseConstant();
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					break _loop306;
				}
				
			} while (true);
			}
			break;
		}
		case LITERAL_default:
		{
			AST tmp159_AST = null;
			tmp159_AST = astFactory.create(LT(1));
			astFactory.makeASTRoot(currentAST, tmp159_AST);
			match(LITERAL_default);
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		switch ( LA(1)) {
		case COLON:
		{
			AST tmp160_AST = null;
			tmp160_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp160_AST);
			match(COLON);
			break;
		}
		case FINAL:
		case ABSTRACT:
		case STRICTFP:
		case SEMI:
		case LITERAL_void:
		case LITERAL_boolean:
		case LITERAL_byte:
		case LITERAL_char:
		case LITERAL_short:
		case LITERAL_int:
		case LITERAL_float:
		case LITERAL_long:
		case LITERAL_double:
		case IDENT:
		case LITERAL_private:
		case LITERAL_public:
		case LITERAL_protected:
		case LITERAL_static:
		case LITERAL_transient:
		case LITERAL_native:
		case LITERAL_synchronized:
		case LITERAL_volatile:
		case LITERAL_class:
		case LCURLY:
		case RCURLY:
		case LPAREN:
		case LITERAL_this:
		case LITERAL_super:
		case LITERAL_if:
		case LITERAL_while:
		case LITERAL_do:
		case LITERAL_break:
		case LITERAL_continue:
		case LITERAL_return:
		case LITERAL_switch:
		case LITERAL_throw:
		case LITERAL_for:
		case LITERAL_case:
		case LITERAL_default:
		case LITERAL_try:
		case PLUS:
		case MINUS:
		case INC:
		case DEC:
		case BNOT:
		case LNOT:
		case LITERAL_true:
		case LITERAL_false:
		case LITERAL_null:
		case LITERAL_new:
		case NUM_INT:
		case CHAR_LITERAL:
		case STRING_LITERAL:
		case NUM_FLOAT:
		case NUM_LONG:
		case NUM_DOUBLE:
		case ASSERT:
		case AT:
		case LAMBDA:
		case LITERAL_record:
		case TEXT_BLOCK_CONTENT:
		case LITERAL_yield:
		case LITERAL_sealed:
		case LITERAL_permits:
		case LITERAL_non:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		switchLabel_AST = (AST)currentAST.root;
		returnAST = switchLabel_AST;
	}
	
	public final void caseSList() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST caseSList_AST = null;
		
		{
		int _cnt291=0;
		_loop291:
		do {
			if (((_tokenSet_46.member(LA(1))) && (_tokenSet_81.member(LA(2))))&&(LA(1)!=LITERAL_default)) {
				statement();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else {
				if ( _cnt291>=1 ) { break _loop291; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt291++;
		} while (true);
		}
		if ( inputState.guessing==0 ) {
			caseSList_AST = (AST)currentAST.root;
			caseSList_AST = (AST)astFactory.make( (new ASTArray(2)).add(astFactory.create(SLIST,"SLIST")).add(caseSList_AST));
			currentAST.root = caseSList_AST;
			currentAST.child = caseSList_AST!=null &&caseSList_AST.getFirstChild()!=null ?
				caseSList_AST.getFirstChild() : caseSList_AST;
			currentAST.advanceChildToEnd();
		}
		caseSList_AST = (AST)currentAST.root;
		returnAST = caseSList_AST;
	}
	
	public final void switchLabeledExpression() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST switchLabeledExpression_AST = null;
		
		switchLabel();
		astFactory.addASTChild(currentAST, returnAST);
		AST tmp161_AST = null;
		tmp161_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp161_AST);
		match(LAMBDA);
		expression();
		astFactory.addASTChild(currentAST, returnAST);
		AST tmp162_AST = null;
		tmp162_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp162_AST);
		match(SEMI);
		switchLabeledExpression_AST = (AST)currentAST.root;
		returnAST = switchLabeledExpression_AST;
	}
	
	public final void switchLabeledBlock() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST switchLabeledBlock_AST = null;
		
		switchLabel();
		astFactory.addASTChild(currentAST, returnAST);
		AST tmp163_AST = null;
		tmp163_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp163_AST);
		match(LAMBDA);
		compoundStatement();
		astFactory.addASTChild(currentAST, returnAST);
		switchLabeledBlock_AST = (AST)currentAST.root;
		returnAST = switchLabeledBlock_AST;
	}
	
	public final void switchLabeledThrow() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST switchLabeledThrow_AST = null;
		
		switchLabel();
		astFactory.addASTChild(currentAST, returnAST);
		AST tmp164_AST = null;
		tmp164_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp164_AST);
		match(LAMBDA);
		throwStatement();
		astFactory.addASTChild(currentAST, returnAST);
		switchLabeledThrow_AST = (AST)currentAST.root;
		returnAST = switchLabeledThrow_AST;
	}
	
	public final void caseConstant() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST caseConstant_AST = null;
		
		conditionalExpression();
		astFactory.addASTChild(currentAST, returnAST);
		if ( inputState.guessing==0 ) {
			caseConstant_AST = (AST)currentAST.root;
			caseConstant_AST = (AST)astFactory.make( (new ASTArray(2)).add(astFactory.create(EXPR,"EXPR")).add(caseConstant_AST));
			currentAST.root = caseConstant_AST;
			currentAST.child = caseConstant_AST!=null &&caseConstant_AST.getFirstChild()!=null ?
				caseConstant_AST.getFirstChild() : caseConstant_AST;
			currentAST.advanceChildToEnd();
		}
		caseConstant_AST = (AST)currentAST.root;
		returnAST = caseConstant_AST;
	}
	
	public final void expressionList() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST expressionList_AST = null;
		
		expression();
		astFactory.addASTChild(currentAST, returnAST);
		{
		_loop342:
		do {
			if ((LA(1)==COMMA)) {
				AST tmp165_AST = null;
				tmp165_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp165_AST);
				match(COMMA);
				expression();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else {
				break _loop342;
			}
			
		} while (true);
		}
		if ( inputState.guessing==0 ) {
			expressionList_AST = (AST)currentAST.root;
			expressionList_AST = (AST)astFactory.make( (new ASTArray(2)).add(astFactory.create(ELIST,"ELIST")).add(expressionList_AST));
			currentAST.root = expressionList_AST;
			currentAST.child = expressionList_AST!=null &&expressionList_AST.getFirstChild()!=null ?
				expressionList_AST.getFirstChild() : expressionList_AST;
			currentAST.advanceChildToEnd();
		}
		expressionList_AST = (AST)currentAST.root;
		returnAST = expressionList_AST;
	}
	
	public final void resourceSpecification() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST resourceSpecification_AST = null;
		
		AST tmp166_AST = null;
		tmp166_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp166_AST);
		match(LPAREN);
		resources();
		astFactory.addASTChild(currentAST, returnAST);
		{
		switch ( LA(1)) {
		case SEMI:
		{
			AST tmp167_AST = null;
			tmp167_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp167_AST);
			match(SEMI);
			break;
		}
		case RPAREN:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		AST tmp168_AST = null;
		tmp168_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp168_AST);
		match(RPAREN);
		if ( inputState.guessing==0 ) {
			resourceSpecification_AST = (AST)currentAST.root;
			resourceSpecification_AST =
			(AST)astFactory.make( (new ASTArray(2)).add(astFactory.create(RESOURCE_SPECIFICATION,"RESOURCE_SPECIFICATION")).add(resourceSpecification_AST));
			currentAST.root = resourceSpecification_AST;
			currentAST.child = resourceSpecification_AST!=null &&resourceSpecification_AST.getFirstChild()!=null ?
				resourceSpecification_AST.getFirstChild() : resourceSpecification_AST;
			currentAST.advanceChildToEnd();
		}
		resourceSpecification_AST = (AST)currentAST.root;
		returnAST = resourceSpecification_AST;
	}
	
	public final void handler() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST handler_AST = null;
		
		AST tmp169_AST = null;
		tmp169_AST = astFactory.create(LT(1));
		astFactory.makeASTRoot(currentAST, tmp169_AST);
		match(LITERAL_catch);
		AST tmp170_AST = null;
		tmp170_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp170_AST);
		match(LPAREN);
		catchParameterDeclaration();
		astFactory.addASTChild(currentAST, returnAST);
		AST tmp171_AST = null;
		tmp171_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp171_AST);
		match(RPAREN);
		compoundStatement();
		astFactory.addASTChild(currentAST, returnAST);
		handler_AST = (AST)currentAST.root;
		returnAST = handler_AST;
	}
	
	public final void finallyHandler() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST finallyHandler_AST = null;
		
		AST tmp172_AST = null;
		tmp172_AST = astFactory.create(LT(1));
		astFactory.makeASTRoot(currentAST, tmp172_AST);
		match(LITERAL_finally);
		compoundStatement();
		astFactory.addASTChild(currentAST, returnAST);
		finallyHandler_AST = (AST)currentAST.root;
		returnAST = finallyHandler_AST;
	}
	
	public final void resources() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST resources_AST = null;
		
		resource();
		astFactory.addASTChild(currentAST, returnAST);
		{
		_loop327:
		do {
			if ((LA(1)==SEMI) && (_tokenSet_82.member(LA(2)))) {
				AST tmp173_AST = null;
				tmp173_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp173_AST);
				match(SEMI);
				resource();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else {
				break _loop327;
			}
			
		} while (true);
		}
		if ( inputState.guessing==0 ) {
			resources_AST = (AST)currentAST.root;
			resources_AST = (AST)astFactory.make( (new ASTArray(2)).add(astFactory.create(RESOURCES,"RESOURCES")).add(resources_AST));
			currentAST.root = resources_AST;
			currentAST.child = resources_AST!=null &&resources_AST.getFirstChild()!=null ?
				resources_AST.getFirstChild() : resources_AST;
			currentAST.advanceChildToEnd();
		}
		resources_AST = (AST)currentAST.root;
		returnAST = resources_AST;
	}
	
	public final void resource() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST resource_AST = null;
		
		boolean synPredMatched330 = false;
		if (((_tokenSet_52.member(LA(1))) && (_tokenSet_83.member(LA(2))))) {
			int _m330 = mark();
			synPredMatched330 = true;
			inputState.guessing++;
			try {
				{
				tryResourceDeclaration();
				}
			}
			catch (RecognitionException pe) {
				synPredMatched330 = false;
			}
			rewind(_m330);
inputState.guessing--;
		}
		if ( synPredMatched330 ) {
			tryResourceDeclaration();
			astFactory.addASTChild(currentAST, returnAST);
			resource_AST = (AST)currentAST.root;
		}
		else if ((_tokenSet_58.member(LA(1))) && (_tokenSet_84.member(LA(2)))) {
			{
			_loop332:
			do {
				if ((_tokenSet_58.member(LA(1))) && (_tokenSet_59.member(LA(2)))) {
					primaryExpression();
					astFactory.addASTChild(currentAST, returnAST);
					AST tmp174_AST = null;
					tmp174_AST = astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp174_AST);
					match(DOT);
				}
				else {
					break _loop332;
				}
				
			} while (true);
			}
			id();
			astFactory.addASTChild(currentAST, returnAST);
			if ( inputState.guessing==0 ) {
				resource_AST = (AST)currentAST.root;
				resource_AST = (AST)astFactory.make( (new ASTArray(2)).add(astFactory.create(RESOURCE,"RESOURCE")).add(resource_AST));
				currentAST.root = resource_AST;
				currentAST.child = resource_AST!=null &&resource_AST.getFirstChild()!=null ?
					resource_AST.getFirstChild() : resource_AST;
				currentAST.advanceChildToEnd();
			}
			resource_AST = (AST)currentAST.root;
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		returnAST = resource_AST;
	}
	
	public final void tryResourceDeclaration() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST tryResourceDeclaration_AST = null;
		AST m_AST = null;
		AST t_AST = null;
		AST v_AST = null;
		
		parameterModifier();
		m_AST = (AST)returnAST;
		typeSpec(false);
		t_AST = (AST)returnAST;
		tryResourceDeclarator((AST) getASTFactory().dupTree(m_AST),
                                    //dupList as this also copies siblings (like TYPE_ARGUMENTS)
                                    (AST) getASTFactory().dupList(t_AST));
		v_AST = (AST)returnAST;
		if ( inputState.guessing==0 ) {
			tryResourceDeclaration_AST = (AST)currentAST.root;
			tryResourceDeclaration_AST = v_AST;
			currentAST.root = tryResourceDeclaration_AST;
			currentAST.child = tryResourceDeclaration_AST!=null &&tryResourceDeclaration_AST.getFirstChild()!=null ?
				tryResourceDeclaration_AST.getFirstChild() : tryResourceDeclaration_AST;
			currentAST.advanceChildToEnd();
		}
		returnAST = tryResourceDeclaration_AST;
	}
	
	public final void tryResourceDeclarator(
		AST mods, AST t
	) throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST tryResourceDeclarator_AST = null;
		AST id_AST = null;
		AST d_AST = null;
		AST v_AST = null;
		
		id();
		id_AST = (AST)returnAST;
		declaratorBrackets(t);
		d_AST = (AST)returnAST;
		varInitializer();
		v_AST = (AST)returnAST;
		if ( inputState.guessing==0 ) {
			tryResourceDeclarator_AST = (AST)currentAST.root;
			tryResourceDeclarator_AST = (AST)astFactory.make( (new ASTArray(5)).add(astFactory.create(RESOURCE,"RESOURCE")).add(mods).add((AST)astFactory.make( (new ASTArray(2)).add(astFactory.create(TYPE,"TYPE")).add(d_AST))).add(id_AST).add(v_AST));
			currentAST.root = tryResourceDeclarator_AST;
			currentAST.child = tryResourceDeclarator_AST!=null &&tryResourceDeclarator_AST.getFirstChild()!=null ?
				tryResourceDeclarator_AST.getFirstChild() : tryResourceDeclarator_AST;
			currentAST.advanceChildToEnd();
		}
		returnAST = tryResourceDeclarator_AST;
	}
	
	public final void lambdaExpression() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST lambdaExpression_AST = null;
		
		lambdaParameters();
		astFactory.addASTChild(currentAST, returnAST);
		AST tmp175_AST = null;
		tmp175_AST = astFactory.create(LT(1));
		astFactory.makeASTRoot(currentAST, tmp175_AST);
		match(LAMBDA);
		lambdaBody();
		astFactory.addASTChild(currentAST, returnAST);
		lambdaExpression_AST = (AST)currentAST.root;
		returnAST = lambdaExpression_AST;
	}
	
	public final void assignmentExpression() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST assignmentExpression_AST = null;
		
		conditionalExpression();
		astFactory.addASTChild(currentAST, returnAST);
		{
		switch ( LA(1)) {
		case ASSIGN:
		case PLUS_ASSIGN:
		case MINUS_ASSIGN:
		case STAR_ASSIGN:
		case DIV_ASSIGN:
		case MOD_ASSIGN:
		case SR_ASSIGN:
		case BSR_ASSIGN:
		case SL_ASSIGN:
		case BAND_ASSIGN:
		case BXOR_ASSIGN:
		case BOR_ASSIGN:
		{
			{
			switch ( LA(1)) {
			case ASSIGN:
			{
				AST tmp176_AST = null;
				tmp176_AST = astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp176_AST);
				match(ASSIGN);
				break;
			}
			case PLUS_ASSIGN:
			{
				AST tmp177_AST = null;
				tmp177_AST = astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp177_AST);
				match(PLUS_ASSIGN);
				break;
			}
			case MINUS_ASSIGN:
			{
				AST tmp178_AST = null;
				tmp178_AST = astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp178_AST);
				match(MINUS_ASSIGN);
				break;
			}
			case STAR_ASSIGN:
			{
				AST tmp179_AST = null;
				tmp179_AST = astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp179_AST);
				match(STAR_ASSIGN);
				break;
			}
			case DIV_ASSIGN:
			{
				AST tmp180_AST = null;
				tmp180_AST = astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp180_AST);
				match(DIV_ASSIGN);
				break;
			}
			case MOD_ASSIGN:
			{
				AST tmp181_AST = null;
				tmp181_AST = astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp181_AST);
				match(MOD_ASSIGN);
				break;
			}
			case SR_ASSIGN:
			{
				AST tmp182_AST = null;
				tmp182_AST = astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp182_AST);
				match(SR_ASSIGN);
				break;
			}
			case BSR_ASSIGN:
			{
				AST tmp183_AST = null;
				tmp183_AST = astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp183_AST);
				match(BSR_ASSIGN);
				break;
			}
			case SL_ASSIGN:
			{
				AST tmp184_AST = null;
				tmp184_AST = astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp184_AST);
				match(SL_ASSIGN);
				break;
			}
			case BAND_ASSIGN:
			{
				AST tmp185_AST = null;
				tmp185_AST = astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp185_AST);
				match(BAND_ASSIGN);
				break;
			}
			case BXOR_ASSIGN:
			{
				AST tmp186_AST = null;
				tmp186_AST = astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp186_AST);
				match(BXOR_ASSIGN);
				break;
			}
			case BOR_ASSIGN:
			{
				AST tmp187_AST = null;
				tmp187_AST = astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp187_AST);
				match(BOR_ASSIGN);
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			{
			boolean synPredMatched348 = false;
			if (((_tokenSet_22.member(LA(1))) && (_tokenSet_23.member(LA(2))))) {
				int _m348 = mark();
				synPredMatched348 = true;
				inputState.guessing++;
				try {
					{
					lambdaExpression();
					}
				}
				catch (RecognitionException pe) {
					synPredMatched348 = false;
				}
				rewind(_m348);
inputState.guessing--;
			}
			if ( synPredMatched348 ) {
				lambdaExpression();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else if ((_tokenSet_19.member(LA(1))) && (_tokenSet_63.member(LA(2)))) {
				assignmentExpression();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else {
				throw new NoViableAltException(LT(1), getFilename());
			}
			
			}
			break;
		}
		case FINAL:
		case ABSTRACT:
		case STRICTFP:
		case SEMI:
		case RBRACK:
		case LITERAL_void:
		case LITERAL_boolean:
		case LITERAL_byte:
		case LITERAL_char:
		case LITERAL_short:
		case LITERAL_int:
		case LITERAL_float:
		case LITERAL_long:
		case LITERAL_double:
		case IDENT:
		case STAR:
		case LITERAL_private:
		case LITERAL_public:
		case LITERAL_protected:
		case LITERAL_static:
		case LITERAL_transient:
		case LITERAL_native:
		case LITERAL_synchronized:
		case LITERAL_volatile:
		case LITERAL_class:
		case LITERAL_interface:
		case LCURLY:
		case RCURLY:
		case COMMA:
		case LPAREN:
		case RPAREN:
		case LITERAL_this:
		case LITERAL_super:
		case COLON:
		case LITERAL_if:
		case LITERAL_while:
		case LITERAL_do:
		case LITERAL_break:
		case LITERAL_continue:
		case LITERAL_return:
		case LITERAL_switch:
		case LITERAL_throw:
		case LITERAL_for:
		case LITERAL_else:
		case LITERAL_case:
		case LITERAL_default:
		case LITERAL_try:
		case LT:
		case GT:
		case LE:
		case GE:
		case LITERAL_instanceof:
		case SL:
		case SR:
		case BSR:
		case PLUS:
		case MINUS:
		case DIV:
		case MOD:
		case INC:
		case DEC:
		case BNOT:
		case LNOT:
		case LITERAL_true:
		case LITERAL_false:
		case LITERAL_null:
		case LITERAL_new:
		case NUM_INT:
		case CHAR_LITERAL:
		case STRING_LITERAL:
		case NUM_FLOAT:
		case NUM_LONG:
		case NUM_DOUBLE:
		case ASSERT:
		case ENUM:
		case AT:
		case LITERAL_record:
		case TEXT_BLOCK_CONTENT:
		case LITERAL_yield:
		case LITERAL_sealed:
		case LITERAL_permits:
		case LITERAL_non:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		assignmentExpression_AST = (AST)currentAST.root;
		returnAST = assignmentExpression_AST;
	}
	
	public final void logicalOrExpression() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST logicalOrExpression_AST = null;
		
		logicalAndExpression();
		astFactory.addASTChild(currentAST, returnAST);
		{
		_loop359:
		do {
			if ((LA(1)==LOR)) {
				AST tmp188_AST = null;
				tmp188_AST = astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp188_AST);
				match(LOR);
				logicalAndExpression();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else {
				break _loop359;
			}
			
		} while (true);
		}
		logicalOrExpression_AST = (AST)currentAST.root;
		returnAST = logicalOrExpression_AST;
	}
	
	public final void logicalAndExpression() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST logicalAndExpression_AST = null;
		
		inclusiveOrExpression();
		astFactory.addASTChild(currentAST, returnAST);
		{
		_loop362:
		do {
			if ((LA(1)==LAND)) {
				AST tmp189_AST = null;
				tmp189_AST = astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp189_AST);
				match(LAND);
				inclusiveOrExpression();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else {
				break _loop362;
			}
			
		} while (true);
		}
		logicalAndExpression_AST = (AST)currentAST.root;
		returnAST = logicalAndExpression_AST;
	}
	
	public final void inclusiveOrExpression() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST inclusiveOrExpression_AST = null;
		
		exclusiveOrExpression();
		astFactory.addASTChild(currentAST, returnAST);
		{
		_loop365:
		do {
			if ((LA(1)==BOR)) {
				AST tmp190_AST = null;
				tmp190_AST = astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp190_AST);
				match(BOR);
				exclusiveOrExpression();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else {
				break _loop365;
			}
			
		} while (true);
		}
		inclusiveOrExpression_AST = (AST)currentAST.root;
		returnAST = inclusiveOrExpression_AST;
	}
	
	public final void exclusiveOrExpression() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST exclusiveOrExpression_AST = null;
		
		andExpression();
		astFactory.addASTChild(currentAST, returnAST);
		{
		_loop368:
		do {
			if ((LA(1)==BXOR)) {
				AST tmp191_AST = null;
				tmp191_AST = astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp191_AST);
				match(BXOR);
				andExpression();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else {
				break _loop368;
			}
			
		} while (true);
		}
		exclusiveOrExpression_AST = (AST)currentAST.root;
		returnAST = exclusiveOrExpression_AST;
	}
	
	public final void andExpression() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST andExpression_AST = null;
		
		equalityExpression();
		astFactory.addASTChild(currentAST, returnAST);
		{
		_loop371:
		do {
			if ((LA(1)==BAND)) {
				AST tmp192_AST = null;
				tmp192_AST = astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp192_AST);
				match(BAND);
				equalityExpression();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else {
				break _loop371;
			}
			
		} while (true);
		}
		andExpression_AST = (AST)currentAST.root;
		returnAST = andExpression_AST;
	}
	
	public final void equalityExpression() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST equalityExpression_AST = null;
		
		relationalExpression();
		astFactory.addASTChild(currentAST, returnAST);
		{
		_loop375:
		do {
			if ((LA(1)==NOT_EQUAL||LA(1)==EQUAL)) {
				{
				switch ( LA(1)) {
				case NOT_EQUAL:
				{
					AST tmp193_AST = null;
					tmp193_AST = astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp193_AST);
					match(NOT_EQUAL);
					break;
				}
				case EQUAL:
				{
					AST tmp194_AST = null;
					tmp194_AST = astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp194_AST);
					match(EQUAL);
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
				relationalExpression();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else {
				break _loop375;
			}
			
		} while (true);
		}
		equalityExpression_AST = (AST)currentAST.root;
		returnAST = equalityExpression_AST;
	}
	
	public final void relationalExpression() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST relationalExpression_AST = null;
		
		shiftExpression();
		astFactory.addASTChild(currentAST, returnAST);
		{
		if ((LA(1)==LITERAL_instanceof) && (_tokenSet_69.member(LA(2)))) {
			AST tmp195_AST = null;
			tmp195_AST = astFactory.create(LT(1));
			astFactory.makeASTRoot(currentAST, tmp195_AST);
			match(LITERAL_instanceof);
			{
			boolean synPredMatched380 = false;
			if (((_tokenSet_69.member(LA(1))) && (_tokenSet_70.member(LA(2))))) {
				int _m380 = mark();
				synPredMatched380 = true;
				inputState.guessing++;
				try {
					{
					modifiers();
					typeSpec(true);
					match(IDENT);
					}
				}
				catch (RecognitionException pe) {
					synPredMatched380 = false;
				}
				rewind(_m380);
inputState.guessing--;
			}
			if ( synPredMatched380 ) {
				patternDefinition();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else if ((_tokenSet_15.member(LA(1))) && (_tokenSet_85.member(LA(2)))) {
				instanceofTypeSpec();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else {
				throw new NoViableAltException(LT(1), getFilename());
			}
			
			}
		}
		else if ((_tokenSet_79.member(LA(1))) && (_tokenSet_62.member(LA(2)))) {
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		{
		{
		_loop384:
		do {
			if (((LA(1) >= LT && LA(1) <= GE)) && (_tokenSet_19.member(LA(2)))) {
				{
				switch ( LA(1)) {
				case LT:
				{
					AST tmp196_AST = null;
					tmp196_AST = astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp196_AST);
					match(LT);
					break;
				}
				case GT:
				{
					AST tmp197_AST = null;
					tmp197_AST = astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp197_AST);
					match(GT);
					break;
				}
				case LE:
				{
					AST tmp198_AST = null;
					tmp198_AST = astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp198_AST);
					match(LE);
					break;
				}
				case GE:
				{
					AST tmp199_AST = null;
					tmp199_AST = astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp199_AST);
					match(GE);
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
				shiftExpression();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else {
				break _loop384;
			}
			
		} while (true);
		}
		}
		relationalExpression_AST = (AST)currentAST.root;
		returnAST = relationalExpression_AST;
	}
	
	public final void shiftExpression() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST shiftExpression_AST = null;
		
		additiveExpression();
		astFactory.addASTChild(currentAST, returnAST);
		{
		_loop391:
		do {
			if (((LA(1) >= SL && LA(1) <= BSR)) && (_tokenSet_19.member(LA(2)))) {
				{
				switch ( LA(1)) {
				case SL:
				{
					AST tmp200_AST = null;
					tmp200_AST = astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp200_AST);
					match(SL);
					break;
				}
				case SR:
				{
					AST tmp201_AST = null;
					tmp201_AST = astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp201_AST);
					match(SR);
					break;
				}
				case BSR:
				{
					AST tmp202_AST = null;
					tmp202_AST = astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp202_AST);
					match(BSR);
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
				additiveExpression();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else {
				break _loop391;
			}
			
		} while (true);
		}
		shiftExpression_AST = (AST)currentAST.root;
		returnAST = shiftExpression_AST;
	}
	
	public final void patternDefinition() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST patternDefinition_AST = null;
		AST v_AST = null;
		
		patternVariableDefinition();
		v_AST = (AST)returnAST;
		if ( inputState.guessing==0 ) {
			patternDefinition_AST = (AST)currentAST.root;
			patternDefinition_AST = v_AST;
			currentAST.root = patternDefinition_AST;
			currentAST.child = patternDefinition_AST!=null &&patternDefinition_AST.getFirstChild()!=null ?
				patternDefinition_AST.getFirstChild() : patternDefinition_AST;
			currentAST.advanceChildToEnd();
		}
		returnAST = patternDefinition_AST;
	}
	
	public final void instanceofTypeSpec() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST instanceofTypeSpec_AST = null;
		AST t_AST = null;
		
		typeSpec(true);
		t_AST = (AST)returnAST;
		if ( inputState.guessing==0 ) {
			instanceofTypeSpec_AST = (AST)currentAST.root;
			instanceofTypeSpec_AST = t_AST;
			currentAST.root = instanceofTypeSpec_AST;
			currentAST.child = instanceofTypeSpec_AST!=null &&instanceofTypeSpec_AST.getFirstChild()!=null ?
				instanceofTypeSpec_AST.getFirstChild() : instanceofTypeSpec_AST;
			currentAST.advanceChildToEnd();
		}
		returnAST = instanceofTypeSpec_AST;
	}
	
	public final void patternVariableDefinition() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST patternVariableDefinition_AST = null;
		AST m_AST = null;
		AST t_AST = null;
		Token  i = null;
		AST i_AST = null;
		
		modifiers();
		m_AST = (AST)returnAST;
		typeSpec(true);
		t_AST = (AST)returnAST;
		i = LT(1);
		i_AST = astFactory.create(i);
		match(IDENT);
		if ( inputState.guessing==0 ) {
			patternVariableDefinition_AST = (AST)currentAST.root;
			patternVariableDefinition_AST = (AST)astFactory.make( (new ASTArray(4)).add(astFactory.create(PATTERN_VARIABLE_DEF,"PATTERN_VARIABLE_DEF")).add(m_AST).add(t_AST).add(i_AST));
			currentAST.root = patternVariableDefinition_AST;
			currentAST.child = patternVariableDefinition_AST!=null &&patternVariableDefinition_AST.getFirstChild()!=null ?
				patternVariableDefinition_AST.getFirstChild() : patternVariableDefinition_AST;
			currentAST.advanceChildToEnd();
		}
		returnAST = patternVariableDefinition_AST;
	}
	
	public final void additiveExpression() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST additiveExpression_AST = null;
		
		multiplicativeExpression();
		astFactory.addASTChild(currentAST, returnAST);
		{
		_loop395:
		do {
			if ((LA(1)==PLUS||LA(1)==MINUS) && (_tokenSet_19.member(LA(2)))) {
				{
				switch ( LA(1)) {
				case PLUS:
				{
					AST tmp203_AST = null;
					tmp203_AST = astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp203_AST);
					match(PLUS);
					break;
				}
				case MINUS:
				{
					AST tmp204_AST = null;
					tmp204_AST = astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp204_AST);
					match(MINUS);
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
				multiplicativeExpression();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else {
				break _loop395;
			}
			
		} while (true);
		}
		additiveExpression_AST = (AST)currentAST.root;
		returnAST = additiveExpression_AST;
	}
	
	public final void multiplicativeExpression() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST multiplicativeExpression_AST = null;
		
		unaryExpression();
		astFactory.addASTChild(currentAST, returnAST);
		{
		_loop399:
		do {
			if ((_tokenSet_86.member(LA(1))) && (_tokenSet_19.member(LA(2)))) {
				{
				switch ( LA(1)) {
				case STAR:
				{
					AST tmp205_AST = null;
					tmp205_AST = astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp205_AST);
					match(STAR);
					break;
				}
				case DIV:
				{
					AST tmp206_AST = null;
					tmp206_AST = astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp206_AST);
					match(DIV);
					break;
				}
				case MOD:
				{
					AST tmp207_AST = null;
					tmp207_AST = astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp207_AST);
					match(MOD);
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
				unaryExpression();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else {
				break _loop399;
			}
			
		} while (true);
		}
		multiplicativeExpression_AST = (AST)currentAST.root;
		returnAST = multiplicativeExpression_AST;
	}
	
	public final void unaryExpression() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST unaryExpression_AST = null;
		
		switch ( LA(1)) {
		case INC:
		{
			AST tmp208_AST = null;
			tmp208_AST = astFactory.create(LT(1));
			astFactory.makeASTRoot(currentAST, tmp208_AST);
			match(INC);
			unaryExpression();
			astFactory.addASTChild(currentAST, returnAST);
			unaryExpression_AST = (AST)currentAST.root;
			break;
		}
		case DEC:
		{
			AST tmp209_AST = null;
			tmp209_AST = astFactory.create(LT(1));
			astFactory.makeASTRoot(currentAST, tmp209_AST);
			match(DEC);
			unaryExpression();
			astFactory.addASTChild(currentAST, returnAST);
			unaryExpression_AST = (AST)currentAST.root;
			break;
		}
		case MINUS:
		{
			AST tmp210_AST = null;
			tmp210_AST = astFactory.create(LT(1));
			astFactory.makeASTRoot(currentAST, tmp210_AST);
			match(MINUS);
			if ( inputState.guessing==0 ) {
				tmp210_AST.setType(UNARY_MINUS);
			}
			unaryExpression();
			astFactory.addASTChild(currentAST, returnAST);
			unaryExpression_AST = (AST)currentAST.root;
			break;
		}
		case PLUS:
		{
			AST tmp211_AST = null;
			tmp211_AST = astFactory.create(LT(1));
			astFactory.makeASTRoot(currentAST, tmp211_AST);
			match(PLUS);
			if ( inputState.guessing==0 ) {
				tmp211_AST.setType(UNARY_PLUS);
			}
			unaryExpression();
			astFactory.addASTChild(currentAST, returnAST);
			unaryExpression_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_void:
		case LITERAL_boolean:
		case LITERAL_byte:
		case LITERAL_char:
		case LITERAL_short:
		case LITERAL_int:
		case LITERAL_float:
		case LITERAL_long:
		case LITERAL_double:
		case IDENT:
		case LPAREN:
		case LITERAL_this:
		case LITERAL_super:
		case LITERAL_switch:
		case BNOT:
		case LNOT:
		case LITERAL_true:
		case LITERAL_false:
		case LITERAL_null:
		case LITERAL_new:
		case NUM_INT:
		case CHAR_LITERAL:
		case STRING_LITERAL:
		case NUM_FLOAT:
		case NUM_LONG:
		case NUM_DOUBLE:
		case AT:
		case LITERAL_record:
		case TEXT_BLOCK_CONTENT:
		case LITERAL_yield:
		case LITERAL_sealed:
		case LITERAL_permits:
		case LITERAL_non:
		{
			unaryExpressionNotPlusMinus();
			astFactory.addASTChild(currentAST, returnAST);
			unaryExpression_AST = (AST)currentAST.root;
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		returnAST = unaryExpression_AST;
	}
	
	public final void unaryExpressionNotPlusMinus() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST unaryExpressionNotPlusMinus_AST = null;
		
		switch ( LA(1)) {
		case BNOT:
		{
			AST tmp212_AST = null;
			tmp212_AST = astFactory.create(LT(1));
			astFactory.makeASTRoot(currentAST, tmp212_AST);
			match(BNOT);
			unaryExpression();
			astFactory.addASTChild(currentAST, returnAST);
			unaryExpressionNotPlusMinus_AST = (AST)currentAST.root;
			break;
		}
		case LNOT:
		{
			AST tmp213_AST = null;
			tmp213_AST = astFactory.create(LT(1));
			astFactory.makeASTRoot(currentAST, tmp213_AST);
			match(LNOT);
			unaryExpression();
			astFactory.addASTChild(currentAST, returnAST);
			unaryExpressionNotPlusMinus_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_void:
		case LITERAL_boolean:
		case LITERAL_byte:
		case LITERAL_char:
		case LITERAL_short:
		case LITERAL_int:
		case LITERAL_float:
		case LITERAL_long:
		case LITERAL_double:
		case IDENT:
		case LPAREN:
		case LITERAL_this:
		case LITERAL_super:
		case LITERAL_true:
		case LITERAL_false:
		case LITERAL_null:
		case LITERAL_new:
		case NUM_INT:
		case CHAR_LITERAL:
		case STRING_LITERAL:
		case NUM_FLOAT:
		case NUM_LONG:
		case NUM_DOUBLE:
		case AT:
		case LITERAL_record:
		case TEXT_BLOCK_CONTENT:
		case LITERAL_yield:
		case LITERAL_sealed:
		case LITERAL_permits:
		case LITERAL_non:
		{
			castExpression();
			astFactory.addASTChild(currentAST, returnAST);
			unaryExpressionNotPlusMinus_AST = (AST)currentAST.root;
			break;
		}
		case LITERAL_switch:
		{
			switchExpression();
			astFactory.addASTChild(currentAST, returnAST);
			unaryExpressionNotPlusMinus_AST = (AST)currentAST.root;
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		returnAST = unaryExpressionNotPlusMinus_AST;
	}
	
	public final void castExpression() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST castExpression_AST = null;
		Token  lpb = null;
		AST lpb_AST = null;
		Token  lpl = null;
		AST lpl_AST = null;
		Token  lp = null;
		AST lp_AST = null;
		
		{
		boolean synPredMatched405 = false;
		if (((LA(1)==LPAREN) && ((LA(2) >= LITERAL_void && LA(2) <= LITERAL_double)))) {
			int _m405 = mark();
			synPredMatched405 = true;
			inputState.guessing++;
			try {
				{
				match(LPAREN);
				builtInTypeSpec(true);
				match(RPAREN);
				unaryExpression();
				}
			}
			catch (RecognitionException pe) {
				synPredMatched405 = false;
			}
			rewind(_m405);
inputState.guessing--;
		}
		if ( synPredMatched405 ) {
			lpb = LT(1);
			lpb_AST = astFactory.create(lpb);
			astFactory.makeASTRoot(currentAST, lpb_AST);
			match(LPAREN);
			if ( inputState.guessing==0 ) {
				lpb_AST.setType(TYPECAST);
			}
			builtInTypeSpec(true);
			astFactory.addASTChild(currentAST, returnAST);
			AST tmp214_AST = null;
			tmp214_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp214_AST);
			match(RPAREN);
			unaryExpression();
			astFactory.addASTChild(currentAST, returnAST);
		}
		else {
			boolean synPredMatched407 = false;
			if (((LA(1)==LPAREN) && (_tokenSet_10.member(LA(2))))) {
				int _m407 = mark();
				synPredMatched407 = true;
				inputState.guessing++;
				try {
					{
					match(LPAREN);
					typeCastParameters();
					match(RPAREN);
					lambdaExpression();
					}
				}
				catch (RecognitionException pe) {
					synPredMatched407 = false;
				}
				rewind(_m407);
inputState.guessing--;
			}
			if ( synPredMatched407 ) {
				lpl = LT(1);
				lpl_AST = astFactory.create(lpl);
				astFactory.makeASTRoot(currentAST, lpl_AST);
				match(LPAREN);
				if ( inputState.guessing==0 ) {
					lpl_AST.setType(TYPECAST);
				}
				typeCastParameters();
				astFactory.addASTChild(currentAST, returnAST);
				AST tmp215_AST = null;
				tmp215_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp215_AST);
				match(RPAREN);
				lambdaExpression();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else {
				boolean synPredMatched409 = false;
				if (((LA(1)==LPAREN) && (_tokenSet_10.member(LA(2))))) {
					int _m409 = mark();
					synPredMatched409 = true;
					inputState.guessing++;
					try {
						{
						match(LPAREN);
						typeCastParameters();
						match(RPAREN);
						unaryExpressionNotPlusMinus();
						}
					}
					catch (RecognitionException pe) {
						synPredMatched409 = false;
					}
					rewind(_m409);
inputState.guessing--;
				}
				if ( synPredMatched409 ) {
					lp = LT(1);
					lp_AST = astFactory.create(lp);
					astFactory.makeASTRoot(currentAST, lp_AST);
					match(LPAREN);
					if ( inputState.guessing==0 ) {
						lp_AST.setType(TYPECAST);
					}
					typeCastParameters();
					astFactory.addASTChild(currentAST, returnAST);
					AST tmp216_AST = null;
					tmp216_AST = astFactory.create(LT(1));
					astFactory.addASTChild(currentAST, tmp216_AST);
					match(RPAREN);
					unaryExpressionNotPlusMinus();
					astFactory.addASTChild(currentAST, returnAST);
				}
				else if ((_tokenSet_58.member(LA(1))) && (_tokenSet_25.member(LA(2)))) {
					postfixExpression();
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					throw new NoViableAltException(LT(1), getFilename());
				}
				}}
				}
				castExpression_AST = (AST)currentAST.root;
				returnAST = castExpression_AST;
			}
			
	public final void typeCastParameters() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST typeCastParameters_AST = null;
		Token  b = null;
		AST b_AST = null;
		
		classTypeSpec(true);
		astFactory.addASTChild(currentAST, returnAST);
		{
		_loop413:
		do {
			if ((LA(1)==BAND)) {
				b = LT(1);
				b_AST = astFactory.create(b);
				astFactory.addASTChild(currentAST, b_AST);
				match(BAND);
				if ( inputState.guessing==0 ) {
					b_AST.setType(TYPE_EXTENSION_AND);
				}
				classTypeSpec(true);
				astFactory.addASTChild(currentAST, returnAST);
			}
			else {
				break _loop413;
			}
			
		} while (true);
		}
		typeCastParameters_AST = (AST)currentAST.root;
		returnAST = typeCastParameters_AST;
	}
	
	public final void postfixExpression() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST postfixExpression_AST = null;
		Token  dc = null;
		AST dc_AST = null;
		Token  lbc = null;
		AST lbc_AST = null;
		Token  lb = null;
		AST lb_AST = null;
		Token  lp = null;
		AST lp_AST = null;
		Token  in = null;
		AST in_AST = null;
		Token  de = null;
		AST de_AST = null;
		
		primaryExpression();
		astFactory.addASTChild(currentAST, returnAST);
		{
		_loop425:
		do {
			switch ( LA(1)) {
			case DOT:
			{
				AST tmp217_AST = null;
				tmp217_AST = astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp217_AST);
				match(DOT);
				{
				switch ( LA(1)) {
				case IDENT:
				case LITERAL_this:
				case LITERAL_super:
				case LT:
				case LITERAL_record:
				case LITERAL_yield:
				case LITERAL_sealed:
				case LITERAL_permits:
				case LITERAL_non:
				{
					{
					switch ( LA(1)) {
					case LT:
					{
						typeArguments(false);
						astFactory.addASTChild(currentAST, returnAST);
						break;
					}
					case IDENT:
					case LITERAL_this:
					case LITERAL_super:
					case LITERAL_record:
					case LITERAL_yield:
					case LITERAL_sealed:
					case LITERAL_permits:
					case LITERAL_non:
					{
						break;
					}
					default:
					{
						throw new NoViableAltException(LT(1), getFilename());
					}
					}
					}
					{
					switch ( LA(1)) {
					case IDENT:
					case LITERAL_record:
					case LITERAL_yield:
					case LITERAL_sealed:
					case LITERAL_permits:
					case LITERAL_non:
					{
						id();
						astFactory.addASTChild(currentAST, returnAST);
						break;
					}
					case LITERAL_this:
					{
						AST tmp218_AST = null;
						tmp218_AST = astFactory.create(LT(1));
						astFactory.addASTChild(currentAST, tmp218_AST);
						match(LITERAL_this);
						break;
					}
					case LITERAL_super:
					{
						AST tmp219_AST = null;
						tmp219_AST = astFactory.create(LT(1));
						astFactory.addASTChild(currentAST, tmp219_AST);
						match(LITERAL_super);
						break;
					}
					default:
					{
						throw new NoViableAltException(LT(1), getFilename());
					}
					}
					}
					break;
				}
				case LITERAL_class:
				{
					AST tmp220_AST = null;
					tmp220_AST = astFactory.create(LT(1));
					astFactory.addASTChild(currentAST, tmp220_AST);
					match(LITERAL_class);
					break;
				}
				case LITERAL_new:
				{
					newExpression();
					astFactory.addASTChild(currentAST, returnAST);
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
				break;
			}
			case DOUBLE_COLON:
			{
				dc = LT(1);
				dc_AST = astFactory.create(dc);
				astFactory.makeASTRoot(currentAST, dc_AST);
				match(DOUBLE_COLON);
				if ( inputState.guessing==0 ) {
					dc_AST.setType(METHOD_REF);
				}
				{
				{
				switch ( LA(1)) {
				case LT:
				{
					typeArguments(false);
					astFactory.addASTChild(currentAST, returnAST);
					break;
				}
				case IDENT:
				case LITERAL_new:
				case LITERAL_record:
				case LITERAL_yield:
				case LITERAL_sealed:
				case LITERAL_permits:
				case LITERAL_non:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
				{
				switch ( LA(1)) {
				case IDENT:
				case LITERAL_record:
				case LITERAL_yield:
				case LITERAL_sealed:
				case LITERAL_permits:
				case LITERAL_non:
				{
					id();
					astFactory.addASTChild(currentAST, returnAST);
					break;
				}
				case LITERAL_new:
				{
					AST tmp221_AST = null;
					tmp221_AST = astFactory.create(LT(1));
					astFactory.addASTChild(currentAST, tmp221_AST);
					match(LITERAL_new);
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
				}
				break;
			}
			default:
				if ((LA(1)==LBRACK) && (LA(2)==RBRACK)) {
					{
					int _cnt423=0;
					_loop423:
					do {
						if ((LA(1)==LBRACK) && (LA(2)==RBRACK)) {
							lbc = LT(1);
							lbc_AST = astFactory.create(lbc);
							astFactory.makeASTRoot(currentAST, lbc_AST);
							match(LBRACK);
							if ( inputState.guessing==0 ) {
								lbc_AST.setType(ARRAY_DECLARATOR);
							}
							AST tmp222_AST = null;
							tmp222_AST = astFactory.create(LT(1));
							astFactory.addASTChild(currentAST, tmp222_AST);
							match(RBRACK);
						}
						else {
							if ( _cnt423>=1 ) { break _loop423; } else {throw new NoViableAltException(LT(1), getFilename());}
						}
						
						_cnt423++;
					} while (true);
					}
					{
					if ((LA(1)==DOT) && (LA(2)==LITERAL_class)) {
						AST tmp223_AST = null;
						tmp223_AST = astFactory.create(LT(1));
						astFactory.makeASTRoot(currentAST, tmp223_AST);
						match(DOT);
						AST tmp224_AST = null;
						tmp224_AST = astFactory.create(LT(1));
						astFactory.addASTChild(currentAST, tmp224_AST);
						match(LITERAL_class);
					}
					else if ((_tokenSet_61.member(LA(1))) && (_tokenSet_62.member(LA(2)))) {
					}
					else {
						throw new NoViableAltException(LT(1), getFilename());
					}
					
					}
				}
				else if ((LA(1)==LBRACK) && (_tokenSet_19.member(LA(2)))) {
					lb = LT(1);
					lb_AST = astFactory.create(lb);
					astFactory.makeASTRoot(currentAST, lb_AST);
					match(LBRACK);
					if ( inputState.guessing==0 ) {
						lb_AST.setType(INDEX_OP);
					}
					expression();
					astFactory.addASTChild(currentAST, returnAST);
					AST tmp225_AST = null;
					tmp225_AST = astFactory.create(LT(1));
					astFactory.addASTChild(currentAST, tmp225_AST);
					match(RBRACK);
				}
				else if ((LA(1)==LPAREN) && (_tokenSet_87.member(LA(2)))) {
					lp = LT(1);
					lp_AST = astFactory.create(lp);
					astFactory.makeASTRoot(currentAST, lp_AST);
					match(LPAREN);
					if ( inputState.guessing==0 ) {
						lp_AST.setType(METHOD_CALL);
					}
					argList();
					astFactory.addASTChild(currentAST, returnAST);
					AST tmp226_AST = null;
					tmp226_AST = astFactory.create(LT(1));
					astFactory.addASTChild(currentAST, tmp226_AST);
					match(RPAREN);
				}
			else {
				break _loop425;
			}
			}
		} while (true);
		}
		{
		if ((LA(1)==INC) && (_tokenSet_79.member(LA(2)))) {
			in = LT(1);
			in_AST = astFactory.create(in);
			astFactory.makeASTRoot(currentAST, in_AST);
			match(INC);
			if ( inputState.guessing==0 ) {
				in_AST.setType(POST_INC);
			}
		}
		else if ((LA(1)==DEC) && (_tokenSet_79.member(LA(2)))) {
			de = LT(1);
			de_AST = astFactory.create(de);
			astFactory.makeASTRoot(currentAST, de_AST);
			match(DEC);
			if ( inputState.guessing==0 ) {
				de_AST.setType(POST_DEC);
			}
		}
		else if ((_tokenSet_79.member(LA(1))) && (_tokenSet_62.member(LA(2)))) {
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		postfixExpression_AST = (AST)currentAST.root;
		returnAST = postfixExpression_AST;
	}
	
/** object instantiation.
 *  Trees are built as illustrated by the following input/tree pairs:
 *
 *  new T()
 *
 *  new
 *   |
 *   T --  ELIST
 *           |
 *          arg1 -- arg2 -- .. -- argn
 *
 *  new int[]
 *
 *  new
 *   |
 *  int -- ARRAY_DECLARATOR
 *
 *  new int[] {1,2}
 *
 *  new
 *   |
 *  int -- ARRAY_DECLARATOR -- ARRAY_INIT
 *                                  |
 *                                EXPR -- EXPR
 *                                  |      |
 *                                  1      2
 *
 *  new int[3]
 *  new
 *   |
 *  int -- ARRAY_DECLARATOR
 *                |
 *              EXPR
 *                |
 *                3
 *
 *  new int[1][2]
 *
 *  new
 *   |
 *  int -- ARRAY_DECLARATOR
 *               |
 *         ARRAY_DECLARATOR -- EXPR
 *               |              |
 *             EXPR             1
 *               |
 *               2
 *
 *
 * @throws RecognitionException if recognition problem occurs.
 * @throws TokenStreamException if problem occurs while generating a stream of tokens.
 */
	public final void newExpression() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST newExpression_AST = null;
		
		AST tmp227_AST = null;
		tmp227_AST = astFactory.create(LT(1));
		astFactory.makeASTRoot(currentAST, tmp227_AST);
		match(LITERAL_new);
		{
		switch ( LA(1)) {
		case LT:
		{
			typeArguments(false);
			astFactory.addASTChild(currentAST, returnAST);
			break;
		}
		case LITERAL_void:
		case LITERAL_boolean:
		case LITERAL_byte:
		case LITERAL_char:
		case LITERAL_short:
		case LITERAL_int:
		case LITERAL_float:
		case LITERAL_long:
		case LITERAL_double:
		case IDENT:
		case AT:
		case LITERAL_record:
		case LITERAL_yield:
		case LITERAL_sealed:
		case LITERAL_permits:
		case LITERAL_non:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		type();
		astFactory.addASTChild(currentAST, returnAST);
		{
		switch ( LA(1)) {
		case LPAREN:
		{
			AST tmp228_AST = null;
			tmp228_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp228_AST);
			match(LPAREN);
			argList();
			astFactory.addASTChild(currentAST, returnAST);
			AST tmp229_AST = null;
			tmp229_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp229_AST);
			match(RPAREN);
			{
			if ((LA(1)==LCURLY) && (_tokenSet_40.member(LA(2)))) {
				classBlock();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else if ((_tokenSet_61.member(LA(1))) && (_tokenSet_62.member(LA(2)))) {
			}
			else {
				throw new NoViableAltException(LT(1), getFilename());
			}
			
			}
			break;
		}
		case LBRACK:
		case AT:
		{
			newArrayDeclarator();
			astFactory.addASTChild(currentAST, returnAST);
			{
			if ((LA(1)==LCURLY) && (_tokenSet_88.member(LA(2)))) {
				arrayInitializer();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else if ((_tokenSet_61.member(LA(1))) && (_tokenSet_62.member(LA(2)))) {
			}
			else {
				throw new NoViableAltException(LT(1), getFilename());
			}
			
			}
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		newExpression_AST = (AST)currentAST.root;
		returnAST = newExpression_AST;
	}
	
	public final void constant() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST constant_AST = null;
		
		switch ( LA(1)) {
		case NUM_INT:
		{
			AST tmp230_AST = null;
			tmp230_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp230_AST);
			match(NUM_INT);
			constant_AST = (AST)currentAST.root;
			break;
		}
		case NUM_LONG:
		{
			AST tmp231_AST = null;
			tmp231_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp231_AST);
			match(NUM_LONG);
			constant_AST = (AST)currentAST.root;
			break;
		}
		case NUM_FLOAT:
		{
			AST tmp232_AST = null;
			tmp232_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp232_AST);
			match(NUM_FLOAT);
			constant_AST = (AST)currentAST.root;
			break;
		}
		case NUM_DOUBLE:
		{
			AST tmp233_AST = null;
			tmp233_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp233_AST);
			match(NUM_DOUBLE);
			constant_AST = (AST)currentAST.root;
			break;
		}
		case CHAR_LITERAL:
		{
			AST tmp234_AST = null;
			tmp234_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp234_AST);
			match(CHAR_LITERAL);
			constant_AST = (AST)currentAST.root;
			break;
		}
		case STRING_LITERAL:
		{
			AST tmp235_AST = null;
			tmp235_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp235_AST);
			match(STRING_LITERAL);
			constant_AST = (AST)currentAST.root;
			break;
		}
		case TEXT_BLOCK_CONTENT:
		{
			textBlock();
			astFactory.addASTChild(currentAST, returnAST);
			constant_AST = (AST)currentAST.root;
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		returnAST = constant_AST;
	}
	
	public final void newArrayDeclarator() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST newArrayDeclarator_AST = null;
		Token  lb = null;
		AST lb_AST = null;
		
		{
		int _cnt447=0;
		_loop447:
		do {
			if ((LA(1)==LBRACK||LA(1)==AT) && (_tokenSet_89.member(LA(2)))) {
				{
				if (((LA(1)==LBRACK||LA(1)==AT) && (_tokenSet_89.member(LA(2))))&&(LA(1) == AT)) {
					annotations();
					astFactory.addASTChild(currentAST, returnAST);
				}
				else if ((LA(1)==LBRACK) && (_tokenSet_89.member(LA(2)))) {
				}
				else {
					throw new NoViableAltException(LT(1), getFilename());
				}
				
				}
				lb = LT(1);
				lb_AST = astFactory.create(lb);
				astFactory.makeASTRoot(currentAST, lb_AST);
				match(LBRACK);
				if ( inputState.guessing==0 ) {
					lb_AST.setType(ARRAY_DECLARATOR);
				}
				{
				switch ( LA(1)) {
				case LITERAL_void:
				case LITERAL_boolean:
				case LITERAL_byte:
				case LITERAL_char:
				case LITERAL_short:
				case LITERAL_int:
				case LITERAL_float:
				case LITERAL_long:
				case LITERAL_double:
				case IDENT:
				case LPAREN:
				case LITERAL_this:
				case LITERAL_super:
				case LITERAL_switch:
				case PLUS:
				case MINUS:
				case INC:
				case DEC:
				case BNOT:
				case LNOT:
				case LITERAL_true:
				case LITERAL_false:
				case LITERAL_null:
				case LITERAL_new:
				case NUM_INT:
				case CHAR_LITERAL:
				case STRING_LITERAL:
				case NUM_FLOAT:
				case NUM_LONG:
				case NUM_DOUBLE:
				case AT:
				case LITERAL_record:
				case TEXT_BLOCK_CONTENT:
				case LITERAL_yield:
				case LITERAL_sealed:
				case LITERAL_permits:
				case LITERAL_non:
				{
					expression();
					astFactory.addASTChild(currentAST, returnAST);
					break;
				}
				case RBRACK:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
				AST tmp236_AST = null;
				tmp236_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp236_AST);
				match(RBRACK);
			}
			else {
				if ( _cnt447>=1 ) { break _loop447; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt447++;
		} while (true);
		}
		newArrayDeclarator_AST = (AST)currentAST.root;
		returnAST = newArrayDeclarator_AST;
	}
	
	public final void textBlock() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST textBlock_AST = null;
		Token  c = null;
		AST c_AST = null;
		
		c = LT(1);
		c_AST = astFactory.create(c);
		match(TEXT_BLOCK_CONTENT);
		AST tmp237_AST = null;
		tmp237_AST = astFactory.create(LT(1));
		match(TEXT_BLOCK_LITERAL_END);
		AST tmp238_AST = null;
		tmp238_AST = astFactory.create(LT(1));
		match(TEXT_BLOCK_LITERAL_BEGIN);
		if ( inputState.guessing==0 ) {
			textBlock_AST = (AST)currentAST.root;
			textBlock_AST=(AST)astFactory.make( (new ASTArray(3)).add(tmp238_AST).add(c_AST).add(tmp237_AST));
			currentAST.root = textBlock_AST;
			currentAST.child = textBlock_AST!=null &&textBlock_AST.getFirstChild()!=null ?
				textBlock_AST.getFirstChild() : textBlock_AST;
			currentAST.advanceChildToEnd();
		}
		returnAST = textBlock_AST;
	}
	
	public final void lambdaParameters() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST lambdaParameters_AST = null;
		
		switch ( LA(1)) {
		case IDENT:
		case LITERAL_record:
		case LITERAL_yield:
		case LITERAL_sealed:
		case LITERAL_permits:
		case LITERAL_non:
		{
			id();
			astFactory.addASTChild(currentAST, returnAST);
			lambdaParameters_AST = (AST)currentAST.root;
			break;
		}
		case LPAREN:
		{
			AST tmp239_AST = null;
			tmp239_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp239_AST);
			match(LPAREN);
			{
			if ((_tokenSet_90.member(LA(1))) && (_tokenSet_91.member(LA(2)))) {
				parameterDeclarationList();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else if ((LA(1)==RPAREN) && (LA(2)==LAMBDA)) {
			}
			else {
				throw new NoViableAltException(LT(1), getFilename());
			}
			
			}
			AST tmp240_AST = null;
			tmp240_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp240_AST);
			match(RPAREN);
			lambdaParameters_AST = (AST)currentAST.root;
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		returnAST = lambdaParameters_AST;
	}
	
	public final void lambdaBody() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST lambdaBody_AST = null;
		
		{
		if ((_tokenSet_19.member(LA(1))) && (_tokenSet_25.member(LA(2)))) {
			expression();
			astFactory.addASTChild(currentAST, returnAST);
		}
		else if ((_tokenSet_46.member(LA(1))) && (_tokenSet_25.member(LA(2)))) {
			statement();
			astFactory.addASTChild(currentAST, returnAST);
		}
		else {
			throw new NoViableAltException(LT(1), getFilename());
		}
		
		}
		lambdaBody_AST = (AST)currentAST.root;
		returnAST = lambdaBody_AST;
	}
	
	public final void recordKey() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST recordKey_AST = null;
		
		AST tmp241_AST = null;
		tmp241_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp241_AST);
		match(LITERAL_record);
		if ( inputState.guessing==0 ) {
			recordKey_AST = (AST)currentAST.root;
			recordKey_AST.setType(IDENT);
		}
		recordKey_AST = (AST)currentAST.root;
		returnAST = recordKey_AST;
	}
	
	public final void yieldKey() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST yieldKey_AST = null;
		
		AST tmp242_AST = null;
		tmp242_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp242_AST);
		match(LITERAL_yield);
		if ( inputState.guessing==0 ) {
			yieldKey_AST = (AST)currentAST.root;
			yieldKey_AST.setType(IDENT);
		}
		yieldKey_AST = (AST)currentAST.root;
		returnAST = yieldKey_AST;
	}
	
	public final void nonKey() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST nonKey_AST = null;
		
		AST tmp243_AST = null;
		tmp243_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp243_AST);
		match(LITERAL_non);
		if ( inputState.guessing==0 ) {
			nonKey_AST = (AST)currentAST.root;
			nonKey_AST.setType(IDENT);
		}
		nonKey_AST = (AST)currentAST.root;
		returnAST = nonKey_AST;
	}
	
	public final void sealedKey() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST sealedKey_AST = null;
		
		AST tmp244_AST = null;
		tmp244_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp244_AST);
		match(LITERAL_sealed);
		if ( inputState.guessing==0 ) {
			sealedKey_AST = (AST)currentAST.root;
			sealedKey_AST.setType(IDENT);
		}
		sealedKey_AST = (AST)currentAST.root;
		returnAST = sealedKey_AST;
	}
	
	public final void permitsKey() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST permitsKey_AST = null;
		
		AST tmp245_AST = null;
		tmp245_AST = astFactory.create(LT(1));
		astFactory.addASTChild(currentAST, tmp245_AST);
		match(LITERAL_permits);
		if ( inputState.guessing==0 ) {
			permitsKey_AST = (AST)currentAST.root;
			permitsKey_AST.setType(IDENT);
		}
		permitsKey_AST = (AST)currentAST.root;
		returnAST = permitsKey_AST;
	}
	
	
	public static final String[] _tokenNames = {
		"<0>",
		"EOF",
		"<2>",
		"NULL_TREE_LOOKAHEAD",
		"BLOCK",
		"MODIFIERS",
		"OBJBLOCK",
		"SLIST",
		"CTOR_DEF",
		"METHOD_DEF",
		"VARIABLE_DEF",
		"INSTANCE_INIT",
		"STATIC_INIT",
		"TYPE",
		"CLASS_DEF",
		"INTERFACE_DEF",
		"PACKAGE_DEF",
		"ARRAY_DECLARATOR",
		"EXTENDS_CLAUSE",
		"IMPLEMENTS_CLAUSE",
		"PARAMETERS",
		"PARAMETER_DEF",
		"LABELED_STAT",
		"TYPECAST",
		"INDEX_OP",
		"POST_INC",
		"POST_DEC",
		"METHOD_CALL",
		"EXPR",
		"ARRAY_INIT",
		"IMPORT",
		"UNARY_MINUS",
		"UNARY_PLUS",
		"CASE_GROUP",
		"ELIST",
		"FOR_INIT",
		"FOR_CONDITION",
		"FOR_ITERATOR",
		"EMPTY_STAT",
		"\"final\"",
		"\"abstract\"",
		"\"strictfp\"",
		"SUPER_CTOR_CALL",
		"CTOR_CALL",
		"\"package\"",
		"SEMI",
		"\"import\"",
		"LBRACK",
		"RBRACK",
		"\"void\"",
		"\"boolean\"",
		"\"byte\"",
		"\"char\"",
		"\"short\"",
		"\"int\"",
		"\"float\"",
		"\"long\"",
		"\"double\"",
		"IDENT",
		"DOT",
		"STAR",
		"\"private\"",
		"\"public\"",
		"\"protected\"",
		"\"static\"",
		"\"transient\"",
		"\"native\"",
		"\"synchronized\"",
		"\"volatile\"",
		"\"class\"",
		"\"extends\"",
		"\"interface\"",
		"LCURLY",
		"RCURLY",
		"COMMA",
		"\"implements\"",
		"LPAREN",
		"RPAREN",
		"\"this\"",
		"\"super\"",
		"ASSIGN",
		"\"throws\"",
		"COLON",
		"\"if\"",
		"\"while\"",
		"\"do\"",
		"\"break\"",
		"\"continue\"",
		"\"return\"",
		"\"switch\"",
		"\"throw\"",
		"\"for\"",
		"\"else\"",
		"\"case\"",
		"\"default\"",
		"\"try\"",
		"\"catch\"",
		"\"finally\"",
		"PLUS_ASSIGN",
		"MINUS_ASSIGN",
		"STAR_ASSIGN",
		"DIV_ASSIGN",
		"MOD_ASSIGN",
		"SR_ASSIGN",
		"BSR_ASSIGN",
		"SL_ASSIGN",
		"BAND_ASSIGN",
		"BXOR_ASSIGN",
		"BOR_ASSIGN",
		"QUESTION",
		"LOR",
		"LAND",
		"BOR",
		"BXOR",
		"BAND",
		"NOT_EQUAL",
		"EQUAL",
		"LT",
		"GT",
		"LE",
		"GE",
		"\"instanceof\"",
		"SL",
		"SR",
		"BSR",
		"PLUS",
		"MINUS",
		"DIV",
		"MOD",
		"INC",
		"DEC",
		"BNOT",
		"LNOT",
		"\"true\"",
		"\"false\"",
		"\"null\"",
		"\"new\"",
		"NUM_INT",
		"CHAR_LITERAL",
		"STRING_LITERAL",
		"NUM_FLOAT",
		"NUM_LONG",
		"NUM_DOUBLE",
		"WS",
		"SINGLE_LINE_COMMENT",
		"BLOCK_COMMENT_BEGIN",
		"ESC",
		"HEX_DIGIT",
		"VOCAB",
		"EXPONENT",
		"FLOAT_SUFFIX",
		"ASSERT",
		"STATIC_IMPORT",
		"ENUM",
		"ENUM_DEF",
		"ENUM_CONSTANT_DEF",
		"FOR_EACH_CLAUSE",
		"ANNOTATION_DEF",
		"ANNOTATIONS",
		"ANNOTATION",
		"ANNOTATION_MEMBER_VALUE_PAIR",
		"ANNOTATION_FIELD_DEF",
		"ANNOTATION_ARRAY_INIT",
		"TYPE_ARGUMENTS",
		"TYPE_ARGUMENT",
		"TYPE_PARAMETERS",
		"TYPE_PARAMETER",
		"WILDCARD_TYPE",
		"TYPE_UPPER_BOUNDS",
		"TYPE_LOWER_BOUNDS",
		"AT",
		"ELLIPSIS",
		"GENERIC_START",
		"GENERIC_END",
		"TYPE_EXTENSION_AND",
		"DO_WHILE",
		"RESOURCE_SPECIFICATION",
		"RESOURCES",
		"RESOURCE",
		"DOUBLE_COLON",
		"METHOD_REF",
		"LAMBDA",
		"BLOCK_COMMENT_END",
		"COMMENT_CONTENT",
		"SINGLE_LINE_COMMENT_CONTENT",
		"BLOCK_COMMENT_CONTENT",
		"STD_ESC",
		"BINARY_DIGIT",
		"ID_START",
		"ID_PART",
		"INT_LITERAL",
		"LONG_LITERAL",
		"FLOAT_LITERAL",
		"DOUBLE_LITERAL",
		"HEX_FLOAT_LITERAL",
		"HEX_DOUBLE_LITERAL",
		"SIGNED_INTEGER",
		"BINARY_EXPONENT",
		"PATTERN_VARIABLE_DEF",
		"RECORD_DEF",
		"\"record\"",
		"RECORD_COMPONENTS",
		"RECORD_COMPONENT_DEF",
		"COMPACT_CTOR_DEF",
		"TEXT_BLOCK_LITERAL_BEGIN",
		"TEXT_BLOCK_CONTENT",
		"TEXT_BLOCK_LITERAL_END",
		"\"yield\"",
		"SWITCH_RULE",
		"\"non-sealed\"",
		"\"sealed\"",
		"\"permits\"",
		"PERMITS_CLAUSE",
		"\"non\""
	};
	
	protected void buildTokenTypeASTClassMap() {
		tokenTypeToASTClassMap=null;
	};
	
	private static final long[] mk_tokenSet_0() {
		long[] data = new long[8];
		data[0]=288230376151711744L;
		data[3]=2916608L;
		return data;
	}
	public static final BitSet _tokenSet_0 = new BitSet(mk_tokenSet_0());
	private static final long[] mk_tokenSet_1() {
		long[] data = new long[8];
		data[0]=-2305733607806730238L;
		data[1]=1073742015L;
		data[2]=4398080065536L;
		data[3]=2359552L;
		return data;
	}
	public static final BitSet _tokenSet_1 = new BitSet(mk_tokenSet_1());
	private static final long[] mk_tokenSet_2() {
		long[] data = new long[8];
		data[0]=-2017503231655018494L;
		data[1]=4611686019501129919L;
		data[2]=4398080065536L;
		data[3]=2916608L;
		return data;
	}
	public static final BitSet _tokenSet_2 = new BitSet(mk_tokenSet_2());
	private static final long[] mk_tokenSet_3() {
		long[] data = new long[8];
		data[0]=-2017503231655018494L;
		data[1]=1073742015L;
		data[2]=4398080065536L;
		data[3]=2916608L;
		return data;
	}
	public static final BitSet _tokenSet_3 = new BitSet(mk_tokenSet_3());
	private static final long[] mk_tokenSet_4() {
		long[] data = new long[8];
		data[0]=-2305803976550907904L;
		data[1]=1073742015L;
		data[2]=4398080065536L;
		data[3]=2359552L;
		return data;
	}
	public static final BitSet _tokenSet_4 = new BitSet(mk_tokenSet_4());
	private static final long[] mk_tokenSet_5() {
		long[] data = new long[8];
		data[0]=-2305803976550907902L;
		data[1]=1073742015L;
		data[2]=4398080065536L;
		data[3]=2359552L;
		return data;
	}
	public static final BitSet _tokenSet_5 = new BitSet(mk_tokenSet_5());
	private static final long[] mk_tokenSet_6() {
		long[] data = new long[8];
		data[0]=-2305839160922996736L;
		data[1]=1073741855L;
		data[3]=2359296L;
		return data;
	}
	public static final BitSet _tokenSet_6 = new BitSet(mk_tokenSet_6());
	private static final long[] mk_tokenSet_7() {
		long[] data = new long[8];
		data[0]=-1729941358572994560L;
		data[1]=4620693218755870911L;
		data[2]=4398080065536L;
		data[3]=2916608L;
		return data;
	}
	public static final BitSet _tokenSet_7 = new BitSet(mk_tokenSet_7());
	private static final long[] mk_tokenSet_8() {
		long[] data = new long[8];
		data[0]=288511851128422400L;
		data[3]=2916608L;
		return data;
	}
	public static final BitSet _tokenSet_8 = new BitSet(mk_tokenSet_8());
	private static final long[] mk_tokenSet_9() {
		long[] data = { 140737488355328L, 0L, 13194139533312L, 0L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_9 = new BitSet(mk_tokenSet_9());
	private static final long[] mk_tokenSet_10() {
		long[] data = new long[8];
		data[0]=288230376151711744L;
		data[2]=4398046511104L;
		data[3]=2916608L;
		return data;
	}
	public static final BitSet _tokenSet_10 = new BitSet(mk_tokenSet_10());
	private static final long[] mk_tokenSet_11() {
		long[] data = new long[8];
		data[0]=-101704825569280L;
		data[1]=-12885032961L;
		data[2]=11272193249935359L;
		data[3]=2924800L;
		return data;
	}
	public static final BitSet _tokenSet_11 = new BitSet(mk_tokenSet_11());
	private static final long[] mk_tokenSet_12() {
		long[] data = new long[8];
		data[0]=-84112639524862L;
		data[1]=-131073L;
		data[2]=11272193249935359L;
		data[3]=2941184L;
		return data;
	}
	public static final BitSet _tokenSet_12 = new BitSet(mk_tokenSet_12());
	private static final long[] mk_tokenSet_13() {
		long[] data = new long[8];
		data[0]=575897802350002176L;
		data[1]=35184372088832L;
		data[2]=4398046511104L;
		data[3]=2916608L;
		return data;
	}
	public static final BitSet _tokenSet_13 = new BitSet(mk_tokenSet_13());
	private static final long[] mk_tokenSet_14() {
		long[] data = { 0L, 1747396655419752448L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_14 = new BitSet(mk_tokenSet_14());
	private static final long[] mk_tokenSet_15() {
		long[] data = new long[8];
		data[0]=575897802350002176L;
		data[2]=4398046511104L;
		data[3]=2916608L;
		return data;
	}
	public static final BitSet _tokenSet_15 = new BitSet(mk_tokenSet_15());
	private static final long[] mk_tokenSet_16() {
		long[] data = new long[8];
		data[0]=864831865943490560L;
		data[1]=9007199254745088L;
		data[2]=4398046511104L;
		data[3]=2916608L;
		return data;
	}
	public static final BitSet _tokenSet_16 = new BitSet(mk_tokenSet_16());
	private static final long[] mk_tokenSet_17() {
		long[] data = new long[8];
		data[0]=575897802350002176L;
		data[1]=6917529027674689792L;
		data[2]=4398046543870L;
		data[3]=2924800L;
		return data;
	}
	public static final BitSet _tokenSet_17 = new BitSet(mk_tokenSet_17());
	private static final long[] mk_tokenSet_18() {
		long[] data = new long[8];
		data[0]=2305420796748627968L;
		data[1]=-35184338472448L;
		data[2]=2256197860229119L;
		data[3]=2941184L;
		return data;
	}
	public static final BitSet _tokenSet_18 = new BitSet(mk_tokenSet_18());
	private static final long[] mk_tokenSet_19() {
		long[] data = new long[8];
		data[0]=575897802350002176L;
		data[1]=6917529027674689536L;
		data[2]=4398046543870L;
		data[3]=2924800L;
		return data;
	}
	public static final BitSet _tokenSet_19 = new BitSet(mk_tokenSet_19());
	private static final long[] mk_tokenSet_20() {
		long[] data = new long[8];
		data[0]=2305455981120716800L;
		data[1]=-35184338471936L;
		data[2]=2256197860229119L;
		data[3]=2941184L;
		return data;
	}
	public static final BitSet _tokenSet_20 = new BitSet(mk_tokenSet_20());
	private static final long[] mk_tokenSet_21() {
		long[] data = new long[8];
		data[0]=2305420796748627968L;
		data[1]=-35184338479616L;
		data[2]=2256197860229119L;
		data[3]=2941184L;
		return data;
	}
	public static final BitSet _tokenSet_21 = new BitSet(mk_tokenSet_21());
	private static final long[] mk_tokenSet_22() {
		long[] data = new long[8];
		data[0]=288230376151711744L;
		data[1]=4096L;
		data[3]=2916608L;
		return data;
	}
	public static final BitSet _tokenSet_22 = new BitSet(mk_tokenSet_22());
	private static final long[] mk_tokenSet_23() {
		long[] data = new long[8];
		data[0]=575898352105816064L;
		data[1]=24576L;
		data[2]=9011597301252096L;
		data[3]=2916608L;
		return data;
	}
	public static final BitSet _tokenSet_23 = new BitSet(mk_tokenSet_23());
	private static final long[] mk_tokenSet_24() {
		long[] data = new long[8];
		data[0]=2305420796748627968L;
		data[1]=-17145933824L;
		data[2]=2256197860229119L;
		data[3]=2941184L;
		return data;
	}
	public static final BitSet _tokenSet_24 = new BitSet(mk_tokenSet_24());
	private static final long[] mk_tokenSet_25() {
		long[] data = new long[8];
		data[0]=-101704825569280L;
		data[1]=-12885035073L;
		data[2]=11263397156913151L;
		data[3]=2941184L;
		return data;
	}
	public static final BitSet _tokenSet_25 = new BitSet(mk_tokenSet_25());
	private static final long[] mk_tokenSet_26() {
		long[] data = new long[8];
		data[0]=-2017608784771284992L;
		data[1]=1073741855L;
		data[2]=4398046511104L;
		data[3]=2916608L;
		return data;
	}
	public static final BitSet _tokenSet_26 = new BitSet(mk_tokenSet_26());
	private static final long[] mk_tokenSet_27() {
		long[] data = new long[8];
		data[0]=-2017608784771284992L;
		data[1]=4611686019501130015L;
		data[2]=4398046511104L;
		data[3]=2916608L;
		return data;
	}
	public static final BitSet _tokenSet_27 = new BitSet(mk_tokenSet_27());
	private static final long[] mk_tokenSet_28() {
		long[] data = new long[8];
		data[0]=-1729941358572994560L;
		data[1]=9007200328483263L;
		data[2]=4398080065536L;
		data[3]=2916608L;
		return data;
	}
	public static final BitSet _tokenSet_28 = new BitSet(mk_tokenSet_28());
	private static final long[] mk_tokenSet_29() {
		long[] data = new long[8];
		data[0]=-1153304684409126912L;
		data[1]=6926536230385013695L;
		data[2]=4398088486910L;
		data[3]=2924800L;
		return data;
	}
	public static final BitSet _tokenSet_29 = new BitSet(mk_tokenSet_29());
	private static final long[] mk_tokenSet_30() {
		long[] data = new long[8];
		data[0]=864831865943490560L;
		data[1]=9007199254740992L;
		data[2]=4398046511104L;
		data[3]=2916608L;
		return data;
	}
	public static final BitSet _tokenSet_30 = new BitSet(mk_tokenSet_30());
	private static final long[] mk_tokenSet_31() {
		long[] data = new long[8];
		data[0]=864831865943490560L;
		data[1]=9007199254740992L;
		data[2]=13194139533312L;
		data[3]=2916608L;
		return data;
	}
	public static final BitSet _tokenSet_31 = new BitSet(mk_tokenSet_31());
	private static final long[] mk_tokenSet_32() {
		long[] data = new long[8];
		data[0]=-1729906174200905728L;
		data[1]=9007200328951743L;
		data[2]=4398080065536L;
		data[3]=2916608L;
		return data;
	}
	public static final BitSet _tokenSet_32 = new BitSet(mk_tokenSet_32());
	private static final long[] mk_tokenSet_33() {
		long[] data = new long[8];
		data[0]=-101704825569278L;
		data[1]=-12884901953L;
		data[2]=11263397156913151L;
		data[3]=2924800L;
		return data;
	}
	public static final BitSet _tokenSet_33 = new BitSet(mk_tokenSet_33());
	private static final long[] mk_tokenSet_34() {
		long[] data = new long[8];
		data[0]=-1729941358572994560L;
		data[1]=9007200328483007L;
		data[2]=4398080065536L;
		data[3]=2916608L;
		return data;
	}
	public static final BitSet _tokenSet_34 = new BitSet(mk_tokenSet_34());
	private static final long[] mk_tokenSet_35() {
		long[] data = new long[8];
		data[0]=-1153339868781215744L;
		data[1]=4620693218755875007L;
		data[2]=4398080065536L;
		data[3]=2916608L;
		return data;
	}
	public static final BitSet _tokenSet_35 = new BitSet(mk_tokenSet_35());
	private static final long[] mk_tokenSet_36() {
		long[] data = new long[8];
		data[1]=160L;
		data[2]=4398080065536L;
		data[3]=256L;
		return data;
	}
	public static final BitSet _tokenSet_36 = new BitSet(mk_tokenSet_36());
	private static final long[] mk_tokenSet_37() {
		long[] data = new long[8];
		data[0]=288230376151711744L;
		data[1]=128L;
		data[3]=2916608L;
		return data;
	}
	public static final BitSet _tokenSet_37 = new BitSet(mk_tokenSet_37());
	private static final long[] mk_tokenSet_38() {
		long[] data = new long[8];
		data[0]=575897802350002176L;
		data[1]=9007199254740992L;
		data[2]=4398046511104L;
		data[3]=2916608L;
		return data;
	}
	public static final BitSet _tokenSet_38 = new BitSet(mk_tokenSet_38());
	private static final long[] mk_tokenSet_39() {
		long[] data = new long[8];
		data[0]=-1729765436712550400L;
		data[1]=9007200328550335L;
		data[2]=4398080065536L;
		data[3]=2916608L;
		return data;
	}
	public static final BitSet _tokenSet_39 = new BitSet(mk_tokenSet_39());
	private static final long[] mk_tokenSet_40() {
		long[] data = new long[8];
		data[0]=-1729906174200905728L;
		data[1]=9007200328483775L;
		data[2]=4398080065536L;
		data[3]=2916608L;
		return data;
	}
	public static final BitSet _tokenSet_40 = new BitSet(mk_tokenSet_40());
	private static final long[] mk_tokenSet_41() {
		long[] data = new long[8];
		data[0]=-101704825569278L;
		data[1]=-12885035073L;
		data[2]=11263397156913151L;
		data[3]=2924800L;
		return data;
	}
	public static final BitSet _tokenSet_41 = new BitSet(mk_tokenSet_41());
	private static final long[] mk_tokenSet_42() {
		long[] data = new long[8];
		data[0]=575897802350002176L;
		data[1]=9007199254794240L;
		data[2]=4398046543840L;
		data[3]=2924800L;
		return data;
	}
	public static final BitSet _tokenSet_42 = new BitSet(mk_tokenSet_42());
	private static final long[] mk_tokenSet_43() {
		long[] data = new long[8];
		data[0]=1152499292141780992L;
		data[1]=8673968066721271808L;
		data[2]=4398046543870L;
		data[3]=2941184L;
		return data;
	}
	public static final BitSet _tokenSet_43 = new BitSet(mk_tokenSet_43());
	private static final long[] mk_tokenSet_44() {
		long[] data = new long[8];
		data[0]=-1729906174200905728L;
		data[1]=6917529031130272575L;
		data[2]=4398054932478L;
		data[3]=2924800L;
		return data;
	}
	public static final BitSet _tokenSet_44 = new BitSet(mk_tokenSet_44());
	private static final long[] mk_tokenSet_45() {
		long[] data = new long[8];
		data[0]=-383179802279936L;
		data[1]=-13690342465L;
		data[2]=11263397156913151L;
		data[3]=2941184L;
		return data;
	}
	public static final BitSet _tokenSet_45 = new BitSet(mk_tokenSet_45());
	private static final long[] mk_tokenSet_46() {
		long[] data = new long[8];
		data[0]=-1729906174200905728L;
		data[1]=6917529031130272063L;
		data[2]=4398054932478L;
		data[3]=2924800L;
		return data;
	}
	public static final BitSet _tokenSet_46 = new BitSet(mk_tokenSet_46());
	private static final long[] mk_tokenSet_47() {
		long[] data = new long[8];
		data[0]=575897802350002176L;
		data[1]=1747396655419759936L;
		data[2]=4398046511104L;
		data[3]=2916608L;
		return data;
	}
	public static final BitSet _tokenSet_47 = new BitSet(mk_tokenSet_47());
	private static final long[] mk_tokenSet_48() {
		long[] data = new long[8];
		data[0]=-1153304684409126912L;
		data[1]=9007200328498175L;
		data[2]=4398080065536L;
		data[3]=2916608L;
		return data;
	}
	public static final BitSet _tokenSet_48 = new BitSet(mk_tokenSet_48());
	private static final long[] mk_tokenSet_49() {
		long[] data = { 175921860444160L, 66560L, 4398046511104L, 0L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_49 = new BitSet(mk_tokenSet_49());
	private static final long[] mk_tokenSet_50() {
		long[] data = new long[8];
		data[0]=575898352105816064L;
		data[1]=16384L;
		data[2]=4398046511104L;
		data[3]=2916608L;
		return data;
	}
	public static final BitSet _tokenSet_50 = new BitSet(mk_tokenSet_50());
	private static final long[] mk_tokenSet_51() {
		long[] data = new long[8];
		data[0]=1152499292141780992L;
		data[1]=9007199254766592L;
		data[2]=4398046511104L;
		data[3]=2916608L;
		return data;
	}
	public static final BitSet _tokenSet_51 = new BitSet(mk_tokenSet_51());
	private static final long[] mk_tokenSet_52() {
		long[] data = new long[8];
		data[0]=575898352105816064L;
		data[2]=4398046511104L;
		data[3]=2916608L;
		return data;
	}
	public static final BitSet _tokenSet_52 = new BitSet(mk_tokenSet_52());
	private static final long[] mk_tokenSet_53() {
		long[] data = new long[8];
		data[0]=1152499292141780992L;
		data[1]=9007199254740992L;
		data[2]=13194139533312L;
		data[3]=2916608L;
		return data;
	}
	public static final BitSet _tokenSet_53 = new BitSet(mk_tokenSet_53());
	private static final long[] mk_tokenSet_54() {
		long[] data = new long[8];
		data[0]=864726312827224064L;
		data[1]=1280L;
		data[3]=2916608L;
		return data;
	}
	public static final BitSet _tokenSet_54 = new BitSet(mk_tokenSet_54());
	private static final long[] mk_tokenSet_55() {
		long[] data = { 576495936675512320L, 1280L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_55 = new BitSet(mk_tokenSet_55());
	private static final long[] mk_tokenSet_56() {
		long[] data = { 0L, 9007199254790144L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_56 = new BitSet(mk_tokenSet_56());
	private static final long[] mk_tokenSet_57() {
		long[] data = new long[8];
		data[0]=575897802350002176L;
		data[1]=1747431839791894528L;
		data[2]=4398046511104L;
		data[3]=2916608L;
		return data;
	}
	public static final BitSet _tokenSet_57 = new BitSet(mk_tokenSet_57());
	private static final long[] mk_tokenSet_58() {
		long[] data = new long[8];
		data[0]=575897802350002176L;
		data[1]=53248L;
		data[2]=4398046543840L;
		data[3]=2924800L;
		return data;
	}
	public static final BitSet _tokenSet_58 = new BitSet(mk_tokenSet_58());
	private static final long[] mk_tokenSet_59() {
		long[] data = new long[8];
		data[0]=1152499292141780992L;
		data[1]=6926536226929430528L;
		data[2]=4398046543870L;
		data[3]=2941184L;
		return data;
	}
	public static final BitSet _tokenSet_59 = new BitSet(mk_tokenSet_59());
	private static final long[] mk_tokenSet_60() {
		long[] data = new long[8];
		data[0]=2305420796748627968L;
		data[1]=-17146187776L;
		data[2]=2256197860229119L;
		data[3]=2941184L;
		return data;
	}
	public static final BitSet _tokenSet_60 = new BitSet(mk_tokenSet_60());
	private static final long[] mk_tokenSet_61() {
		long[] data = new long[8];
		data[0]=-101704825569280L;
		data[1]=-12885035073L;
		data[2]=11263397156913151L;
		data[3]=2924800L;
		return data;
	}
	public static final BitSet _tokenSet_61 = new BitSet(mk_tokenSet_61());
	private static final long[] mk_tokenSet_62() {
		long[] data = new long[8];
		data[0]=-84112639524862L;
		data[1]=-133185L;
		data[2]=11272193249935359L;
		data[3]=2941184L;
		return data;
	}
	public static final BitSet _tokenSet_62 = new BitSet(mk_tokenSet_62());
	private static final long[] mk_tokenSet_63() {
		long[] data = new long[8];
		data[0]=-101704825569280L;
		data[1]=-12885035073L;
		data[2]=2256197902172159L;
		data[3]=2941184L;
		return data;
	}
	public static final BitSet _tokenSet_63 = new BitSet(mk_tokenSet_63());
	private static final long[] mk_tokenSet_64() {
		long[] data = new long[8];
		data[0]=864831865943490560L;
		data[1]=9007199254757376L;
		data[2]=4398046511104L;
		data[3]=2916608L;
		return data;
	}
	public static final BitSet _tokenSet_64 = new BitSet(mk_tokenSet_64());
	private static final long[] mk_tokenSet_65() {
		long[] data = new long[8];
		data[0]=288230376151711744L;
		data[1]=16384L;
		data[3]=2916608L;
		return data;
	}
	public static final BitSet _tokenSet_65 = new BitSet(mk_tokenSet_65());
	private static final long[] mk_tokenSet_66() {
		long[] data = { 576601489791778816L, 9216L, 4398046511104L, 0L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_66 = new BitSet(mk_tokenSet_66());
	private static final long[] mk_tokenSet_67() {
		long[] data = new long[8];
		data[0]=-576984669594058752L;
		data[1]=-9007194959973569L;
		data[2]=4398054932479L;
		data[3]=2924800L;
		return data;
	}
	public static final BitSet _tokenSet_67 = new BitSet(mk_tokenSet_67());
	private static final long[] mk_tokenSet_68() {
		long[] data = new long[8];
		data[0]=-101704825569280L;
		data[1]=-133185L;
		data[2]=11263397156913151L;
		data[3]=2941184L;
		return data;
	}
	public static final BitSet _tokenSet_68 = new BitSet(mk_tokenSet_68());
	private static final long[] mk_tokenSet_69() {
		long[] data = new long[8];
		data[0]=-1729941358572994560L;
		data[1]=1073741855L;
		data[2]=4398046511104L;
		data[3]=2916608L;
		return data;
	}
	public static final BitSet _tokenSet_69 = new BitSet(mk_tokenSet_69());
	private static final long[] mk_tokenSet_70() {
		long[] data = new long[8];
		data[0]=-1153339868781215744L;
		data[1]=4620693218755870751L;
		data[2]=4398046511104L;
		data[3]=2916608L;
		return data;
	}
	public static final BitSet _tokenSet_70 = new BitSet(mk_tokenSet_70());
	private static final long[] mk_tokenSet_71() {
		long[] data = new long[8];
		data[0]=-383179802279936L;
		data[1]=-12885036225L;
		data[2]=11263397123358719L;
		data[3]=2941184L;
		return data;
	}
	public static final BitSet _tokenSet_71 = new BitSet(mk_tokenSet_71());
	private static final long[] mk_tokenSet_72() {
		long[] data = new long[8];
		data[0]=-2305839160922996736L;
		data[1]=1073741887L;
		data[2]=4398046511104L;
		data[3]=2359296L;
		return data;
	}
	public static final BitSet _tokenSet_72 = new BitSet(mk_tokenSet_72());
	private static final long[] mk_tokenSet_73() {
		long[] data = new long[8];
		data[0]=-2017608784771284992L;
		data[1]=4611686019501129791L;
		data[2]=4398046511104L;
		data[3]=2916608L;
		return data;
	}
	public static final BitSet _tokenSet_73 = new BitSet(mk_tokenSet_73());
	private static final long[] mk_tokenSet_74() {
		long[] data = new long[8];
		data[0]=-1729906174200905728L;
		data[1]=6917529028748431391L;
		data[2]=4398046543870L;
		data[3]=2924800L;
		return data;
	}
	public static final BitSet _tokenSet_74 = new BitSet(mk_tokenSet_74());
	private static final long[] mk_tokenSet_75() {
		long[] data = new long[8];
		data[0]=-383179802279936L;
		data[1]=-16072444897L;
		data[2]=11263397114970111L;
		data[3]=2941184L;
		return data;
	}
	public static final BitSet _tokenSet_75 = new BitSet(mk_tokenSet_75());
	private static final long[] mk_tokenSet_76() {
		long[] data = new long[8];
		data[0]=2305456530876530688L;
		data[1]=-17146186752L;
		data[2]=11263397114970111L;
		data[3]=2941184L;
		return data;
	}
	public static final BitSet _tokenSet_76 = new BitSet(mk_tokenSet_76());
	private static final long[] mk_tokenSet_77() {
		long[] data = new long[8];
		data[0]=575897802350002176L;
		data[1]=6917529027674951680L;
		data[2]=9011597301284862L;
		data[3]=2924800L;
		return data;
	}
	public static final BitSet _tokenSet_77 = new BitSet(mk_tokenSet_77());
	private static final long[] mk_tokenSet_78() {
		long[] data = { 0L, 1610613248L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_78 = new BitSet(mk_tokenSet_78());
	private static final long[] mk_tokenSet_79() {
		long[] data = new long[8];
		data[0]=-576703194617348096L;
		data[1]=-12885035073L;
		data[2]=9011597343227903L;
		data[3]=2924800L;
		return data;
	}
	public static final BitSet _tokenSet_79 = new BitSet(mk_tokenSet_79());
	private static final long[] mk_tokenSet_80() {
		long[] data = new long[8];
		data[0]=-1729906174200905728L;
		data[1]=6917529031667405631L;
		data[2]=4398054932478L;
		data[3]=2924800L;
		return data;
	}
	public static final BitSet _tokenSet_80 = new BitSet(mk_tokenSet_80());
	private static final long[] mk_tokenSet_81() {
		long[] data = new long[8];
		data[0]=-383179802279936L;
		data[1]=-13153471681L;
		data[2]=11263397123358719L;
		data[3]=2941184L;
		return data;
	}
	public static final BitSet _tokenSet_81 = new BitSet(mk_tokenSet_81());
	private static final long[] mk_tokenSet_82() {
		long[] data = new long[8];
		data[0]=575898352105816064L;
		data[1]=53248L;
		data[2]=4398046543840L;
		data[3]=2924800L;
		return data;
	}
	public static final BitSet _tokenSet_82 = new BitSet(mk_tokenSet_82());
	private static final long[] mk_tokenSet_83() {
		long[] data = new long[8];
		data[0]=1152499292141780992L;
		data[1]=9007199254740992L;
		data[2]=4398046511104L;
		data[3]=2916608L;
		return data;
	}
	public static final BitSet _tokenSet_83 = new BitSet(mk_tokenSet_83());
	private static final long[] mk_tokenSet_84() {
		long[] data = new long[8];
		data[0]=1152534476513869824L;
		data[1]=6926536226929438720L;
		data[2]=4398046543870L;
		data[3]=2941184L;
		return data;
	}
	public static final BitSet _tokenSet_84 = new BitSet(mk_tokenSet_84());
	private static final long[] mk_tokenSet_85() {
		long[] data = new long[8];
		data[0]=-101704825569280L;
		data[1]=-12885035073L;
		data[2]=9011597343227903L;
		data[3]=2924800L;
		return data;
	}
	public static final BitSet _tokenSet_85 = new BitSet(mk_tokenSet_85());
	private static final long[] mk_tokenSet_86() {
		long[] data = { 1152921504606846976L, -9223372036854775808L, 1L, 0L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_86 = new BitSet(mk_tokenSet_86());
	private static final long[] mk_tokenSet_87() {
		long[] data = new long[8];
		data[0]=575897802350002176L;
		data[1]=6917529027674697728L;
		data[2]=4398046543870L;
		data[3]=2924800L;
		return data;
	}
	public static final BitSet _tokenSet_87 = new BitSet(mk_tokenSet_87());
	private static final long[] mk_tokenSet_88() {
		long[] data = new long[8];
		data[0]=575897802350002176L;
		data[1]=6917529027674691328L;
		data[2]=4398046543870L;
		data[3]=2924800L;
		return data;
	}
	public static final BitSet _tokenSet_88 = new BitSet(mk_tokenSet_88());
	private static final long[] mk_tokenSet_89() {
		long[] data = new long[8];
		data[0]=576179277326712832L;
		data[1]=6917529027674689536L;
		data[2]=4398046543870L;
		data[3]=2924800L;
		return data;
	}
	public static final BitSet _tokenSet_89 = new BitSet(mk_tokenSet_89());
	private static final long[] mk_tokenSet_90() {
		long[] data = new long[8];
		data[0]=575898352105816064L;
		data[1]=24576L;
		data[2]=4398046511104L;
		data[3]=2916608L;
		return data;
	}
	public static final BitSet _tokenSet_90 = new BitSet(mk_tokenSet_90());
	private static final long[] mk_tokenSet_91() {
		long[] data = new long[8];
		data[0]=1152499292141780992L;
		data[1]=9007199254766592L;
		data[2]=9020393394274304L;
		data[3]=2916608L;
		return data;
	}
	public static final BitSet _tokenSet_91 = new BitSet(mk_tokenSet_91());
	
	}
