/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import antlr.collections.AST;
import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

@StatelessCheck
public class SimplifyBooleanReturnCheck
extends AbstractCheck {
    public static final String MSG_KEY = "simplify.boolReturn";

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{83};
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST elseLiteral = ast.findFirstToken(92);
        if (elseLiteral != null) {
            AST elseStatement = elseLiteral.getFirstChild();
            DetailAST condition = ast.getFirstChild().getNextSibling();
            AST thenStatement = condition.getNextSibling().getNextSibling();
            if (SimplifyBooleanReturnCheck.canReturnOnlyBooleanLiteral(thenStatement) && SimplifyBooleanReturnCheck.canReturnOnlyBooleanLiteral(elseStatement)) {
                this.log(ast.getLineNo(), ast.getColumnNo(), MSG_KEY, new Object[0]);
            }
        }
    }

    private static boolean canReturnOnlyBooleanLiteral(AST ast) {
        boolean result = true;
        if (!SimplifyBooleanReturnCheck.isBooleanLiteralReturnStatement(ast)) {
            AST firstStatement = ast.getFirstChild();
            result = SimplifyBooleanReturnCheck.isBooleanLiteralReturnStatement(firstStatement);
        }
        return result;
    }

    private static boolean isBooleanLiteralReturnStatement(AST ast) {
        AST expr;
        boolean booleanReturnStatement = false;
        if (ast != null && ast.getType() == 88 && (expr = ast.getFirstChild()).getType() != 45) {
            AST value = expr.getFirstChild();
            booleanReturnStatement = SimplifyBooleanReturnCheck.isBooleanLiteralType(value.getType());
        }
        return booleanReturnStatement;
    }

    private static boolean isBooleanLiteralType(int tokenType) {
        boolean isTrue = tokenType == 133;
        boolean isFalse = tokenType == 134;
        return isTrue || isFalse;
    }
}

