/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.Scope;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.utils.ScopeUtils;
import java.util.regex.Pattern;

@StatelessCheck
public class JavadocVariableCheck
extends AbstractCheck {
    public static final String MSG_JAVADOC_MISSING = "javadoc.missing";
    private Scope scope = Scope.PRIVATE;
    private Scope excludeScope;
    private Pattern ignoreNamePattern;

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public void setExcludeScope(Scope excludeScope) {
        this.excludeScope = excludeScope;
    }

    public void setIgnoreNamePattern(Pattern pattern) {
        this.ignoreNamePattern = pattern;
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{10, 155};
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{10};
    }

    @Override
    public void visitToken(DetailAST ast) {
        FileContents contents;
        TextBlock textBlock;
        if (this.shouldCheck(ast) && (textBlock = (contents = this.getFileContents()).getJavadocBefore(ast.getLineNo())) == null) {
            this.log(ast, MSG_JAVADOC_MISSING, new Object[0]);
        }
    }

    private boolean isIgnored(DetailAST ast) {
        String name = ast.findFirstToken(58).getText();
        return this.ignoreNamePattern != null && this.ignoreNamePattern.matcher(name).matches() || "serialVersionUID".equals(name);
    }

    private boolean shouldCheck(DetailAST ast) {
        boolean result = false;
        if (!ScopeUtils.isInCodeBlock(ast) && !this.isIgnored(ast)) {
            Scope customScope = Scope.PUBLIC;
            if (ast.getType() != 155 && !ScopeUtils.isInInterfaceOrAnnotationBlock(ast)) {
                DetailAST mods = ast.findFirstToken(5);
                customScope = ScopeUtils.getScopeFromMods(mods);
            }
            Scope surroundingScope = ScopeUtils.getSurroundingScope(ast);
            result = customScope.isIn(this.scope) && surroundingScope.isIn(this.scope) && (this.excludeScope == null || !customScope.isIn(this.excludeScope) || !surroundingScope.isIn(this.excludeScope));
        }
        return result;
    }
}

