/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.xpath;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.XpathUtil;
import com.puppycrawl.tools.checkstyle.xpath.AbstractNode;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.GenericTreeInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.tree.iter.ArrayIterator;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.SingleNodeIterator;
import net.sf.saxon.tree.util.Navigator;

public class RootNode
extends AbstractNode {
    private static final String ROOT_NAME = "ROOT";
    private static final AbstractNode[] EMPTY_ABSTRACT_NODE_ARRAY = new AbstractNode[0];
    private final DetailAST detailAst;

    public RootNode(DetailAST detailAst) {
        super((TreeInfo)new GenericTreeInfo(Configuration.newConfiguration()));
        this.detailAst = detailAst;
    }

    public int compareOrder(NodeInfo nodeInfo) {
        throw RootNode.throwUnsupportedOperationException();
    }

    @Override
    protected List<AbstractNode> createChildren() {
        return XpathUtil.createChildren(this, this, this.detailAst);
    }

    public boolean hasChildNodes() {
        return this.detailAst != null;
    }

    public String getAttributeValue(String namespace, String localPart) {
        throw RootNode.throwUnsupportedOperationException();
    }

    public String getLocalPart() {
        return ROOT_NAME;
    }

    public int getNodeKind() {
        return 9;
    }

    public NodeInfo getParent() {
        return null;
    }

    public NodeInfo getRoot() {
        return this;
    }

    public AxisIterator iterateAxis(int axisNumber) {
        AxisIterator result;
        switch (axisNumber) {
            case 0: 
            case 2: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                result = EmptyIterator.ofNodes();
                break;
            }
            case 1: 
            case 12: {
                result = SingleNodeIterator.makeIterator((NodeInfo)this);
                break;
            }
            case 3: {
                if (this.hasChildNodes()) {
                    result = new ArrayIterator.OfNodes((NodeInfo[])this.getChildren().toArray(EMPTY_ABSTRACT_NODE_ARRAY));
                    break;
                }
                result = EmptyIterator.ofNodes();
                break;
            }
            case 4: {
                if (this.hasChildNodes()) {
                    result = new Navigator.DescendantEnumeration((NodeInfo)this, false, true);
                    break;
                }
                result = EmptyIterator.ofNodes();
                break;
            }
            case 5: {
                result = new Navigator.DescendantEnumeration((NodeInfo)this, true, true);
                break;
            }
            default: {
                throw RootNode.throwUnsupportedOperationException();
            }
        }
        return result;
    }

    public int getLineNumber() {
        return this.detailAst.getLineNo();
    }

    public int getColumnNumber() {
        return this.detailAst.getColumnNo();
    }

    @Override
    public int getTokenType() {
        return 1;
    }

    @Override
    public DetailAST getUnderlyingNode() {
        return this.detailAst;
    }

    @Override
    public int getDepth() {
        return 0;
    }

    private static UnsupportedOperationException throwUnsupportedOperationException() {
        return new UnsupportedOperationException("Operation is not supported");
    }
}

