/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.util.regex.Pattern;

@StatelessCheck
public class TrailingCommentCheck
extends AbstractCheck {
    public static final String MSG_KEY = "trailing.comments";
    private static final Pattern FORMAT_LINE = Pattern.compile("/");
    private Pattern legalComment;
    private Pattern format = Pattern.compile("^[\\s});]*$");

    public void setLegalComment(Pattern legalComment) {
        this.legalComment = legalComment;
    }

    public final void setFormat(Pattern pattern) {
        this.format = pattern;
    }

    @Override
    public boolean isCommentNodesRequired() {
        return true;
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{144, 145};
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (ast.getType() == 144) {
            this.checkSingleLineComment(ast);
        } else {
            this.checkBlockComment(ast);
        }
    }

    private void checkSingleLineComment(DetailAST ast) {
        int lineNo = ast.getLineNo();
        String comment = ast.getFirstChild().getText();
        String line = this.getLines()[lineNo - 1];
        String lineBefore = line.substring(0, ast.getColumnNo());
        if (!this.format.matcher(lineBefore).find() && !this.isLegalCommentContent(comment)) {
            this.log(ast, MSG_KEY, new Object[0]);
        }
    }

    private void checkBlockComment(DetailAST ast) {
        boolean isLegalBlockComment;
        int lineNo = ast.getLineNo();
        DetailAST firstChild = ast.getFirstChild();
        DetailAST lastChild = ast.getLastChild();
        String comment = firstChild.getText();
        String line = this.getLines()[lineNo - 1];
        if (line.length() > lastChild.getColumnNo() + 1) {
            line = line.substring(lastChild.getColumnNo() + 2);
        }
        line = FORMAT_LINE.matcher(line).replaceAll("");
        String lineBefore = this.getLines()[lineNo - 1].substring(0, ast.getColumnNo());
        boolean isCommentAtEndOfLine = ast.getLineNo() != lastChild.getLineNo() || CommonUtil.isBlank(line);
        boolean bl = isLegalBlockComment = this.isLegalCommentContent(comment) && TokenUtil.areOnSameLine(firstChild, lastChild) || this.format.matcher(lineBefore).find();
        if (isCommentAtEndOfLine && !isLegalBlockComment) {
            this.log(ast, MSG_KEY, new Object[0]);
        }
    }

    private boolean isLegalCommentContent(String commentContent) {
        return this.legalComment != null && this.legalComment.matcher(commentContent).find();
    }
}

