/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.alice.models.db;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.qaprosoft.alice.models.db.AbstractEntity;
import com.qaprosoft.alice.models.db.Group;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class User
extends AbstractEntity
implements Comparable<User> {
    private static final long serialVersionUID = 2720141152633805371L;
    private String username;
    private String password;
    private String email;
    private String firstName;
    private String lastName;
    private List<Group> groups = new ArrayList<Group>();

    public User() {
    }

    public User(long id) {
        super.setId(id);
    }

    public User(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public List<Group> getGroups() {
        return this.groups;
    }

    public void setGroups(List<Group> groups) {
        this.groups = groups;
    }

    public void setRoles(List<Group.Role> roles) {
    }

    public List<Group.Role> getRoles() {
        HashSet<Group.Role> roles = new HashSet<Group.Role>();
        for (Group group : this.groups) {
            roles.add(group.getRole());
        }
        return new ArrayList<Group.Role>(roles);
    }

    @Override
    public int compareTo(User user) {
        return this.username.compareTo(user.getUsername());
    }
}

