/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.zafira.client;

import com.qaprosoft.zafira.config.CIConfig;
import com.qaprosoft.zafira.models.db.Status;
import com.qaprosoft.zafira.models.db.TestRun;
import com.qaprosoft.zafira.models.dto.EmailType;
import com.qaprosoft.zafira.models.dto.JobType;
import com.qaprosoft.zafira.models.dto.TestArtifactType;
import com.qaprosoft.zafira.models.dto.TestCaseType;
import com.qaprosoft.zafira.models.dto.TestRunType;
import com.qaprosoft.zafira.models.dto.TestSuiteType;
import com.qaprosoft.zafira.models.dto.TestType;
import com.qaprosoft.zafira.models.dto.auth.AuthTokenType;
import com.qaprosoft.zafira.models.dto.auth.CredentialsType;
import com.qaprosoft.zafira.models.dto.auth.RefreshTokenType;
import com.qaprosoft.zafira.models.dto.user.UserType;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZafiraClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZafiraClient.class);
    private static final String ANONYMOUS = "anonymous";
    private static final Integer CONNECT_TIMEOUT = 30000;
    private static final Integer READ_TIMEOUT = 30000;
    private static final String STATUS_PATH = "/api/status";
    private static final String PROFILE_PATH = "/api/users/profile";
    private static final String LOGIN_PATH = "/api/auth/login";
    private static final String REFRESH_TOKEN_PATH = "/api/auth/refresh";
    private static final String USERS_PATH = "/api/users";
    private static final String JOBS_PATH = "/api/jobs";
    private static final String TESTS_PATH = "/api/tests";
    private static final String TEST_FINISH_PATH = "/api/tests/%d/finish";
    private static final String TEST_BY_ID_PATH = "/api/tests/%d";
    private static final String TEST_WORK_ITEMS_PATH = "/api/tests/%d/workitems";
    private static final String TEST_ARTIFACTS_PATH = "/api/tests/%d/artifacts";
    private static final String TEST_SUITES_PATH = "/api/tests/suites";
    private static final String TEST_CASES_PATH = "/api/tests/cases";
    private static final String TEST_CASES_BATCH_PATH = "/api/tests/cases/batch";
    private static final String TEST_RUNS_PATH = "/api/tests/runs";
    private static final String TEST_RUNS_FINISH_PATH = "/api/tests/runs/%d/finish";
    private static final String TEST_RUNS_RESULTS_PATH = "/api/tests/runs/%d/results";
    private static final String TEST_RUNS_ABORT_PATH = "/api/tests/runs/abort?id=%d";
    private static final String TEST_RUN_BY_ID_PATH = "/api/tests/runs/%d";
    private static final String TEST_RUN_EMAIL_PATH = "/api/tests/runs/%d/email?filter=%s&showStacktrace=%s";
    private static final String SETTINGS_TOOL_PATH = "/api/settings/tool/%s";
    private String serviceURL;
    private Client client;
    private String authToken;
    private String project;

    public ZafiraClient(String serviceURL) {
        this.serviceURL = serviceURL;
        this.client = Client.create();
        this.client.setConnectTimeout(CONNECT_TIMEOUT);
        this.client.setReadTimeout(READ_TIMEOUT);
    }

    public void setAuthToken(String authToken) {
        this.authToken = authToken;
    }

    public boolean isAvailable() {
        boolean isAvailable = false;
        try {
            WebResource webResource = this.client.resource(this.serviceURL + STATUS_PATH);
            ClientResponse clientRS = (ClientResponse)webResource.get(ClientResponse.class);
            if (clientRS.getStatus() == 200) {
                isAvailable = true;
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to send ping", (Throwable)e);
        }
        return isAvailable;
    }

    public synchronized Response<UserType> getUserProfile() {
        Response<Object> response = new Response<Object>(0, null);
        try {
            WebResource webResource = this.client.resource(this.serviceURL + PROFILE_PATH);
            ClientResponse clientRS = (ClientResponse)((WebResource.Builder)this.initHeaders(webResource.type("application/json")).accept(new String[]{"application/json"})).get(ClientResponse.class);
            response.setStatus(clientRS.getStatus());
            if (clientRS.getStatus() == 200) {
                response.setObject(clientRS.getEntity(UserType.class));
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to authorize user", (Throwable)e);
        }
        return response;
    }

    public synchronized Response<AuthTokenType> login(String username, String password) {
        Response<Object> response = new Response<Object>(0, null);
        try {
            WebResource webResource = this.client.resource(this.serviceURL + LOGIN_PATH);
            ClientResponse clientRS = (ClientResponse)((WebResource.Builder)this.initHeaders(webResource.type("application/json")).accept(new String[]{"application/json"})).post(ClientResponse.class, (Object)new CredentialsType(username, password));
            response.setStatus(clientRS.getStatus());
            if (clientRS.getStatus() == 200) {
                response.setObject(clientRS.getEntity(AuthTokenType.class));
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to login", (Throwable)e);
        }
        return response;
    }

    public synchronized Response<AuthTokenType> refreshToken(String token) {
        Response<Object> response = new Response<Object>(0, null);
        try {
            WebResource webResource = this.client.resource(this.serviceURL + REFRESH_TOKEN_PATH);
            ClientResponse clientRS = (ClientResponse)((WebResource.Builder)this.initHeaders(webResource.type("application/json")).accept(new String[]{"application/json"})).post(ClientResponse.class, (Object)new RefreshTokenType(token));
            response.setStatus(clientRS.getStatus());
            if (clientRS.getStatus() == 200) {
                response.setObject(clientRS.getEntity(AuthTokenType.class));
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to create user", (Throwable)e);
        }
        return response;
    }

    public synchronized Response<UserType> createUser(UserType user) {
        Response<Object> response = new Response<Object>(0, null);
        try {
            WebResource webResource = this.client.resource(this.serviceURL + USERS_PATH);
            ClientResponse clientRS = (ClientResponse)((WebResource.Builder)this.initHeaders(webResource.type("application/json")).accept(new String[]{"application/json"})).put(ClientResponse.class, (Object)user);
            response.setStatus(clientRS.getStatus());
            if (clientRS.getStatus() == 200) {
                response.setObject(clientRS.getEntity(UserType.class));
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to create user", (Throwable)e);
        }
        return response;
    }

    public synchronized Response<JobType> createJob(JobType job) {
        Response<Object> response = new Response<Object>(0, null);
        try {
            WebResource webResource = this.client.resource(this.serviceURL + JOBS_PATH);
            ClientResponse clientRS = (ClientResponse)((WebResource.Builder)this.initHeaders(webResource.type("application/json")).accept(new String[]{"application/json"})).post(ClientResponse.class, (Object)job);
            response.setStatus(clientRS.getStatus());
            if (clientRS.getStatus() == 200) {
                response.setObject(clientRS.getEntity(JobType.class));
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to create job", (Throwable)e);
        }
        return response;
    }

    public synchronized Response<TestSuiteType> createTestSuite(TestSuiteType testSuite) {
        Response<Object> response = new Response<Object>(0, null);
        try {
            WebResource webResource = this.client.resource(this.serviceURL + TEST_SUITES_PATH);
            ClientResponse clientRS = (ClientResponse)((WebResource.Builder)this.initHeaders(webResource.type("application/json")).accept(new String[]{"application/json"})).post(ClientResponse.class, (Object)testSuite);
            response.setStatus(clientRS.getStatus());
            if (clientRS.getStatus() == 200) {
                response.setObject(clientRS.getEntity(TestSuiteType.class));
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to create test suite", (Throwable)e);
        }
        return response;
    }

    public Response<TestRunType> startTestRun(TestRunType testRun) {
        Response<Object> response = new Response<Object>(0, null);
        try {
            WebResource webResource = this.client.resource(this.serviceURL + TEST_RUNS_PATH);
            ClientResponse clientRS = (ClientResponse)((WebResource.Builder)this.initHeaders(webResource.type("application/json")).accept(new String[]{"application/json"})).post(ClientResponse.class, (Object)testRun);
            response.setStatus(clientRS.getStatus());
            if (clientRS.getStatus() == 200) {
                response.setObject(clientRS.getEntity(TestRunType.class));
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to start test run", (Throwable)e);
        }
        return response;
    }

    public Response<TestRunType> updateTestRun(TestRunType testRun) {
        Response<Object> response = new Response<Object>(0, null);
        try {
            WebResource webResource = this.client.resource(this.serviceURL + TEST_RUNS_PATH);
            ClientResponse clientRS = (ClientResponse)((WebResource.Builder)this.initHeaders(webResource.type("application/json")).accept(new String[]{"application/json"})).put(ClientResponse.class, (Object)testRun);
            response.setStatus(clientRS.getStatus());
            if (clientRS.getStatus() == 200) {
                response.setObject(clientRS.getEntity(TestRunType.class));
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to update test run", (Throwable)e);
        }
        return response;
    }

    public Response<TestRunType> finishTestRun(long id) {
        Response<Object> response = new Response<Object>(0, null);
        try {
            WebResource webResource = this.client.resource(this.serviceURL + String.format(TEST_RUNS_FINISH_PATH, id));
            ClientResponse clientRS = (ClientResponse)((WebResource.Builder)this.initHeaders(webResource.type("application/json")).accept(new String[]{"application/json"})).post(ClientResponse.class);
            response.setStatus(clientRS.getStatus());
            if (clientRS.getStatus() == 200) {
                response.setObject(clientRS.getEntity(TestRunType.class));
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to finish test run", (Throwable)e);
        }
        return response;
    }

    public Response<TestRunType> getTestRun(long id) {
        Response<Object> response = new Response<Object>(0, null);
        try {
            WebResource webResource = this.client.resource(this.serviceURL + String.format(TEST_RUN_BY_ID_PATH, id));
            ClientResponse clientRS = (ClientResponse)((WebResource.Builder)this.initHeaders(webResource.type("application/json")).accept(new String[]{"application/json"})).get(ClientResponse.class);
            response.setStatus(clientRS.getStatus());
            if (clientRS.getStatus() == 200) {
                response.setObject(clientRS.getEntity(TestRunType.class));
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to find test run by id", (Throwable)e);
        }
        return response;
    }

    public Response<String> sendTestRunReport(long id, String recipients, boolean showOnlyFailures, boolean showStacktrace) {
        Response<Object> response = new Response<Object>(0, null);
        try {
            WebResource webResource = this.client.resource(this.serviceURL + String.format(TEST_RUN_EMAIL_PATH, id, showOnlyFailures ? "failures" : "all", showStacktrace ? "true" : "false"));
            ClientResponse clientRS = (ClientResponse)((WebResource.Builder)this.initHeaders(webResource.type("application/json")).accept(new MediaType[]{MediaType.TEXT_HTML_TYPE})).post(ClientResponse.class, (Object)new EmailType(recipients));
            response.setStatus(clientRS.getStatus());
            if (clientRS.getStatus() == 200) {
                response.setObject(clientRS.getEntity(String.class));
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to send test run report", (Throwable)e);
        }
        return response;
    }

    public Response<TestRunType> getTestRunByCiRunId(String ciRunId) {
        Response<Object> response = new Response<Object>(0, null);
        try {
            WebResource webResource = this.client.resource(this.serviceURL + TEST_RUNS_PATH);
            ClientResponse clientRS = (ClientResponse)((WebResource.Builder)this.initHeaders(webResource.queryParam("ciRunId", ciRunId).type("application/json")).accept(new String[]{"application/json"})).get(ClientResponse.class);
            response.setStatus(clientRS.getStatus());
            if (clientRS.getStatus() == 200) {
                response.setObject(clientRS.getEntity(TestRunType.class));
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable find test run by CI run id", (Throwable)e);
        }
        return response;
    }

    public Response<TestType> startTest(TestType test) {
        Response<Object> response = new Response<Object>(0, null);
        try {
            WebResource webResource = this.client.resource(this.serviceURL + TESTS_PATH);
            ClientResponse clientRS = (ClientResponse)((WebResource.Builder)this.initHeaders(webResource.type("application/json")).accept(new String[]{"application/json"})).post(ClientResponse.class, (Object)test);
            response.setStatus(clientRS.getStatus());
            if (clientRS.getStatus() == 200) {
                response.setObject(clientRS.getEntity(TestType.class));
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to start test", (Throwable)e);
        }
        return response;
    }

    public Response<TestType> finishTest(TestType test) {
        Response<Object> response = new Response<Object>(0, null);
        try {
            WebResource webResource = this.client.resource(this.serviceURL + String.format(TEST_FINISH_PATH, test.getId()));
            ClientResponse clientRS = (ClientResponse)((WebResource.Builder)this.initHeaders(webResource.type("application/json")).accept(new String[]{"application/json"})).post(ClientResponse.class, (Object)test);
            response.setStatus(clientRS.getStatus());
            if (clientRS.getStatus() == 200) {
                response.setObject(clientRS.getEntity(TestType.class));
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to finish test", (Throwable)e);
        }
        return response;
    }

    public void deleteTest(long id) {
        try {
            WebResource webResource = this.client.resource(this.serviceURL + String.format(TEST_BY_ID_PATH, id));
            webResource.delete(ClientResponse.class);
        }
        catch (Exception e) {
            LOGGER.error("Unable to finish test", (Throwable)e);
        }
    }

    public Response<TestType> createTestWorkItems(long testId, List<String> workItems) {
        Response<Object> response = new Response<Object>(0, null);
        try {
            WebResource webResource = this.client.resource(this.serviceURL + String.format(TEST_WORK_ITEMS_PATH, testId));
            ClientResponse clientRS = (ClientResponse)((WebResource.Builder)this.initHeaders(webResource.type("application/json")).accept(new String[]{"application/json"})).post(ClientResponse.class, workItems);
            response.setStatus(clientRS.getStatus());
            if (clientRS.getStatus() == 200) {
                response.setObject(clientRS.getEntity(TestType.class));
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to create test work items", (Throwable)e);
        }
        return response;
    }

    public void addTestArtifact(TestArtifactType artifact) {
        Response<Object> response = new Response<Object>(0, null);
        try {
            WebResource webResource = this.client.resource(this.serviceURL + String.format(TEST_ARTIFACTS_PATH, artifact.getTestId()));
            ClientResponse clientRS = (ClientResponse)((WebResource.Builder)this.initHeaders(webResource.type("application/json")).accept(new String[]{"application/json"})).post(ClientResponse.class, (Object)artifact);
            response.setStatus(clientRS.getStatus());
        }
        catch (Exception e) {
            LOGGER.error("Unable to add test artifact", (Throwable)e);
        }
    }

    public synchronized Response<TestCaseType> createTestCase(TestCaseType testCase) {
        Response<Object> response = new Response<Object>(0, null);
        try {
            WebResource webResource = this.client.resource(this.serviceURL + TEST_CASES_PATH);
            ClientResponse clientRS = (ClientResponse)((WebResource.Builder)this.initHeaders(webResource.type("application/json")).accept(new String[]{"application/json"})).post(ClientResponse.class, (Object)testCase);
            response.setStatus(clientRS.getStatus());
            if (clientRS.getStatus() == 200) {
                response.setObject(clientRS.getEntity(TestCaseType.class));
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to create test case", (Throwable)e);
        }
        return response;
    }

    public Response<TestCaseType[]> createTestCases(TestCaseType[] testCases) {
        Response<Object> response = new Response<Object>(0, null);
        try {
            WebResource webResource = this.client.resource(this.serviceURL + TEST_CASES_BATCH_PATH);
            ClientResponse clientRS = (ClientResponse)((WebResource.Builder)this.initHeaders(webResource.type("application/json")).accept(new String[]{"application/json"})).post(ClientResponse.class, (Object)testCases);
            response.setStatus(clientRS.getStatus());
            if (clientRS.getStatus() == 200) {
                response.setObject(clientRS.getEntity(TestCaseType[].class));
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to create test cases", (Throwable)e);
        }
        return response;
    }

    public Response<TestType[]> getTestRunResults(long id) {
        Response<Object> response = new Response<Object>(0, null);
        try {
            WebResource webResource = this.client.resource(this.serviceURL + String.format(TEST_RUNS_RESULTS_PATH, id));
            ClientResponse clientRS = (ClientResponse)((WebResource.Builder)this.initHeaders(webResource.type("application/json")).accept(new String[]{"application/json"})).get(ClientResponse.class);
            response.setStatus(clientRS.getStatus());
            if (clientRS.getStatus() == 200) {
                response.setObject(clientRS.getEntity(TestType[].class));
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to find test run results", (Throwable)e);
        }
        return response;
    }

    private WebResource.Builder initHeaders(WebResource.Builder builder) {
        if (!StringUtils.isEmpty((CharSequence)this.authToken)) {
            builder.header("Authorization", (Object)this.authToken);
        }
        if (!StringUtils.isEmpty((CharSequence)this.project)) {
            builder.header("Project", (Object)this.project);
        }
        return builder;
    }

    public String getProject() {
        return this.project;
    }

    public ZafiraClient setProject(String project) {
        this.project = project;
        return this;
    }

    public UserType registerUser(String userName, String email, String firstName, String lastName) {
        if (StringUtils.isEmpty((CharSequence)userName) || userName.equals("$BUILD_USER_ID")) {
            userName = ANONYMOUS;
        }
        userName = userName.toLowerCase();
        String userDetails = "userName: %s, email: %s, firstName: %s, lastName: %s";
        LOGGER.debug("User details for registration:" + String.format(userDetails, userName, email, firstName, lastName));
        UserType user = new UserType(userName, email, firstName, lastName);
        Response<UserType> response = this.createUser(user);
        user = response.getObject();
        if (user == null) {
            throw new RuntimeException("Unable to register user '" + userName + "' for zafira service: " + this.serviceURL);
        }
        LOGGER.debug("Registered user details:" + String.format(userDetails, user.getUsername(), user.getEmail(), user.getFirstName(), user.getLastName()));
        return user;
    }

    public TestCaseType registerTestCase(Long suiteId, Long primaryOwnerId, Long secondaryOwnerId, String testClass, String testMethod) {
        TestCaseType testCase = new TestCaseType(testClass, testMethod, "", suiteId, primaryOwnerId, secondaryOwnerId);
        String testCaseDetails = "testClass: %s, testMethod: %s, info: %s, testSuiteId: %d, primaryOwnerId: %d, secondaryOwnerId: %d";
        LOGGER.debug("Test Case details for registration:" + String.format(testCaseDetails, testClass, testMethod, "", suiteId, primaryOwnerId, secondaryOwnerId));
        Response<TestCaseType> response = this.createTestCase(testCase);
        testCase = response.getObject();
        if (testCase == null) {
            throw new RuntimeException("Unable to register test case '" + String.format(testCaseDetails, testClass, testMethod, "", suiteId, primaryOwnerId) + "' for zafira service: " + this.serviceURL);
        }
        LOGGER.debug("Registered test case details:" + String.format(testCaseDetails, testClass, testMethod, "", suiteId, primaryOwnerId, secondaryOwnerId));
        return testCase;
    }

    public TestType registerWorkItems(Long testId, List<String> workItems) {
        TestType test = null;
        if (workItems != null && workItems.size() > 0) {
            Response<TestType> response = this.createTestWorkItems(testId, workItems);
            test = response.getObject();
        }
        return test;
    }

    public TestSuiteType registerTestSuite(String suiteName, String fileName, Long userId) {
        TestSuiteType testSuite = new TestSuiteType(suiteName, fileName, userId);
        String testSuiteDetails = "suiteName: %s, fileName: %s, userId: %s";
        LOGGER.debug("Test Suite details for registration:" + String.format(testSuiteDetails, suiteName, fileName, userId));
        Response<TestSuiteType> response = this.createTestSuite(testSuite);
        testSuite = response.getObject();
        if (testSuite == null) {
            throw new RuntimeException("Unable to register test suite '" + suiteName + "' for zafira service: " + this.serviceURL);
        }
        LOGGER.debug("Registered test suite details:" + String.format(testSuiteDetails, testSuite.getName(), testSuite.getFileName(), testSuite.getUserId()));
        return testSuite;
    }

    public JobType registerJob(String jobUrl, Long userId) {
        jobUrl = jobUrl.replaceAll("/$", "");
        String jobName = StringUtils.substringAfterLast((String)jobUrl, (String)"/");
        String jenkinsHost = "";
        if (jobUrl.contains("/view/")) {
            jenkinsHost = jobUrl.split("/view/")[0];
        } else if (jobUrl.contains("/job/")) {
            jenkinsHost = jobUrl.split("/job/")[0];
        }
        String jobDetails = "jobName: %s, jenkinsHost: %s, userId: %s";
        LOGGER.debug("Job details for registration:" + String.format(jobDetails, jobName, jenkinsHost, userId));
        JobType job = new JobType(jobName, jobUrl, jenkinsHost, userId);
        Response<JobType> response = this.createJob(job);
        job = response.getObject();
        if (job == null) {
            throw new RuntimeException("Unable to register job for zafira service: " + this.serviceURL);
        }
        LOGGER.debug("Registered job details:" + String.format(jobDetails, job.getName(), job.getJenkinsHost(), job.getUserId()));
        return job;
    }

    public TestRunType registerTestRunByHUMAN(Long testSuiteId, Long userId, String configXML, Long jobId, CIConfig ciConfig, TestRun.Initiator startedBy, String workItem, TestRun.DriverMode driverMode) {
        TestRunType testRun = new TestRunType(ciConfig.getCiRunId(), testSuiteId, userId, ciConfig.getGitUrl(), ciConfig.getGitBranch(), ciConfig.getGitCommit(), configXML, jobId, ciConfig.getCiBuild(), startedBy, workItem);
        testRun.setDriverMode(driverMode);
        String testRunDetails = "testSuiteId: %s, userId: %s, scmURL: %s, scmBranch: %s, scmCommit: %s, jobId: %s, buildNumber: %s, startedBy: %s, workItem";
        LOGGER.debug("Test Run details for registration:" + String.format(testRunDetails, testSuiteId, userId, ciConfig.getGitUrl(), ciConfig.getGitBranch(), ciConfig.getGitCommit(), jobId, ciConfig.getCiBuild(), startedBy, workItem));
        Response<TestRunType> response = this.startTestRun(testRun);
        testRun = response.getObject();
        if (testRun == null) {
            throw new RuntimeException("Unable to register test run '" + String.format(testRunDetails, testSuiteId, userId, ciConfig.getGitUrl(), ciConfig.getGitBranch(), ciConfig.getGitCommit(), jobId, ciConfig.getCiBuild(), startedBy, workItem) + "' for zafira service: " + this.serviceURL);
        }
        LOGGER.debug("Registered test run details:" + String.format(testRunDetails, testSuiteId, userId, ciConfig.getGitUrl(), ciConfig.getGitBranch(), ciConfig.getGitCommit(), jobId, ciConfig.getCiBuild(), startedBy, workItem));
        return testRun;
    }

    public TestRunType registerTestRunBySCHEDULER(Long testSuiteId, String configXML, Long jobId, CIConfig ciConfig, TestRun.Initiator startedBy, String workItem, TestRun.DriverMode driverMode) {
        TestRunType testRun = new TestRunType(ciConfig.getCiRunId(), testSuiteId, ciConfig.getGitUrl(), ciConfig.getGitBranch(), ciConfig.getGitCommit(), configXML, jobId, ciConfig.getCiBuild(), startedBy, workItem);
        testRun.setDriverMode(driverMode);
        String testRunDetails = "testSuiteId: %s, scmURL: %s, scmBranch: %s, scmCommit: %s, jobId: %s, buildNumber: %s, startedBy: %s, workItem";
        LOGGER.debug("Test Run details for registration:" + String.format(testRunDetails, testSuiteId, ciConfig.getGitUrl(), ciConfig.getGitBranch(), ciConfig.getGitCommit(), jobId, ciConfig.getCiBuild(), startedBy, workItem));
        Response<TestRunType> response = this.startTestRun(testRun);
        testRun = response.getObject();
        if (testRun == null) {
            throw new RuntimeException("Unable to register test run '" + String.format(testRunDetails, testSuiteId, ciConfig.getGitUrl(), ciConfig.getGitBranch(), ciConfig.getGitCommit(), jobId, ciConfig.getCiBuild(), startedBy, workItem) + "' for zafira service: " + this.serviceURL);
        }
        LOGGER.debug("Registered test run details:" + String.format(testRunDetails, testSuiteId, ciConfig.getGitUrl(), ciConfig.getGitBranch(), ciConfig.getGitCommit(), jobId, ciConfig.getCiBuild(), startedBy, workItem));
        return testRun;
    }

    public TestRunType registerTestRunUPSTREAM_JOB(Long testSuiteId, String configXML, Long jobId, Long parentJobId, CIConfig ciConfig, TestRun.Initiator startedBy, String workItem, TestRun.DriverMode driverMode) {
        TestRunType testRun = new TestRunType(ciConfig.getCiRunId(), testSuiteId, ciConfig.getGitUrl(), ciConfig.getGitBranch(), ciConfig.getGitCommit(), configXML, jobId, parentJobId, ciConfig.getCiParentBuild(), ciConfig.getCiBuild(), startedBy, workItem);
        testRun.setDriverMode(driverMode);
        String testRunDetails = "testSuiteId: %s, scmURL: %s, scmBranch: %s, scmCommit: %s, jobId: %s, parentJobId: %s, parentBuildNumber: %s, buildNumber: %s, startedBy: %s, workItem";
        LOGGER.debug("Test Run details for registration:" + String.format(testRunDetails, testSuiteId, ciConfig.getGitUrl(), ciConfig.getGitBranch(), ciConfig.getGitCommit(), jobId, parentJobId, ciConfig.getCiParentBuild(), ciConfig.getCiBuild(), startedBy, workItem));
        Response<TestRunType> response = this.startTestRun(testRun);
        testRun = response.getObject();
        if (testRun == null) {
            throw new RuntimeException("Unable to register test run '" + String.format(testRunDetails, testSuiteId, ciConfig.getGitUrl(), ciConfig.getGitBranch(), ciConfig.getGitCommit(), jobId, parentJobId, ciConfig.getCiParentBuild(), ciConfig.getCiBuild(), startedBy, workItem) + "' for zafira service: " + this.serviceURL);
        }
        LOGGER.debug("Registered test run details:" + String.format(testRunDetails, testSuiteId, ciConfig.getGitUrl(), ciConfig.getGitBranch(), ciConfig.getGitCommit(), jobId, parentJobId, ciConfig.getCiParentBuild(), ciConfig.getCiBuild(), startedBy, workItem));
        return testRun;
    }

    public TestRunType registerTestRunResults(TestRunType testRun) {
        this.updateTestRun(testRun);
        Response<TestRunType> response = this.finishTestRun(testRun.getId());
        return response.getObject();
    }

    public TestType registerTestStart(String name, String group, Status status, String testArgs, Long testRunId, Long testCaseId, int retry, String configXML, String[] dependsOnMethods) {
        Response<TestType> response;
        Long startTime = new Date().getTime();
        String testDetails = "name: %s, status: %s, testArgs: %s, testRunId: %s, testCaseId: %s, startTime: %s, retry: %d";
        TestType test = new TestType(name, status, testArgs, testRunId, testCaseId, startTime, null, retry, configXML);
        LOGGER.debug("Test details for startup registration:" + String.format(testDetails, name, status, testArgs, testRunId, testCaseId, startTime, retry));
        test.setTestGroup(group);
        if (dependsOnMethods != null) {
            StringBuilder sb = new StringBuilder();
            for (String method : Arrays.asList(dependsOnMethods)) {
                sb.append(StringUtils.substringAfterLast((String)method, (String)".") + " ");
            }
            test.setDependsOnMethods(sb.toString());
        }
        if ((test = (response = this.startTest(test)).getObject()) == null) {
            throw new RuntimeException("Unable to register test '" + String.format(testDetails, name, status, testArgs, testRunId, testCaseId, startTime, retry) + "' startup for zafira service: " + this.serviceURL);
        }
        LOGGER.debug("Registered test startup details:" + String.format(testDetails, name, status, testArgs, testRunId, testCaseId, startTime, retry));
        return test;
    }

    public TestType registerTestRestart(TestType test) {
        String testName = test.getName();
        Response<TestType> response = this.startTest(test);
        if ((test = response.getObject()) == null) {
            throw new RuntimeException("Unable to register test '" + testName + "' restart for zafira service: " + this.serviceURL);
        }
        LOGGER.debug("Registered test restart details:'" + testName + "'; startTime: " + new Date(test.getStartTime()));
        return test;
    }

    public boolean abortTestRun(long id) {
        boolean aborted = false;
        try {
            WebResource webResource = this.client.resource(this.serviceURL + String.format(TEST_RUNS_ABORT_PATH, id));
            ClientResponse clientRS = (ClientResponse)((WebResource.Builder)this.initHeaders(webResource.type("application/json")).accept(new String[]{"application/json"})).get(ClientResponse.class);
            aborted = clientRS.getStatus() == 200;
        }
        catch (Exception e) {
            LOGGER.error("Unable to find test run by id", (Throwable)e);
        }
        return aborted;
    }

    public synchronized Response<List<HashMap<String, String>>> getToolSettings(String tool) {
        Response<Object> response = new Response<Object>(0, null);
        try {
            WebResource webResource = this.client.resource(this.serviceURL + String.format(SETTINGS_TOOL_PATH, tool));
            ClientResponse clientRS = (ClientResponse)((WebResource.Builder)this.initHeaders(webResource.type("application/json")).accept(new String[]{"application/json"})).get(ClientResponse.class);
            response.setStatus(clientRS.getStatus());
            if (clientRS.getStatus() == 200) {
                response.setObject(clientRS.getEntity(List.class));
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to authorize user", (Throwable)e);
        }
        return response;
    }

    public class Response<T> {
        private int status;
        private T object;

        public Response(int status, T object) {
            this.status = status;
            this.object = object;
        }

        public int getStatus() {
            return this.status;
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public T getObject() {
            return this.object;
        }

        public void setObject(T object) {
            this.object = object;
        }
    }
}

