/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.zafira.models.db;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.qaprosoft.zafira.models.db.AbstractEntity;
import java.util.Arrays;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Setting
extends AbstractEntity {
    private static final long serialVersionUID = -6809215085336377266L;
    private static final List<String> TO_ENCRYPT = Arrays.asList("JIRA_PASSWORD", "JENKINS_API_TOKEN_OR_PASSWORD", "EMAIL_PASSWORD", "AMAZON_SECRET_KEY", "HIPCHAT_ACCESS_TOKEN", "LDAP_MANAGER_PASSWORD");
    private String name;
    private String value;
    private boolean isEncrypted;
    private Tool tool;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isEncrypted() {
        return this.isEncrypted;
    }

    public void setEncrypted(boolean encrypted) {
        this.isEncrypted = encrypted;
    }

    public Tool getTool() {
        return this.tool;
    }

    public void setTool(Tool tool) {
        this.tool = tool;
    }

    public boolean isValueForEncrypting() {
        return TO_ENCRYPT.contains(this.getName());
    }

    public static enum Tool {
        GOOGLE,
        JIRA,
        JENKINS,
        SLACK,
        EMAIL,
        AMAZON,
        HIPCHAT,
        LDAP,
        CRYPTO,
        RABBITMQ;

    }

    public static enum SettingType {
        GOOGLE_CLIENT_SECRET_ORIGIN,
        GOOGLE_ENABLED,
        JIRA_URL,
        JIRA_USER,
        JIRA_PASSWORD,
        JIRA_CLOSED_STATUS,
        JIRA_ENABLED,
        JENKINS_URL,
        JENKINS_USER,
        JENKINS_API_TOKEN_OR_PASSWORD,
        JENKINS_ENABLED,
        SLACK_WEB_HOOK_URL,
        SLACK_NOTIF_CHANNEL_EXAMPLE,
        EMAIL_HOST,
        EMAIL_PORT,
        EMAIL_USER,
        EMAIL_PASSWORD,
        EMAIL_ENABLED,
        AMAZON_ACCESS_KEY,
        AMAZON_SECRET_KEY,
        AMAZON_BUCKET,
        AMAZON_IMAGE_FOLDER,
        AMAZON_ENABLED,
        HIPCHAT_ACCESS_TOKEN,
        HIPCHAT_ENABLED,
        LDAP_DN,
        LDAP_SEARCH_FILTER,
        LDAP_URL,
        LDAP_MANAGER_USER,
        LDAP_MANAGER_PASSWORD,
        LDAP_ENABLED,
        CRYPTO_KEY_TYPE,
        CRYPTO_ALGORITHM,
        CRYPTO_KEY_SIZE,
        KEY,
        RABBITMQ_ENABLED,
        RABBITMQ_HOST,
        RABBITMQ_PORT,
        RABBITMQ_WS,
        RABBITMQ_USER,
        RABBITMQ_PASSWORD,
        COMPANY_LOGO_URL;

    }
}

