/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.maven;

import com.querydsl.codegen.GenericExporter;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.sonatype.plexus.build.incremental.BuildContext;

public abstract class AbstractExporterMojo
extends AbstractMojo {
    private File targetFolder;
    private boolean scala;
    private String[] packages;
    private boolean handleFields = true;
    private boolean handleMethods = true;
    private boolean useFieldTypes = false;
    private MavenProject project;
    private String sourceEncoding;
    private boolean testClasspath;
    private boolean skip;
    private String generatedAnnotationClass;
    private BuildContext buildContext;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.testClasspath) {
            this.project.addTestCompileSourceRoot(this.targetFolder.getAbsolutePath());
        } else {
            this.project.addCompileSourceRoot(this.targetFolder.getAbsolutePath());
        }
        if (this.skip || !this.hasSourceChanges()) {
            return;
        }
        ClassLoader classLoader = null;
        try {
            classLoader = this.getProjectClassLoader();
        }
        catch (MalformedURLException | DependencyResolutionRequiredException e) {
            throw new MojoFailureException(e.getMessage(), e);
        }
        Charset charset = this.sourceEncoding != null ? Charset.forName(this.sourceEncoding) : Charset.defaultCharset();
        GenericExporter exporter = new GenericExporter(classLoader, charset);
        exporter.setTargetFolder(this.targetFolder);
        if (this.scala) {
            try {
                exporter.setSerializerClass(Class.forName("com.querydsl.scala.ScalaEntitySerializer"));
                exporter.setTypeMappingsClass(Class.forName("com.querydsl.scala.ScalaTypeMappings"));
                exporter.setCreateScalaSources(true);
            }
            catch (ClassNotFoundException e) {
                throw new MojoFailureException(e.getMessage(), (Throwable)e);
            }
        }
        this.configure(exporter);
        exporter.export(this.packages);
    }

    protected void configure(GenericExporter exporter) {
        exporter.setHandleFields(this.handleFields);
        exporter.setHandleMethods(this.handleMethods);
        exporter.setUseFieldTypes(this.useFieldTypes);
        exporter.setGeneratedAnnotationClass(this.generatedAnnotationClass);
    }

    protected ClassLoader getProjectClassLoader() throws DependencyResolutionRequiredException, MalformedURLException {
        List classpathElements = this.testClasspath ? this.project.getTestClasspathElements() : this.project.getCompileClasspathElements();
        ArrayList<URL> urls = new ArrayList<URL>(classpathElements.size());
        for (String element : classpathElements) {
            File file = new File(element);
            if (!file.exists()) continue;
            urls.add(file.toURI().toURL());
        }
        return new URLClassLoader(urls.toArray(new URL[0]), ((Object)((Object)this)).getClass().getClassLoader());
    }

    private boolean hasSourceChanges() {
        if (this.buildContext != null) {
            List sourceRoots = this.testClasspath ? this.project.getTestCompileSourceRoots() : this.project.getCompileSourceRoots();
            for (Object path : sourceRoots) {
                if (!this.buildContext.hasDelta(new File(path.toString()))) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public void setTargetFolder(File targetFolder) {
        this.targetFolder = targetFolder;
    }

    public void setScala(boolean scala) {
        this.scala = scala;
    }

    public void setPackages(String[] packages) {
        this.packages = packages;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setSourceEncoding(String sourceEncoding) {
        this.sourceEncoding = sourceEncoding;
    }

    public void setTestClasspath(boolean testClasspath) {
        this.testClasspath = testClasspath;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public void setBuildContext(BuildContext buildContext) {
        this.buildContext = buildContext;
    }

    public void setHandleFields(boolean handleFields) {
        this.handleFields = handleFields;
    }

    public void setHandleMethods(boolean handleMethods) {
        this.handleMethods = handleMethods;
    }

    public void setUseFieldTypes(boolean useFieldTypes) {
        this.useFieldTypes = useFieldTypes;
    }

    public void setGeneratedAnnotationClass(String generatedAnnotationClass) {
        this.generatedAnnotationClass = generatedAnnotationClass;
    }
}

