/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.amqp.impl;

import com.rabbitmq.client.amqp.AmqpException;
import com.rabbitmq.client.amqp.BackOffDelayPolicy;
import com.rabbitmq.client.amqp.Consumer;
import com.rabbitmq.client.amqp.ConsumerBuilder;
import com.rabbitmq.client.amqp.Resource;
import com.rabbitmq.client.amqp.impl.AmqpConnection;
import com.rabbitmq.client.amqp.impl.AmqpConsumerBuilder;
import com.rabbitmq.client.amqp.impl.AmqpMessage;
import com.rabbitmq.client.amqp.impl.ConsumerWorkService;
import com.rabbitmq.client.amqp.impl.DefaultAddressBuilder;
import com.rabbitmq.client.amqp.impl.ExceptionUtils;
import com.rabbitmq.client.amqp.impl.ResourceBase;
import com.rabbitmq.client.amqp.impl.RetryUtils;
import com.rabbitmq.client.amqp.impl.SerialNumberUtils;
import com.rabbitmq.client.amqp.impl.SessionHandler;
import com.rabbitmq.client.amqp.impl.Utils;
import com.rabbitmq.client.amqp.metrics.MetricsCollector;
import com.rabbitmq.qpid.protonj2.client.Delivery;
import com.rabbitmq.qpid.protonj2.client.DeliveryMode;
import com.rabbitmq.qpid.protonj2.client.DurabilityMode;
import com.rabbitmq.qpid.protonj2.client.ExpiryPolicy;
import com.rabbitmq.qpid.protonj2.client.ReceiverOptions;
import com.rabbitmq.qpid.protonj2.client.Session;
import com.rabbitmq.qpid.protonj2.client.SourceOptions;
import com.rabbitmq.qpid.protonj2.client.exceptions.ClientException;
import com.rabbitmq.qpid.protonj2.client.exceptions.ClientIOException;
import com.rabbitmq.qpid.protonj2.client.exceptions.ClientIllegalStateException;
import com.rabbitmq.qpid.protonj2.client.impl.ClientConversionSupport;
import com.rabbitmq.qpid.protonj2.client.impl.ClientReceiver;
import com.rabbitmq.qpid.protonj2.client.util.DeliveryQueue;
import com.rabbitmq.qpid.protonj2.engine.EventHandler;
import com.rabbitmq.qpid.protonj2.engine.Receiver;
import com.rabbitmq.qpid.protonj2.engine.Scheduler;
import com.rabbitmq.qpid.protonj2.engine.impl.ProtonLinkCreditState;
import com.rabbitmq.qpid.protonj2.engine.impl.ProtonReceiver;
import com.rabbitmq.qpid.protonj2.engine.impl.ProtonSessionIncomingWindow;
import com.rabbitmq.qpid.protonj2.types.DescribedType;
import com.rabbitmq.qpid.protonj2.types.messaging.Accepted;
import com.rabbitmq.qpid.protonj2.types.messaging.Modified;
import com.rabbitmq.qpid.protonj2.types.messaging.Rejected;
import com.rabbitmq.qpid.protonj2.types.messaging.Released;
import com.rabbitmq.qpid.protonj2.types.transport.DeliveryState;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AmqpConsumer
extends ResourceBase
implements Consumer {
    private static final AtomicLong ID_SEQUENCE = new AtomicLong(0L);
    private static final Logger LOGGER = LoggerFactory.getLogger(AmqpConsumer.class);
    private volatile ClientReceiver nativeReceiver;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final int initialCredits;
    private final Long id;
    private final String address;
    private volatile String directReplyToAddress;
    private final String queue;
    private final Map<String, DescribedType> filters;
    private final Map<String, Object> linkProperties;
    private final ConsumerBuilder.SubscriptionListener subscriptionListener;
    private final AmqpConnection connection;
    private final AtomicReference<PauseStatus> pauseStatus = new AtomicReference<PauseStatus>(PauseStatus.UNPAUSED);
    private final AtomicReference<CountDownLatch> echoedFlowAfterPauseLatch = new AtomicReference();
    private final MetricsCollector metricsCollector;
    private final SessionHandler sessionHandler;
    private final AtomicLong unsettledMessageCount = new AtomicLong(0L);
    private final Runnable replenishCreditOperation = this::replenishCreditIfNeeded;
    private final java.util.function.Consumer<Delivery> nativeHandler;
    private final java.util.function.Consumer<ClientException> nativeCloseHandler;
    private final ConsumerWorkService consumerWorkService;
    private ProtonReceiver protonReceiver;
    private volatile Scheduler protonExecutor;
    private DeliveryQueue protonDeliveryQueue;
    private ProtonSessionIncomingWindow sessionWindow;
    private ProtonLinkCreditState creditState;

    AmqpConsumer(AmqpConsumerBuilder builder) {
        super(builder.listeners());
        this.id = ID_SEQUENCE.getAndIncrement();
        this.initialCredits = builder.initialCredits();
        Consumer.MessageHandler messageHandler = builder.connection().observationCollector().subscribe(builder.queue(), builder.messageHandler());
        if (builder.directReplyTo()) {
            this.address = null;
            this.queue = null;
        } else {
            DefaultAddressBuilder<?> addressBuilder = Utils.addressBuilder();
            addressBuilder.queue(builder.queue());
            this.address = addressBuilder.address();
            this.queue = builder.queue();
        }
        this.filters = Map.copyOf(builder.filters());
        this.linkProperties = Map.copyOf(builder.properties());
        this.subscriptionListener = Optional.ofNullable(builder.subscriptionListener()).orElse(AmqpConsumerBuilder.NO_OP_SUBSCRIPTION_LISTENER);
        this.connection = builder.connection();
        this.sessionHandler = this.connection.createSessionHandler();
        this.nativeHandler = this.createNativeHandler(messageHandler);
        this.nativeCloseHandler = e -> this.connection.consumerWorkService().dispatch(() -> {
            boolean ignored = AmqpConsumer.maybeCloseConsumerOnException(this, e);
        });
        this.consumerWorkService = this.connection.consumerWorkService();
        this.consumerWorkService.register(this);
        this.nativeReceiver = AmqpConsumer.createNativeReceiver(this.sessionHandler.session(), this.address, this.linkProperties, this.filters, this.subscriptionListener, this.nativeHandler, this.nativeCloseHandler);
        try {
            this.directReplyToAddress = this.nativeReceiver.address();
            this.initStateFromNativeReceiver(this.nativeReceiver);
            this.metricsCollector = this.connection.metricsCollector();
            this.state(Resource.State.OPEN);
            this.nativeReceiver.addCredit(this.initialCredits);
        }
        catch (ClientException e2) {
            AmqpException ex = ExceptionUtils.convert(e2);
            this.close(ex);
            throw ex;
        }
        this.metricsCollector.openConsumer();
    }

    @Override
    public void pause() {
        block6: {
            if (this.pauseStatus.compareAndSet(PauseStatus.UNPAUSED, PauseStatus.PAUSING)) {
                try {
                    CountDownLatch latch = new CountDownLatch(1);
                    this.echoedFlowAfterPauseLatch.set(latch);
                    this.protonExecutor.execute(this::doPause);
                    try {
                        boolean echoed = latch.await(10L, TimeUnit.SECONDS);
                        if (echoed) {
                            this.pauseStatus.set(PauseStatus.PAUSED);
                            break block6;
                        }
                        LOGGER.warn("Did not receive echoed flow to pause receiver");
                        this.pauseStatus.set(PauseStatus.UNPAUSED);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                catch (Exception e) {
                    this.pauseStatus.set(PauseStatus.UNPAUSED);
                }
            }
        }
    }

    @Override
    public void unpause() {
        this.checkOpen();
        if (this.pauseStatus.compareAndSet(PauseStatus.PAUSED, PauseStatus.UNPAUSED)) {
            try {
                this.nativeReceiver.addCredit(this.initialCredits);
            }
            catch (ClientException e) {
                throw ExceptionUtils.convert(e);
            }
        }
    }

    @Override
    public long unsettledMessageCount() {
        return this.unsettledMessageCount.get();
    }

    @Override
    public void close() {
        this.close(null);
    }

    private static ClientReceiver createNativeReceiver(Session nativeSession, String address, Map<String, Object> properties, Map<String, DescribedType> filters, ConsumerBuilder.SubscriptionListener subscriptionListener, java.util.function.Consumer<Delivery> nativeHandler, java.util.function.Consumer<ClientException> closeHandler) {
        try {
            filters = new LinkedHashMap<String, DescribedType>(filters);
            ConsumerBuilder.StreamOptions streamOptions = AmqpConsumerBuilder.streamOptions(filters);
            subscriptionListener.preSubscribe(() -> streamOptions);
            boolean directReplyTo = address == null;
            ReceiverOptions receiverOptions = new ReceiverOptions();
            if (directReplyTo) {
                ((SourceOptions)((SourceOptions)((ReceiverOptions)((ReceiverOptions)receiverOptions.deliveryMode(DeliveryMode.AT_MOST_ONCE)).autoAccept(true).autoSettle(true)).sourceOptions().capabilities("rabbitmq:volatile-queue")).expiryPolicy(ExpiryPolicy.LINK_CLOSE)).durabilityMode(DurabilityMode.NONE);
            } else {
                ((ReceiverOptions)receiverOptions.deliveryMode(DeliveryMode.AT_LEAST_ONCE)).autoAccept(false).autoSettle(false);
            }
            receiverOptions.handler(nativeHandler).closeHandler(closeHandler).creditWindow(0).properties(properties);
            Map<String, Object> localSourceFilters = Collections.emptyMap();
            if (!filters.isEmpty()) {
                localSourceFilters = Map.copyOf(filters);
                receiverOptions.sourceOptions().filters(localSourceFilters);
            }
            ClientReceiver receiver = directReplyTo ? (ClientReceiver)ExceptionUtils.wrapGet(nativeSession.openDynamicReceiver(receiverOptions).openFuture()) : (ClientReceiver)ExceptionUtils.wrapGet(nativeSession.openReceiver(address, receiverOptions).openFuture());
            boolean filterOk = true;
            if (!filters.isEmpty()) {
                Map<String, String> remoteSourceFilters = receiver.source().filters();
                for (Map.Entry<String, Object> localEntry : localSourceFilters.entrySet()) {
                    if (remoteSourceFilters.containsKey(localEntry.getKey())) continue;
                    LOGGER.warn("Missing filter value in attach response: {} => {}", (Object)localEntry.getKey(), localEntry.getValue());
                    filterOk = false;
                }
            }
            if (!filterOk) {
                receiver.close();
                throw new AmqpException("The sending endpoint filters do not match the receiving endpoint filters", new Object[0]);
            }
            return receiver;
        }
        catch (ClientException e) {
            throw ExceptionUtils.convert(e, "Error while creating receiver from '%s'", address);
        }
    }

    private java.util.function.Consumer<Delivery> createNativeHandler(Consumer.MessageHandler handler) {
        return delivery -> {
            if (this.state() == Resource.State.OPEN) {
                this.unsettledMessageCount.incrementAndGet();
                this.metricsCollector.consume();
                this.consumerWorkService.dispatch(this, () -> {
                    AmqpMessage message;
                    try {
                        message = new AmqpMessage(delivery.message());
                    }
                    catch (ClientException e) {
                        LOGGER.warn("Error while decoding message: {}", (Object)e.getMessage());
                        try {
                            delivery.disposition(com.rabbitmq.qpid.protonj2.client.DeliveryState.rejected("", ""), true);
                        }
                        catch (ClientException ex) {
                            LOGGER.warn("Error while rejecting non-decoded message: {}", (Object)ex.getMessage());
                        }
                        return;
                    }
                    DeliveryContext context = new DeliveryContext((Delivery)delivery, this.protonExecutor, this.protonReceiver, this.metricsCollector, this.unsettledMessageCount, this.replenishCreditOperation, this);
                    handler.handle(context, message);
                });
            }
        };
    }

    void recoverAfterConnectionFailure() {
        this.nativeReceiver = RetryUtils.callAndMaybeRetry(() -> AmqpConsumer.createNativeReceiver(this.sessionHandler.sessionNoCheck(), this.address, this.linkProperties, this.filters, this.subscriptionListener, this.nativeHandler, this.nativeCloseHandler), e -> {
            boolean shouldRetry = ExceptionUtils.noRunningStreamMemberOnNode(e);
            LOGGER.debug("Retrying receiver creation on consumer recovery: {}", (Object)shouldRetry);
            return shouldRetry;
        }, List.of(Duration.ofSeconds(1L), Duration.ofSeconds(2L), Duration.ofSeconds(3L), BackOffDelayPolicy.TIMEOUT), "Create AMQP receiver to address '%s'", this.address);
        try {
            this.directReplyToAddress = this.nativeReceiver.address();
            this.initStateFromNativeReceiver(this.nativeReceiver);
            this.pauseStatus.set(PauseStatus.UNPAUSED);
            this.unsettledMessageCount.set(0L);
            this.nativeReceiver.addCredit(this.initialCredits);
        }
        catch (ClientException e2) {
            throw ExceptionUtils.convert(e2);
        }
    }

    void close(Throwable cause) {
        if (this.closed.compareAndSet(false, true)) {
            this.state(Resource.State.CLOSING, cause);
            if (this.consumerWorkService != null) {
                this.consumerWorkService.unregister(this);
            }
            this.connection.removeConsumer(this);
            try {
                if (this.nativeReceiver != null) {
                    this.nativeReceiver.close();
                }
                this.sessionHandler.close();
            }
            catch (Exception e) {
                LOGGER.warn("Error while closing receiver", (Throwable)e);
            }
            this.state(Resource.State.CLOSED, cause);
            MetricsCollector mc = this.metricsCollector;
            if (mc != null) {
                mc.closeConsumer();
            }
        }
    }

    long id() {
        return this.id;
    }

    String queue() {
        return this.queue;
    }

    private void initStateFromNativeReceiver(ClientReceiver receiver) {
        try {
            Scheduler protonExecutor = receiver.executor();
            CountDownLatch fieldsSetLatch = new CountDownLatch(1);
            protonExecutor.execute(() -> {
                this.protonReceiver = (ProtonReceiver)receiver.protonReceiver();
                this.creditState = this.protonReceiver.getCreditState();
                this.sessionWindow = this.protonReceiver.sessionWindow();
                this.protonDeliveryQueue = receiver.deliveryQueue();
                EventHandler<Receiver> eventHandler = this.protonReceiver.linkCreditUpdatedHandler();
                EventHandler<Receiver> decorator = target -> {
                    eventHandler.handle((Receiver)target);
                    CountDownLatch latch = this.echoedFlowAfterPauseLatch.getAndSet(null);
                    if (latch != null) {
                        latch.countDown();
                    }
                };
                this.protonReceiver.creditStateUpdateHandler((EventHandler)decorator);
                this.protonExecutor = protonExecutor;
                fieldsSetLatch.countDown();
            });
            if (!fieldsSetLatch.await(10L, TimeUnit.SECONDS)) {
                throw new AmqpException("Could not initialize consumer internal state", new Object[0]);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void replenishCreditIfNeeded() {
        if (!this.pausedOrPausing() && this.state() == Resource.State.OPEN) {
            int potentialPrefetch;
            int creditWindow = this.initialCredits;
            int currentCredit = this.protonReceiver.getCredit();
            if ((double)currentCredit <= (double)creditWindow * 0.5 && (double)(potentialPrefetch = currentCredit + this.protonDeliveryQueue.size()) <= (double)creditWindow * 0.7) {
                int additionalCredit = creditWindow - potentialPrefetch;
                try {
                    this.protonReceiver.addCredit(additionalCredit);
                }
                catch (Exception ex) {
                    LOGGER.debug("Error caught during credit top-up", (Throwable)ex);
                }
            }
        }
    }

    private void doPause() {
        this.creditState.updateCredit(0);
        this.creditState.updateEcho(true);
        this.sessionWindow.writeFlow(this.protonReceiver);
    }

    boolean pausedOrPausing() {
        return this.pauseStatus.get() != PauseStatus.UNPAUSED;
    }

    String directReplyToAddress() {
        return this.directReplyToAddress;
    }

    public String toString() {
        return "AmqpConsumer{id=" + this.id + ", queue='" + this.queue + "'}";
    }

    private static void handleContextException(AmqpConsumer consumer, Exception ex, String operation) {
        if (AmqpConsumer.maybeCloseConsumerOnException(consumer, ex)) {
            return;
        }
        if (ex instanceof ClientIllegalStateException || ex instanceof RejectedExecutionException || ex instanceof ClientIOException) {
            LOGGER.debug("message {} failed: {}", (Object)operation, (Object)ex.getMessage());
        } else if (ex instanceof ClientException) {
            throw ExceptionUtils.convert((ClientException)ex);
        }
    }

    private static boolean maybeCloseConsumerOnException(AmqpConsumer consumer, Exception ex) {
        return ExceptionUtils.maybeCloseOnException(consumer::close, ex);
    }

    private static final class BatchDeliveryContext
    implements Consumer.BatchContext {
        private static final DeliveryState REJECTED = new Rejected();
        private final List<DeliveryContext> contexts;
        private final AtomicBoolean settled = new AtomicBoolean(false);
        private final Scheduler protonExecutor;
        private final ProtonReceiver protonReceiver;
        private final MetricsCollector metricsCollector;
        private final AtomicLong unsettledMessageCount;
        private final Runnable replenishCreditOperation;
        private final AmqpConsumer consumer;

        private BatchDeliveryContext(int batchSizeHint, Scheduler protonExecutor, ProtonReceiver protonReceiver, MetricsCollector metricsCollector, AtomicLong unsettledMessageCount, Runnable replenishCreditOperation, AmqpConsumer consumer) {
            this.contexts = new ArrayList<DeliveryContext>(batchSizeHint);
            this.protonExecutor = protonExecutor;
            this.protonReceiver = protonReceiver;
            this.metricsCollector = metricsCollector;
            this.unsettledMessageCount = unsettledMessageCount;
            this.replenishCreditOperation = replenishCreditOperation;
            this.consumer = consumer;
        }

        @Override
        public void add(Consumer.Context context) {
            DeliveryContext dctx;
            if (this.settled.get()) {
                throw new IllegalStateException("Batch is closed");
            }
            if (context instanceof DeliveryContext) {
                dctx = (DeliveryContext)context;
                if (!dctx.settled.compareAndSet(false, true)) {
                    throw new IllegalStateException("Message already settled");
                }
            } else {
                throw new IllegalArgumentException("Context type not supported: " + String.valueOf(context));
            }
            this.contexts.add(dctx);
        }

        @Override
        public int size() {
            return this.contexts.size();
        }

        @Override
        public void accept() {
            this.settle(Accepted.getInstance(), MetricsCollector.ConsumeDisposition.ACCEPTED, "accept");
        }

        @Override
        public void discard() {
            this.settle(REJECTED, MetricsCollector.ConsumeDisposition.DISCARDED, "discard");
        }

        @Override
        public void discard(Map<String, Object> annotations) {
            annotations = annotations == null ? Collections.emptyMap() : annotations;
            Utils.checkMessageAnnotations(annotations);
            Modified state = new Modified(false, true, ClientConversionSupport.toSymbolKeyedMap(annotations));
            this.settle(state, MetricsCollector.ConsumeDisposition.DISCARDED, "discard (modified)");
        }

        @Override
        public void requeue() {
            this.settle(Released.getInstance(), MetricsCollector.ConsumeDisposition.REQUEUED, "requeue");
        }

        @Override
        public void requeue(Map<String, Object> annotations) {
            annotations = annotations == null ? Collections.emptyMap() : annotations;
            Utils.checkMessageAnnotations(annotations);
            Modified state = new Modified(false, false, ClientConversionSupport.toSymbolKeyedMap(annotations));
            this.settle(state, MetricsCollector.ConsumeDisposition.REQUEUED, "requeue (modified)");
        }

        @Override
        public Consumer.BatchContext batch(int batchSizeHint) {
            return this;
        }

        private void settle(DeliveryState state, MetricsCollector.ConsumeDisposition disposition, String label) {
            if (this.settled.compareAndSet(false, true)) {
                int batchSize = this.contexts.size();
                try {
                    this.protonExecutor.execute(this.replenishCreditOperation);
                    long[][] ranges = SerialNumberUtils.ranges(this.contexts, ctx -> ctx.delivery.getDeliveryId());
                    this.protonExecutor.execute(() -> {
                        for (long[] range : ranges) {
                            this.protonReceiver.disposition(state, range);
                        }
                    });
                    this.unsettledMessageCount.addAndGet(-batchSize);
                    IntStream.range(0, batchSize).forEach(ignored -> this.metricsCollector.consumeDisposition(disposition));
                }
                catch (Exception e) {
                    AmqpConsumer.handleContextException(this.consumer, e, label);
                }
            }
        }
    }

    private static class DeliveryContext
    implements Consumer.Context {
        private static final com.rabbitmq.qpid.protonj2.client.DeliveryState REJECTED = com.rabbitmq.qpid.protonj2.client.DeliveryState.rejected(null, null);
        private final AtomicBoolean settled = new AtomicBoolean(false);
        private final Delivery delivery;
        private final Scheduler protonExecutor;
        private final ProtonReceiver protonReceiver;
        private final MetricsCollector metricsCollector;
        private final AtomicLong unsettledMessageCount;
        private final Runnable replenishCreditOperation;
        private final AmqpConsumer consumer;

        private DeliveryContext(Delivery delivery, Scheduler protonExecutor, ProtonReceiver protonReceiver, MetricsCollector metricsCollector, AtomicLong unsettledMessageCount, Runnable replenishCreditOperation, AmqpConsumer consumer) {
            this.delivery = delivery;
            this.protonExecutor = protonExecutor;
            this.protonReceiver = protonReceiver;
            this.metricsCollector = metricsCollector;
            this.unsettledMessageCount = unsettledMessageCount;
            this.replenishCreditOperation = replenishCreditOperation;
            this.consumer = consumer;
        }

        @Override
        public void accept() {
            this.settle(com.rabbitmq.qpid.protonj2.client.DeliveryState.accepted(), MetricsCollector.ConsumeDisposition.ACCEPTED, "accept");
        }

        @Override
        public void discard() {
            this.settle(REJECTED, MetricsCollector.ConsumeDisposition.DISCARDED, "discard");
        }

        @Override
        public void discard(Map<String, Object> annotations) {
            annotations = annotations == null ? Collections.emptyMap() : annotations;
            Utils.checkMessageAnnotations(annotations);
            this.settle(com.rabbitmq.qpid.protonj2.client.DeliveryState.modified(true, true, annotations), MetricsCollector.ConsumeDisposition.DISCARDED, "discard (modified)");
        }

        @Override
        public void requeue() {
            this.settle(com.rabbitmq.qpid.protonj2.client.DeliveryState.released(), MetricsCollector.ConsumeDisposition.REQUEUED, "requeue");
        }

        @Override
        public void requeue(Map<String, Object> annotations) {
            annotations = annotations == null ? Collections.emptyMap() : annotations;
            Utils.checkMessageAnnotations(annotations);
            this.settle(com.rabbitmq.qpid.protonj2.client.DeliveryState.modified(false, false, annotations), MetricsCollector.ConsumeDisposition.REQUEUED, "requeue (modified)");
        }

        @Override
        public Consumer.BatchContext batch(int batchSizeHint) {
            return new BatchDeliveryContext(batchSizeHint, this.protonExecutor, this.protonReceiver, this.metricsCollector, this.unsettledMessageCount, this.replenishCreditOperation, this.consumer);
        }

        private void settle(com.rabbitmq.qpid.protonj2.client.DeliveryState state, MetricsCollector.ConsumeDisposition disposition, String label) {
            if (this.settled.compareAndSet(false, true)) {
                try {
                    this.protonExecutor.execute(this.replenishCreditOperation);
                    this.delivery.disposition(state, true);
                    this.unsettledMessageCount.decrementAndGet();
                    this.metricsCollector.consumeDisposition(disposition);
                }
                catch (Exception e) {
                    AmqpConsumer.handleContextException(this.consumer, e, label);
                }
            }
        }
    }

    static enum PauseStatus {
        UNPAUSED,
        PAUSING,
        PAUSED;

    }
}

