/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.amqp.impl;

import com.rabbitmq.client.amqp.ConnectionSettings;
import com.rabbitmq.client.amqp.Environment;
import com.rabbitmq.client.amqp.EnvironmentBuilder;
import com.rabbitmq.client.amqp.ObservationCollector;
import com.rabbitmq.client.amqp.impl.AmqpEnvironment;
import com.rabbitmq.client.amqp.impl.DefaultConnectionSettings;
import com.rabbitmq.client.amqp.impl.Utils;
import com.rabbitmq.client.amqp.metrics.MetricsCollector;
import com.rabbitmq.client.amqp.metrics.NoOpMetricsCollector;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;

public class AmqpEnvironmentBuilder
implements EnvironmentBuilder {
    private final DefaultEnvironmentConnectionSettings connectionSettings = new DefaultEnvironmentConnectionSettings(this);
    private ExecutorService executorService;
    private ScheduledExecutorService scheduledExecutorService;
    private Executor dispatchingExecutor;
    private ExecutorService publisherExecutorService;
    private MetricsCollector metricsCollector = NoOpMetricsCollector.INSTANCE;
    private ObservationCollector observationCollector = Utils.NO_OP_OBSERVATION_COLLECTOR;

    public AmqpEnvironmentBuilder executorService(ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    public AmqpEnvironmentBuilder dispatchingExecutor(Executor executor) {
        this.dispatchingExecutor = executor;
        return this;
    }

    public AmqpEnvironmentBuilder scheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = scheduledExecutorService;
        return this;
    }

    public AmqpEnvironmentBuilder publisherExecutorService(ExecutorService publisherExecutorService) {
        this.publisherExecutorService = publisherExecutorService;
        return this;
    }

    @Deprecated(forRemoval=true)
    public AmqpEnvironmentBuilder consumerExecutorService(ExecutorService consumerExecutorService) {
        return this;
    }

    public AmqpEnvironmentBuilder metricsCollector(MetricsCollector metricsCollector) {
        this.metricsCollector = metricsCollector;
        return this;
    }

    public AmqpEnvironmentBuilder observationCollector(ObservationCollector observationCollector) {
        this.observationCollector = observationCollector;
        return this;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public EnvironmentConnectionSettings connectionSettings() {
        return this.connectionSettings;
    }

    @Override
    public Environment build() {
        return new AmqpEnvironment(this.executorService, this.scheduledExecutorService, this.dispatchingExecutor, this.publisherExecutorService, this.connectionSettings, this.metricsCollector, this.observationCollector);
    }

    static class DefaultEnvironmentConnectionSettings
    extends DefaultConnectionSettings<EnvironmentConnectionSettings>
    implements EnvironmentConnectionSettings {
        private final AmqpEnvironmentBuilder builder;

        public DefaultEnvironmentConnectionSettings(AmqpEnvironmentBuilder builder) {
            this.builder = builder;
        }

        @Override
        EnvironmentConnectionSettings toReturn() {
            return this;
        }

        @Override
        public AmqpEnvironmentBuilder environmentBuilder() {
            return this.builder;
        }
    }

    public static interface EnvironmentConnectionSettings
    extends ConnectionSettings<EnvironmentConnectionSettings> {
        public AmqpEnvironmentBuilder environmentBuilder();
    }
}

