/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.amqp.impl;

import com.rabbitmq.client.amqp.ByteCapacity;
import com.rabbitmq.client.amqp.Management;
import com.rabbitmq.client.amqp.impl.AmqpManagement;
import com.rabbitmq.client.amqp.impl.Assert;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AmqpQueueSpecification
implements Management.QueueSpecification {
    private static final Logger LOGGER = LoggerFactory.getLogger(AmqpQueueSpecification.class);
    private static final Duration TEN_YEARS = Duration.ofDays(3650L);
    private static final boolean DURABLE = true;
    private final AmqpManagement management;
    private boolean shortcutArguments = false;
    private String name;
    private boolean exclusive = false;
    private boolean autoDelete = false;
    private final Map<String, Object> arguments = new LinkedHashMap<String, Object>();

    AmqpQueueSpecification(AmqpManagement management) {
        this.management = management;
    }

    @Override
    public Management.QueueSpecification name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public Management.QueueSpecification exclusive(boolean exclusive) {
        this.exclusive = exclusive;
        return this;
    }

    @Override
    public Management.QueueSpecification autoDelete(boolean autoDelete) {
        this.autoDelete = autoDelete;
        return this;
    }

    @Override
    public Management.QueueSpecification type(Management.QueueType type) {
        if (type == Management.QueueType.QUORUM || type == Management.QueueType.STREAM) {
            this.exclusive(false).autoDelete(false);
        }
        this.arg("x-queue-type", type.name().toLowerCase(Locale.ENGLISH));
        return this;
    }

    @Override
    public Management.QueueSpecification deadLetterExchange(String dlx) {
        this.arg("x-dead-letter-exchange", dlx);
        return this;
    }

    @Override
    public Management.QueueSpecification deadLetterRoutingKey(String dlrk) {
        this.arg("x-dead-letter-routing-key", dlrk);
        return this;
    }

    @Override
    public Management.QueueSpecification overflowStrategy(String overflow) {
        this.arg("x-overflow", overflow);
        return this;
    }

    @Override
    public Management.QueueSpecification overflowStrategy(Management.OverflowStrategy overflow) {
        this.arg("x-overflow", overflow.strategy());
        return this;
    }

    @Override
    public Management.QueueSpecification expires(Duration expiration) {
        AmqpQueueSpecification.validatePositive("x-expires", expiration.toMillis(), TEN_YEARS.toMillis());
        this.arg("x-expires", expiration.toMillis());
        return this;
    }

    @Override
    public Management.QueueSpecification maxLength(long maxLength) {
        AmqpQueueSpecification.validatePositive("x-max-length", maxLength);
        this.arg("x-max-length", maxLength);
        return this;
    }

    @Override
    public Management.QueueSpecification maxLengthBytes(ByteCapacity maxLengthBytes) {
        AmqpQueueSpecification.validatePositive("x-max-length-bytes", maxLengthBytes.toBytes());
        this.arg("x-max-length-bytes", maxLengthBytes.toBytes());
        return this;
    }

    @Override
    public Management.QueueSpecification singleActiveConsumer(boolean singleActiveConsumer) {
        this.arg("x-single-active-consumer", singleActiveConsumer);
        return this;
    }

    @Override
    public Management.QueueSpecification messageTtl(Duration ttl) {
        AmqpQueueSpecification.validateNonNegative("x-message-ttl", ttl.toMillis(), TEN_YEARS.toMillis());
        this.arg("x-message-ttl", ttl.toMillis());
        return this;
    }

    @Override
    public Management.QueueSpecification leaderLocator(Management.QueueLeaderLocator locator) {
        if (locator == null) {
            this.arg("x-queue-master-locator", null);
            this.arg("x-queue-leader-locator", null);
        } else {
            Management.QueueType type = this.type();
            if (type == Management.QueueType.CLASSIC) {
                this.arg("x-queue-master-locator", locator == Management.QueueLeaderLocator.BALANCED ? "min-masters" : locator.locator());
            } else if (type == Management.QueueType.QUORUM || type == Management.QueueType.STREAM) {
                this.arg("x-queue-leader-locator", locator.locator());
            } else {
                LOGGER.warn("Set queue type before setting leader locator");
            }
        }
        return this;
    }

    @Override
    public Management.QuorumQueueSpecification quorum() {
        this.type(Management.QueueType.QUORUM);
        return new AmqpQuorumQueueSpecification(this);
    }

    @Override
    public Management.ClassicQueueSpecification classic() {
        this.type(Management.QueueType.CLASSIC);
        return new AmqpClassicQueueSpecification(this);
    }

    @Override
    public Management.StreamSpecification stream() {
        this.type(Management.QueueType.STREAM);
        return new AmqpStreamSpecification(this);
    }

    @Override
    public Management.QueueSpecification argument(String key, Object value) {
        if (value == null) {
            this.arguments.remove(key);
        } else {
            this.arguments.put(key, value);
        }
        return this;
    }

    @Override
    public Management.QueueSpecification arguments(Map<String, Object> arguments) {
        Assert.notNull(arguments, "Arguments");
        this.arguments.clear();
        this.arguments.putAll(arguments);
        return this;
    }

    @Override
    public Management.QueueInfo declare() {
        LinkedHashMap<String, Object> body = new LinkedHashMap<String, Object>();
        body.put("durable", true);
        body.put("exclusive", this.exclusive);
        body.put("auto_delete", this.autoDelete);
        body.put("arguments", this.arguments);
        Management.QueueInfo info = this.management.declareQueue(this.name, body);
        AmqpQueueSpecification copy = this.duplicate();
        copy.name(info.name());
        this.management.recovery().queueDeclared(copy);
        return info;
    }

    private Map<String, Object> arg(String key, Object value) {
        if (value == null) {
            this.arguments.remove(key);
        } else {
            this.arguments.put(key, value);
        }
        this.shortcutArguments = true;
        return this.arguments;
    }

    private static void validatePositive(String label, long value) {
        AmqpQueueSpecification.validatePositive(label, value, 0L);
    }

    private static void validatePositive(String label, long value, long max) {
        if (value <= 0L) {
            throw new IllegalArgumentException(String.format("'%s' must be positive", label));
        }
        if (max > 0L && value > max) {
            throw new IllegalArgumentException(String.format("'%s' must be lesser than %d", label, max));
        }
    }

    private static void validateNonNegative(String label, long value, long max) {
        if (value < 0L) {
            throw new IllegalArgumentException(String.format("'%s' must be greater than or equal to 0", label));
        }
        if (max > 0L && value > max) {
            throw new IllegalArgumentException(String.format("'%s' must be lesser than %d", label, max));
        }
    }

    Management.QueueType type() {
        String type = (String)this.arguments.get("x-queue-type");
        for (Management.QueueType value : Management.QueueType.values()) {
            if (!value.toString().toLowerCase(Locale.ENGLISH).equals(type)) continue;
            return value;
        }
        return null;
    }

    String name() {
        return this.name;
    }

    boolean exclusive() {
        return this.exclusive;
    }

    boolean autoDelete() {
        return this.autoDelete;
    }

    void arguments(BiConsumer<String, Object> consumer) {
        this.arguments.forEach(consumer);
    }

    AmqpQueueSpecification duplicate() {
        AmqpQueueSpecification copy = new AmqpQueueSpecification(this.management);
        copy.name(this.name).exclusive(this.exclusive).autoDelete(this.autoDelete);
        copy.shortcutArguments = this.shortcutArguments;
        copy.arguments.putAll(this.arguments);
        return copy;
    }

    private static class AmqpStreamSpecification
    implements Management.StreamSpecification {
        private final AmqpQueueSpecification parent;

        private AmqpStreamSpecification(AmqpQueueSpecification parent) {
            this.parent = parent;
        }

        @Override
        public Management.StreamSpecification maxAge(Duration maxAge) {
            AmqpQueueSpecification.validatePositive("x-max-age", maxAge.getSeconds());
            this.parent.arg("x-max-age", maxAge.getSeconds() + "s");
            return this;
        }

        @Override
        public Management.StreamSpecification maxSegmentSizeBytes(ByteCapacity maxSegmentSize) {
            AmqpQueueSpecification.validatePositive("x-stream-max-segment-size-bytes", maxSegmentSize.toBytes());
            this.parent.arg("x-stream-max-segment-size-bytes", maxSegmentSize.toBytes());
            return this;
        }

        @Override
        public Management.StreamSpecification initialClusterSize(int initialClusterSize) {
            return this.initialMemberCount(initialClusterSize);
        }

        @Override
        public Management.StreamSpecification initialMemberCount(int initialMemberCount) {
            AmqpQueueSpecification.validatePositive("x-initial-cluster-size", initialMemberCount);
            this.parent.arg("x-initial-cluster-size", initialMemberCount);
            return this;
        }

        @Override
        public Management.QueueSpecification queue() {
            return this.parent;
        }
    }

    private static class AmqpClassicQueueSpecification
    implements Management.ClassicQueueSpecification {
        private final AmqpQueueSpecification parent;

        private AmqpClassicQueueSpecification(AmqpQueueSpecification parent) {
            this.parent = parent;
        }

        @Override
        public Management.ClassicQueueSpecification maxPriority(int maxPriority) {
            AmqpQueueSpecification.validateNonNegative("x-max-priority", maxPriority, 256L);
            this.parent.arg("x-max-priority", maxPriority);
            return this;
        }

        @Override
        public Management.ClassicQueueSpecification version(Management.ClassicQueueVersion version) {
            if (version == null) {
                this.parent.arg("x-queue-version", null);
            } else {
                this.parent.arg("x-queue-version", version.version());
            }
            return this;
        }

        @Override
        public Management.QueueSpecification queue() {
            return this.parent;
        }
    }

    private static class AmqpQuorumQueueSpecification
    implements Management.QuorumQueueSpecification {
        private final AmqpQueueSpecification parent;

        private AmqpQuorumQueueSpecification(AmqpQueueSpecification parent) {
            this.parent = parent;
        }

        @Override
        public Management.QuorumQueueSpecification deadLetterStrategy(String strategy) {
            this.parent.arg("x-dead-letter-strategy", strategy);
            return this;
        }

        @Override
        public Management.QuorumQueueSpecification deadLetterStrategy(Management.QuorumQueueDeadLetterStrategy strategy) {
            this.parent.arg("x-dead-letter-strategy", strategy.strategy());
            return this;
        }

        @Override
        public Management.QuorumQueueSpecification deliveryLimit(int limit) {
            AmqpQueueSpecification.validatePositive("x-delivery-limit", limit);
            this.parent.arg("x-delivery-limit", limit);
            return this;
        }

        @Override
        public Management.QuorumQueueSpecification quorumInitialGroupSize(int size) {
            return this.initialMemberCount(size);
        }

        @Override
        public Management.QuorumQueueSpecification initialMemberCount(int initialMemberCount) {
            AmqpQueueSpecification.validatePositive("x-quorum-initial-group-size", initialMemberCount);
            this.parent.arg("x-quorum-initial-group-size", initialMemberCount);
            return this;
        }

        @Override
        public Management.QueueSpecification queue() {
            return this.parent;
        }
    }
}

