/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.amqp.impl;

import com.rabbitmq.client.amqp.Management;
import com.rabbitmq.client.amqp.impl.AmqpConnection;
import com.rabbitmq.client.amqp.impl.RecordingTopologyListener;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EntityRecovery {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntityRecovery.class);
    private final RecordingTopologyListener listener;
    private final AmqpConnection connection;
    private final RecordingTopologyListener.Visitor recoveryVisitor;

    EntityRecovery(AmqpConnection connection, RecordingTopologyListener listener) {
        this.connection = connection;
        this.listener = listener;
        this.recoveryVisitor = new RecordingTopologyListener.Visitor(){

            @Override
            public void visitExchanges(List<RecordingTopologyListener.ExchangeSpec> exchanges) {
                if (exchanges.isEmpty()) {
                    LOGGER.debug("No exchanges to recover.");
                } else {
                    LOGGER.debug("Recovering {} exchange(s)...", (Object)exchanges.size());
                    for (RecordingTopologyListener.ExchangeSpec spec : exchanges) {
                        EntityRecovery.this.recoverExchange(spec);
                    }
                    LOGGER.debug("Exchanges recovered");
                }
            }

            @Override
            public void visitQueues(List<RecordingTopologyListener.QueueSpec> queues) {
                if (queues.isEmpty()) {
                    LOGGER.debug("No queues to recover");
                } else {
                    LOGGER.debug("Recovering {} queue(s)...", (Object)queues.size());
                    for (RecordingTopologyListener.QueueSpec spec : queues) {
                        EntityRecovery.this.recoverQueue(spec);
                    }
                    LOGGER.debug("Queues recovered");
                }
            }

            @Override
            public void visitBindings(Collection<RecordingTopologyListener.BindingSpec> bindings) {
                if (bindings.isEmpty()) {
                    LOGGER.debug("No bindings to recover");
                } else {
                    LOGGER.debug("Recovering {} binding(s)...", (Object)bindings.size());
                    for (RecordingTopologyListener.BindingSpec binding : bindings) {
                        EntityRecovery.this.recoverBinding(binding);
                    }
                    LOGGER.debug("Bindings recovered");
                }
            }
        };
    }

    void recover() {
        LOGGER.debug("Starting topology recovery");
        this.listener.accept(this.recoveryVisitor);
        LOGGER.debug("Topology recovered");
    }

    private void recoverExchange(RecordingTopologyListener.ExchangeSpec exchange) {
        LOGGER.debug("Recovering exchange {}", (Object)exchange.name());
        try {
            Management.ExchangeSpecification spec = this.connection.managementNoCheck().exchange().name(exchange.name()).autoDelete(exchange.autoDelete()).type(exchange.type());
            exchange.arguments().forEach(spec::argument);
            spec.declare();
            LOGGER.debug("Exchange {} recovered", (Object)exchange.name());
        }
        catch (Exception e) {
            LOGGER.warn("Error while recovering exchange {}", (Object)exchange.name(), (Object)e);
        }
    }

    private void recoverQueue(RecordingTopologyListener.QueueSpec queue) {
        if (queue.exclusive() || queue.autoDelete()) {
            LOGGER.debug("Recovering queue {}", (Object)queue.name());
            try {
                Management.QueueSpecification spec = this.connection.managementNoCheck().queue().name(queue.name()).exclusive(queue.exclusive()).autoDelete(queue.autoDelete());
                queue.arguments().forEach(spec::argument);
                spec.declare();
                LOGGER.debug("Queue {} recovered", (Object)queue.name());
            }
            catch (Exception e) {
                LOGGER.warn("Error while recovering queue {}", (Object)queue.name(), (Object)e);
            }
        }
    }

    private void recoverBinding(RecordingTopologyListener.BindingSpec binding) {
        try {
            Management.BindingSpecification spec = this.connection.managementNoCheck().binding().sourceExchange(binding.source()).key(binding.key());
            if (binding.toQueue()) {
                spec.destinationQueue(binding.destination());
            } else {
                spec.destinationExchange(binding.destination());
            }
            binding.arguments().forEach(spec::argument);
            spec.bind();
        }
        catch (Exception e) {
            LOGGER.warn("Error while recovering binding from {} to {} {} with binding key {}", new Object[]{binding.source(), binding.toQueue() ? "queue" : "exchange", binding.destination(), binding.key(), e});
        }
    }
}

