/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.amqp.impl;

import com.rabbitmq.client.amqp.AmqpException;
import com.rabbitmq.client.amqp.BackOffDelayPolicy;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class RetryUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(RetryUtils.class);

    private RetryUtils() {
    }

    static <T> T callAndMaybeRetry(Callable<T> operation, Predicate<Exception> retryCondition, List<Duration> waitTimes, String format, Object ... args) {
        return RetryUtils.callAndMaybeRetry(operation, retryCondition, (int i) -> i > waitTimes.size() ? BackOffDelayPolicy.TIMEOUT : (Duration)waitTimes.get(i - 1), format, args);
    }

    static <T> T callAndMaybeRetry(Callable<T> operation, Predicate<Exception> retryCondition, Duration waitTime, int attempts, String format, Object ... args) {
        return RetryUtils.callAndMaybeRetry(operation, retryCondition, (int i) -> i > attempts ? BackOffDelayPolicy.TIMEOUT : waitTime, format, args);
    }

    static <T> T callAndMaybeRetry(Callable<T> operation, Predicate<Exception> retryCondition, BackOffDelayPolicy delayPolicy, String format, Object ... args) {
        String description = String.format(format, args);
        int attempt = 0;
        Exception lastException = null;
        long startTime = System.nanoTime();
        boolean keepTrying = true;
        while (keepTrying) {
            try {
                LOGGER.debug("Starting attempt #{} for operation '{}'", (Object)(++attempt), (Object)description);
                T result = operation.call();
                Duration operationDuration = Duration.ofNanos(System.nanoTime() - startTime);
                LOGGER.debug("Operation '{}' completed in {} ms after {} attempt(s)", new Object[]{description, operationDuration.toMillis(), attempt});
                return result;
            }
            catch (Exception e) {
                lastException = e;
                if (retryCondition.test(e)) {
                    LOGGER.debug("Operation '{}' failed, retrying...", (Object)description);
                    Duration delay = delayPolicy.delay(attempt);
                    if (BackOffDelayPolicy.TIMEOUT.equals(delay)) {
                        keepTrying = false;
                        continue;
                    }
                    if (delay.isZero()) continue;
                    try {
                        Thread.sleep(delay.toMillis());
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        lastException = ex;
                        keepTrying = false;
                    }
                    continue;
                }
                keepTrying = false;
            }
        }
        String message = String.format("Could not complete task '%s' after %d attempt(s) (reason: %s)", description, attempt, RetryUtils.exceptionMessage(lastException));
        LOGGER.debug(message);
        if (lastException instanceof RuntimeException) {
            throw (RuntimeException)lastException;
        }
        throw new AmqpException(message, lastException);
    }

    static String exceptionMessage(Exception e) {
        if (e == null) {
            return "unknown";
        }
        if (e.getMessage() == null) {
            return e.getClass().getSimpleName();
        }
        return e.getMessage() + " [" + e.getClass().getSimpleName() + "]";
    }
}

