/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.amqp.observation.micrometer;

import com.rabbitmq.client.amqp.observation.micrometer.AmqpObservationDocumentation;
import com.rabbitmq.client.amqp.observation.micrometer.PublishContext;
import com.rabbitmq.client.amqp.observation.micrometer.PublishObservationConvention;
import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.common.util.StringUtils;

public class DefaultPublishObservationConvention
implements PublishObservationConvention {
    private static final String OPERATION = "publish";
    private static final String OPERATION_SUFFIX = " publish";

    public String getName() {
        return "rabbitmq.amqp.publish";
    }

    public String getContextualName(PublishContext context) {
        return this.exchange(context.exchange()) + OPERATION_SUFFIX;
    }

    private String exchange(String destination) {
        return StringUtils.isNotBlank((String)destination) ? destination : "amq.default";
    }

    public KeyValues getLowCardinalityKeyValues(PublishContext context) {
        return KeyValues.of((KeyValue[])new KeyValue[]{AmqpObservationDocumentation.LowCardinalityTags.MESSAGING_OPERATION.withValue(OPERATION), AmqpObservationDocumentation.LowCardinalityTags.MESSAGING_SYSTEM.withValue("rabbitmq"), AmqpObservationDocumentation.LowCardinalityTags.NET_PROTOCOL_NAME.withValue("amqp"), AmqpObservationDocumentation.LowCardinalityTags.NET_PROTOCOL_VERSION.withValue("1.0")});
    }

    public KeyValues getHighCardinalityKeyValues(PublishContext context) {
        KeyValues keyValues = KeyValues.of((KeyValue[])new KeyValue[]{AmqpObservationDocumentation.HighCardinalityTags.MESSAGING_DESTINATION_NAME.withValue(context.exchange()), AmqpObservationDocumentation.HighCardinalityTags.MESSAGING_MESSAGE_PAYLOAD_SIZE_BYTES.withValue(String.valueOf(context.payloadSizeBytes())), AmqpObservationDocumentation.HighCardinalityTags.NET_SOCK_PEER_ADDR.withValue(context.peerAddress()), AmqpObservationDocumentation.HighCardinalityTags.NET_SOCK_PEER_PORT.withValue(String.valueOf(context.peerPort()))});
        if (context.routingKey() != null) {
            keyValues = keyValues.and(new KeyValue[]{AmqpObservationDocumentation.HighCardinalityTags.MESSAGING_ROUTING_KEY.withValue(context.routingKey())});
        }
        if (context.messageId() != null) {
            keyValues = keyValues.and(new KeyValue[]{AmqpObservationDocumentation.HighCardinalityTags.MESSAGING_MESSAGE_ID.withValue(context.messageId())});
        }
        if (context.correlationId() != null) {
            keyValues = keyValues.and(new KeyValue[]{AmqpObservationDocumentation.HighCardinalityTags.MESSAGING_MESSAGE_CONVERSATION_ID.withValue(context.correlationId())});
        }
        return keyValues;
    }
}

