/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.buffer.impl;

import com.rabbitmq.qpid.protonj2.buffer.ProtonBuffer;
import com.rabbitmq.qpid.protonj2.buffer.ProtonBufferAccessors;
import com.rabbitmq.qpid.protonj2.buffer.ProtonBufferAllocator;
import com.rabbitmq.qpid.protonj2.buffer.ProtonBufferClosedException;
import com.rabbitmq.qpid.protonj2.buffer.ProtonBufferComponent;
import com.rabbitmq.qpid.protonj2.buffer.ProtonBufferComponentAccessor;
import com.rabbitmq.qpid.protonj2.buffer.ProtonBufferIterator;
import com.rabbitmq.qpid.protonj2.buffer.ProtonBufferReadOnlyException;
import com.rabbitmq.qpid.protonj2.buffer.ProtonBufferUtils;
import com.rabbitmq.qpid.protonj2.buffer.ProtonCompositeBuffer;
import com.rabbitmq.qpid.protonj2.resource.SharedResource;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;

public final class ProtonCompositeBufferImpl
extends SharedResource<ProtonBuffer>
implements ProtonCompositeBuffer {
    private static final ProtonBuffer[] EMPTY_COMPOSITE = new ProtonBuffer[0];
    private static final int[] EMPTY_COMPOSITE_INDICES = new int[0];
    private final ProtonBufferAllocator allocator;
    private int readOffset;
    private int writeOffset;
    private int capacity;
    private int implicitGrowthLimit = 0x7FFFFFF7;
    private boolean readOnly;
    private boolean closed;
    private final CrossChunkAccessor chunker = new CrossChunkAccessor(this);
    private final OffsetBufferAccessor offseter = new OffsetBufferAccessor(this);
    private int lastAccessedChunk = -1;
    private ProtonBuffer[] buffers = EMPTY_COMPOSITE;
    private int[] startIndices = EMPTY_COMPOSITE_INDICES;

    public ProtonCompositeBufferImpl(ProtonBufferAllocator allocator) {
        this.allocator = Objects.requireNonNull(allocator, "ProtonBufferAllocator cannot be null.");
    }

    private ProtonCompositeBufferImpl(ProtonBuffer[] chain, ProtonBufferAllocator allocator) {
        this.allocator = Objects.requireNonNull(allocator, "ProtonBufferAllocator cannot be null.");
        Objects.requireNonNull(chain, "Cannot create a split buffer from a null chain");
        this.buffers = chain;
        if (this.buffers.length > 0) {
            this.readOnly = this.buffers[0].isReadOnly();
        }
        this.fullRecomputeOfChunkIndexAndOffsetValues();
    }

    private ProtonCompositeBufferImpl(ProtonCompositeBufferImpl other) {
        this.buffers = other.buffers;
        this.startIndices = other.startIndices;
        this.allocator = other.allocator;
        this.readOnly = other.readOnly;
        this.capacity = other.capacity;
        this.readOffset = other.readOffset;
        this.writeOffset = other.writeOffset;
        this.lastAccessedChunk = other.lastAccessedChunk;
    }

    public ProtonBufferAllocator allocator() {
        return this.allocator;
    }

    @Override
    public boolean isDirect() {
        if (this.capacity == 0) {
            return false;
        }
        for (int i = 0; i < this.buffers.length; ++i) {
            if (this.buffers[i].isDirect()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ProtonCompositeBuffer convertToReadOnly() {
        for (int i = 0; i < this.buffers.length; ++i) {
            this.buffers[i].convertToReadOnly();
        }
        this.readOnly = true;
        return this;
    }

    @Override
    public int implicitGrowthLimit() {
        return this.implicitGrowthLimit;
    }

    @Override
    public ProtonCompositeBuffer implicitGrowthLimit(int limit) {
        ProtonBufferUtils.checkImplicitGrowthLimit(limit, this.capacity());
        this.implicitGrowthLimit = limit;
        return this;
    }

    @Override
    public ProtonCompositeBuffer fill(byte value) {
        ProtonBufferUtils.checkIsClosed(this);
        this.checkWriteBounds(value, 0);
        for (int i = 0; i < this.buffers.length; ++i) {
            this.buffers[i].fill(value);
        }
        return this;
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    @Override
    public int componentCount() {
        int result = 0;
        for (ProtonBuffer buffer : this.buffers) {
            result += buffer.componentCount();
        }
        return result;
    }

    @Override
    public int readableComponentCount() {
        int result = 0;
        for (ProtonBuffer buffer : this.buffers) {
            result += buffer.readableComponentCount();
        }
        return result;
    }

    @Override
    public int writableComponentCount() {
        int result = 0;
        for (ProtonBuffer buffer : this.buffers) {
            result += buffer.writableComponentCount();
        }
        return result;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public ProtonCompositeBuffer unwrap() {
        return this;
    }

    @Override
    public int getReadOffset() {
        return this.readOffset;
    }

    @Override
    public ProtonCompositeBuffer setReadOffset(int value) {
        this.checkReadBounds(value, 0);
        int remaining = value;
        for (int i = 0; i < this.buffers.length; ++i) {
            this.buffers[i].setReadOffset(Math.min(remaining, this.buffers[i].capacity()));
            remaining = Math.max(0, remaining - this.buffers[i].capacity());
        }
        this.readOffset = value;
        return this;
    }

    @Override
    public int getWriteOffset() {
        return this.writeOffset;
    }

    @Override
    public ProtonCompositeBuffer setWriteOffset(int value) {
        this.checkWriteBounds(value, 0);
        int remaining = value;
        for (int i = 0; i < this.buffers.length; ++i) {
            this.buffers[i].setWriteOffset(Math.min(remaining, this.buffers[i].capacity()));
            remaining = Math.max(0, remaining - this.buffers[i].capacity());
        }
        this.writeOffset = value;
        return this;
    }

    @Override
    public ProtonCompositeBuffer compact() {
        if (this.isClosed()) {
            throw ProtonBufferUtils.genericBufferIsClosed(this);
        }
        if (this.isReadOnly()) {
            throw new ProtonBufferReadOnlyException("Buffer must be writable in order to compact, but was read-only.");
        }
        int distance = this.readOffset;
        if (distance == 0) {
            return this;
        }
        int pos = 0;
        for (int i = this.readOffset; i < this.writeOffset; ++i) {
            this.setByte(pos++, this.getByte(i));
        }
        this.setReadOffset(0);
        this.setWriteOffset(this.writeOffset - distance);
        return this;
    }

    @Override
    public void copyInto(int offset, byte[] destination, int destOffset, int length) {
        if (this.isClosed()) {
            throw ProtonBufferUtils.genericBufferIsClosed(this);
        }
        ProtonBufferUtils.checkLength(length);
        ProtonBufferUtils.checkIsNotNegative(destOffset, "Array offset cannot be negative");
        if (offset < 0) {
            throw this.generateIndexOutOfBounds(offset, false);
        }
        if (offset + length > this.capacity) {
            throw this.generateIndexOutOfBounds(offset + length, false);
        }
        if (length == 0) {
            return;
        }
        int lastAccessedChunk = this.findChunkWithIndex(offset);
        while (length > 0) {
            ProtonBuffer buffer = this.buffers[lastAccessedChunk];
            int readBytes = Math.min(buffer.getReadableBytes(), length);
            buffer.copyInto(offset - this.startIndices[lastAccessedChunk], destination, destOffset, readBytes);
            offset += readBytes;
            length -= readBytes;
            destOffset += readBytes;
            ++lastAccessedChunk;
        }
    }

    @Override
    public void copyInto(int offset, ByteBuffer destination, int destOffset, int length) {
        int lastAccessedChunk;
        if (destination.isReadOnly()) {
            throw new ProtonBufferReadOnlyException();
        }
        if (this.isClosed()) {
            throw ProtonBufferUtils.genericBufferIsClosed(this);
        }
        ProtonBufferUtils.checkLength(length);
        ProtonBufferUtils.checkIsNotNegative(destOffset, "ByteBuffer offset cannot be negative");
        if (offset < 0) {
            throw this.generateIndexOutOfBounds(offset, false);
        }
        if (offset + length > this.capacity) {
            throw this.generateIndexOutOfBounds(offset + length, false);
        }
        int n = lastAccessedChunk = length > 0 ? this.findChunkWithIndex(offset) : 0;
        while (length > 0) {
            ProtonBuffer buffer = this.buffers[lastAccessedChunk];
            int readBytes = Math.min(buffer.getReadableBytes(), length);
            buffer.copyInto(offset - this.startIndices[lastAccessedChunk], destination, destOffset, readBytes);
            offset += readBytes;
            length -= readBytes;
            destOffset += readBytes;
            ++lastAccessedChunk;
        }
    }

    @Override
    public void copyInto(int offset, ProtonBuffer destination, int destOffset, int length) {
        int lastAccessedChunk;
        if (destination.isReadOnly()) {
            throw new ProtonBufferReadOnlyException();
        }
        if (this.isClosed()) {
            throw ProtonBufferUtils.genericBufferIsClosed(this);
        }
        ProtonBufferUtils.checkLength(length);
        ProtonBufferUtils.checkIsNotNegative(destOffset, "Buffer offset cannot be negative");
        if (offset < 0) {
            throw this.generateIndexOutOfBounds(offset, false);
        }
        if (offset + length > this.capacity) {
            throw this.generateIndexOutOfBounds(offset + length, false);
        }
        int n = lastAccessedChunk = length > 0 ? this.findChunkWithIndex(offset) : 0;
        while (length > 0) {
            ProtonBuffer buffer = this.buffers[lastAccessedChunk];
            int readBytes = Math.min(buffer.getReadableBytes(), length);
            buffer.copyInto(offset - this.startIndices[lastAccessedChunk], destination, destOffset, readBytes);
            offset += readBytes;
            length -= readBytes;
            destOffset += readBytes;
            ++lastAccessedChunk;
        }
    }

    @Override
    public ProtonCompositeBuffer writeBytes(byte[] source, int offset, int length) {
        if (this.isReadOnly()) {
            throw new ProtonBufferReadOnlyException();
        }
        if (this.isClosed()) {
            throw ProtonBufferUtils.genericBufferIsClosed(this);
        }
        ProtonBufferUtils.checkLength(length);
        ProtonBufferUtils.checkIsNotNegative(offset, "Buffer offset cannot be negative");
        if (offset < 0) {
            throw this.generateIndexOutOfBounds(offset, false);
        }
        if (offset + length > source.length) {
            throw this.generateIndexOutOfBounds(offset + length, false);
        }
        if (length != 0) {
            this.prepareForWrite(this.writeOffset, length);
            this.lastAccessedChunk = this.findChunkWithIndex(this.writeOffset) - 1;
            while (length > 0) {
                ProtonBuffer buffer = this.buffers[++this.lastAccessedChunk];
                int writableBytes = Math.min(buffer.getWritableBytes(), length);
                buffer.writeBytes(source, offset, writableBytes);
                offset += writableBytes;
                length -= writableBytes;
                this.writeOffset += writableBytes;
            }
        }
        return this;
    }

    @Override
    public ProtonCompositeBuffer writeBytes(ProtonBuffer source) {
        if (this.isReadOnly()) {
            throw new ProtonBufferReadOnlyException();
        }
        if (this.isClosed()) {
            throw ProtonBufferUtils.genericBufferIsClosed(this);
        }
        if (!source.isReadable()) {
            return this;
        }
        this.prepareForWrite(this.writeOffset, source.getReadableBytes());
        this.lastAccessedChunk = this.findChunkWithIndex(this.writeOffset) - 1;
        while (source.getReadableBytes() > 0) {
            ProtonBuffer buffer = this.buffers[++this.lastAccessedChunk];
            int writableBytes = Math.min(buffer.getWritableBytes(), source.getReadableBytes());
            source.copyInto(source.getReadOffset(), buffer, this.writeOffset - this.startIndices[this.lastAccessedChunk], writableBytes);
            buffer.advanceWriteOffset(writableBytes);
            source.advanceReadOffset(writableBytes);
            this.writeOffset += writableBytes;
        }
        return this;
    }

    @Override
    public ProtonCompositeBuffer append(ProtonBuffer buffer) {
        ProtonBuffer extension = (ProtonBuffer)Objects.requireNonNull(buffer, "Buffer to append cannot be null.").transfer();
        if (this.isClosed()) {
            extension.close();
            throw ProtonBufferUtils.genericBufferIsClosed(this);
        }
        if (extension.isReadOnly() != this.isReadOnly() && this.buffers.length > 0) {
            extension.close();
            throw new IllegalArgumentException("Appended buffer read-only state must match this buffers state");
        }
        try {
            ProtonBufferUtils.checkBufferCanGrowTo(this.capacity, extension.capacity());
        }
        catch (Exception e) {
            extension.close();
            throw e;
        }
        if (extension.capacity() == 0) {
            extension.close();
            return this;
        }
        if (this.buffers.length == 0 && !extension.isComposite()) {
            this.appendBuffer(extension);
            this.readOnly = extension.isReadOnly();
            this.readOffset = extension.getReadOffset();
            this.writeOffset = extension.getWriteOffset();
        } else if (this.writeOffset == this.capacity() && extension.getReadOffset() == 0 && !extension.isComposite()) {
            this.appendBuffer(extension);
            this.writeOffset += extension.getWriteOffset();
        } else {
            ProtonBuffer[] appendedChain = ProtonCompositeBufferImpl.buildChainFromBuffers(new ProtonBuffer[]{extension});
            if (appendedChain.length > 0) {
                ProtonBuffer[] newChain = new ProtonBuffer[appendedChain.length + this.buffers.length];
                System.arraycopy(this.buffers, 0, newChain, 0, this.buffers.length);
                System.arraycopy(appendedChain, 0, newChain, this.buffers.length, appendedChain.length);
                this.buffers = ProtonCompositeBufferImpl.filterCompositeBufferChain(newChain, this.readOnly);
                this.fullRecomputeOfChunkIndexAndOffsetValues();
            }
        }
        return this;
    }

    @Override
    public Iterable<ProtonBuffer> decomposeBuffer() {
        ProtonBufferUtils.checkIsClosed(this);
        ProtonBufferIterable decomposed = this.buffers.length == 0 ? ProtonBufferIterable.EMPTY_ITERABLE : new ProtonBufferIterable(this.buffers);
        this.buffers = EMPTY_COMPOSITE;
        this.startIndices = EMPTY_COMPOSITE_INDICES;
        this.capacity = 0;
        try {
            this.close();
        }
        catch (Throwable error) {
            for (ProtonBuffer buffer : decomposed) {
                try {
                    buffer.close();
                }
                catch (Throwable t) {
                    error.addSuppressed(t);
                }
            }
            throw error;
        }
        return decomposed;
    }

    @Override
    public ProtonCompositeBuffer ensureWritable(int size, int minimumGrowth, boolean allowCompaction) throws IndexOutOfBoundsException, IllegalArgumentException {
        if (this.isClosed()) {
            throw ProtonBufferUtils.genericBufferIsClosed(this);
        }
        ProtonBufferUtils.checkIsNotNegative(size, "New writable size value cannot be negative");
        ProtonBufferUtils.checkIsNotNegative(minimumGrowth, "Minimum growth value cannot be negative");
        if (this.isReadOnly()) {
            throw ProtonBufferUtils.genericBufferIsReadOnly(this);
        }
        if (this.getWritableBytes() >= size) {
            return this;
        }
        if (allowCompaction && this.readOffset >= size) {
            if (this.buffers.length == 1) {
                ProtonBuffer target = this.buffers[0];
                target.compact();
                this.readOffset = target.getReadOffset();
                this.writeOffset = target.getWriteOffset();
            } else {
                ProtonBuffer current;
                int compacted = 0;
                for (int i = 0; i < this.buffers.length && (current = this.buffers[i]).getReadableBytes() == current.capacity(); ++i) {
                    ++compacted;
                    current.clear();
                }
                if (compacted > 0) {
                    ProtonBuffer[] compactedSet = new ProtonBuffer[compacted];
                    System.arraycopy(this.buffers, 0, compactedSet, 0, compacted);
                    System.arraycopy(this.buffers, compacted, this.buffers, 0, this.buffers.length - compacted);
                    System.arraycopy(compactedSet, 0, this.buffers, compacted, compacted);
                    this.recomputeChunkIndexValues();
                }
            }
        }
        if (this.getWritableBytes() < size) {
            int allocate = Math.max(size - this.getWritableBytes(), minimumGrowth);
            ProtonBufferUtils.checkBufferCanGrowTo(this.capacity(), allocate);
            this.appendBuffer(this.allocator.allocate(allocate));
        }
        return this;
    }

    @Override
    public ProtonCompositeBuffer copy(int index, int length, boolean readOnly) throws IllegalArgumentException {
        ProtonBufferUtils.checkLength(length);
        this.checkGetBounds(index, length);
        if (this.isClosed()) {
            throw ProtonBufferUtils.genericBufferIsClosed(this);
        }
        ProtonBuffer[] copy = EMPTY_COMPOSITE;
        if (this.buffers.length != 0 && length > 0) {
            int startingPoint = this.findChunkWithIndex(index);
            int remaining = length - (this.buffers[startingPoint].capacity() - index);
            int requiredCopies = 1;
            int i = startingPoint + 1;
            while (i < this.buffers.length && remaining > 0) {
                remaining -= this.buffers[i].capacity();
                ++i;
                ++requiredCopies;
            }
            copy = new ProtonBuffer[requiredCopies];
            for (i = 0; i < requiredCopies; ++i) {
                ProtonBuffer current = this.buffers[startingPoint + i];
                int copyPointOffset = index - this.startIndices[startingPoint + i];
                int available = Math.min(current.capacity() - copyPointOffset, length);
                copy[i] = current.copy(copyPointOffset, available, readOnly);
                index += available;
                length -= available;
            }
        }
        return new ProtonCompositeBufferImpl(copy, this.allocator);
    }

    @Override
    public ProtonCompositeBuffer split(int splitOffset) {
        ProtonBuffer[] front;
        ProtonBufferUtils.checkIsNotNegative(splitOffset, "The split offset value cannot be negative");
        if (this.capacity() < splitOffset) {
            throw new IllegalArgumentException("The split offset cannot be greater than the buffer capacity, but the split offset was " + splitOffset + ", and capacity is " + this.capacity() + ".");
        }
        if (this.isClosed()) {
            throw ProtonBufferUtils.genericBufferIsClosed(this);
        }
        if (this.buffers.length == 0 || splitOffset == 0) {
            return new ProtonCompositeBufferImpl(this.allocator);
        }
        int splitPoint = splitOffset != this.capacity() ? this.findChunkWithIndex(splitOffset) : this.buffers.length;
        int offsetSplitOffset = splitOffset != this.capacity ? splitOffset - this.startIndices[splitPoint] : 0;
        ProtonBuffer[] rear = new ProtonBuffer[this.buffers.length - splitPoint];
        if (offsetSplitOffset != 0) {
            front = new ProtonBuffer[splitPoint + 1];
            System.arraycopy(this.buffers, 0, front, 0, splitPoint);
            System.arraycopy(this.buffers, splitPoint, rear, 0, this.buffers.length - splitPoint);
            front[splitPoint] = this.buffers[splitPoint].split(offsetSplitOffset);
        } else {
            front = new ProtonBuffer[splitPoint];
            System.arraycopy(this.buffers, 0, front, 0, splitPoint);
            System.arraycopy(this.buffers, splitPoint, rear, 0, this.buffers.length - splitPoint);
        }
        this.buffers = rear;
        this.fullRecomputeOfChunkIndexAndOffsetValues();
        return new ProtonCompositeBufferImpl(front, this.allocator);
    }

    @Override
    public ProtonCompositeBuffer splitComponentsFloor(int splitOffset) {
        ProtonBufferUtils.checkIsNotNegative(splitOffset, "The split offset value cannot be negative");
        if (this.capacity() < splitOffset) {
            throw new IllegalArgumentException("The split offset cannot be greater than the buffer capacity, but the split offset was " + splitOffset + ", and capacity is " + this.capacity() + ".");
        }
        if (this.isClosed()) {
            throw ProtonBufferUtils.genericBufferIsClosed(this);
        }
        if (this.buffers.length == 0 || splitOffset < this.buffers[0].capacity()) {
            return new ProtonCompositeBufferImpl(this.allocator);
        }
        int splitPoint = splitOffset != this.capacity() ? Math.max(1, this.findChunkWithIndex(splitOffset) - 1) : this.buffers.length;
        ProtonBuffer[] front = new ProtonBuffer[splitPoint];
        ProtonBuffer[] back = new ProtonBuffer[this.buffers.length - splitPoint];
        System.arraycopy(this.buffers, 0, front, 0, front.length);
        System.arraycopy(this.buffers, splitPoint, back, 0, back.length);
        this.buffers = back;
        this.fullRecomputeOfChunkIndexAndOffsetValues();
        return new ProtonCompositeBufferImpl(front, this.allocator);
    }

    @Override
    public ProtonCompositeBuffer splitComponentsCeil(int splitOffset) {
        ProtonBufferUtils.checkIsNotNegative(splitOffset, "The split offset value cannot be negative");
        if (this.capacity() < splitOffset) {
            throw new IllegalArgumentException("The split offset cannot be greater than the buffer capacity, but the split offset was " + splitOffset + ", and capacity is " + this.capacity() + ".");
        }
        if (this.isClosed()) {
            throw ProtonBufferUtils.genericBufferIsClosed(this);
        }
        if (this.buffers.length == 0 || splitOffset == 0) {
            return new ProtonCompositeBufferImpl(this.allocator);
        }
        int splitPoint = splitOffset != this.capacity() ? Math.min(this.buffers.length, this.findChunkWithIndex(splitOffset) + 1) : this.buffers.length;
        ProtonBuffer[] front = new ProtonBuffer[splitPoint];
        ProtonBuffer[] back = new ProtonBuffer[this.buffers.length - splitPoint];
        System.arraycopy(this.buffers, 0, front, 0, front.length);
        System.arraycopy(this.buffers, splitPoint, back, 0, back.length);
        this.buffers = back;
        this.fullRecomputeOfChunkIndexAndOffsetValues();
        return new ProtonCompositeBufferImpl(front, this.allocator);
    }

    @Override
    public byte peekByte() {
        this.checkPeek();
        return this.findIndexedAccessor(this.readOffset, 1).getByte(this.readOffset);
    }

    @Override
    public byte getByte(int index) {
        this.checkGetBounds(index, 1);
        return this.findIndexedAccessor(index, 1).getByte(index);
    }

    @Override
    public char getChar(int index) {
        this.checkGetBounds(index, 2);
        return this.findIndexedAccessor(index, 2).getChar(index);
    }

    @Override
    public short getShort(int index) {
        this.checkGetBounds(index, 2);
        return this.findIndexedAccessor(index, 2).getShort(index);
    }

    @Override
    public int getInt(int index) {
        this.checkGetBounds(index, 4);
        return this.findIndexedAccessor(index, 4).getInt(index);
    }

    @Override
    public long getLong(int index) {
        this.checkGetBounds(index, 8);
        return this.findIndexedAccessor(index, 8).getLong(index);
    }

    @Override
    public ProtonBuffer setByte(int index, byte value) {
        this.checkWriteBounds(index, 1);
        this.findIndexedAccessor(index, 1).setByte(index, value);
        return this;
    }

    @Override
    public ProtonBuffer setChar(int index, char value) {
        this.checkWriteBounds(index, 2);
        this.findIndexedAccessor(index, 2).setChar(index, value);
        return this;
    }

    @Override
    public ProtonBuffer setShort(int index, short value) {
        this.checkWriteBounds(index, 2);
        this.findIndexedAccessor(index, 2).setShort(index, value);
        return this;
    }

    @Override
    public ProtonBuffer setInt(int index, int value) {
        this.checkWriteBounds(index, 4);
        this.findIndexedAccessor(index, 4).setInt(index, value);
        return this;
    }

    @Override
    public ProtonBuffer setLong(int index, long value) {
        this.checkWriteBounds(index, 8);
        this.findIndexedAccessor(index, 8).setLong(index, value);
        return this;
    }

    @Override
    public byte readByte() {
        this.checkReadBounds(this.readOffset, 1);
        return this.findReadAccessor(1).readByte();
    }

    @Override
    public char readChar() {
        this.checkReadBounds(this.readOffset, 2);
        return this.findReadAccessor(2).readChar();
    }

    @Override
    public short readShort() {
        this.checkReadBounds(this.readOffset, 2);
        return this.findReadAccessor(2).readShort();
    }

    @Override
    public int readInt() {
        this.checkReadBounds(this.readOffset, 4);
        return this.findReadAccessor(4).readInt();
    }

    @Override
    public long readLong() {
        this.checkReadBounds(this.readOffset, 8);
        return this.findReadAccessor(8).readLong();
    }

    @Override
    public ProtonBuffer writeByte(byte value) {
        this.prepareForWrite(this.writeOffset, 1);
        this.findWriteAccessor(1).writeByte(value);
        return this;
    }

    @Override
    public ProtonBuffer writeChar(char value) {
        this.prepareForWrite(this.writeOffset, 2);
        this.findWriteAccessor(2).writeChar(value);
        return this;
    }

    @Override
    public ProtonBuffer writeShort(short value) {
        this.prepareForWrite(this.writeOffset, 2);
        this.findWriteAccessor(2).writeShort(value);
        return this;
    }

    @Override
    public ProtonBuffer writeInt(int value) {
        this.prepareForWrite(this.writeOffset, 4);
        this.findWriteAccessor(4).writeInt(value);
        return this;
    }

    @Override
    public ProtonBuffer writeLong(long value) {
        this.prepareForWrite(this.writeOffset, 8);
        this.findWriteAccessor(8).writeLong(value);
        return this;
    }

    public boolean equals(Object o) {
        return o instanceof ProtonBuffer && ProtonBufferUtils.equals(this, (ProtonBuffer)o);
    }

    public int hashCode() {
        return ProtonBufferUtils.hashCode(this);
    }

    public String toString() {
        return "ProtonCompositeBuffer{ read:" + this.readOffset + ", write: " + this.writeOffset + ", capacity: " + this.capacity + "}";
    }

    @Override
    public int transferTo(WritableByteChannel channel, int length) throws IOException {
        if (this.isClosed()) {
            throw ProtonBufferUtils.genericBufferIsClosed(this);
        }
        ProtonBufferUtils.checkIsNotNegative(length, "TransferTo length cannot be negative: " + length);
        int writableBytes = Math.min(this.getReadableBytes(), length);
        this.checkGetBounds(this.readOffset, writableBytes);
        if (writableBytes == 0) {
            return 0;
        }
        if (channel instanceof GatheringByteChannel) {
            return this.transferToGatheringByteChannel((GatheringByteChannel)channel, writableBytes);
        }
        return this.transferToWritableByteChannel(channel, writableBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int transferToGatheringByteChannel(GatheringByteChannel channel, int length) throws IOException {
        ByteBuffer[] composingBuffers = new ByteBuffer[this.readableComponentCount()];
        int count = 0;
        int bytesWritten = 0;
        try (ProtonBufferComponentAccessor accessor = this.componentAccessor();){
            ProtonBufferComponent component = accessor.firstReadable();
            while (component != null) {
                composingBuffers[count++] = component.getReadableBuffer();
                component = accessor.nextReadable();
            }
            for (count = 0; count < composingBuffers.length && length > 0; ++count) {
                if ((length -= composingBuffers[count].remaining()) >= 0) continue;
                ByteBuffer buffer = composingBuffers[count];
                buffer.limit(buffer.limit() + length);
            }
            bytesWritten = Math.toIntExact(channel.write(composingBuffers, 0, count));
        }
        finally {
            if (bytesWritten > 0) {
                this.advanceReadOffset(bytesWritten);
            }
        }
        return bytesWritten;
    }

    private int transferToWritableByteChannel(WritableByteChannel channel, int length) throws IOException {
        int chunkedWrite;
        ProtonBuffer buffer;
        int bytesWritten;
        int written;
        int currentChunkIndex = this.findChunkWithIndex(this.readOffset);
        for (bytesWritten = 0; bytesWritten < length && currentChunkIndex < this.buffers.length && (written = (buffer = this.buffers[currentChunkIndex]).transferTo(channel, chunkedWrite = Math.min(buffer.getReadableBytes(), length))) != 0; bytesWritten += written, ++currentChunkIndex) {
            this.readOffset = Math.addExact(this.readOffset, written);
        }
        return bytesWritten;
    }

    @Override
    public int transferFrom(ReadableByteChannel channel, int length) throws IOException {
        int bytesRead;
        int read;
        ProtonBufferUtils.checkArgumentIsNotNegative(length, "Length given cannot be negative");
        ProtonBufferUtils.checkIsClosed(this);
        ProtonBufferUtils.checkIsReadOnly(this);
        int readableBytes = Math.min(this.getWritableBytes(), length);
        if (readableBytes == 0) {
            return 0;
        }
        this.checkWriteBounds(this.getWriteOffset(), readableBytes);
        int lastAccessedChunk = this.findChunkWithIndex(this.writeOffset);
        for (bytesRead = 0; bytesRead < readableBytes && lastAccessedChunk < this.buffers.length; bytesRead += read, ++lastAccessedChunk) {
            ProtonBuffer buffer = this.buffers[lastAccessedChunk];
            int chunckedRead = Math.min(buffer.getWritableBytes(), readableBytes);
            read = buffer.transferFrom(channel, chunckedRead);
            if (read <= 0) {
                bytesRead = bytesRead == 0 ? -1 : bytesRead;
                break;
            }
            this.writeOffset = Math.addExact(this.writeOffset, read);
        }
        return bytesRead;
    }

    @Override
    public int transferFrom(FileChannel channel, long position, int length) throws IOException {
        ProtonBufferUtils.checkArgumentIsNotNegative(position, "Position");
        ProtonBufferUtils.checkArgumentIsNotNegative(length, "Length");
        ProtonBufferUtils.checkIsClosed(this);
        ProtonBufferUtils.checkIsReadOnly(this);
        int readableBytes = Math.min(this.getWritableBytes(), length);
        if (readableBytes == 0) {
            return 0;
        }
        this.checkWriteBounds(this.getWriteOffset(), readableBytes);
        int lastAccessedChunk = this.findChunkWithIndex(this.writeOffset);
        int bytesRead = 0;
        while (bytesRead < readableBytes && lastAccessedChunk < this.buffers.length) {
            ProtonBuffer buffer = this.buffers[lastAccessedChunk];
            int chunckedRead = Math.min(buffer.getWritableBytes(), readableBytes);
            int read = buffer.transferFrom(channel, position, chunckedRead);
            if (read <= 0) {
                bytesRead = bytesRead == 0 ? -1 : bytesRead;
                break;
            }
            this.writeOffset = Math.addExact(this.writeOffset, read);
            bytesRead += read;
            position += (long)read;
            ++lastAccessedChunk;
        }
        return bytesRead;
    }

    @Override
    public ProtonBufferIterator bufferIterator(int offset, int length) {
        ProtonBufferUtils.checkIsClosed(this);
        ProtonBufferUtils.checkArgumentIsNotNegative(offset, "offset");
        ProtonBufferUtils.checkArgumentIsNotNegative(length, "length");
        if (offset + length > this.capacity()) {
            throw new IndexOutOfBoundsException("The iterator cannot read beyond the bounds of the buffer: offset=" + offset + ", length=" + length);
        }
        return new ProtonCompositeBufferIterator(offset, length);
    }

    @Override
    public ProtonBufferIterator bufferReverseIterator(int offset, int length) {
        ProtonBufferUtils.checkIsClosed(this);
        ProtonBufferUtils.checkArgumentIsNotNegative(offset, "offset");
        ProtonBufferUtils.checkArgumentIsNotNegative(length, "length");
        if (offset >= this.capacity()) {
            throw new IndexOutOfBoundsException("Read offset must be within the bounds of the buffer: offset = " + offset + ", capacity = " + this.capacity());
        }
        if (offset - length < -1) {
            throw new IndexOutOfBoundsException("Cannot read past start of buffer: offset = " + offset + ", length = " + length);
        }
        return new ProtonCompositeBufferReverseIterator(offset, length);
    }

    @Override
    public int indexOf(byte needle, int offset, int length) {
        ProtonBufferUtils.checkIsClosed(this);
        this.checkIndexOfBounds(offset, length);
        int bytesRead = 0;
        int lastAccessedChunk = this.findChunkWithIndex(offset);
        int readOffset = offset - this.startIndices[lastAccessedChunk];
        while (length > 0 && lastAccessedChunk != this.buffers.length) {
            int result;
            ProtonBuffer buffer;
            int readableBytes = Math.min(buffer.capacity(), length);
            if ((result = (buffer = this.buffers[lastAccessedChunk++]).indexOf(needle, readOffset, readableBytes)) != -1) {
                return bytesRead + result;
            }
            bytesRead += buffer.getReadableBytes();
            length -= buffer.getReadableBytes();
            readOffset = 0;
        }
        return -1;
    }

    @Override
    public ProtonBufferComponentAccessor componentAccessor() {
        if (this.isClosed()) {
            throw ProtonBufferUtils.genericBufferIsClosed(this);
        }
        return new ProtonCompositeBufferComponentAccessor((ProtonCompositeBufferImpl)this.acquire());
    }

    public static ProtonCompositeBuffer create(ProtonBufferAllocator allocator) {
        return new ProtonCompositeBufferImpl(allocator);
    }

    public static ProtonCompositeBuffer create(ProtonBufferAllocator allocator, ProtonBuffer[] buffers) {
        ProtonCompositeBufferImpl result;
        Objects.requireNonNull(buffers, "Provided buffers array cannot be null");
        boolean readOnly = buffers[0].isReadOnly();
        ProtonBuffer[] chain = ProtonCompositeBufferImpl.buildChainFromBuffers(Arrays.copyOf(buffers, buffers.length));
        try {
            result = chain.length == 0 ? new ProtonCompositeBufferImpl(allocator) : new ProtonCompositeBufferImpl(ProtonCompositeBufferImpl.filterCompositeBufferChain(chain, readOnly), allocator);
        }
        catch (RuntimeException e) {
            throw ProtonCompositeBufferImpl.closeBuffers(buffers, chain, e);
        }
        return result;
    }

    public static ProtonCompositeBuffer create(ProtonBufferAllocator allocator, ProtonBuffer buffer) {
        ProtonCompositeBufferImpl result;
        Objects.requireNonNull(buffer, "Provided buffers cannot be null");
        ProtonBuffer[] chain = ProtonCompositeBufferImpl.buildChainFromBuffers(new ProtonBuffer[]{buffer});
        try {
            result = chain.length == 0 ? new ProtonCompositeBufferImpl(allocator) : new ProtonCompositeBufferImpl(chain, allocator);
        }
        catch (RuntimeException e) {
            throw ProtonCompositeBufferImpl.closeBuffers(new ProtonBuffer[]{buffer}, chain, e);
        }
        return result;
    }

    @Override
    protected void releaseResourceOwnership() {
        this.closed = true;
        this.readOnly = false;
        this.capacity = 0;
        this.readOffset = 0;
        this.writeOffset = 0;
        try {
            for (int i = 0; i < this.buffers.length; ++i) {
                try {
                    this.buffers[i].close();
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        finally {
            this.buffers = EMPTY_COMPOSITE;
            this.startIndices = EMPTY_COMPOSITE_INDICES;
        }
    }

    @Override
    protected ProtonBuffer transferTheResource() {
        ProtonCompositeBufferImpl transfer = new ProtonCompositeBufferImpl(this);
        this.buffers = EMPTY_COMPOSITE;
        this.startIndices = EMPTY_COMPOSITE_INDICES;
        return transfer;
    }

    @Override
    protected RuntimeException resourceIsClosedException() {
        return ProtonBufferUtils.genericBufferIsClosed(this);
    }

    private static ProtonBuffer[] buildChainFromBuffers(ProtonBuffer[] buffers) {
        RuntimeException suppressed = null;
        ProtonBuffer[] chain = buffers;
        int totalChunks = 0;
        for (int i = 0; i < chain.length; ++i) {
            try {
                if (buffers[i].capacity() > 0) {
                    if (buffers[i].isComposite()) {
                        int bufferCount = buffers[i].componentCount();
                        if (bufferCount > 1) {
                            chain = Arrays.copyOf(chain, chain.length + bufferCount - 1);
                        }
                        for (ProtonBuffer buffer : ((ProtonCompositeBuffer)buffers[i]).decomposeBuffer()) {
                            chain[totalChunks++] = buffer;
                        }
                        i += bufferCount - 1;
                        continue;
                    }
                    chain[i] = (ProtonBuffer)buffers[i].transfer();
                    ++totalChunks;
                    continue;
                }
                if (buffers[i].isClosed()) {
                    throw new ProtonBufferClosedException("Cannot create a composite from a closed buffer");
                }
                buffers[i].close();
                continue;
            }
            catch (RuntimeException e) {
                suppressed = e;
                break;
            }
        }
        if (suppressed != null) {
            throw ProtonCompositeBufferImpl.closeBuffers(buffers, chain, suppressed);
        }
        if (chain.length > totalChunks) {
            chain = Arrays.copyOf(chain, totalChunks);
        }
        return chain;
    }

    private static RuntimeException closeBuffers(ProtonBuffer[] source, ProtonBuffer[] captured, RuntimeException exRoot) {
        for (int i = 0; i < captured.length && captured[i] != null; ++i) {
            try {
                captured[i].close();
                continue;
            }
            catch (Throwable e) {
                exRoot.addSuppressed(e);
            }
        }
        for (ProtonBuffer buffer : source) {
            try {
                buffer.close();
            }
            catch (Throwable e) {
                exRoot.addSuppressed(e);
            }
        }
        return exRoot;
    }

    private void checkPeek() {
        if (this.readOffset == this.writeOffset) {
            throw this.generateIndexOutOfBounds(this.readOffset, false);
        }
    }

    private void checkGetBounds(int index, int size) {
        if (index < 0 || this.capacity < index + size) {
            throw this.generateIndexOutOfBounds(index, false);
        }
    }

    private void checkReadBounds(int index, int size) {
        if (index < 0 || this.writeOffset < index + size) {
            throw this.generateIndexOutOfBounds(index, false);
        }
    }

    private void checkIndexOfBounds(int index, int size) {
        if (index < this.readOffset || this.writeOffset < index + size) {
            throw this.generateIndexOutOfBounds(index, false);
        }
    }

    private void prepareForWrite(int index, int size) {
        if (this.getWritableBytes() < size && this.writeOffset + size <= this.implicitGrowthLimit && !this.readOnly) {
            int minGrowth = this.buffers.length == 0 ? Math.min(this.implicitGrowthLimit, 64) : Math.min(Math.max(this.capacity() / this.buffers.length * 2, size), this.implicitGrowthLimit - this.capacity);
            this.ensureWritable(size, minGrowth, false);
        }
        this.checkWriteBounds(index, size);
    }

    private void checkWriteBounds(int index, int size) {
        if (index < 0 || this.capacity < index + size || this.readOnly) {
            throw this.generateIndexOutOfBounds(index, true);
        }
    }

    private RuntimeException generateIndexOutOfBounds(int index, boolean write) {
        if (this.closed) {
            return ProtonBufferUtils.genericBufferIsClosed(this);
        }
        if (write && this.readOnly) {
            return ProtonBufferUtils.genericBufferIsReadOnly(this);
        }
        return new IndexOutOfBoundsException("Index " + index + " is out of bounds: [read 0 to " + this.writeOffset + ", write 0 to " + this.capacity + "].");
    }

    private ProtonBufferAccessors findIndexedAccessor(int index, int size) {
        int chunkForIndex = this.findChunkWithIndex(index);
        ProtonBufferAccessors accessor = size > this.buffers[chunkForIndex].capacity() - (index - this.startIndices[chunkForIndex]) ? this.chunker.prepare(chunkForIndex) : this.offseter.prepare(chunkForIndex);
        return accessor;
    }

    private ProtonBufferAccessors findReadAccessor(int size) {
        int chunkForIndex = this.findChunkWithIndex(this.readOffset);
        ProtonBufferAccessors accessor = this.buffers[chunkForIndex].getReadableBytes() < size ? this.chunker.prepare(chunkForIndex) : this.buffers[chunkForIndex];
        this.readOffset += size;
        return accessor;
    }

    private ProtonBufferAccessors findWriteAccessor(int size) {
        int chunkForIndex = this.findChunkWithIndex(this.writeOffset);
        ProtonBufferAccessors accessor = this.buffers[chunkForIndex].getWritableBytes() < size ? this.chunker.prepare(chunkForIndex) : this.buffers[chunkForIndex];
        this.writeOffset += size;
        return accessor;
    }

    private int findChunkWithIndex(int index) {
        if (index < this.startIndices[this.lastAccessedChunk]) {
            do {
                --this.lastAccessedChunk;
            } while (index < this.startIndices[this.lastAccessedChunk]);
        } else if (index >= this.startIndices[this.lastAccessedChunk] + this.buffers[this.lastAccessedChunk].capacity()) {
            do {
                ++this.lastAccessedChunk;
            } while (index >= this.startIndices[this.lastAccessedChunk] + this.buffers[this.lastAccessedChunk].capacity());
        }
        return this.lastAccessedChunk;
    }

    private void recomputeChunkIndexValues() {
        int i = 0;
        int capacity = 0;
        while (i < this.buffers.length) {
            this.startIndices[i] = capacity;
            capacity += this.buffers[i++].capacity();
        }
    }

    private void fullRecomputeOfChunkIndexAndOffsetValues() {
        int totalCapcity = 0;
        int writeOffset = 0;
        int readOffset = 0;
        if (this.startIndices.length != this.buffers.length) {
            this.startIndices = new int[this.buffers.length];
        }
        boolean compositeWriteOffsetFound = false;
        boolean compositeReadOffsetFound = false;
        for (int i = 0; i < this.buffers.length; ++i) {
            if (!compositeWriteOffsetFound) {
                writeOffset += this.buffers[i].getWriteOffset();
                if (this.buffers[i].getWritableBytes() > 0) {
                    compositeWriteOffsetFound = true;
                }
            } else if (this.buffers[i].getWriteOffset() != 0) {
                throw new IllegalArgumentException("The given buffers cannot be composed because they leave an unwritten gap: ");
            }
            if (!compositeReadOffsetFound) {
                readOffset += this.buffers[i].getReadOffset();
                if (this.buffers[i].getReadableBytes() > 0 || compositeWriteOffsetFound) {
                    compositeReadOffsetFound = true;
                }
            } else if (this.buffers[i].getReadOffset() != 0) {
                throw new IllegalArgumentException("The given buffers cannot be composed because they leave an unread gap: ");
            }
            this.startIndices[i] = totalCapcity;
            totalCapcity += this.buffers[i].capacity();
        }
        ProtonBufferUtils.checkBufferCanGrowTo(totalCapcity, 0);
        this.readOffset = readOffset;
        this.writeOffset = writeOffset;
        this.capacity = totalCapcity;
        this.lastAccessedChunk = 0;
    }

    private ProtonCompositeBuffer appendBuffer(ProtonBuffer buffer) {
        ProtonBuffer[] newBuffers = Arrays.copyOf(this.buffers, this.buffers.length + 1);
        int[] newIndices = Arrays.copyOf(this.startIndices, newBuffers.length);
        newBuffers[this.buffers.length] = buffer;
        newIndices[this.buffers.length] = this.capacity;
        this.capacity += buffer.capacity();
        if (this.lastAccessedChunk == -1) {
            this.lastAccessedChunk = 0;
        }
        this.buffers = newBuffers;
        this.startIndices = newIndices;
        return this;
    }

    private static ProtonBuffer[] filterCompositeBufferChain(ProtonBuffer[] chain, boolean readOnlyExpectation) {
        int i;
        int firstReadable = -1;
        int lastReadable = -1;
        int totalChunks = chain.length;
        int totalCapacity = 0;
        int readableBytes = 0;
        for (i = 0; i < chain.length; ++i) {
            if (readOnlyExpectation != chain[i].isReadOnly()) {
                throw new IllegalArgumentException("The buffers must all have the same read-only state");
            }
            if (chain[i].getReadableBytes() != 0) {
                if (firstReadable == -1) {
                    firstReadable = i;
                }
                lastReadable = i;
            }
            totalCapacity += chain[i].capacity();
            readableBytes += chain[i].getReadableBytes();
        }
        if (firstReadable != -1 && totalCapacity != readableBytes) {
            for (i = 0; i < totalChunks; ++i) {
                ProtonBuffer buffer = chain[i];
                if (i > firstReadable && i < lastReadable && buffer.getReadableBytes() == 0) {
                    buffer.close();
                    System.arraycopy(chain, i + 1, chain, i, chain.length - (i + 1));
                    --lastReadable;
                    --totalChunks;
                    --i;
                    continue;
                }
                if (i > firstReadable && buffer.getReadOffset() > 0) {
                    buffer.readSplit(0).close();
                }
                if (i >= lastReadable || buffer.getWriteOffset() == buffer.capacity()) continue;
                if (buffer.getWriteOffset() == 0) {
                    System.arraycopy(chain, i + 1, chain, i, chain.length - (i + 1));
                    --lastReadable;
                    --totalChunks;
                    --i;
                } else {
                    chain[i] = buffer.split();
                }
                buffer.close();
            }
            if (chain.length > totalChunks) {
                chain = Arrays.copyOf(chain, totalChunks);
            }
        }
        return chain;
    }

    private static final class ProtonCompositeBufferComponentAccessor
    implements ProtonBufferComponentAccessor,
    ProtonBufferComponent {
        private final ProtonCompositeBufferImpl composite;
        private ProtonBufferComponentAccessor currentAccessor;
        private ProtonBufferComponent currentComponent;
        private int bufferIndex;
        private int cumulativeReadSkip;
        private int cumulativeWriteSkip;

        public ProtonCompositeBufferComponentAccessor(ProtonCompositeBufferImpl composite) {
            this.composite = composite;
        }

        @Override
        public void close() {
            if (this.currentAccessor != null) {
                this.currentAccessor.close();
                this.currentAccessor = null;
            }
            this.composite.close();
        }

        @Override
        public ProtonBufferComponent first() {
            if (this.currentAccessor != null) {
                this.currentAccessor.close();
                this.currentAccessor = null;
            }
            if (this.composite.buffers.length != 0) {
                this.currentAccessor = this.composite.buffers[0].componentAccessor();
                this.currentComponent = this.currentAccessor.first();
                this.bufferIndex = 0;
            }
            return this.currentComponent == null ? null : this;
        }

        @Override
        public ProtonBufferComponent next() {
            ProtonBufferComponent next;
            ProtonBufferComponent protonBufferComponent = next = this.currentAccessor != null ? this.currentAccessor.next() : null;
            if (next == null && this.currentAccessor != null) {
                this.currentAccessor.close();
                this.currentAccessor = null;
                this.currentComponent = null;
                if (this.composite.buffers.length > ++this.bufferIndex) {
                    this.currentAccessor = this.composite.buffers[this.bufferIndex].componentAccessor();
                    this.currentComponent = this.currentAccessor.first();
                }
            }
            return this.currentComponent == null ? null : this;
        }

        @Override
        public int getReadableBytes() {
            return this.currentComponent.getReadableBytes();
        }

        @Override
        public boolean hasReadbleArray() {
            return this.currentComponent.hasReadbleArray();
        }

        @Override
        public ProtonBufferComponent advanceReadOffset(int amount) {
            this.currentComponent.advanceReadOffset(amount);
            this.composite.setReadOffset(this.cumulativeReadSkip + amount);
            this.cumulativeReadSkip += amount;
            return this.currentComponent;
        }

        @Override
        public byte[] getReadableArray() {
            return this.currentComponent.getReadableArray();
        }

        @Override
        public int getReadableArrayOffset() {
            return this.currentComponent.getReadableArrayOffset();
        }

        @Override
        public int getReadableArrayLength() {
            return this.currentComponent.getReadableArrayLength();
        }

        @Override
        public ByteBuffer getReadableBuffer() {
            return this.currentComponent.getReadableBuffer();
        }

        @Override
        public int getWritableBytes() {
            return this.currentComponent.getWritableBytes();
        }

        @Override
        public ProtonBufferComponent advanceWriteOffset(int amount) {
            this.currentComponent.advanceWriteOffset(amount);
            this.composite.setWriteOffset(this.cumulativeWriteSkip + amount);
            this.cumulativeWriteSkip += amount;
            return this.currentComponent;
        }

        @Override
        public boolean hasWritableArray() {
            return this.currentComponent.hasWritableArray();
        }

        @Override
        public byte[] getWritableArray() {
            return this.currentComponent.getWritableArray();
        }

        @Override
        public int getWritableArrayOffset() {
            return this.currentComponent.getWritableArrayOffset();
        }

        @Override
        public int getWritableArrayLength() {
            return this.currentComponent.getWritableArrayLength();
        }

        @Override
        public ByteBuffer getWritableBuffer() {
            return this.currentComponent.getWritableBuffer();
        }

        @Override
        public long getNativeAddress() {
            return this.currentComponent.getNativeAddress();
        }

        @Override
        public long getNativeReadAddress() {
            return this.currentComponent.getNativeReadAddress();
        }

        @Override
        public long getNativeWriteAddress() {
            return this.currentComponent.getNativeWriteAddress();
        }

        @Override
        public ProtonBufferIterator bufferIterator() {
            return this.currentComponent.bufferIterator();
        }

        @Override
        public Object unwrap() {
            return this.currentComponent.unwrap();
        }
    }

    private static class ProtonBufferIterable
    implements Iterable<ProtonBuffer> {
        public static final Iterable<ProtonBuffer> EMPTY_ITERABLE = Collections.emptyList();
        private final ProtonBuffer[] chain;

        public ProtonBufferIterable(ProtonBuffer[] chain) {
            this.chain = chain;
        }

        @Override
        public Iterator<ProtonBuffer> iterator() {
            return new ProtonBufferIterator();
        }

        private final class ProtonBufferIterator
        implements Iterator<ProtonBuffer> {
            private int next = 0;

            @Override
            public boolean hasNext() {
                return this.next < ProtonBufferIterable.this.chain.length;
            }

            @Override
            public ProtonBuffer next() {
                if (this.next == ProtonBufferIterable.this.chain.length) {
                    throw new NoSuchElementException();
                }
                ProtonBuffer result = ProtonBufferIterable.this.chain[this.next++];
                return result;
            }
        }
    }

    private static class CrossChunkAccessor
    implements ProtonBufferAccessors {
        private final ProtonCompositeBufferImpl parent;
        private int chunk;

        public CrossChunkAccessor(ProtonCompositeBufferImpl parent) {
            this.parent = parent;
        }

        public ProtonBufferAccessors prepare(int chunk) {
            this.chunk = chunk;
            return this;
        }

        @Override
        public byte peekByte() {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte getByte(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ProtonBuffer setByte(int index, byte value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte readByte() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ProtonBuffer writeByte(byte value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public char getChar(int index) {
            char result = '\u0000';
            result = (char)(result | (this.parent.buffers[this.chunk].getByte(index - this.parent.startIndices[this.chunk]) & 0xFF) << 8);
            result = (char)(result | this.parent.buffers[++this.chunk].getByte(0) & 0xFF);
            return result;
        }

        @Override
        public ProtonBuffer setChar(int index, char value) {
            this.parent.buffers[this.chunk].setByte(index - this.parent.startIndices[this.chunk], (byte)(value >>> 8));
            this.parent.buffers[++this.chunk].setByte(0, (byte)(value & 0xFF));
            return this.parent;
        }

        @Override
        public char readChar() {
            char result = '\u0000';
            result = (char)(result | (this.parent.buffers[this.chunk].readByte() & 0xFF) << 8);
            result = (char)(result | this.parent.buffers[++this.chunk].readByte() & 0xFF);
            return result;
        }

        @Override
        public ProtonBuffer writeChar(char value) {
            this.parent.buffers[this.chunk].writeByte((byte)(value >>> 8));
            this.parent.buffers[++this.chunk].writeByte((byte)(value & 0xFF));
            return this.parent;
        }

        @Override
        public short getShort(int index) {
            short result = 0;
            result = (short)(result | (this.parent.buffers[this.chunk].getByte(index - this.parent.startIndices[this.chunk]) & 0xFF) << 8);
            result = (short)(result | this.parent.buffers[++this.chunk].getByte(0) & 0xFF);
            return result;
        }

        @Override
        public ProtonBuffer setShort(int index, short value) {
            this.parent.buffers[this.chunk].setByte(index - this.parent.startIndices[this.chunk], (byte)(value >>> 8));
            this.parent.buffers[++this.chunk].setByte(0, (byte)(value & 0xFF));
            return this.parent;
        }

        @Override
        public short readShort() {
            short result = 0;
            result = (short)(result | (this.parent.buffers[this.chunk].readByte() & 0xFF) << 8);
            result = (short)(result | this.parent.buffers[++this.chunk].readByte() & 0xFF);
            return result;
        }

        @Override
        public ProtonBuffer writeShort(short value) {
            this.parent.buffers[this.chunk].writeByte((byte)(value >>> 8));
            this.parent.buffers[++this.chunk].writeByte((byte)(value & 0xFF));
            return this.parent;
        }

        @Override
        public int getInt(int index) {
            int result = 0;
            index -= this.parent.startIndices[this.chunk];
            for (int i = 3; i >= 0; --i) {
                result |= (this.parent.buffers[this.chunk].getByte(index++) & 0xFF) << i * 8;
                if (this.parent.buffers[this.chunk].capacity() > index) continue;
                ++this.chunk;
                index = 0;
            }
            return result;
        }

        @Override
        public ProtonBuffer setInt(int index, int value) {
            index -= this.parent.startIndices[this.chunk];
            for (int i = 3; i >= 0; --i) {
                this.parent.buffers[this.chunk].setByte(index++, (byte)(value >>> i * 8));
                if (this.parent.buffers[this.chunk].capacity() > index) continue;
                ++this.chunk;
                index = 0;
            }
            return this.parent;
        }

        @Override
        public int readInt() {
            int result = 0;
            for (int i = 3; i >= 0; --i) {
                result |= (this.parent.buffers[this.chunk].readByte() & 0xFF) << i * 8;
                if (this.parent.buffers[this.chunk].getReadableBytes() > 0) continue;
                ++this.chunk;
            }
            return result;
        }

        @Override
        public ProtonBuffer writeInt(int value) {
            for (int i = 3; i >= 0; --i) {
                this.parent.buffers[this.chunk].writeByte((byte)(value >>> i * 8));
                if (this.parent.buffers[this.chunk].getWritableBytes() > 0) continue;
                ++this.chunk;
            }
            return this.parent;
        }

        @Override
        public long getLong(int index) {
            long result = 0L;
            index -= this.parent.startIndices[this.chunk];
            for (int i = 7; i >= 0; --i) {
                result |= (long)(this.parent.buffers[this.chunk].getByte(index++) & 0xFF) << i * 8;
                if (this.parent.buffers[this.chunk].capacity() > index) continue;
                ++this.chunk;
                index = 0;
            }
            return result;
        }

        @Override
        public ProtonBuffer setLong(int index, long value) {
            index -= this.parent.startIndices[this.chunk];
            for (int i = 7; i >= 0; --i) {
                this.parent.buffers[this.chunk].setByte(index++, (byte)(value >>> i * 8));
                if (this.parent.buffers[this.chunk].capacity() > index) continue;
                ++this.chunk;
                index = 0;
            }
            return this.parent;
        }

        @Override
        public long readLong() {
            long result = 0L;
            for (int i = 7; i >= 0; --i) {
                result |= (long)(this.parent.buffers[this.chunk].readByte() & 0xFF) << i * 8;
                if (this.parent.buffers[this.chunk].getReadableBytes() > 0) continue;
                ++this.chunk;
            }
            return result;
        }

        @Override
        public ProtonBuffer writeLong(long value) {
            for (int i = 7; i >= 0; --i) {
                this.parent.buffers[this.chunk].writeByte((byte)(value >>> i * 8));
                if (this.parent.buffers[this.chunk].getWritableBytes() > 0) continue;
                ++this.chunk;
            }
            return this.parent;
        }
    }

    private static class OffsetBufferAccessor
    implements ProtonBufferAccessors {
        private int chunkIndex;
        private int startIndex;
        private final ProtonCompositeBufferImpl parent;

        public OffsetBufferAccessor(ProtonCompositeBufferImpl parent) {
            this.parent = parent;
        }

        public ProtonBufferAccessors prepare(int chunkIndex) {
            this.chunkIndex = chunkIndex;
            this.startIndex = this.parent.startIndices[chunkIndex];
            return this;
        }

        private int offset(int index) {
            return index - this.startIndex;
        }

        @Override
        public byte peekByte() {
            return this.parent.buffers[this.chunkIndex].peekByte();
        }

        @Override
        public byte getByte(int index) {
            return this.parent.buffers[this.chunkIndex].getByte(this.offset(index));
        }

        @Override
        public ProtonBuffer setByte(int index, byte value) {
            return this.parent.buffers[this.chunkIndex].setByte(this.offset(index), value);
        }

        @Override
        public byte readByte() {
            return this.parent.buffers[this.chunkIndex].readByte();
        }

        @Override
        public ProtonBuffer writeByte(byte value) {
            return this.parent.buffers[this.chunkIndex].writeByte(value);
        }

        @Override
        public char getChar(int index) {
            return this.parent.buffers[this.chunkIndex].getChar(this.offset(index));
        }

        @Override
        public ProtonBuffer setChar(int index, char value) {
            return this.parent.buffers[this.chunkIndex].setChar(this.offset(index), value);
        }

        @Override
        public char readChar() {
            return this.parent.buffers[this.chunkIndex].readChar();
        }

        @Override
        public ProtonBuffer writeChar(char value) {
            return this.parent.buffers[this.chunkIndex].writeChar(value);
        }

        @Override
        public short getShort(int index) {
            return this.parent.buffers[this.chunkIndex].getShort(this.offset(index));
        }

        @Override
        public ProtonBuffer setShort(int index, short value) {
            return this.parent.buffers[this.chunkIndex].setShort(this.offset(index), value);
        }

        @Override
        public short readShort() {
            return this.parent.buffers[this.chunkIndex].readShort();
        }

        @Override
        public ProtonBuffer writeShort(short value) {
            return this.parent.buffers[this.chunkIndex].writeShort(value);
        }

        @Override
        public int getInt(int index) {
            return this.parent.buffers[this.chunkIndex].getInt(this.offset(index));
        }

        @Override
        public ProtonBuffer setInt(int index, int value) {
            return this.parent.buffers[this.chunkIndex].setInt(this.offset(index), value);
        }

        @Override
        public int readInt() {
            return this.parent.buffers[this.chunkIndex].readInt();
        }

        @Override
        public ProtonBuffer writeInt(int value) {
            return this.parent.buffers[this.chunkIndex].writeInt(value);
        }

        @Override
        public long getLong(int index) {
            return this.parent.buffers[this.chunkIndex].getLong(this.offset(index));
        }

        @Override
        public ProtonBuffer setLong(int index, long value) {
            return this.parent.buffers[this.chunkIndex].setLong(this.offset(index), value);
        }

        @Override
        public long readLong() {
            return this.parent.buffers[this.chunkIndex].readLong();
        }

        @Override
        public ProtonBuffer writeLong(long value) {
            return this.parent.buffers[this.chunkIndex].writeLong(value);
        }
    }

    private final class ProtonCompositeBufferReverseIterator
    implements ProtonBufferIterator {
        private final int endOffset;
        private int offset;
        private int currentBufferIndex;
        private int currentBufferOffset;

        public ProtonCompositeBufferReverseIterator(int offset, int length) {
            this.endOffset = offset - length;
            this.offset = offset;
            this.currentBufferIndex = ProtonCompositeBufferImpl.this.findChunkWithIndex(offset);
            this.currentBufferOffset = offset - ProtonCompositeBufferImpl.this.startIndices[this.currentBufferIndex];
        }

        @Override
        public boolean hasNext() {
            return this.offset > this.endOffset;
        }

        @Override
        public byte next() {
            if (this.offset == this.endOffset) {
                throw new NoSuchElementException("Buffer iteration complete, no additional bytes available");
            }
            byte result = ProtonCompositeBufferImpl.this.buffers[this.currentBufferIndex].getByte(this.currentBufferOffset--);
            if (--this.offset != this.endOffset && this.currentBufferOffset < 0) {
                this.currentBufferIndex = ProtonCompositeBufferImpl.this.findChunkWithIndex(this.offset);
                this.currentBufferOffset = 0;
            }
            return result;
        }

        @Override
        public int remaining() {
            return Math.abs(this.endOffset - this.offset);
        }

        @Override
        public int offset() {
            return this.offset;
        }
    }

    private final class ProtonCompositeBufferIterator
    implements ProtonBufferIterator {
        private final int endOffset;
        private int offset;
        private int currentBufferIndex;
        private int currentBufferOffset;

        public ProtonCompositeBufferIterator(int offset, int length) {
            this.endOffset = offset + length;
            this.offset = offset;
            this.currentBufferIndex = ProtonCompositeBufferImpl.this.findChunkWithIndex(offset);
            this.currentBufferOffset = offset - ProtonCompositeBufferImpl.this.startIndices[this.currentBufferIndex];
        }

        @Override
        public boolean hasNext() {
            return this.offset < this.endOffset;
        }

        @Override
        public byte next() {
            if (this.offset == this.endOffset) {
                throw new NoSuchElementException("Buffer iteration complete, no additional bytes available");
            }
            byte result = ProtonCompositeBufferImpl.this.buffers[this.currentBufferIndex].getByte(this.currentBufferOffset++);
            if (++this.offset != this.endOffset && this.currentBufferOffset == ProtonCompositeBufferImpl.this.buffers[this.currentBufferIndex].capacity()) {
                this.currentBufferIndex = ProtonCompositeBufferImpl.this.findChunkWithIndex(this.currentBufferOffset);
                this.currentBufferOffset = 0;
            }
            return result;
        }

        @Override
        public int remaining() {
            return this.endOffset - this.offset;
        }

        @Override
        public int offset() {
            return this.offset;
        }
    }
}

