/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.buffer.netty;

import com.rabbitmq.qpid.protonj2.buffer.ProtonBuffer;
import com.rabbitmq.qpid.protonj2.buffer.ProtonBufferAllocator;
import com.rabbitmq.qpid.protonj2.buffer.ProtonCompositeBuffer;
import com.rabbitmq.qpid.protonj2.buffer.netty.Netty4ToProtonBufferAdapter;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;

public final class Netty4ProtonBufferAllocator
implements ProtonBufferAllocator {
    public static ProtonBufferAllocator POOLED = new Netty4ProtonBufferAllocator((ByteBufAllocator)PooledByteBufAllocator.DEFAULT);
    public static ProtonBufferAllocator UNPOOLED = new Netty4ProtonBufferAllocator((ByteBufAllocator)PooledByteBufAllocator.DEFAULT);
    private final ByteBufAllocator allocator;
    private boolean closed;

    public Netty4ProtonBufferAllocator(ByteBufAllocator allocator) {
        this.allocator = allocator;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    public ByteBufAllocator allocator() {
        return this.allocator;
    }

    public Netty4ToProtonBufferAdapter wrap(ByteBuf buffer) {
        this.checkClosed();
        return new Netty4ToProtonBufferAdapter(this, buffer);
    }

    @Override
    public Netty4ToProtonBufferAdapter outputBuffer(int initialCapacity) {
        this.checkClosed();
        return new Netty4ToProtonBufferAdapter(this, this.allocator.ioBuffer(initialCapacity));
    }

    @Override
    public Netty4ToProtonBufferAdapter allocate() {
        this.checkClosed();
        return new Netty4ToProtonBufferAdapter(this, this.allocator.heapBuffer());
    }

    @Override
    public Netty4ToProtonBufferAdapter allocate(int initialCapacity) {
        this.checkClosed();
        return new Netty4ToProtonBufferAdapter(this, this.allocator.heapBuffer(initialCapacity));
    }

    @Override
    public Netty4ToProtonBufferAdapter allocateHeapBuffer() {
        this.checkClosed();
        return new Netty4ToProtonBufferAdapter(this, Unpooled.buffer());
    }

    @Override
    public Netty4ToProtonBufferAdapter allocateHeapBuffer(int initialCapacity) {
        this.checkClosed();
        return new Netty4ToProtonBufferAdapter(this, Unpooled.buffer((int)initialCapacity));
    }

    @Override
    public Netty4ToProtonBufferAdapter copy(byte[] array, int offset, int length) {
        this.checkClosed();
        return new Netty4ToProtonBufferAdapter(this, Unpooled.copiedBuffer((byte[])array, (int)offset, (int)length));
    }

    @Override
    public ProtonCompositeBuffer composite() {
        this.checkClosed();
        return ProtonCompositeBuffer.create(this);
    }

    @Override
    public ProtonCompositeBuffer composite(ProtonBuffer buffer) {
        this.checkClosed();
        return ProtonCompositeBuffer.create((ProtonBufferAllocator)this, buffer);
    }

    @Override
    public ProtonCompositeBuffer composite(ProtonBuffer[] buffers) {
        this.checkClosed();
        return ProtonCompositeBuffer.create((ProtonBufferAllocator)this, buffers);
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("This allocator instance is closed");
        }
    }
}

